//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
//                              *** Utilities ***
//
// Created by Tim Little & Chuck Walbourn
//
// eshdir.cpp
//
//

//
//
//                                Includes
//
//

#include <conio.h>
#include <iostream.h>
#include <stdlib.h>
#include <stdio.h>

#include "debug.h"
#include "xfile.hpp"
#include "escher.hpp"
#include "esfile.hpp"

//
//
//                                Equates
//
//

#define FLAGS_PAUSE    0x1

//
//
//                               Routines
//
//

STATIC void print_help(int full);
STATIC void print_error(XFParseIFF &xp, char *s=0);

STATIC void directory(XFParseIFF &iff);
STATIC void directory_EMTL(XFParseIFF &iff);

STATIC void pause(void);

//
//
//                                 Data
//
//

STATIC dword   Flags=0;

STATIC ulong   Line=0;
STATIC ulong   Maxline=24;

char Util_name[] = " Escher Directory - (C) 1994-1999 by D. Higdon, T. Little, C. Walbourn \n"
                   "                      subject to GNU LGPL " __DATE__ "\n";

//
//
//                                 Code
//
//

//Ŀ
// main                                                                     
//                                                                          
// Entry point for the ESHDIR utility.                                      
//
void main(int argc, char *argv[])
{
    int         i;
    char        *fn;
    XFParseIFF  iff;

// Handle no filename for directory...
    if (argc < 2)
    {
        print_help(0);
        return;
    }

// Process arguments
    for(i=1, fn=0; i < argc; i++)
    {
        if (*argv[i] == '-' || *argv[i] == '/')
        {
            switch (argv[i][1])
            {
                case 'p':
                case 'P':
                    Flags |= FLAGS_PAUSE;
                    break;
                case '?':
                    print_help(1);
                    return;
                default:
                    cout << "Unknown option " << argv[i] << " ignored\n";
                    break;
            }
        }
        else if (!fn)
        {
            fn=argv[i];
        }
    }

    if (!fn)
    {
        print_help(0);
        return;
    }

// Check to see if supplied iff file exists
    if (!xf_exist(fn))
    {
        cout << " " << fn << " does not exist\n";
        return;
    }

// Open supplied iff file
    if (iff.open(fn,XF_OPEN_READ | XF_OPEN_DENYWRITE))
    {
        print_error(iff,"Failed to open file");
        return;
    }

// Print outline of file contents
    cout << Util_name;
    cout << "   File: " << fn << "\n";
    Line=3;
    directory(iff);

// Close file
    iff.close();
}


//Ŀ
// print_help                                                               
//
STATIC void print_help(int full)
{
    cout << Util_name;
    cout << "   Usage: eshdir [-p] <filename.iff>\n";
    if (full)
    {
        cout << "          -p = Pause between screens.\n";
    }
}

//Ŀ
// print_error                                                              
//
STATIC void print_error(XFParseIFF &xp, char *s)
{
    cout << " ";

    if (s)
    {
        cout << s << ", ";
    }

    switch (xp.error())
    {
        case XF_ERR_NOTIFF:
            cout << "not an IFF file error";
            break;
        case XF_ERR_CHUCKNOTFOUND:
            cout << "chunk not found error";
            break;
        case XF_ERR_FORMNOTFOUND:
            cout << "form not found error";
            break;
        case XF_ERR_UNEXPECTEDEOF:
            cout << "unexpected end-of-file error";
            break;
        case XF_ERR_INVALIDFORFORM:
            cout << "invalid operation for FORM error";
            break;
        case XF_ERR_INVALIDFORCHUNK:
            cout << "invalid operation for chunk error";
            break;
        case XF_ERR_INVALIDID:
            cout << "invalid identifier error";
            break;
        case XF_ERR_TRUNCATEDCHUNK:
            cout << "truncated chunk error";
            break;
        case XF_ERR_WRITENOTALLOWED:
            cout << "write not allowed error";
            break;
        case XF_ERR_MAXDEPTHREACHED:
            cout << "maximum supported depth reached error";
            break;
        default:
            cout << "error " << (int)xp.error();
            break;
    }

    cout << "\n";
    pause();
}


//Ŀ
// directory                                                                
//

#define COLUMN 45
#define MAXCOLUMN  75

STATIC void directory(XFParseIFF &iff)
{
    ulong               i;

// Loop through current level
    while (iff.next() == XF_ERR_NONE)
    {
        // Scenes
        if ((iff.makeid('F','O','R','M') == iff.chunkid)
             && (iff.makeid('E','S','E','N') == iff.formid))
        {
            if (iff.enterform() != XF_ERR_NONE)
            {
                print_error(iff,"Problem entering 'ESEN' FORM");
            }
            else
            {
                EschFileSceneHDR    sheader;

                cout << "Scene";
                for(i=sizeof("Object")-1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                iff.enterform();

                iff.next();

                if (iff.chunkSize != sizeof(EschFileSceneHDR))
                {
                    print_error(iff,"Scene header chunk not valid, incorrect size");
                }
                else if (iff.read(&sheader))
                {
                    print_error(iff,"Problem reading scene header");
                }
                else
                {
                    cout << sheader.name << "\n";
                    pause();
                    cout << "       # Cameras: " << sheader.ncameras << "\n";
                    pause();
                    cout << "       # Objects: " << sheader.nobjects << "\n";
                    pause();
                    cout << "       # VLights: " << sheader.nvectorlights << "\n";
                    pause();
                    cout << "     # FP Lights: " << sheader.nfpointlights << "\n";
                    pause();
                    cout << " # FAtten Lights: " << sheader.nfattenlights << "\n";
                    pause();
                    cout << "  # FSpot Lights: " << sheader.nfspotlights << "\n";
                    pause();
                    cout << "       # PLights: " << sheader.npointlights << "\n";
                    pause();
                    cout << "  # Atten Lights: " << sheader.nattenlights << "\n";
                    pause();
                    cout << "   # Spot Lights: " << sheader.nspotlights << "\n";
                    pause();
                }

                directory(iff);
                iff.leaveform();

                cout << "\n";
                pause();
            }

        }
        // Misc data
        else if (iff.makeid('D','E','S','C') == iff.chunkid)
        {
            char    buff[256];

            if (iff.read(buff))
            {
                print_error(iff,"Problem reading scene description");
            }
            else
            {
                cout << "   Desc: " <<  buff << endl;
                pause();
            }
        }
        else if (iff.makeid('A','U','T','H') == iff.chunkid)
        {
            char    buff[256];

            if (iff.read(buff))
            {
                print_error(iff,"Problem reading scene author string");
            }
            else
            {
                cout << " Author: " <<  buff << endl;
                pause();
            }
        }
        else if (iff.makeid('(','C',')',' ') == iff.chunkid)
        {
            char    buff[256];

            if (iff.read(buff))
            {
                print_error(iff,"Problem reading scene copyright notice");
            }
            else
            {
                cout << " Notice: " <<  buff << endl;
                pause();
            }
        }
        // Materials
        else if ((iff.makeid('F','O','R','M') == iff.chunkid)
                && (iff.makeid('E','M','T','L') == iff.formid
                    || iff.makeid('E','M','T','1') == iff.formid))
        {
            cout << "Material";
            for(i=sizeof("Material")-1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();

            directory_EMTL(iff);

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // Mesh
        else if ((iff.makeid('F','O','R','M') == iff.chunkid)
                 && (iff.makeid('E','M','S','H') == iff.formid))
        {
            EschFileMeshHDR     mheader;

            if (iff.enterform() != XF_ERR_NONE)
            {
                print_error(iff,"Problem entering 'EMSH' FORM");
            }
            else
            {
                cout << "Object";
                for(i=sizeof("Object")-1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                while (iff.next() == XF_ERR_NONE)
                {
                    // Header
                    if (iff.makeid('H','D','R',' ') == iff.chunkid)
                    {
                        if (iff.chunkSize != sizeof(EschFileMeshHDR))
                        {
                            print_error(iff,"Object header chunk not valid, incorrect size");
                        }
                        else if (iff.read(&mheader))
                        {
                            print_error(iff,"Problem reading object header");
                        }
                        else
                        {
                            cout << "" << mheader.name;
                            cout.flush();
                            printf( "\tFLAGS: %x",mheader.flags);
                            cout << "\tNV: " << mheader.nverts;
                            cout << "\tNF: " << mheader.nfaces << "\n";
                            pause();
                        }
                    }
                    // Extents
                    else if (iff.makeid('E','X','N','T') == iff.chunkid
                             || iff.makeid('E','X','N','1') == iff.chunkid)
                    {
                        EschFileMeshEXNT    mextents;

                        if (iff.makeid('E','X','N','1') == iff.chunkid)
                        {
                            if (iff.chunkSize != sizeof(mextents))
                            {
                                print_error(iff,"Object extents chunk not valid, incorrect size");
                            }
                            else if (iff.read(&mextents))
                            {
                                print_error(iff,"Problem reading object extents");
                            }
                        }
                        else
                        {
                            EschFileMeshEXNTV1  v1;

                            if (iff.chunkSize != sizeof(v1))
                            {
                                print_error(iff,"Object extents chunk not valid, incorrect size");
                            }
                            else if (iff.read(&v1))
                            {
                                print_error(iff,"Problem reading object extents");
                            }
                            else
                            {
                                mextents.cenx = v1.cenx / 65536.0f;
                                mextents.ceny = v1.ceny / 65536.0f;
                                mextents.cenz = v1.cenz / 65536.0f;
                                mextents.extent_radius = v1.extent_radius / 65536.0f;
                                mextents.minx = v1.minx / 65536.0f;
                                mextents.miny = v1.miny / 65536.0f;
                                mextents.minz = v1.minz / 65536.0f;
                                mextents.maxx = v1.maxx / 65536.0f;
                                mextents.maxy = v1.maxy / 65536.0f;
                                mextents.maxz = v1.maxz / 65536.0f;
                            }
                        }

                        cout << "  CEN: " << mextents.cenx << " "
                                           << mextents.ceny << " "
                                           << mextents.cenz << "\n";
                        pause();
                        cout << "  RAD: " << mextents.extent_radius << "\n";
                        pause();
                        cout << "  MIN: " << mextents.minx << " "
                                           << mextents.miny << " "
                                           << mextents.minz << "\n";
                        pause();
                        cout << "  MAX: " << mextents.maxx << " "
                                           << mextents.maxy << " "
                                           << mextents.maxz << "\n";
                        pause();
                    }
                    // Matrix
                    else if (iff.makeid('M','T','R','X') == iff.chunkid
                             || iff.makeid('M','T','R','1') == iff.chunkid)
                    {
                        EschMatrix          mtx;

                        if (iff.makeid('M','T','R','1') == iff.chunkid)
                        {
                            if (iff.chunkSize != sizeof(mtx))
                            {
                                print_error(iff,"Matrix chunk not valid, incorrect size");
                            }
                            else if (iff.read(&mtx))
                            {
                                print_error(iff,"Problem reading matrix");
                            }
                        }
                        else
                        {
                            EschMatrixV1    v1;

                            if (iff.chunkSize != sizeof(v1))
                            {
                                print_error(iff,"Matrix chunk not valid, incorrect size");
                            }
                            else if (iff.read(&v1))
                            {
                                print_error(iff,"Problem reading matrix");
                            }
                            else
                            {
                                for(int i=0; i < ESCH_MTX_NUM; i++)
                                    mtx.mtx[i] = v1.mtx[i] / 65536.0f;
                            }
                        }

                        cout << " MTRX: " << mtx.mtx[ESCH_MTX_A] << " "
                                           << mtx.mtx[ESCH_MTX_B] << " "
                                           << mtx.mtx[ESCH_MTX_C] << "\n";
                        pause();
                        cout << "       " << mtx.mtx[ESCH_MTX_D] << " "
                                           << mtx.mtx[ESCH_MTX_E] << " "
                                           << mtx.mtx[ESCH_MTX_F] << "\n";
                        pause();
                        cout << "       " << mtx.mtx[ESCH_MTX_G] << " "
                                           << mtx.mtx[ESCH_MTX_H] << " "
                                           << mtx.mtx[ESCH_MTX_I] << "\n";
                        pause();
                        cout << "       " << mtx.mtx[ESCH_MTX_J] << " "
                                           << mtx.mtx[ESCH_MTX_K] << " "
                                           << mtx.mtx[ESCH_MTX_L] << "\n";
                        pause();
                    }
                    // Hierarchy
                    else if (iff.makeid('H','I','E','R') == iff.chunkid)
                    {
                        EschFileMeshHIER    ehier;

                        if (iff.chunkSize != sizeof(EschFileMeshHIER))
                        {
                            print_error(iff,"Hierarchy chunk not valid, incorrect size");
                        }
                        else if (iff.read(&ehier))
                        {
                            print_error(iff,"Problem reading hierarchy chunk");
                        }
                        else
                        {
                            cout << " HIER: " << ehier.parent << "\n";
                            pause();
                        }
                    }
                    // Verticies
                    else if (iff.makeid('V','E','R','T') == iff.chunkid)
                    {
                        cout << " Contains fixed-point format vertex data\n";
                        pause();
                    }
                    else if (iff.makeid('V','E','R','1') == iff.chunkid)
                    {
                        cout << " Contains floating-point format vertex data\n";
                        pause();
                    }
                    // Faces
                    else if (iff.makeid('F','A','C','E') == iff.chunkid)
                    {
                        cout << " Contains fixed-point format face data\n";
                        pause();
                    }
                    else if (iff.makeid('F','A','C','1') == iff.chunkid)
                    {
                        cout << " Contains old floating-point format face data\n";
                        pause();
                    }
                    else if (iff.makeid('F','A','C','2') == iff.chunkid)
                    {
                        cout << " Contains floating-point format face data\n";
                        pause();
                    }
                    // Materials
                    else if (iff.makeid('M','T','L',' ') == iff.chunkid)
                    {
                        if (iff.chunkSize != (sizeof(EschFileMeshMTL) * mheader.nmtls))
                        {
                            print_error(iff,"Object materials chunk not valid, incorrect size");
                        }
                        else if (mheader.nmtls)
                        {
                            EschFileMeshMTL *emtls = new EschFileMeshMTL[mheader.nmtls];

                            if (iff.read(emtls))
                            {
                                print_error(iff,"Problem reading object materials");
                            }
                            else
                            {
                                cout << " MTLS:\n";
                                pause();
                                for(i=0; i < mheader.nmtls; i++)
                                {
                                    char name[ESCH_MAX_NAME+1];
                                    strncpy(name,emtls[i].name,ESCH_MAX_NAME);
                                    name[ESCH_MAX_NAME] = 0;
                                    cout << "       " << name << "\n";
                                    pause();
                                }
                            }

                            delete [] emtls;
                        }
                    }
                    else if ((iff.makeid('F','O','R','M') == iff.chunkid)
                            && (iff.makeid('E','M','T','L') == iff.formid
                                || iff.makeid('E','M','T','1') == iff.formid))
                    {
                        cout << " MATERIAL:\n";
                        pause();

                        directory_EMTL(iff);
                    }
                }

                cout << "";
                for(i=1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                iff.leaveform();
            }
        }
        // Camera
        else if (iff.makeid('E','C','A','M') == iff.chunkid
                 || iff.makeid('E','C','A','1') == iff.chunkid)
        {
            EschFileCamera      cdata;

            if (iff.makeid('E','C','A','1') == iff.chunkid)
            {
                if (iff.chunkSize != sizeof(cdata))
                {
                    print_error(iff,"Camera chunk not valid, incorrect size");
                }
                else if (iff.read(&cdata))
                {
                    print_error(iff,"Problem reading camera chunk");
                }
            }
            else
            {
                EschFileCameraV1    v1;

                if (iff.chunkSize != sizeof(v1))
                {
                    print_error(iff,"Camera chunk not valid, incorrect size");
                }
                else if (iff.read(&v1))
                {
                    print_error(iff,"Problem reading camera chunk");
                }
                else
                {
                    strncpy(cdata.name,v1.name,sizeof(v1.name));
                    cdata.flags = v1.flags;

                    cdata.x = v1.x / 65536.0f;
                    cdata.y = v1.y / 65536.0f;
                    cdata.z = v1.z / 65536.0f;

                    cdata.diri = v1.diri / 65536.0f;
                    cdata.dirj = v1.dirj / 65536.0f;
                    cdata.dirk = v1.dirk / 65536.0f;

                    cdata.topi = v1.topi / 65536.0f;
                    cdata.topj = v1.topj / 65536.0f;
                    cdata.topk = v1.topk / 65536.0f;

                    cdata.fov = v1.fov / 65536.0f;
                }
            }

            cout << "Camera";
            for(i=sizeof("Camera")-1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();

            cout << "" << cdata.name;
            cout.flush();
            printf( "\tFLAGS: %x\n",cdata.flags);
            pause();

            cout << "   POS: " << cdata.x
                 << " " << cdata.y
                 << " " << cdata.z << "\n";

            pause();
            cout << "   DIR: " << (float) cdata.diri
                 << " " << (float) cdata.dirj
                 << " " << (float) cdata.dirk << "\n";
            pause();

            cout << "   TOP: " << (float) cdata.topi
                 << " " << (float) cdata.topj
                 << " " << (float) cdata.topk << "\n";
            pause();

            cout << "   FOV: " << (float) cdata.fov << "\n";
            pause();

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // Ambient Light
        else if (iff.makeid('E','A','M','B') == iff.chunkid)
        {
            EschFileLightAmbi   adata;

            if (iff.chunkSize != sizeof(EschFileLightAmbi))
            {
                print_error(iff,"Ambient light chunk not valid, incorrect size");
            }
            else if (iff.read(&adata))
            {
                print_error(iff,"Problem reading abmient light chunk");
            }
            else
            {
                cout << "Ambient";
                for(i=sizeof("Ambient")-1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                cout << "" << adata.name;
                cout.flush();
                printf( "\tFLAGS: %x\n",adata.flags);
                pause();
                cout << "COLOR: " << (adata.color & 0xff) << " "
                                   << ((adata.color >> 8) & 0xff) << " "
                                   << ((adata.color >> 16) & 0xff) << "\n";
                pause();

                cout << "";
                for(i=1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();
            }
        }
        // Vector Light
        else if (iff.makeid('E','V','E','C') == iff.chunkid
                 || iff.makeid('E','V','E','1') == iff.chunkid)
        {
            EschFileLightVect   vdata;

            if (iff.makeid('E','V','E','1') == iff.chunkid)
            {
                if (iff.chunkSize != sizeof(vdata))
                {
                    print_error(iff,"Vector light chunk not valid, incorrect size");
                }
                else if (iff.read(&vdata))
                {
                    print_error(iff,"Problem reading vector light chunk");
                }
            }
            else
            {
                EschFileLightVectV1 v1;

                if (iff.chunkSize != sizeof(v1))
                {
                    print_error(iff,"Vector light chunk not valid, incorrect size");
                }
                else if (iff.read(&v1))
                {
                    print_error(iff,"Problem reading vector light chunk");
                }
                else
                {
                    strncpy(vdata.name,v1.name,sizeof(v1.name));
                    vdata.flags = v1.flags;
                    vdata.color = v1.color;

                    vdata.i = v1.i / 65536.0f;
                    vdata.j = v1.j / 65536.0f;
                    vdata.k = v1.k / 65536.0f;
                }
            }

            cout << "Vector Light";
            for(i=sizeof("Vector Light")-1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();

            cout << "" << vdata.name;
            cout.flush();
            printf( "\tFLAGS: %x\n",vdata.flags);
            pause();
            cout << "COLOR: " << (vdata.color & 0xff) << " "
                               << ((vdata.color >> 8) & 0xff) << " "
                               << ((vdata.color >> 16) & 0xff) << "\n";
            pause();
            cout << "  DIR: " << vdata.i << " "
                 << vdata.j << " "
                 << vdata.k << "\n";
            pause();

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // (Fast) Point Light
        else if (iff.makeid('E','P','N','T') == iff.chunkid
                 || iff.makeid('E','P','N','1') == iff.chunkid
                 || iff.makeid('E','F','P','T') == iff.chunkid
                 || iff.makeid('E','F','P','1') == iff.chunkid)
        {
            EschFileLightPoint  pdata;

            if (iff.makeid('E','P','N','1') == iff.chunkid
                || iff.makeid('E','F','P','1') == iff.chunkid)
            {
                if (iff.chunkSize != sizeof(pdata))
                {
                    print_error(iff,"Point light chunk not valid, incorrect size");
                }
                else if (iff.read(&pdata))
                {
                    print_error(iff,"Problem reading point light chunk");
                }
            }
            else
            {
                EschFileLightPointV1    v1;

                if (iff.chunkSize != sizeof(v1))
                {
                    print_error(iff,"Point light chunk not valid, incorrect size");
                }
                else if (iff.read(&v1))
                {
                    print_error(iff,"Problem reading point light chunk");
                }
                else
                {
                    strncpy(pdata.name,v1.name,sizeof(v1.name));
                    pdata.flags = v1.flags;
                    pdata.color = v1.color;

                    pdata.x = v1.x / 65536.0f;
                    pdata.y = v1.y / 65536.0f;
                    pdata.z = v1.z / 65536.0f;
                }
            }

            if (iff.makeid('E','F','P','T') == iff.chunkid
                || iff.makeid('E','F','P','1') == iff.chunkid)
            {
                cout << "Fast Point Light";
                for(i=sizeof("Fast Point Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            else
            {
                cout << "Point Light";
                for(i=sizeof("Point Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            cout << "\n";
            pause();

            cout << "" << pdata.name;
            cout.flush();
            printf( "\tFLAGS: %x\n",pdata.flags);
            pause();
            cout << "COLOR: " << (pdata.color & 0xff) << " "
                               << ((pdata.color >> 8) & 0xff) << " "
                               << ((pdata.color >> 16) & 0xff) << "\n";
            pause();

            cout << "  POS: " << (float)pdata.x << " "
                 << pdata.y << " "
                 << pdata.z << "\n";
            pause();

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // (Fast) Attenuated Light
        else if (iff.makeid('E','A','T','N') == iff.chunkid
                 || iff.makeid('E','A','T','1') == iff.chunkid
                 || iff.makeid('E','F','A','T') == iff.chunkid
                 || iff.makeid('E','F','A','1') == iff.chunkid)
        {
            EschFileLightAtten  adata;

            if (iff.makeid('E','A','T','1') == iff.chunkid
                || iff.makeid('E','F','A','1') == iff.chunkid)
            {
                if (iff.chunkSize != sizeof(adata))
                {
                    print_error(iff,"Attenuated light chunk not valid, incorrect size");
                }
                else if (iff.read(&adata))
                {
                    print_error(iff,"Problem reading attenuated light chunk");
                }
            }
            else
            {
                EschFileLightAttenV1    v1;

                if (iff.chunkSize != sizeof(v1))
                {
                    print_error(iff,"Attenuated light chunk not valid, incorrect size");
                }
                else if (iff.read(&v1))
                {
                    print_error(iff,"Problem reading attenuated light chunk");
                }
                else
                {
                    strncpy(adata.name,v1.name,sizeof(v1.name));
                    adata.flags = v1.flags;
                    adata.color = v1.color;

                    adata.x = v1.x / 65536.0f;
                    adata.y = v1.y / 65536.0f;
                    adata.z = v1.z / 65536.0f;

                    adata.inner = v1.inner / 65536.0f;
                    adata.outer = v1.outer / 65536.0f;
                }
            }

            if (iff.makeid('E','F','A','T') == iff.chunkid
                || iff.makeid('E','F','A','1') == iff.chunkid)
            {
                cout << "Fast Atten Light";
                for(i=sizeof("Fast Atten Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            else
            {
                cout << "Atten Light";
                for(i=sizeof("Atten Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            cout << "\n";
            pause();

            cout << "" << adata.name;
            cout.flush();
            printf( "\tFLAGS: %x\n",adata.flags);
            pause();

            cout << "COLOR: " << (adata.color & 0xff) << " "
                                << ((adata.color >> 8) & 0xff) << " "
                                << ((adata.color >> 16) & 0xff) << "\n";
            pause();
            cout << "  POS: " << adata.x << " "
                 << adata.y << " "
                 << adata.z << "\n";
            pause();

            cout << " RNGS: " << adata.inner << " "
                 << adata.outer << "\n";
            pause();

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // Spot Light
        else if (iff.makeid('E','S','P','T') == iff.chunkid
                 || iff.makeid('E','S','P','1') == iff.chunkid
                 || iff.makeid('E','F','S','P') == iff.chunkid
                 || iff.makeid('E','F','S','1') == iff.chunkid)
        {
            EschFileLightSpot   sdata;

            if (iff.makeid('E','S','P','1') == iff.chunkid
                || iff.makeid('E','F','S','1') == iff.chunkid)
            {
                if (iff.chunkSize != sizeof(sdata))
                {
                    print_error(iff,"Spot light chunk not valid, incorrect size");
                }
                else if (iff.read(&sdata))
                {
                    print_error(iff,"Problem reading spot light chunk");
                }
            }
            else
            {
                EschFileLightSpotV1 v1;

                if (iff.chunkSize != sizeof(v1))
                {
                    print_error(iff,"Spot light chunk not valid, incorrect size");
                }
                else if (iff.read(&v1))
                {
                    print_error(iff,"Problem reading spot light chunk");
                }
                else
                {
                    strncpy(sdata.name,v1.name,sizeof(v1.name));
                    sdata.flags = v1.flags;
                    sdata.color = v1.color;

                    sdata.x = v1.x / 65536.0f;
                    sdata.y = v1.y / 65536.0f;
                    sdata.z = v1.z / 65536.0f;

                    sdata.i = v1.i / 65536.0f;
                    sdata.j = v1.j / 65536.0f;
                    sdata.k = v1.k / 65536.0f;

                    sdata.hotspot = v1.hotspot / 65536.0f;
                    sdata.falloff = v1.falloff / 65536.0f;

                    sdata.inner = v1.inner / 65536.0f;
                    sdata.outer = v1.outer / 65536.0f;
                }
            }

            if (iff.makeid('E','F','S','P') == iff.chunkid
                || iff.makeid('E','F','S','1') == iff.chunkid)
            {
                cout << "Fast Spot Light";
                for(i=sizeof("Fast Spot Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            else
            {
                cout << "Spot Light";
                for(i=sizeof("Spot Light")-1; i < MAXCOLUMN; i++)
                    cout << "";
            }
            cout << "\n";
            pause();

            cout << "" << sdata.name;
            cout.flush();
            printf( "\tFLAGS: %x\n",sdata.flags);
            pause();
            cout << "COLOR: " << (sdata.color & 0xff) << " "
                                << ((sdata.color >> 8) & 0xff) << " "
                                << ((sdata.color >> 16) & 0xff) << "\n";
            pause();
            cout << "  POS: " << sdata.x << " "
                 << sdata.y << " "
                 << sdata.z << "\n";
            pause();

            cout << "  DIR: " << sdata.i << " "
                 << sdata.j << " "
                 << sdata.k << "\n";
            pause();

            cout << "HSPOT: " << sdata.hotspot
                 << "\tFALLOFF: " << sdata.falloff << "\n";
            pause();

            cout << " RNGS: " << sdata.inner << " "
                 << sdata.outer << "\n";
            pause();

            cout << "";
            for(i=1; i < MAXCOLUMN; i++)
                cout << "";
            cout << "\n";
            pause();
        }
        // Terrain
        else if ((iff.makeid('F','O','R','M') == iff.chunkid)
                 && (iff.makeid('E','T','E','R') == iff.formid))
        {
            EschFileTerrHDR     theader;
            EschFileTerrHCLR    thcolor;

            if (iff.enterform() != XF_ERR_NONE)
            {
                print_error(iff,"Problem entering 'ETER' FORM");
            }
            else
            {
                cout << "Terrain";
                for(i=sizeof("Terrain")-1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                while (iff.next() == XF_ERR_NONE)
                {

                    if (iff.makeid('H','D','R',' ') == iff.chunkid
                        || iff.makeid('H','D','R','1') == iff.chunkid)
                    {
                        if (iff.makeid('H','D','R','1') == iff.chunkid)
                        {
                            if (iff.chunkSize != sizeof(theader))
                            {
                                print_error(iff,"Terrain header chunk not valid, incorrect size");
                            }
                            else if (iff.read(&theader))
                            {
                                print_error(iff,"Problem reading terrain header");
                            }
                        }
                        else
                        {
                            EschFileTerrHDRV1   v1;

                            if (iff.chunkSize != sizeof(v1))
                            {
                                print_error(iff,"Terrain header chunk not valid, incorrect size");
                            }
                            else if (iff.read(&v1))
                            {
                                print_error(iff,"Problem reading terrain header");
                            }
                            else
                            {
                                strncpy(theader.name,v1.name,sizeof(v1.name));
                                theader.flags = v1.flags;

                                theader.width = v1.width;
                                theader.depth = v1.depth;

                                theader.wscale = v1.wscale / 65536.0f;
                                theader.dscale = v1.dscale / 65536.0f;
                                theader.hscale = v1.hscale / 65536.0f;

                                strncpy(theader.palname,v1.palname,
                                        sizeof(v1.palname));

                                theader.ntxts = v1.ntxts;
                            }
                        }

                        cout << "" << theader.name;
                        cout.flush();
                        printf( "\tFLAGS: %x\n",theader.flags);
                        pause();

                        cout << "  SIZE: " << theader.width << " by "
                                            << theader.depth << endl;
                        pause();

                        cout << " SCALE: X:" << theader.wscale
                             << " D:" << theader.dscale
                             << " H:" << theader.hscale << endl;
                        pause();

                        cout << " PNAME: " << theader.palname << endl;
                        pause();
                    }
                    else if (iff.makeid('D','E','S','C') == iff.chunkid)
                    {
                        char    buff[256];

                        if (iff.read(buff))
                        {
                            print_error(iff,"Problem reading terrain description");
                        }
                        else
                        {
                            cout << "  DESC: " <<  buff << endl;
                            pause();
                        }
                    }
                    else if (iff.makeid('A','U','T','H') == iff.chunkid)
                    {
                        char    buff[256];

                        if (iff.read(buff))
                        {
                            print_error(iff,"Problem reading terrain author string");
                        }
                        else
                        {
                            cout << "  AUTH: " <<  buff << endl;
                            pause();
                        }
                    }
                    else if (iff.makeid('(','C',')',' ') == iff.chunkid)
                    {
                        char    buff[256];

                        if (iff.read(buff))
                        {
                            print_error(iff,"Problem reading terrain copyright notice");
                        }
                        else
                        {
                            cout << "   (C): " <<  buff << endl;
                            pause();
                        }
                    }
                    else if (iff.makeid('H','C','L','R') == iff.chunkid)
                    {
                        if (iff.chunkSize != sizeof(EschFileTerrHCLR))
                        {
                            print_error(iff,"Terrain color bands chunk not valid, incorrect size");
                        }
                        else if (iff.read(&thcolor))
                        {
                            print_error(iff,"Problem reading terrain color bands chunk");
                        }
                        else
                        {
                            cout << "  Height-based color bands present:" << thcolor.blue << endl;
                            pause();
                            cout << "  \tBlue:" << thcolor.blue << endl;
                            pause();
                            cout << "  \tL. Blue:" << thcolor.lblue << endl;
                            pause();
                            cout << "  \tWhite:" << thcolor.white << endl;
                            pause();
                            cout << "  \tGreen:" << thcolor.green << endl;
                            pause();
                            cout << "  \tL. Green:" << thcolor.lgreen << endl;
                            pause();
                            cout << "  \tYellow:" << thcolor.yellow << endl;
                            pause();
                            cout << "  \tL. Orange:" << thcolor.lorange << endl;
                            pause();
                            cout << "  \tOrange:" << thcolor.orange << endl;
                            pause();
                            cout << "  \tL. Brown:" << thcolor.lbrown << endl;
                            pause();
                            cout << "  \tBrown:" << thcolor.brown << endl;
                            pause();
                            cout << "  \tRed:" << thcolor.red << endl;
                            pause();
                        }
                    }
                    else if (iff.makeid('H','T','B','L') == iff.chunkid
                             || iff.makeid('H','T','B','1') == iff.chunkid)
                    {
                        cout << " Contains height-table" << endl;
                    }
                    else if (iff.makeid('S','U','R','F') == iff.chunkid)
                    {
                        cout << " Contains surface information" << endl;
                    }
                    else if (iff.makeid('N','R','M','L') == iff.chunkid
                             || iff.makeid('N','R','M','2') == iff.chunkid)
                    {
                        cout << " Contains normals" << endl;
                    }
                    else if (iff.makeid('N','R','M','1') == iff.chunkid)
                    {
                        cout << " Contains normals (compressed)" << endl;
                    }
                    else if (iff.makeid('M','T','L',' ') == iff.chunkid)
                    {
                        if (iff.chunkSize != (sizeof(EschFileTerrMTL) * theader.ntxts))
                        {
                            print_error(iff,"Terrain materials name chunk not valid, incorrect size");
                        }
                        else if (theader.ntxts)
                        {
                            EschFileTerrMTL *emtls = new EschFileTerrMTL[theader.ntxts];

                            if (iff.read(emtls))
                            {
                                print_error(iff,"Problem reading terrain materials names");
                            }
                            else
                            {
                                cout << " MTLS:\n";
                                pause();
                                for(i=0; i < theader.ntxts; i++)
                                {
                                    char name[ESCH_MAX_NAME+1];
                                    strncpy(name,emtls[i].name,ESCH_MAX_NAME);
                                    name[ESCH_MAX_NAME] = 0;
                                    cout << "       " << name << "\n";
                                    pause();
                                }
                            }

                            delete [] emtls;
                        }
                    }
                    else if ((iff.makeid('F','O','R','M') == iff.chunkid)
                            && (iff.makeid('E','M','T','L') == iff.formid
                                || iff.makeid('E','M','T','1') == iff.formid))
                    {
                        cout << " MATERIAL:\n";
                        pause();

                        directory_EMTL(iff);
                    }
                }

                cout << "";
                for(i=1; i < MAXCOLUMN; i++)
                    cout << "";
                cout << "\n";
                pause();

                iff.leaveform();
            }
        }
    }

    if (iff.error() != XF_ERR_EOF)
    {
        print_error(iff,"Problem processing file");
    }
}


//Ŀ
// directory_EMTL                                                           
//
STATIC void directory_EMTL(XFParseIFF &iff)
{
    EschFileMtlMHDR mtlhdr;

    iff.enterform();

    if (iff.seekchunk(iff.makeid('M','H','D','R')))
    {
        cout << " Can't find header\n";
        pause();
    }
    else if (iff.chunkSize != sizeof(EschFileMtlMHDR))
    {
        print_error(iff,"Object materials data header chunk not valid, incorrect size");
    }
    else
    {
        if (iff.read(&mtlhdr))
        {
            print_error(iff,"Problem reading object materials data header");
        }
        else
        {
            char name[ESCH_MAX_NAME+1];
            strncpy(name,mtlhdr.name,ESCH_MAX_NAME);
            name[ESCH_MAX_NAME] = 0;

            cout << "     " << name << "\n";
            pause();

            cout << "               x=" << mtlhdr.xsize << " y=" << mtlhdr.ysize;
            cout << " nf=" << mtlhdr.nframes;

            switch (mtlhdr.type)
            {
                case ESCH_MTL_TYPE_8BIT:
                    cout << " 8bits";
                    break;
                case ESCH_MTL_TYPE_8BIT_TRANSP:
                    cout << " 8bits xprnt";
                    break;
                case ESCH_MTL_TYPE_15BIT:
                    cout << " 15bits";
                    break;
                case ESCH_MTL_TYPE_15BIT_TRANSP:
                    cout << " 15bits xprnt";
                    break;
                case ESCH_MTL_TYPE_24BIT:
                    cout << " 24bits";
                    break;
                case ESCH_MTL_TYPE_32BIT:
                    cout << " 32bits";
                    break;
                default:
                    cout << " ?bits";
                    break;
            }

            switch (mtlhdr.compress)
            {
                case ESCH_MTL_COMPRESS_NONE:
                    cout << " Uncompressed";
                    break;
                case ESCH_MTL_COMPRESS_RLE:
                    cout << " Compressed";
                    break;
            }
            cout << " pal='" << mtlhdr.pname << "'\n";
            pause();
        }
    }

    for(int i=0; i < mtlhdr.nframes; i++)
    {
        if (iff.seekchunk(iff.makeid('B','O','D','Y')))
        {
            cout << " Can't find body for frame #" << i+1 << "\n";
            pause();
        }
        else if (!iff.chunkSize)
        {
            print_error(iff,"Object materials data body chunk empty");
        }
        else
        {
            cout << "               Frame " << i+1 << "  " << iff.chunkSize << " bytes\n";
            pause();
        }
    }

    iff.leaveform();
}


//Ŀ
// Pause                                                                    
//

STATIC void pause(void)
{
    if ((Flags & FLAGS_PAUSE) && (++Line >= Maxline))
    {
        cout << " More \r";
        cout.flush();
        getch();
        Line=1;
    }
}

//
// _charybdis_assert
//
// Handler for failed asserts.  If msg is set to non-NULL, then an assertMyth
// was used with a comment.
//
extern "C" void _charybdis_assert(char *msg, char *exp, char *f, unsigned ln)
{
    cout.flush();
    printf("\n\n Assertion Failed \n"
           "Expr:\t%s\n"
           "File:\t%s\t\tLine %d\n",exp,f,ln);
    if (msg)
    {
        printf("Comment:\n%s\n",msg);
    }

    exit(1);
}

// End of module - eshdir.cpp 

