
/*
 * Portable Object Compiler (c) 1997,98,99.  All Rights Reserved.
 * $Id: Object.h,v 1.16 1999/08/10 22:43:26 stes Exp $
 */

/*
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __PORTABLE_OBJC__
/* if this file is included by a different compiler, it's by mistake */
#error Portable Object Compiler Object.h must not be in include path.
#else

#ifndef __OBJECT_H__
#define __OBJECT_H__

#include "objcrt.h"
#include <string.h>

#define __objcrt_revision__ "2.3.15"

#ifdef _XtIntrinsic_h
#define Object OCObject		/* remap Object class - cant use Xt Object */
#endif

@interface Object
{
  id isa;
#ifdef OBJC_REFCNT
  unsigned int _refcnt;
#else
  unsigned short attr;		/* compatibility Stepstone */
  unsigned short objID;		/* compatibility Stepstone */
#endif
}

+ initialize;

+ new;
- copy;
- deepCopy;
- free;
- release;

- self;
- yourself;
- class;
- superclass;
- superClass;
+ class;
+ superclass;
+ superClass;
- (STR) name;
+ (STR) name;
- findClass:(STR)name;
- (SEL) findSel:(STR)name;
- (SEL) selOfSTR:(STR)name;
- idOfSTR:(STR)aClassName;

- (unsigned) hash;
- (BOOL) isEqual:anObject;
- (STR) str;
- (unsigned) size;
+ (BOOL) isEqual:anObject;
- (BOOL) isSame:anObject;
- (BOOL) notEqual:anObject;
- (BOOL) notSame:anObject;
- (int) compare:anObject;

- (BOOL) respondsTo:(SEL)aSelector;
- (BOOL) isMemberOf:aClass;
- (BOOL) isKindOf:aClass;

+ someInstance;
- nextInstance;
- become:other;

+ subclasses;
+ poseAs:superClass;
+ addMethodsTo:superClass;
+ subclass:(STR)name;
+ (BOOL) inheritsFrom:aClass;

- subclassResponsibility;
- subclassResponsibility:(SEL)aSelector;
- notImplemented;
- notImplemented:(SEL)aSelector;
- shouldNotImplement;
- shouldNotImplement:(SEL)aSelector;
- shouldNotImplement:(SEL)aSelector from:superClass;
- error:(STR)format,...;
- halt:message;

- doesNotRecognize:(SEL)aSelector;
- doesNotUnderstand:aMessage;

- (IMP) methodFor:(SEL)aSelector;
+ (IMP) instanceMethodFor:(SEL)aSelector;

- perform:(SEL)aSelector;
- perform:(SEL)aSelector with:anObject;
- perform:(SEL)aSelector with:anObject with:otherObject;
- perform:(SEL)aSelector with:anObject with:otherObject with:thirdObj;

- print;
+ print;
- printLine;
- show;
- printOn:(IOD)anIOD;

+ (STR) objcrtRevision;

+ readFrom:(STR)aFileName;
- (BOOL) storeOn:(STR)aFileName;

- fileOutOn:aFiler;
+ fileInFrom:aFiler;
- fileInFrom:aFiler;
- fileOut:(void *)value type:(char)typeDesc;
- fileIn:(void *)value type:(char)typeDesc;
- awake;
- awakeFrom:aFiler;

@end

#endif /* __OBJECT_H__ */

#endif /* __PORTABLE_OBJC__ */
 
