#include <ocl>
#include <algorithm>
#include <iostream>
#include <iterator>

using namespace std;
using namespace ocl;

template <class T>
ostream& operator << (ostream& os, const Set<T>& a_set)
{
    copy(a_set.begin(), a_set.end(), ostream_iterator<T>(os, " "));
    return os;
}

template <class T>
ostream& operator << (ostream& os, const Bag<T>& a_bag)
{
    copy(a_bag.begin(), a_bag.end(), ostream_iterator<T>(os, " "));
    return os;
}

template <class T>
ostream& operator << (ostream& os, const Sequence<T>& a_sequence)
{
    copy(a_sequence.begin(), a_sequence.end(), ostream_iterator<T>(os, " "));
    return os;
}

void test_basic_types()
{
    String s = "Hello, OCL users!";
    Real r = -3.14;
    Integer i = r;
    Boolean b = r;

    cout << "s: String = \"" << s << "\"" << endl
         << "r: Real = " << r << endl
         << "i: Integer = r = " << i << endl
         << "b: Boolean = r = " << b << endl
         << "floor(r) = " << floor(r) << endl;
}

void test_set()
{
    Set<Integer> set1, set2;

    set1 = set1.including(4).including(5).including(3).
        including(79).including(79);
    cout << "set1 = " << set1 << endl;

    set2 = set2.including(45).including(23).including(79);
    cout << "set2 = " << set2 << endl;

    cout << "set1.size() = " << set1.size() << endl
         << "set2.sum()  = " << set2.sum() << endl;

    cout << "set1.reunion(set2)             = "
         << set1.reunion(set2) << endl
         << "set1.intersection(set2)        = "
         << set1.intersection(set2) << endl
         << "set1.difference(set2)          = "
         << set1.difference(set2) << endl
         << "set1.symmetricDifference(set2) = "
         << set1.symmetricDifference(set2) << endl;

    cout << "set1.asBag()      = " << set1.asBag() << endl
         << "set1.asSequence() = " << set1.asSequence() << endl;
}

void test_bag()
{
    Bag<Integer> bag1, bag2;

    bag1 = bag1.including(4).including(5).including(3).
        including(79).including(79);
    cout << "bag1 = " << bag1 << endl;

    bag2 = bag2.including(45).including(23).including(79);
    cout << "bag2 = " << bag2 << endl;

    cout << "bag1.size() = " << bag1.size() << endl
         << "bag2.sum()  = " << bag2.sum() << endl;

    cout << "bag1.reunion(bag2)      = " << bag1.reunion(bag2) << endl
         << "bag1.intersection(bag2) = " << bag1.intersection(bag2) << endl;

    cout << "bag1.asSet()      = " << bag1.asSet() << endl
         << "bag1.asSequence() = " << bag1.asSequence() << endl;
}

void test_sequence()
{
    Sequence<Integer> seq1, seq2;

    seq1 = seq1.including(4).including(5).including(3).
        including(79).including(79);
    cout << "seq1 = " << seq1 << endl;

    seq2 = seq2.including(45).including(23).including(79);
    cout << "seq2 = " << seq2 << endl;

    cout << "seq1.size() = " << seq1.size() << endl
         << "seq2.sum()  = " << seq2.sum() << endl;

    cout << "seq1.asSet() = " << seq1.asSet() << endl
         << "seq1.asBag() = " << seq1.asBag() << endl;

    cout << "seq1.subSequence(2, 4) = " << seq1.subSequence(2, 4) << endl;
}

int main()
{
    cout << "Testing OCL basic types...\n";
    test_basic_types();

    cout << "\nTesting OCL Set...\n";
    test_set();

    cout << "\nTesting OCL Bag...\n";
    test_bag();

    cout << "\nTesting OCL Sequence...\n";
    test_sequence();

    return 0;
}
