
/*
  SCRIPTOL LIBRARY
  (c) 2002 by Denis G. Sureau
  http://www.scriptol.com
  http://www.scriptol.net

GENERAL PUBLIC LICENCE

Along with the free Scriptol to native compiler is
provided the libsol.a library. The library contains
the TEXT, DYN and ARRAY classes and lot of functions
compatibles with the Php library.
This library is the orginal work of Denis G. Sureau.
It has been registered at INPI 25 june 2002.
The Php compatible functions are original work. They
have nothing to do with Php sources.
The source of the library is furnished to registered
user of the compiler, enterprise edition.

The library is provided to allow the user to link it
with its Scriptol compiled program. He is allowed to
include the library in its program and distribute its
programs with the library included into, with no any
fee required and no any restriction or condition.

He is not allowed to distribute the compiled library as it
but in the case of an open-source program. The compiled
library may be included unchanged among other files of the
open source distribution and headers of the file to include,
libsol.hpp, text.hpp, dyn.hpp, array.hpp, fun.hpp and
other files, must be included unchanged, and must hold
my name and the address of the Scriptol site.

The source of the library is provided to licensed users
to allow them either to modify it according to their need,
or to compile it in a different file format, for a different
compiler. The registered user is not permitted to
distribute the source of the library in no any case, even
if is is modified.
*/


#ifndef _SOL_ARRAY
#define _SOL_ARRAY

class dict;
class sol_pair
{
 public:
 text key;
 dyn *value;

 sol_pair() { key = text(); value = new dyn(); }
 sol_pair(sol_pair *s)
 {
   key   = s->key;
   value = s->value;
 }
 sol_pair(int a, dyn b)
 {
  key = text(a);
  value = new dyn(b);
 }
 sol_pair(text a, dyn b)
 {
  key = a;
  value = new dyn(b);
 }
};


class array
{
 vector<text> keyList;
 vector<dyn> data;
 int freeKey;       // first free numeric key

 public:
 int indexer;
 inline int size()   { return (int) data.size(); }
 inline bool empty() { return data.empty(); }

 void clear();
 void set(const array &);
 void set(array *);
 void set(const dyn &);
 void set(char *[]);

 void operator=(array a);
 void operator=(array *a);
 void operator=(dyn a);

template<class ANY> void assign(int idx, ANY a)
 {
   int k = findKey(idx);
   if(k != -1) data[k] = dyn(a);
   push(idx, dyn(a));
 }

template<class ANY> void assign(text idx, ANY a)
 {
   int k = findKey(idx);
   if(k != -1) data[k] = dyn(a);
   push(idx, dyn(a));
 }

 array();
 array(char *a[]) { set(a); }
 array(dyn);
 template<class ANY> array(ANY a) { set(a); }

 void add(array *);

 inline array &operator+=(array x) { return operator+=(&x); }
 array &operator+=(array *);
 array &operator+=(dyn);

 dyn get(const text &);
 dyn get(const char *);
 dyn get(int);

 inline array operator+(array x) { return operator+(&x); }
 array operator+(array *);
 array operator+(dyn);
 inline array operator-(array x) { return operator-(&x); }
 array operator-(array *);
 array operator-(dyn);
 inline array operator&(array x) { return operator&(&x); }
 array operator&(array *);
 inline array operator|(array x) { return operator|(&x); }
 array operator|(array *);
 inline array operator^(array x) { return operator^(&x); }
 array operator^(array *);
 void operator-=(array x) { return operator-=(&x); }
 void operator-=(array *);
 void operator-=(dyn);
 inline bool operator==(array x) { return operator==(&x); }
 bool operator==(array *);
 bool operator==(bool);
 inline bool operator!=(array x) { return operator!=(&x); }
 bool operator!=(array *);
 bool operator!=(bool);
 inline bool operator<(array x) { return operator<(&x); }
 bool operator<(array *);
 inline bool operator>(array x) { return operator>(&x); }
 bool operator>(array *);
 inline bool operator>=(array a) { return !operator<(&a); }
 inline bool operator>=(array *a) { return !operator<(a); }
 inline bool operator<=(array b)  { return !operator>(&b); }
 inline bool operator<=(array *b) { return !operator>(b); }
 inline void operator&=(array x) { operator&=(&x); }
 void operator&=(array *);
 inline void operator|=(array x) { operator|=(&x); }
 void operator|=(array *);
 inline void operator^=(array x) { operator^=(&x); }
 void operator^=(array *);
 bool operator!();
 array &operator,(dyn);

 //===== util
 bool in(dyn *d);
 inline bool in(dyn x) { return in(&x); }
 signed int hasStrKey(const text &);
 signed int findKey(const text &);
 signed int findKey(int);
 signed int findValue(dyn);
 signed int findValue(dyn *);
 inline int find(dyn x)  { return findValue(x); }
 inline int find(dyn *x) { return findValue(x); }
 void display();
 void display(int);
 text toText();
 void pushKey(const text &);

 //===== iterator
 void reset();
 dyn inc();
 dyn dec();
 dyn current();
 text key();
 text key(int);
 dyn value();
 dyn value(int);
 dyn begin();
 dyn end();
 int index();

 //===== stack
 void push(dyn);
 void push(dyn *);
 void push(sol_pair *);
 void push(const char *);
 void push(const text &, dyn);
 void pushAdd(const text &, dyn);
// void push(int, dyn);
 void pushUnic(const text &, dyn);
 dyn  pop();
 dyn  shift();
 void unshift(dyn);
 void insert(int, dyn);

 //===== ranges
 void erase(int, int);
 void erase(int);
 array slice(int, int, int);
 void splice(int, int, array, int);
 void splice(int, int, array *, int);
 void splice(int, int);
 void splice(int);
 void splice(int, int, dyn, int);
 void splice(int, int, bool, int);

 //===== transform

 void pack();
 void swapElem(int, int);
 void keysSort(int, int);
 void dynSort(int, int);
 void sort();
 void kSort();
 void aSort();
 void unique();
 array values();
 array keys();

 //===== operations
 void clone(array *);   // copy to another array
 dyn min();
 dyn max();
 double sum();
 text join(const char *);

 int nomatch();

 //===== I/O
 void load(const char *);
 bool store(const char *);

#ifdef DEBUG
 void image();
#endif
 friend class dict;

 dyn & operator[](int);
 dyn &operator[](const char *);
 dyn &operator[](text);
 dyn at(int);
 dyn at(text);
 dyn at(const char *);

 void boundError(const text &);
};


class dict : public array
{
 void sort() { aSort(); }

 dyn &operator[](const char *);
 dyn &operator[](text);
};

ostream& operator<< (ostream& out, array *);
ostream& operator<< (ostream& out, array);

#endif

