/* 64coder.c */

#include "64coder.h"

#define DEBUG 0
#define BYTE unsigned char

static char *MapTable =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
 /*0123456789012345678901234567890123456789012345678901234567890123*/

#define INDEX_OF_A      0
#define INDEX_OF_a     26
#define INDEX_OF_0     52
#define INDEX_OF_PLUS  62
#define INDEX_OF_SLASH 63

static int GetSixBits(char c)
{if((c>='A')&&(c<='Z')) return (c - 'A' + INDEX_OF_A);
 if((c>='a')&&(c<='z')) return (c - 'a' + INDEX_OF_a);
 if((c>='0')&&(c<='9')) return (c - '0' + INDEX_OF_0);
 if(c=='+') return INDEX_OF_PLUS;
 if(c=='/') return INDEX_OF_SLASH;
 return 0;
}

/* encode 3-byte binary to 4-byte ascii */

void Encode64(LPSTR ClearPtr,   /* pointer to 3 byte binary buffer */
              LPSTR CodedPtr)   /* pointer to 4 byte ASCII buffer */
{BYTE SixBits;
 /* encode 1st 6-bits */
 SixBits = 0x3f & ((*ClearPtr) >> 2);
#if DEBUG
 printf("1st=%d\n",SixBits);
#endif
 *CodedPtr++ = MapTable[SixBits];
 /* encode 2nd 6-bits */
 SixBits = 0x30 & ((*ClearPtr++) << 4);
 SixBits |= (0x0f & ((*ClearPtr) >> 4));
#if DEBUG
 printf("2nd=%d\n",SixBits);
#endif
 *CodedPtr++ = MapTable[SixBits];
 /* encode 3rd 6-bits*/
 SixBits = 0x3c & ((*ClearPtr++) << 2);
 SixBits |= (0x03 & ((*ClearPtr) >> 6));
#if DEBUG
 printf("3rd=%d\n",SixBits);
#endif
 *CodedPtr++ = MapTable[SixBits];
 /* encode 4th 6-bits */
 SixBits = (0x3f & (*ClearPtr));
#if DEBUG
 printf("4th=%d\n",SixBits);
#endif
 *CodedPtr++ = MapTable[SixBits];
}

/* decode 4-byte ascii to 3-byte binary */

void Decode64(LPSTR CodedPtr,   /* pointer to 4 byte ASCII buffer */
              LPSTR ClearPtr)   /* pointer to 3 byte binary buffer */
{
 BYTE FirstSixBits;
 BYTE SecondSixBits;
 BYTE ThirdSixBits;
 BYTE FourthSixBits;
 /* decode 1st 6-bits */
 FirstSixBits = GetSixBits(*CodedPtr++);
#if DEBUG
 printf("1st=%d\n",FirstSixBits);
#endif
 /* decode 2nd 6-bits */
 SecondSixBits = GetSixBits(*CodedPtr++);
#if DEBUG
 printf("2nd=%d\n",SecondSixBits);
#endif
 /* decode 3rd 6-bits*/
 ThirdSixBits = GetSixBits(*CodedPtr++);
#if DEBUG
 printf("3rd=%d\n",ThirdSixBits);
#endif
 /* decode 4th 6-bits */
 FourthSixBits = GetSixBits(*CodedPtr++);
#if DEBUG
 printf("4th=%d\n",FourthSixBits);
#endif
 /* write 3 binary bytes */
 *ClearPtr++ =  (FirstSixBits<<2) | (SecondSixBits>>4);
 *ClearPtr++ = (SecondSixBits<<4) | (ThirdSixBits>>2);
 *ClearPtr++ =  (ThirdSixBits<<6) | (0x3f&FourthSixBits);
}

