/*
**  --- host.c ---
*/

#include <windows.h>
#include <winsock.h>

#include "wil.h"
#include "message.h"
#include "paint.h"
#include "about.h"

#ifdef WIN32
#define USE_INS HINSTANCE
#define USE_PTR PSTR
#else
#define USE_INS HANDLE
#define USE_PTR LPSTR
#endif

LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* public globals */

HWND hMainWnd;            /* main window handle */

/* private globals */

#define BS         8
#define LF        10
#define CR        13
#define BUF_SIZE  128
#define INFO_SIZE  40

#define GET_HOST      1
#define GET_PROTO     2
#define GET_SERVER    3

static HMENU hMenu;
static USE_INS hInstance;
static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;
static char Temp[BUF_SIZE+8];
static char InfoText[INFO_SIZE+1];
static char InBufCmd = 0;
static int  InBufLen = 0;
static char InBuffer[BUF_SIZE+1];
static SOCKET Socket = 0;
static HCURSOR ArrowCursor;
static HCURSOR WaitCursor;

/* miscellaneous functions */

static void Add2Buffer(char Chr)
{/* add char to input buffer */
 switch(Chr)
   {case BS:
      if(InBufLen>0)
        {/* backup on screen */
         DisplayChar(BS);
         /* remove last char from buffer */
         InBufLen--;
        }
      break;
    default:
      /* display char */
      DisplayChar(Chr);
      /* put into buffer */
      if(InBufLen<BUF_SIZE) InBuffer[InBufLen++] = Chr;
      break;
   }
}

static void DisplayError(int Code, LPSTR Msg)
{DisplayString("ERROR: ");
 if(Msg) DisplayString(Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    DisplayLine((LPSTR)Temp);
   }
}

/* put cursor in window */

static void SetTheFocus(void)
{/* create client area caret */
 CreateCaret(hMainWnd,NULL,3,10);
 SetCaretPos(PaintGetColPos(),PaintGetRowPos());
 ShowCaret(hMainWnd);
}

/* WinMain */

#ifdef WIN32
int WINAPI
#else
int PASCAL
#endif
WinMain(USE_INS hInst, USE_INS hPrevInstance,
        USE_PTR szCmdLine,  int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "HostIcon");
    wc.hCursor = NULL;
    wc.hbrBackground = (HBRUSH) GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "HostMenu";
    wc.lpszClassName = "HostWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "HostWClass",   "HOST",    WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,  CW_USEDEFAULT,
        WinWidth,       WinHeight,
        NULL,           NULL,
        hInstance,      NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);
 hMenu = GetMenu(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,0,0))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

#ifdef WIN32
LRESULT CALLBACK
#else
long FAR PASCAL
#endif
MainWndProc(HWND hWindow,UINT iMsg,WPARAM wParam,LPARAM lParam)
{int i, Code;
 HDC hDC;
 PAINTSTRUCT ps;
 ULONG IP;
#ifdef WIN32
#else
 static FARPROC lpfnAboutDlgProc;
#endif
 hMainWnd = hWindow;
 switch (iMsg)
    {case WM_CREATE:
      /* create cursors */
      ArrowCursor = LoadCursor(NULL, IDC_ARROW);
      WaitCursor = LoadCursor(NULL, IDC_WAIT);
      SetCursor(ArrowCursor);
#ifdef WIN32
#else
      /* create thunk for Win16 */
      lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc,hInstance);
#endif
      /* initialize paint module */
      PaintInit();
      /* attach WINSOCK */
      DisplayString("Attaching WINSOCK...");
      Code = wilAttach();
      DisplayLine("OK");
      if(Code<0) DisplayError(Code,"wilAttach fails:");
      else
        {
         wilGetDescription((LPSTR)InfoText, INFO_SIZE);
         wsprintf((LPSTR)Temp," Description: %s", (LPSTR)InfoText);
         DisplayLine((LPSTR)Temp);

         wilGetSystemInfo((LPSTR)InfoText, INFO_SIZE);
         if(*InfoText)
           {wsprintf((LPSTR)Temp," System Info: %s", (LPSTR)InfoText);
            DisplayLine((LPSTR)Temp);
           }

         wilGetVendorInfo((LPSTR)InfoText, INFO_SIZE);
         if(*InfoText)
           {wsprintf((LPSTR)Temp,"  VendorInfo: %s", (LPSTR)InfoText);
            DisplayLine((LPSTR)Temp);
           }

         wilGetMyHostName((LPSTR)InfoText, INFO_SIZE);
         wsprintf((LPSTR)Temp,"My Host Name: %s", (LPSTR)InfoText);
         DisplayLine((LPSTR)Temp);

         DisplayString("My Host Addr: ");
         for(i=0;i<8;i++)
         {Code = wilGetMyHostDotted(i,(LPSTR)InfoText, INFO_SIZE);
          if(Code==WIL_NO_HOST) break;
            DisplayLine((LPSTR)InfoText);
           }
        }
      DestroyCaret();
      break;

     case WM_COMMAND:
         switch(wParam)
           {
            case MSG_ABOUT :
#ifdef WIN32
               DialogBox(hInstance, "AboutBox", hMainWnd, AboutDlgProc);
#else
               DialogBox(hInstance, "AboutBox", hMainWnd, lpfnAboutDlgProc);
#endif
               return 0;

            case MSG_BREAK:
              wilCloseSocket(Socket,500);
              break;

            case MSG_EXIT:
              wilRelease();
              DestroyWindow(hMainWnd);
              break;

            case MSG_GET_HOST:
              InBufLen = 0;
              InBufCmd = GET_HOST;
              SetTheFocus();
              DisplayString("Enter host name:");
              break;

            case MSG_GET_PROTO:
              InBufLen = 0;
              InBufCmd = GET_PROTO;
              SetTheFocus();
              DisplayString("Enter protocol name:");
              break;
           }
         break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(PaintGetColPos(),PaintGetRowPos());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    case WM_CHAR:
      if(wParam==CR)
        {/* do the CR */
         DisplayChar((char)wParam);
         /* user has completed input */
         DisplayChar(LF);
         InBuffer[InBufLen] = '\0';
         DestroyCaret();
         SetCursor(WaitCursor);
         /* execute command */
         switch(InBufCmd)
            {
             case GET_HOST:
               if(wilIsDotted((LPSTR)InBuffer))
                 {/* have dotted address */
                  IP = wilMakeAddr((LPSTR)InBuffer);
                  DisplayLine("Looking up host by address...");
                  Code = wilGetHostName((LPSTR)InBuffer,(LPSTR)Temp, BUF_SIZE);
                  if(Code<=0)
                    {DisplayError(Code, "wilGetHostName: ");
                     break;
                    }
                  DisplayLine((LPSTR)Temp);
                  wsprintf((LPSTR)Temp,"IP = %lx", IP);
                  DisplayLine((LPSTR)Temp);
                 }
               else
                 {/* have host name */
                  DisplayLine("Looking up host by name...");
                    {Code = wilGetHostDotted((LPSTR)InBuffer,0,(LPSTR)Temp, BUF_SIZE);
                     if(Code==0) break;
                     if(Code<0)
                       {DisplayError(Code, "wilGetHostDotted: ");
                        break;
                       }
                     DisplayLine((LPSTR)Temp);
                    }
                 }

               break;

             case GET_PROTO:
               Code = (int) wilGetProtoNumber((LPSTR)InBuffer);
               if(Code<0)
                 {DisplayError(Code,"wilGetProtoNumber: ");
                  break;
                 }
               InBufCmd = 0;
               wsprintf((LPSTR)Temp,"Protocol name: %s (%d)",
                        (LPSTR)InBuffer, Code);
               DisplayLine((LPSTR)Temp);
               break;

             default:
               break;
            } /* end-switch(InBufCmd) */
         SetCursor(ArrowCursor);
        }
      else
        {/* add char to input buffer */
         Add2Buffer((char) wParam);
        }
      break;

    default:
      return (DefWindowProc(hMainWnd, iMsg, wParam, lParam));
   }
 return 0;

} /* end MainWndProc */

