/*
**  VIEW.C
**
**  WWW client. Uses synchronous calls.
*/

#include <windows.h>
#include <winsock.h>

#include "wil.h"
#include "message.h"
#include "paint.h"
#include "about.h"
#include "str.h"

#ifdef WIN32
#define USE_INS HINSTANCE
#define USE_PTR PSTR
#else
#define USE_INS HANDLE
#define USE_PTR LPSTR
#endif

LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* globals */

HWND hMainWnd;            /* main window handle */

#define BS            8
#define LF           10
#define CR           13
#define MAX_BUF     256
#define MAX_STR      40

#define ONE_SEC     1000
#define TEN_SEC    10000
#define TWENTY_SEC 20000

#define WWW_PORT  80

static HMENU hMenu;
static USE_INS hInstance;
static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;
static char Temp[MAX_BUF+8];
static int  InBufLen = 0;
static char InBuffer[MAX_BUF+1];
static SOCKET Socket = 0;
static ULONG  HostAddr = 0;
static LPSTR  Ptr;
static char WorkBuf[MAX_BUF+1] = "";
static char URL[MAX_STR] = "";
static char URI[MAX_STR] = "";
static HCURSOR ArrowCursor;
static HCURSOR WaitCursor;

/* sets the focus to client area */

static void SetTheFocus(void)
{/* create client area caret */
 CreateCaret(hMainWnd,NULL,3,10);
 SetCaretPos(PaintGetColPos(),PaintGetRowPos());
 ShowCaret(hMainWnd);
}

/* append character to buffer */

static void Add2Buffer(char Chr)
{/* add char to input buffer */
 switch(Chr)
   {case BS:
      if(InBufLen>0)
        {/* backup on screen */
         DisplayChar(BS);
         /* remove last char from buffer */
         InBufLen--;
        }
      break;
    default:
      /* display char */
      DisplayChar(Chr);
      /* put into buffer */
      if(InBufLen<MAX_BUF) InBuffer[InBufLen++] = Chr;
      break;
   }
}

/* display error code & text */

static void DisplayError(int Code, LPSTR Msg)
{DisplayString("ERROR: ");
 if(Msg) DisplayString(Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    DisplayLine((LPSTR)Temp);
   }
 SetCursor(ArrowCursor);
}

/* WinMain */

#ifdef WIN32
int WINAPI
#else
int PASCAL
#endif
WinMain(USE_INS hInst, USE_INS hPrevInstance,
        USE_PTR szCmdLine,  int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "HostIcon");
    wc.hCursor = NULL;
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "HostMenu";
    wc.lpszClassName = "HostWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "HostWClass",   "WWW_VIEW",    WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,  CW_USEDEFAULT,
        WinWidth,       WinHeight,
        NULL,           NULL,
        hInstance,      NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);
 hMenu = GetMenu(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,0,0))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

#ifdef WIN32
LRESULT CALLBACK
#else
long FAR PASCAL
#endif
MainWndProc(HWND hWindow,UINT iMsg,WPARAM wParam,LPARAM lParam)
{int Code;
 HDC hDC;
 PAINTSTRUCT ps;
#ifdef WIN32
#else
 static FARPROC lpfnAboutDlgProc;
#endif
 hMainWnd = hWindow;
 switch (iMsg)
    {case WM_CREATE:
      /* create cursors */
      ArrowCursor = LoadCursor(NULL, IDC_ARROW);
      WaitCursor = LoadCursor(NULL, IDC_WAIT);
      SetCursor(ArrowCursor);
#ifdef WIN32
#else
       /* create thunk for Win16 */
       lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc,hInstance);
#endif
      /* initialize paint module */
      PaintInit();
      /* attach WINSOCK */
      DisplayString("Attaching WINSOCK...");
      Code = wilAttach();
      DisplayLine("OK");
      if(Code<0) DisplayError(Code,"wilAttach fails:");
      else
        {DisplayString(" Description: ");
         wilGetDescription((LPSTR)Temp, MAX_BUF);
         DisplayLine((LPSTR)Temp);
         DisplayString("My Host Name: ");
         wilGetMyHostName((LPSTR)Temp, MAX_BUF);
         DisplayLine((LPSTR)Temp);
         DisplayString("My Host Addr: ");
         wilGetMyHostDotted(0,(LPSTR)Temp, MAX_BUF);
         DisplayLine((LPSTR)Temp);
        }
      break;

     case WM_COMMAND:
         switch(wParam)
           {
            case MSG_ABOUT:
#ifdef WIN32
               DialogBox(hInstance, "AboutBox", hMainWnd, AboutDlgProc);
#else
               DialogBox(hInstance, "AboutBox", hMainWnd, lpfnAboutDlgProc);
#endif
               return 0;
            case MSG_EXIT:
              wilRelease();
              DestroyWindow(hMainWnd);
              break;

            case MSG_DEBUG:
              Code = wilDebug(0);
              wsprintf((LPSTR)Temp,"Debug(0) returned %d",Code);
              DisplayLine((LPSTR)Temp);
              break;

            case MSG_WWW_HEAD:
              InBufLen = 0;
              DisplayLine("Enter URL (eg: 'www.marshallsoft.com/hello.htm') to view");
              DisplayString("URL: ");
              SetTheFocus();
              break;
           }
         break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(PaintGetColPos(),PaintGetRowPos());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    case WM_CHAR:
      if(wParam==CR)
        {/* do the CR */
         DisplayChar((char)wParam);
         /* user has completed input */
         DestroyCaret();
         DisplayChar(LF);
         InBuffer[InBufLen] = '\0';
#if 0
wsprintf((LPSTR)Temp,"[%s]",(LPSTR)InBuffer); /*DEL*/
DisplayLine((LPSTR)Temp); /*DEL*/
#endif
         StringCopy((LPSTR)WorkBuf,(LPSTR)InBuffer,MAX_BUF);
         DisplayLine((LPSTR)WorkBuf);
         /* extract the URL & URI */
         Ptr = StringChar((LPSTR)WorkBuf,'/');

#if 0
wsprintf((LPSTR)Temp,"(%s)",(LPSTR)Ptr); /*DEL*/
DisplayLine((LPSTR)Temp); /*DEL*/
#endif
         if(Ptr)
           {*Ptr = '\0';
            StringCopy((LPSTR)URL,(LPSTR)WorkBuf,MAX_STR);
            StringCopy((LPSTR)URI,(LPSTR)(Ptr+1),MAX_STR);
           }
         else
           {/* assume "index.html" */
            StringCopy((LPSTR)URL,(LPSTR)WorkBuf,MAX_STR);
            StringCopy((LPSTR)URI,"index.html",MAX_STR);
           }
         /* excute command */
         wsprintf((LPSTR)Temp,"URL: %s",(LPSTR)URL);
         DisplayLine((LPSTR)Temp);
         wsprintf((LPSTR)Temp,"URI: %s",(LPSTR)URI);
         DisplayLine((LPSTR)Temp);
         /* put up hour glass */
         SetCursor(WaitCursor);
         /* get host IP address */
         HostAddr = wilGetHostAddr((LPSTR)URL,0);
         if(HostAddr==0)
           {DisplayError(0, "Cannot get IP addess");
            break;
           }
         wsprintf((LPSTR)Temp,"HostAddr = %lx\n", HostAddr);
         DisplayLine((LPSTR)Temp);
         /* create TCP socket */
         Socket = wilTcpSocket();
         if((int)Socket<0)
           {DisplayError((int)Code, NULL);
            break;
           }
         /* attempt to connect to remote host */
         Code = wilConnect(Socket,HostAddr,WWW_PORT);
         if(Code<0)
           {DisplayError(Code, NULL);
            break;
           }
         /* wait up to 30 seconds for connection */
         if(wilIsConnected(Socket,30000))
           {wsprintf((LPSTR)Temp,"Connected to %s", URL);
            DisplayLine((LPSTR)Temp);
           }
         else
           {/* couldn't connect within 30 seconds */
            DisplayLine("Cannot CONNECT");
            break;
           }
         /* send GET request */
         ///wsprintf((LPSTR)Temp,"GET /%s HTTP/1.0\r\n",(LPSTR)URI);
         wsprintf((LPSTR)Temp,"GET /%s HTTP/1.0\r\nHost:%s\r\n",(LPSTR)URI,(LPSTR)URL);
         DisplayString((LPSTR)Temp);
         wilWriteLine(Socket,(LPSTR)Temp);
         /* wait up to 20 seconds for response */
         if(wilDataIsReady(Socket, TWENTY_SEC))
           {/* read socket */
            while(1)
              {/* wait for next string */
               if(!wilDataIsReady(Socket, ONE_SEC)) break;
               /* read the string */
               Code = wilReadString(Socket,(LPSTR)InBuffer,MAX_BUF);
               if(Code<=0) break;
               /* display for user */
               wsprintf((LPSTR)Temp,"%s", (LPSTR)InBuffer);
               DisplayString((LPSTR)Temp);
              }
            DisplayLine("");
           }
         else DisplayLine("No response from server.");
         SetCursor(ArrowCursor);
         wilCloseSocket(Socket,500);
        }
      else
        {/* add char to input buffer */
         Add2Buffer((char)wParam);
        }
      break;

    default:
      return (DefWindowProc(hMainWnd, iMsg, wParam, lParam));
   }
 return 0;
}


