/*
**  WHO_C.C [WHOIS Client] ---
**
**  After selecting the "WhoIs" memu button, enter
**
**    mike@XXX
**
**  for mike's email address where XXX is the name of host
**  where the host is running.
*/

#include <windows.h>
#include <winsock.h>

#include "wil.h"
#include "message.h"
#include "paint.h"
#include "about.h"
#include "str.h"

#ifdef WIN32
#define USE_INS HINSTANCE
#define USE_PTR PSTR
#else
#define USE_INS HANDLE
#define USE_PTR LPSTR
#endif

LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM);

/* public globals */

HWND hMainWnd;            /* main window handle */

#define BS          8
#define LF         10
#define CR         13
#define BUF_LEN    50
#define ONE_SEC  1000
#define TEN_SEC 10000

#define WHOIS_PORT    5001

static HMENU hMenu;
static USE_INS hInstance;
static int WinWidth = 8 * NCOLS;
static int WinHeight = 12 * NROWS + 48;
static int  InBufLen = 0;
static char Temp[BUF_LEN+8];
static char InfoText[BUF_LEN+1];
static char InBuffer[BUF_LEN+1];
static char UserName[BUF_LEN] = "\0";
static char HostName[BUF_LEN] = "\0";
static SOCKET Socket = 0;
static ULONG  HostIP = 0;
static LPSTR  Ptr;

/* miscellaneous functions */

static void Add2Buffer(char Chr)
{/* add char to input buffer */
 switch(Chr)
   {case BS:
      if(InBufLen>0)
        {/* backup on screen */
         DisplayChar(BS);
         /* remove last char from buffer */
         InBufLen--;
        }
      break;
    default:
      /* display char */
      DisplayChar(Chr);
      /* put into buffer */
      if(InBufLen<BUF_LEN) InBuffer[InBufLen++] = Chr;
      break;
   }
}

/* display error message */

static void DisplayError(int Code, LPSTR Msg)
{DisplayString("ERROR: ");
 if(Msg) DisplayString(Msg);
 if(Code)
   {wilErrorText(Code,(LPSTR)Temp,50);
    DisplayLine((LPSTR)Temp);
   }
}

/* WinMain */

#ifdef WIN32
int WINAPI
#else
int PASCAL
#endif
WinMain(USE_INS hInst, USE_INS hPrevInstance,
        USE_PTR szCmdLine,  int nCmdShow)
{WNDCLASS  wc;
 MSG msg;
 BOOL Result;
 if(!hPrevInstance)
   {/* register main window class */
    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInst;
    wc.hIcon = LoadIcon(hInst, "HostIcon");
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "HostMenu";
    wc.lpszClassName = "HostWClass";
    Result = RegisterClass(&wc);
    if(!Result) return FALSE;
   }

 /* create main window */
 hInstance = hInst;
 hMainWnd = CreateWindow(
        "HostWClass",   "WHOIS Client",    WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT,  CW_USEDEFAULT,
        WinWidth,       WinHeight,
        NULL,           NULL,
        hInstance,      NULL);
 ShowWindow(hMainWnd, nCmdShow);
 UpdateWindow(hMainWnd);
 hMenu = GetMenu(hMainWnd);

 /* window control loop */

 while(GetMessage(&msg,NULL,0,0))
   {
    TranslateMessage(&msg);
    DispatchMessage(&msg);
   }
 return (msg.wParam);
} /* end WinMain */

#ifdef WIN32
LRESULT CALLBACK
#else
long FAR PASCAL
#endif
MainWndProc(HWND hWindow,UINT iMsg,WPARAM wParam,LPARAM lParam)
{int Code;
 HDC hDC;
 PAINTSTRUCT ps;
#ifdef WIN32
#else
 static FARPROC lpfnAboutDlgProc;
#endif
 hMainWnd = hWindow;
 switch (iMsg)
    {case WM_CREATE:
#ifdef WIN32
#else
       /* create thunk for Win16 */
       lpfnAboutDlgProc = MakeProcInstance(AboutDlgProc,hInstance);
#endif
      /* initialize paint module */
      PaintInit();
      /* attach WINSOCK */
      DisplayString("Attaching WINSOCK...");
      Code = wilAttach();
      DisplayLine("OK");
      if(Code<0) DisplayError(Code,"wilAttach fails:");
      else
        {wilGetDescription((LPSTR)InfoText, BUF_LEN);
         wsprintf((LPSTR)Temp," Description: %s", (LPSTR)InfoText);
         DisplayLine((LPSTR)Temp);
         wilGetMyHostName((LPSTR)InfoText, BUF_LEN);
         wsprintf((LPSTR)Temp,"My Host Name: %s", (LPSTR)InfoText);
         DisplayLine((LPSTR)Temp);
         wilGetMyHostDotted(0,(LPSTR)InfoText, BUF_LEN);
         wsprintf((LPSTR)Temp,"My Host Addr: %s", (LPSTR)InfoText);
         DisplayLine((LPSTR)Temp);
        }
      break;

     case WM_COMMAND:
         switch(wParam)
           {case MSG_ABOUT :
#ifdef WIN32
               DialogBox(hInstance, "AboutBox", hMainWnd, AboutDlgProc);
#else
               DialogBox(hInstance, "AboutBox", hMainWnd, lpfnAboutDlgProc);
#endif
               return 0;

            case MSG_EXIT:
              wilRelease();
              DestroyWindow(hMainWnd);
              break;

            case MSG_WHOIS:
              InBufLen = 0;
              DisplayString("WHOIS: Enter user@host:");
              break;

           }
         break;

    case WM_PAINT:
      HideCaret(hMainWnd);
      hDC = BeginPaint(hMainWnd, &ps);
      SetMapMode(hDC,MM_ANISOTROPIC);
      SelectObject(hDC, GetStockObject(OEM_FIXED_FONT) );
      PaintMain(hDC,&ps);
      EndPaint(hMainWnd,&ps);
      SetCaretPos(PaintGetColPos(),PaintGetRowPos());
      ShowCaret(hMainWnd);
      break;

    case WM_DESTROY:
      PostQuitMessage(0);
      break;

    case WM_CHAR:
      if(wParam==CR)
        {/* do the CR */
         DisplayChar((char)wParam);
         /* user has completed input */
         DisplayChar(LF);
         InBuffer[InBufLen] = '\0';
         wsprintf((LPSTR)Temp,"WHOIS %s", InBuffer);
         DisplayLine((LPSTR)InBuffer);
         /* extract user & host names */
         Ptr = StringChar((LPSTR)InBuffer,'@');
         if(Ptr==NULL)
           {DisplayError(Code, "Cannot recognize User@Domain");
            break;
           }
         *Ptr = '\0';
         lstrcpy((LPSTR)UserName, (LPSTR)InBuffer);
         lstrcpy((LPSTR)HostName, (LPSTR)(++Ptr));
         wsprintf((LPSTR)Temp,"UserName ='%s'", (LPSTR)UserName);
         DisplayLine(Temp);
         wsprintf((LPSTR)Temp,"Domain ='%s'", (LPSTR)HostName);
         DisplayLine(Temp);
         if(wilIsDotted((LPSTR)HostName))
           {/* host name is a dotted address */
            HostIP = wilMakeAddr(HostName);
           }
         else
           {/* get host IP address */
            HostIP = wilGetHostAddr((LPSTR)HostName,0);
            if(HostIP==0)
              {DisplayLine("No such host name.");
               break;
              }
            DisplayString("Host IP = ");
            wilMakeDotted(HostIP,(LPSTR)Temp,BUF_LEN);
            DisplayLine((LPSTR)Temp);
           }

         /* create TCP socket */
         Socket = wilTcpSocket();
         if((int)Socket<0)
           {DisplayError((int)Code, NULL);
            break;
           }
         /* attempt to connect to remote host */
         Code = wilConnect(Socket,HostIP,WHOIS_PORT);
         if(Code<=0)
           {DisplayError(Code, NULL);
            break;
           }
         /* wait up to 10 seconds for a response */
         if(wilIsConnected(Socket,10000))
           {wsprintf((LPSTR)Temp,"Connected: Addr=%lx Port=%d",
                      wilRemoteSockAddr(Socket), wilRemoteSockPort(Socket) );
            DisplayLine((LPSTR)Temp);
           }
         else
           {DisplayLine("Cannot CONNECT");
            break;
           }
         /* send user name */
         wsprintf((LPSTR)Temp,"Whois [%s]",(LPSTR)UserName);
         DisplayLine((LPSTR)Temp);
         Code = wilWriteString(Socket,(LPSTR)UserName);
         if(Code<=0)
           {DisplayError(Code, NULL);
            break;
           }
         /* read response */
         while(1)
            {if(!wilDataIsReady(Socket,TEN_SEC)) break;
             Code = wilReadString(Socket,(LPSTR)InBuffer,BUF_LEN);
             if(Code==WIL_EOF) break;
             if(Code>0)
               {wsprintf((LPSTR)Temp,"%s", (LPSTR)InBuffer);
                DisplayString((LPSTR)Temp);
               }
             DisplayLine("<DONE>");
             wilCloseSocket(Socket,500);
            }
        }
      else
        {/* add char to input buffer */
         Add2Buffer((char) wParam);
        }
      break;

    default:
      return (DefWindowProc(hMainWnd, iMsg, wParam, lParam));
   }
 return 0;
}


