/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>

#ifdef NONRECURSIVE
static char ibuf[256];
#endif
char *tmpnam(char *buf)
{
#ifndef NONRECURSIVE
	char pbuf[STACKPAD];
	char ibuf[256];
#endif
	time_t time1;
	struct tm *ltime;
	int i,q=0;
	FILE *fil;
	time(&time1);
	ltime = localtime(&time1);
	while (1) {
		ibuf[0] = (char)(ltime->tm_year/26);
		ibuf[1] = (char)ltime->tm_mon;
		ibuf[2] = (char)ltime->tm_mday;
		ibuf[3] = (char)ltime->tm_hour;
		ibuf[4] = (char)(ltime->tm_min/36);
		ibuf[5] = (char)(ltime->tm_min%36);
		ibuf[6] = (char)(ltime->tm_sec/36);
		ibuf[7] = (char)(ltime->tm_sec%36);
		ibuf[8] = '.';
		ibuf[9] = 'T';
		ibuf[10] = 'M';
		ibuf[11] = 'P';
		ibuf[12] = 0;
		for (i=0; i < 8; i++) {
			ibuf[i] += 'A';
			if (ibuf[i] > 'Z')
				ibuf[i]+= '0' - 'A';
		}
		fil = fopen(ibuf,"rb");
		if (!fil)
		  break;
		fclose(fil);
		if (q % 26 == 0) {
			ltime->tm_mon++;
			if (ltime->tm_mon > 11)
				ltime->tm_mon = 0;
		}
		q++;
		ltime->tm_year++;
	}
	if (buf) {
		strcpy(buf,ibuf);
		return buf;
	}
	else
		return &ibuf;
}
FILE *tmpfile(void)
{
	char buf[20];
	FILE *stream = fopen(tmpnam(buf),"wb+");
	if (stream)
		stream->istemp = 1;
	return stream;
}