/* 
   Copyright 1994-2003 Free Software Foundation, Inc.

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
   USA

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
*/
#include <stdio.h>

/* must define errno and _dos_errno in the low-level code */

extern int errno;

char *_sys_errlist[] ={
	"Error 0",
	"Invalid function number",
	"File not found",
	"Path not found",
	"Memory blocks destroyed",
	"Invalid memory block address",
	"Invalid environment",
	"Invalid format",
	"Invalid access code",
	"Invalid data",
	"Invalid drive specified",
	"Attempt to remove CurDir",
	"Not same device",
	"No more files",
	"No such file or director",
	"Too many open files",
	"Permission denied",
	"Bad file number",
	"Not enough core",
	"Unknown error",
	"No such device",
	"Invalid argument",
	"Arg list too long",
	"Exec format error",
	"Cross-device link",
	"Too many open files",
	"No child process",
	"UNIX - not MSDOS",
	"UNIX - not MSDOS",
	"UNIX - not MSDOS",
	"No space left on device",
	"Illegal seek",
	"Read-only file system",
	"UNIX - not MSDOS",
	"Broken pipe",
	"Math argument",
	"Result too large",
	"File already exists",
	"Locking violation",
	"Operation not permitted",
	"UNIX - not MSDOS",
	"Interrupted function call",
	"Input/output error",
	"No such device or address",
	"Resource temporarily unavailable",
	"UNIX - not MSDOS",
	"Resource busy",
	"UNIX - not MSDOS",
	"UNIX - not MSDOS",
	"UNIX - not MSDOS",
	"Filename too long"
};
int _sys_nerr = sizeof (_sys_errlist) / sizeof(char *) ;

void perror(const char *string)
{
   char *str ;
   if (errno > _sys_nerr)
      str = "Unkown error" ;
   else
      str = _sys_errlist[errno] ;
   if (string && *string) {
      fputs(string,stderr) ;
      fputs(": ",stderr) ;
   }
   fputs(str,stderr) ;
   fputs("\n",stderr) ;
}