; 
;   Copyright 1994-2003 Free Software Foundation, Inc.
;
;   This library is free software; you can redistribute it and/or
;   modify it under the terms of the GNU Lesser General Public
;   License as published by the Free Software Foundation; either
;   version 2.1 of the License, or (at your option) any later version.
;
;   This library is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;   Lesser General Public License for more details.
;
;   You should have received a copy of the GNU Lesser General Public
;   License along with this library; if not, write to the Free Software
;   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 
;   USA
;
;   You may contact the author at:
;
;   mailto::camille@bluegrass.net
;
;   or by snail mail at:
;
;   David Lindauer
;   850 Washburn Ave Apt 99
;   Louisville, KY 40222
;
	;MASM MODE
	.386
	.MODEL use32 small


include  prints.ase 
include  input.ase 
include  mtrap.ase 

	PUBLIC search
	.data
count	dw	0
stab	db	128 DUP (0)


	.CODE
search	PROC
	mov	[count],0
	call	WadeSpace
	jz	errx
	call	ReadAddress	; read address
	jc	errx
	mov	ecx,ebx
	call	WadeSpace
	jz	errx
	push	ecx
	mov	edi,edx
	push	edi
	call	ReadAddress	; read len
	pop	edi
	pop	ecx
	jc	errx
	push	edi
	mov	edi,offset DGROUP:stab
grablp:				; read rest of params
	call	WadeSpace
	jz	grabdone
	cmp	al,"'"
	jz	readstring
	cmp	al,'"'
	jnz	readnum
readstring:             	; read a quoted string
	inc	esi
readstringlp:
	lodsb
	cmp	al,13
	jz	grabdone
	cmp	al,'"'
	jz	grablp
	cmp	al,"'"
	jz	grablp
	stosb
	inc	[count]
	cmp	[count],080h
	jnc	errx
	jmp	readstringlp

readnum:			; read an (8-bit) number
	push	edi
	push	ecx
	call	ReadNumber
	pop	ecx
	pop	edi
	jc	errx2
	stosb
	inc	[count]
	cmp	[count],080h
	jnc	errx
	jmp	grablp

grabdone:                       	; all params got now
	pop	edi
	test	[count],0ffh		; see if any search
	jz	errx
	sub	ebx,ecx
	push	ebx
	call	crlf
	pop	ebx
	mov	esi,ecx
go1:
	call	ScanKey		; I put this in for debug, but,
	jnz	nofill2		; good for mistakes too...
	movzx	ecx,[count]
	push	esi
	mov	edi,offset DGROUP:stab
	repe	cmpsb
	pop	esi
	jnz	nomatch
	push	ebx
	mov	eax,esi		; match, display address
	call	PrintDword
	call	crlf
	pop	ebx
nomatch:
	inc	esi
	dec	ebx
	jne	go1
	clc
	ret
nofill:
nofill2:
	clc
	ret
errx2:
	pop	edi
errx:
	stc
	ret
search	endp
end