/* 
   Copyright 2001-2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
   02111-1307, USA.  

   You may contact the author at:

   mailto::camille@bluegrass.net

   or by snail mail at:

   David Lindauer
   850 Washburn Ave Apt 99
   Louisville, KY 40222
**********************************************************************

PRINT.C holds the functionality to display a print dialog and print
the results out to the printer.

**********************************************************************
*/
#include <windows.h>
#include <commctrl.h>
#include <stdio.h>
#include <time.h>
#include "header.h"

extern int tabs ;

extern HINSTANCE hInstance ;
extern HWND hwndFrame ;
static LOGFONT fontdata = {
	16,0,0,0,FW_NORMAL,FALSE,FALSE,FALSE,ANSI_CHARSET,OUT_DEFAULT_PRECIS,
	CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, FIXED_PITCH | FF_DONTCARE,
	"Courier New"
} ;

static int printing ;

static int leftmargin=0, rightmargin=0 ;
static int topmargin=0, bottommargin=0 ;

static BOOL CALLBACK AbortProc(HDC hDC, int error)
{
   return printing ;
}
static LRESULT CALLBACK CancelProc(HWND hwnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
   switch(iMessage) {
      case WM_COMMAND:
         if (LOWORD(wParam) == IDCANCEL)
            printing = FALSE ;
         break ;
   }
   return 0 ;
}
void Print(HWND win)
{
   int start,end ;
   PRINTDLG pd ;
   HWND hDlgCancel = 0 ;
   memset(&pd,0,sizeof(pd)) ;
   pd.lStructSize = sizeof(pd) ;
   pd.hwndOwner = hwndFrame ;
   pd.Flags = PD_NOPAGENUMS | PD_RETURNDC | PD_COLLATE ;
   pd.hInstance = hInstance ;
   SendDlgItemMessage(win,ID_EDITCHILD,EM_GETSEL,(WPARAM)&start, (LPARAM)&end) ;
   if (end != start)
      pd.Flags |= PD_SELECTION ;
   if (PrintDlg(&pd)) {
      DOCINFO di ;
      HWND child ;
      char *buf,*pos,*savepos1 ;
      if (pd.Flags & PD_SELECTION) {
         if (end <= start)
            return ;
      }
      child = GetDlgItem(win,ID_EDITCHILD) ;
      buf = GetEditData(child) ;
      if (!buf)
         return ;
      if (pd.Flags & PD_SELECTION) {
         savepos1 = pos = buf + start ;
         buf[end] = 0 ;
      } else
         savepos1 = pos = buf ;
      printing = TRUE ;
      memset(&di,0,sizeof(di)) ;
      di.cbSize = sizeof(di) ;
      di.lpszDocName = (char *)SendMessage(win,WM_FILETITLE,0,0) ;
      if (pd.Flags & PD_PRINTTOFILE)
         di.lpszOutput = "FILE:" ;
      SetAbortProc(pd.hDC,&AbortProc) ;

      if (StartDoc(pd.hDC,&di) > 0) {
         int pelsx,pelsy ;
         int width, height,rows,cols;
         int done = FALSE ;
         SIZE strsize,timesize ;
         char tmc[256] ;
         time_t times ;
         struct tm *tms ;
         HFONT hFont,oldhFont ; 
         EnableWindow(hwndFrame,FALSE );
         hDlgCancel = CreateDialog(hInstance,"PRINTABORTDLG",0, (DLGPROC)CancelProc) ; 
         pelsx = GetDeviceCaps(pd.hDC,LOGPIXELSX) ;
         pelsy = GetDeviceCaps(pd.hDC,LOGPIXELSY) ;
         fontdata.lfHeight = -MulDiv(11,pelsx, 72) ;
         hFont = CreateFontIndirect(&fontdata ) ;
         width = GetDeviceCaps(pd.hDC,HORZRES) ;
         height = GetDeviceCaps(pd.hDC,VERTRES) ;
         buf = GetEditData(win) ;
         oldhFont = SelectObject(pd.hDC,hFont );
         GetTextExtentPoint32(pd.hDC,"A",1,&strsize) ;
         SelectObject(pd.hDC,oldhFont ) ;
         rows = (height - (topmargin + bottommargin)*pelsy/10)/strsize.cy - 2 ;
         cols = (width - (leftmargin + rightmargin)*pelsx/10)/strsize.cx  ;

         time(&times) ;
         tms = localtime(&times) ;
         strcpy(tmc,asctime(tms)) ;
         tmc[strlen(tmc)-1] = 0 ;
         GetTextExtentPoint32(pd.hDC, tmc, strlen(tmc), &timesize) ;
         timesize.cx = (leftmargin*pelsx/10 + width-rightmargin*pelsx/10)/2 - timesize.cx/2 ;
         do {
            int colcount = pd.nCopies ;
            int pagenum = 1 ;
            pos = savepos1 ;
            while (printing && *pos && StartPage(pd.hDC) > 0) {
               int i,j,k ;
               char line[512] ;
               char *savepos2 = pos ;
               oldhFont = SelectObject(pd.hDC,hFont);
               sprintf(line,"File: %s",di.lpszDocName) ;
               TextOut(pd.hDC,leftmargin*pelsx/10,topmargin*pelsy/10,line,strlen(line)) ;
               sprintf(line,"Page: %3d",pagenum) ;
               TextOut(pd.hDC,(cols - strlen(line))*strsize.cx-rightmargin*pelsx/10,topmargin*pelsy/10,line,strlen(line)) ;
               TextOut(pd.hDC,timesize.cx,topmargin*pelsy/10,tmc,strlen(tmc)) ;
               for (i=0; i < rows; i++) {
                  int count=0 ;
                  for (j=0; j < cols; j++) {
                     if (*pos == '\t') {
                        pos++ ;
                        for (k=0; k < tabs; k++)
                           line[count++] = ' ' ;
                        j += tabs-1 ;
                     } else {
                        if (*pos < 32 || *pos > 126)
                           break ;
                        line[count++] = *pos++ ;
                     }
                  }
                  TextOut(pd.hDC,leftmargin*pelsx/10,(i+2)*strsize.cy+topmargin*pelsy/10,line,count) ;
                  while (*pos && (*pos != '\t' && (*pos < 32 || *pos > 126)))
                     pos++ ;
                  if (!*pos)
                     break ;
               }
               SelectObject(pd.hDC,oldhFont) ;
               if (printing)
                   if (EndPage(pd.hDC) <= 0)
                     goto doneprinting ;
               if (!(pd.Flags & PD_COLLATE) && --colcount) {
                  pos = savepos2 ;
               } else {
                  colcount = pd.nCopies ;
                  pagenum++ ;
               }
            }
         } while (printing && (pd.Flags & PD_COLLATE ) && --pd.nCopies)  ;

         if (!printing)
            AbortDoc(pd.hDC) ;
doneprinting:
         if (printing)
            EndDoc(pd.hDC) ;
         EnableWindow(hwndFrame,TRUE) ;
         if (hDlgCancel)
            DestroyWindow(hDlgCancel) ;
         DeleteObject(hFont) ;
      }
      free(buf) ;

   }
   if (pd.hDC != NULL)
      DeleteDC(pd.hDC) ;
   if (pd.hDevMode != NULL)
      GlobalFree(pd.hDevMode) ;
   if (pd.hDevNames != NULL)
      GlobalFree(pd.hDevNames) ;
}