//--------------------------------------------------------------------
// MS SQL Extended Stored Procedure Class header file: xproc.h
//
// Copyright (c) 2002-2003 Leonid Belousov
//
// www.bramc.ru/soft/
// mc@bramc.ru
//
//////////////////////////////////////////////////////////////////////


#if !defined(AFX_XPROC_H__FFA4B64F_D6CE_11D6_B969_00E01890B049__INCLUDED_)
#define AFX_XPPROC_H__FFA4B64F_D6CE_11D6_B969_00E01890B049__INCLUDED_



#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


// Insert your headers here
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers

#include <vector>
#include <objbase.h>
#include <oleauto.h>
#include <srv.h>


#ifdef __cplusplus
extern "C" {
#endif 

#ifdef __cplusplus
}
#endif 


namespace XProc {

	using namespace std;

	//const SecsPerDay	86400.0f; //24*3600;

	typedef enum FieldType {	// maps to MS SQL datatype:
		ftUnknown,
		ftInteger,		// INT
		ftBoolean,		// BIT
		ftBytes,		// BINARY, VARBINARY
		ftDateTime,		// DATETIME 
		ftFloat,		// FLOAT
		ftCurrency,		// MONEY
		ftBCD,			// NUMERIC, DECIMAL, and BIGINT 
		ftString,		// CHAR, VARCHAR
		ftWideString,	// NCHAR, NVARCHAR
		ftMemo,			// TEXT
		ftWideMemo,		// NTEXT
		ftBlob			// IMAGE
	};


	class CXProc;
	class CxpItems;
	class CxpParams;


	// CxpItem 
	//////////////////////////////////////////////////////////////////////

	class CxpItem
	{
	friend class CxpItems;
	friend class CxpParams;
	friend class CxpFields;

	private:
		CxpItems*	p_xpItems;
		char*		m_sName;
		PBYTE		m_pbData;
		FieldType	m_DataType;
		BYTE		m_bySrvType;
		ULONG		m_dwActualLen;
		ULONG		m_dwMaxLen;
		bool		m_bOutput;

	public:
		CxpItem(CxpItems* xpItems);
		virtual ~CxpItem();

		void		Clear();
		int			Index();
		bool		IsNull();
		char* 		GetName();
		void		SetName(const char* Value);
		ULONG		Size() { return m_dwActualLen; }
		FieldType	DataType() { return m_DataType; };
		
		bool GetBit();
		void SetBit(const bool Value);

		int GetInt();
		void SetInt(const int Value);

		// Gets float(double) / money / numeric(decimal)
		double GetFloat();
		// Sets float(double)
		void SetFloat(const double Value);
		// Sets money
		void SetMoney(const double Value);
		// Sets numeric(decimal)
		void SetNumeric(const double Value);

		void GetDateTime(SYSTEMTIME& Value);
		void SetDateTime(SYSTEMTIME Value);

		// char / varchar / text
		void GetAnsiText(char** Value);
		char* GetAnsiText();
		void SetVarchar(const char* Value);
		void SetText(const char* Value);

		// nvarchar / ntext
		void GetUnicodeText(WCHAR** Value);
		WCHAR* GetUnicodeText();
		void SetNVarchar(const WCHAR* Value);
		void SetNText(const WCHAR* Value);

		// Gets binary / varbinary / image
		void GetBinary(void** Value);
		void* GetBinary();
		// Sets image
		void SetImage(const void* Value, ULONG uSize);
		// Sets binary / varbinary
		void SetVarbinary(const void* Value, ULONG uSize);

	//	__declspec(property(get=GetAsBoolean,	put=SetAsBoolean))	bool AsBoolean;
	//	__declspec(property(get=GetAsInteger,	put=SetAsInteger))	int AsInteger;
	//	__declspec(property(get=GetAsFloat,		put=SetAsFloat))	double AsFloat;
	};


	// CxpItems 
	//////////////////////////////////////////////////////////////////////

	class CxpItems : public vector<CxpItem*>
	{
	protected:
		CXProc* m_xp;
		virtual CxpItem& GetItem(size_t nIndex) { return *at(nIndex); };
	public:
		CxpItems(CXProc* xp);
		virtual ~CxpItems();

		CXProc*	xp() { return m_xp; };
		CxpItem&		operator [] (size_t nIndex) { return GetItem(nIndex); };
		void			Clear();
		int				IndexOf(const CxpItem* Value);
		CxpItem*		ByName(const char* Value);
	};



	// CxpParams
	//////////////////////////////////////////////////////////////////////

	class CxpParams : public CxpItems 
	{
	protected:
	public:
		CxpParams(CXProc* xp);
		virtual ~CxpParams();
	};


	// CxpFields
	//////////////////////////////////////////////////////////////////////

	class CxpFields : public CxpItems 
	{
	protected:
		DBINT	m_RowCount;
		virtual CxpItem& GetItem(size_t nIndex);
	public:
		CxpFields(CXProc* xp);
		virtual ~CxpFields();

		//virtual CxpItem* ByName(char* Value);
		void Next();
		void Done();
	};

	// CXProc 
	//////////////////////////////////////////////////////////////////////

	class CXProc 
	{
	private:
		SRV_PROC*	p_Handle;
		CxpParams*	p_Params;
		CxpFields*	p_Fields;

	public:
		CXProc(SRV_PROC* Handle);
		virtual ~CXProc();

		SRV_PROC* Handle() { return p_Handle; };
		CxpParams& Params() { return *p_Params; };
		CxpFields& Fields() { return *p_Fields; };

		void RaiseError(char* Value, long MsgNum = 50000, BYTE Severity = 11, BYTE State = 1);
	};

} // of namespace XProc


#endif // !defined(AFX_XPROC_H__FFA4B64F_D6CE_11D6_B969_00E01890B049__INCLUDED_)

