// <HTML><pre>
// KEHOME/test/mkrGetData.java
// Aug/21/2003
// usage: java -DKBDATA=kbdata subject predicate object

import edu.stanford.TAP.Abbrev;
import edu.stanford.TAP.Client;
import edu.stanford.TAP.Resource;
import edu.stanford.TAP.XML;

public class mkrGetData
{
    public static void main(String argv[])
    {
	String info      = "  # INFO: GetData: ";
	String tapuri    = "http://tap.stanford.edu/data/";
	String flags     = "";
	String Subflag   = "includeSubClasses=yes";
	String Superflag = "includeSuperClasses=yes";
	String debug     = "no";

	String kbdata    = System.getProperty("KBDATA");
	String subject   = argv[0];
	String predicate = argv[1];
	String object    = argv[2];

	if (debug == "yes") {
	  System.out.println(info + "tapuri = "    + tapuri);
	  System.out.println(info + "kbdata = "    + kbdata);
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "object = "    + object);
	  System.out.println(info + "flags = "     + flags);
	}

	if (kbdata.length() == 0) {
		kbdata = "http://panic.stanford.edu/data/";
	}
	if (subject.equals("?")) {
		if (debug == "yes") System.out.println("# qtype = qsubject");
		flags = "inverse=yes";
		subject = object;
	} else if (object.equals("?")) {
		if (debug == "yes") System.out.println("# qtype = qobject");
		flags = "inverse=no";
	} else {
		if (debug == "yes") System.out.println("# qtype = unknown");
		System.out.println("# usage: subject predicate ?");
		System.out.println("# usage: ? predicate object");
		return;
	}

	String uriSubject = subject;
	if (!Abbrev.IsStandardTag(subject)) {
	    uriSubject = tapuri + subject;
	}
	String uriPredicate = predicate;
	if (!Abbrev.IsStandardTag(predicate)) {
	    uriPredicate = tapuri + predicate;
	}

	if (debug == "yes") {
	  System.out.println(info + "tapuri = "    + tapuri);
	  System.out.println(info + "kbdata = "    + kbdata);
	  System.out.println(info + "subject = "   + subject);
	  System.out.println(info + "predicate = " + predicate);
	  System.out.println(info + "object = "    + object);
	  System.out.println(info + "flags = "     + flags);
	}

	Client tap = new Client(kbdata);
	Resource answer = tap.GetData(uriSubject,uriPredicate,flags);
	//answer.sort();
	if (answer.count() == 0) {
		System.out.println(info + "count = " + answer.count());
	}
	for(int x = 0; x < answer.count(); ++x) {
	    String tapAnswer = answer.item(x).value;
	    String mkrAnswer = XML.SplitNamespace(tapAnswer).tag;
	    if (debug == "yes")
		System.out.println("  " + "# " + tapAnswer);
	    System.out.println("  " + mkrAnswer);
	}
	if (predicate.equals("arcs")) {
		get_property_values(uriSubject,subject,answer);
	}
	return;
    }

    public static void get_property_values(
	String uriSubject,
	String subject,
	Resource proplist
    )
    {
	String object = "?";

	for(int x = 0; x < proplist.count(); ++x) {
	    String uriProperty = proplist.item(x).value;
	    String property = XML.SplitNamespace(uriProperty).tag;
	    if (property.equals("arcs")) { } else {
		System.out.println("# " + subject + " " + property);
		String[] args = { subject,property,object };
		main(args);
	    }
	}
	return;
    }

} // end class

//</pre></HTML>
