' 7/07/02
' 3D Torus Model

' set variables
Radial1Pts = 18
Radial2Pts = 37
Radius1 = 27
Radius2 = 142
CONST PI = 3.1415926535797#

' calculate other parameters
Vertices = Radial1Pts * Radial2Pts
Polygons = 2 * Vertices

' dimension arrays
DIM Vert(Vertices, 3)
DIM Poly(Polygons, 3)

CLS
PRINT "Radial 1 Points:"; Radial1Pts
PRINT "Radial 2 Points:"; Radial2Pts
PRINT "Vertices:"; Vertices
PRINT "Polygons:"; Polygons

' calculate vertex positions
Idx = 0
FOR J = 1 TO Radial2Pts
  FOR I = 1 TO Radial1Pts
    ' First put it on a circle in the X-Z plane
    Rad1 = 2 * PI * (I - 1) / Radial1Pts
    VertX = Radius1 * COS(Rad1) + Radius2
    VertZ = -Radius1 * SIN(Rad1)
    ' Then twirl the circle into a torus
    MyRadius = VertX
    Rad2 = 2 * PI * (J - 1) / Radial2Pts
    VertX = MyRadius * COS(Rad2)
    VertY = -MyRadius * SIN(Rad2)
    ' store this vertex
    Vert(Idx, 0) = VertX
    Vert(Idx, 1) = VertY
    Vert(Idx, 2) = VertZ
    Idx = Idx + 1
  NEXT I
NEXT J

' Now do the polys
Idx = 0
PolyIdx = 0
FOR J = 1 TO Radial2Pts
  FOR I = 1 TO Radial1Pts
    ' calculate corner positions
    IdxSE = Idx: Idx = Idx + 1
    IF I = Radial1Pts THEN
      IdxSW = IdxSE - (Radial1Pts - 1)
      ELSE
      IdxSW = IdxSE + 1
      END IF
    IF J = Radial2Pts THEN
      IdxNE = I - 1
      ELSE
      IdxNE = IdxSE + Radial1Pts
      END IF
    IF I = Radial1Pts THEN
      IdxNW = IdxNE - (Radial1Pts - 1)
      ELSE
      IdxNW = IdxNE + 1
      END IF
    ' save the polys (define vertices in counter-clockwise order)
    Poly(PolyIdx, 0) = IdxNE
    Poly(PolyIdx, 1) = IdxNW
    Poly(PolyIdx, 2) = IdxSE
    PolyIdx = PolyIdx + 1
    Poly(PolyIdx, 0) = IdxSW
    Poly(PolyIdx, 1) = IdxSE
    Poly(PolyIdx, 2) = IdxNW
    PolyIdx = PolyIdx + 1
  NEXT I
NEXT J

' dump out the vertices
FOR I = 0 TO Vertices - 1
  I0 = INT(I / 26)
  I1 = I - (I0 * 26)
  IF I < 26 THEN NAME$ = CHR$(I + 65) ELSE NAME$ = CHR$(I0 + 64) + CHR$(I1 + 65)
  IF Vert(I, 0) < 0 THEN VX = INT(Vert(I, 0)) ELSE VX = INT(Vert(I, 0) + .5)
  IF Vert(I, 1) < 0 THEN VY = INT(Vert(I, 1)) ELSE VY = INT(Vert(I, 1) + .5)
  IF Vert(I, 2) < 0 THEN VZ = INT(Vert(I, 2)) ELSE VZ = INT(Vert(I, 2) + .5)
  IF VX < 0 THEN VX$ = STR$(VX) ELSE VX$ = MID$(STR$(VX), 2)
  IF VY < 0 THEN VY$ = STR$(VY) ELSE VY$ = MID$(STR$(VY), 2)
  IF VZ < 0 THEN VZ$ = STR$(VZ) ELSE VZ$ = MID$(STR$(VZ), 2)
  IF I - (3 * INT(I / 3)) = 0 THEN PRINT "    ";
  PRINT "Vertex "; NAME$; " ("; VX$; ","; VY$; ","; VZ$; "); ";
  IF I - (3 * INT(I / 3)) = 2 THEN PRINT
NEXT I

' dump out the polygons
FOR I = 0 TO Polygons - 1
  Va = Poly(I, 0)
  Vb = Poly(I, 1)
  Vc = Poly(I, 2)
  I0 = INT(Va / 26): I1 = Va - (I0 * 26)
  IF Va < 26 THEN NameA$ = CHR$(Va + 65) ELSE NameA$ = CHR$(I0 + 64) + CHR$(I1 + 65)
  I0 = INT(Vb / 26): I1 = Vb - (I0 * 26)
  IF Vb < 26 THEN NameB$ = CHR$(Vb + 65) ELSE NameB$ = CHR$(I0 + 64) + CHR$(I1 + 65)
  I0 = INT(Vc / 26): I1 = Vc - (I0 * 26)
  IF Vc < 26 THEN NameC$ = CHR$(Vc + 65) ELSE NameC$ = CHR$(I0 + 64) + CHR$(I1 + 65)
  IF I - (4 * INT(I / 4)) = 0 THEN PRINT "    ";
  P = INT(I / 2)
  IF P / Radial1Pts = INT(P / Radial1Pts) OR P - Radial1Pts * INT(P / Radial1Pts) = INT(Radial1Pts / 2) THEN
    A$ = ") NeonGreen; "
    ELSE
    A$ = "); "
    END IF
  PRINT "Poly ("; NameA$; ","; NameB$; ","; NameC$; A$;
  IF I - (4 * INT(I / 4)) = 3 THEN PRINT
NEXT I

