/* chainmem.h - This file is a part of Floke Integrity
 *      Copyright (C) 2000 Jon Wickmann
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Written by Jon Wickmann <jon.wickmann@excite.com>, 2000.
 * For contact information please see http://www.angelfire.com/wi/wickmann/contact.html
 * Floke Integrity http://www.angelfire.com/wi/wickmann/floke.html
 * Please observe modification guidelines in the documentation
 *
 * History:
 * File last modified 2000.09.14. JWi
 *  */
#include <windows.h>
#include <windowsx.h>
#include <string.h>
#include <stdio.h>

struct direntry
{
   unsigned char dirname[MAX_PATH];
   struct fileentry *firstfile; // Pointer to first file
   struct direntry *firstsub;
   struct direntry *next;
   struct direntry *prev;
} *memcurdir, *memstartdir, *mempriordir, *memfilecurdir, *memfilestartdir, *memfilepriordir;

struct fileentry
{
   unsigned char filename[MAX_PATH];
   unsigned long hash[5];
   unsigned long long	hashbig[3]; //Should find an other solution if(sizeof(unsigned long long)==sizeof(u64))
   struct fileentry *next;
   struct fileentry *prev;
   unsigned char status;
} *memcurfile, *memstartfile, *mempriorfile, *memfilecurfile, *memfilestartfile, *memfilepriorfile; /* *currentpoint, *start, *prior; */

struct fileentry *memAllocfile(struct fileentry *inPrev); //Function to allocate and set file entries
void filedumpallfileentries(FILE *f, struct fileentry *curfileentry);

// Status definitions
#define OKAY 65
#define NEW 66
#define DELETED 67
#define ACCES_DENIED 68
#define CHANGED 69
#define INITIAL 70

