{ ********************************************************
  HEAD_DROPPER for rip files v1.00 (c) Ruzaev Sergei '2003
  ********************************************************}

program RIPHeadCut;

{$APPTYPE CONSOLE}

uses
  SysUtils;

type
 tOperation = (OP_CUT,OP_RESTORE);

var
 File1Name,
 File2Name      : string;
 File1,
 File2          : integer;
 operation      : tOperation;
 opCode         : string;
 hex            : string;
 RIP_Header     : array[0..11] of byte;
 RIP_Block      : array[0..99] of byte;

function GET_HEX: string;
const
 hextable       : array[0..15] of char =
 ('0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F');
var
 i  		        : integer;
begin
 result := '';
 for i:=0 to sizeof(RIP_Header)-1 do
  result := result+hextable[RIP_Header[i] and $f0 shr $04]+
                   hextable[RIP_Header[i] and $0f];
end;

procedure SET_HEX;
var
 i  		        : integer;
begin
 i := 1;
 repeat
 if hex[i] in ['0'..'9'] then
  RIP_Header[pred(i) shr 1] := (ord(hex[i])-ord('0')) shl $04  else
  RIP_Header[pred(i) shr 1] := (ord(hex[i])-ord('A')+$0A) shl $04;
 inc(i);
 if hex[i] in ['0'..'9'] then
  inc(RIP_Header[pred(i) shr 1],ord(hex[i])-ord('0')) else
  inc(RIP_Header[pred(i) shr 1],ord(hex[i])-ord('A')+$0A);
 inc(i);
 until i>sizeof(RIP_Header) shl 1;
end;

begin
  if paramcount<3 then
   begin
   writeln('*******************************');
   writeln('Head dropper for RIPcoder v1.00');
   writeln('*******************************');
   writeln('Please use RIPHeadCut.EXE <option> <file_IN> <file_OUT> [$CUT_HEX]');
   writeln('');
   writeln('Where <option> is:');
   writeln('/d - drop file header');
   writeln('/r - restore file header');
   writeln('');
   writeln('Examples:');
   writeln('RIPHeadCut.EXE /d EncodedFile.RIP NoHeadFile.RAW');
   writeln('or');
   writeln('RIPHeadCut.EXE /r NoHeadFile.RAW EncodedFile.RIP ',
           '$000000000000000000000000');
   exit;
   end;
  File1Name := paramstr(2);
  File2Name := paramstr(3);
  opCode := lowercase(paramstr(1));
  if pos('d',opCode)<>0 then operation := OP_CUT else
  if pos('r',opCode)<>0 then operation := OP_RESTORE else
   begin
   writeln('Unknown operation : '+paramstr(1)); exit;
   end;
  if not fileExists(File1Name) then
   begin
   writeln('invalid file: '+File1Name); exit;
   end;
  if operation=OP_RESTORE then
   begin
   if (paramcount<4) or (pos('$',paramstr(4))<>1) or
      (length(paramstr(4))<>sizeof(RIP_Header) shl 1+1) then
    begin
    writeln('Invalid hex parameter'); exit;
    end;
   hex := uppercase(paramStr(4)); system.Delete(hex,1,1); SET_HEX;
   end;
  File1 := FileOpen(File1Name,fmOpenRead);
  File2 := FileCreate(File2Name);
  if operation=OP_CUT then
   FileRead(File1,RIP_Header[0],sizeof(RIP_Header)) else
   FileWrite(File2,RIP_Header[0],sizeof(RIP_Header));
  repeat until FileWrite
   (File2,RIP_Block[0],FileRead(File1,RIP_Block[0],sizeof(RIP_Block)))=0;
  FileClose(File1);
  FileClose(File2);
  if operation=OP_CUT then
   begin
   writeln('!!! Please remember this hex, you will use it later to restore.');
   writeln('HEX: $'+GET_HEX);
   end;
end.
