/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import main.LikeCD;
import main.MultiInputStream;

public class MultiAudioInputStream
extends MultiInputStream {
    private File[] files;
    private AudioFormat format;
    static final String pyramixId = "PmxCdr";
    static final String cdrWinImgId = "\u0000\u0000\u0000\u0000\u0000\u0000";
    static final int pyramixHeaderLength = 354326;

    public MultiAudioInputStream(File file) throws UnsupportedAudioFileException, IOException, Exception {
        this(new File[]{file});
    }

    public MultiAudioInputStream(File[] fileArray) throws UnsupportedAudioFileException, IOException, Exception {
        this.files = fileArray;
        InputStream[] inputStreamArray = new AudioInputStream[fileArray.length];
        AudioFormat audioFormat = null;
        int n = 0;
        while (n < fileArray.length) {
            try {
                inputStreamArray[n] = this.getAudioInputStream(fileArray[n]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException("File " + fileArray[n] + " does not exist!");
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                throw new UnsupportedAudioFileException("File " + fileArray[n] + " is not a valid sound file! Should be WAV, AU or AIFF. Pyramix and CDRWIN image files are supported in the professional version.");
            }
            if (audioFormat == null) {
                audioFormat = inputStreamArray[n].getFormat();
            } else if (!audioFormat.toString().equals(inputStreamArray[n].getFormat().toString())) {
                throw new IOException("The input audio files have different formats");
            }
            ++n;
        }
        this.format = inputStreamArray[0].getFormat();
        InputStream[] inputStreamArray2 = new InputStream[inputStreamArray.length];
        System.arraycopy(inputStreamArray, 0, inputStreamArray2, 0, inputStreamArray.length);
        this.setInputStreams(inputStreamArray);
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        throw new UnsupportedOperationException();
    }

    public int getByteLength() throws Exception {
        int n = 0;
        try {
            int n2 = 0;
            while (n2 < this.files.length) {
                n = (int)((long)n + this.getFileLength(this.files[n2]));
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new Exception("Error when calculating file length");
        }
        return n;
    }

    public String getName() {
        String string = "";
        int n = 0;
        while (n < this.files.length) {
            if (n != 0) {
                string = string + ";";
            }
            string = string + this.files[n];
            ++n;
        }
        return string;
    }

    public File[] getFiles() {
        return this.files;
    }

    private long getFileLength(File file) {
        return file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioInputStream getAudioInputStream(File file) throws Exception, IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream;
        block9: {
            FileInputStream fileInputStream;
            long l;
            block7: {
                AudioInputStream audioInputStream2;
                block8: {
                    String string;
                    block5: {
                        AudioInputStream audioInputStream3;
                        block6: {
                            l = file.length();
                            fileInputStream = null;
                            try {
                                fileInputStream = new FileInputStream(file);
                                byte[] byArray = new byte[pyramixId.length()];
                                ((InputStream)fileInputStream).read(byArray, 0, pyramixId.length());
                                string = new String(byArray, 0, pyramixId.length());
                                if (string.equals(pyramixId) || string.equals(cdrWinImgId)) break block5;
                                audioInputStream3 = AudioSystem.getAudioInputStream(file);
                                Object var12_9 = null;
                                if (fileInputStream == null) break block6;
                            }
                            catch (Throwable throwable) {
                                block10: {
                                    Object var12_12 = null;
                                    if (fileInputStream == null) break block10;
                                    ((InputStream)fileInputStream).close();
                                }
                                throw throwable;
                            }
                            ((InputStream)fileInputStream).close();
                        }
                        return audioInputStream3;
                    }
                    if (!LikeCD.getLogInfo(LikeCD.getKey())[3].equals("3") && !LikeCD.getLogInfo(LikeCD.getKey())[3].equals("0")) {
                        throw new UnsupportedAudioFileException("Pyramix image files are only supported in the professional verion of VerifyCD.");
                    }
                    if (!string.equals(cdrWinImgId)) break block7;
                    FileInputStream fileInputStream2 = new FileInputStream(file);
                    audioInputStream2 = new AudioInputStream(fileInputStream2, new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false), l / 4L);
                    Object var12_10 = null;
                    if (fileInputStream == null) break block8;
                    ((InputStream)fileInputStream).close();
                }
                return audioInputStream2;
            }
            long l2 = l - 354326L;
            FileInputStream fileInputStream3 = new FileInputStream(file);
            fileInputStream3.skip(354326L);
            audioInputStream = new AudioInputStream(fileInputStream3, new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 44100.0f, 16, 2, 4, 44100.0f, false), l2 / 4L);
            Object var12_11 = null;
            if (fileInputStream == null) break block9;
            ((InputStream)fileInputStream).close();
        }
        return audioInputStream;
    }
}

