// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : ffeed.c
// Description  : This program is a "filter feed" program.
//                It reads the command line for a file spec.
//                If it finds one it opens all matching
//                files and sends each to standard output,
//                separated by a formfeed character followed
//                by the filename.
//
//                This is good for processing more than one file through
//                filters and replaces the "type" command for multiple
//                file processing since the type command only handles
//                one file at a time.
//
//                Handles long filenames under Win9x/NT.
//
//                Optionally this accepts an @list for input.
//                Using a sorted list of files will give you
//                a specified read order. The dir /b command can
//                be redirected to a list to provide an @list.
//
// Written by   : Bill Buckels
// Based On     : feed.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <io.h>
#include <stdio.h>
#include <string.h>
#include <direct.h>
#include <malloc.h>
#include <dos.h>

int feed(char *fname, char *sname)
{
  FILE *fp;
  int c;

  fp = fopen(fname, "rb");            // open raw
  if (NULL != fp) {
    putchar(12);
    puts(sname);
    while ((c = fgetc(fp))!=EOF) {
      if (c == '\r')
        continue;
      putchar(c);
    }
    fclose(fp);
    return 1;
  }
  return 0;

}

int nocr(char *ptr)
{
  int i;
  
  i = 0;
  for(;;)
  {
    if(ptr[i] == 10 || ptr[i] == 13 || ptr[i] == '\x1a')ptr[i] = 0;
    if(ptr[i] == 0)break;
    i++;
  }
  
  return i;
  
}


int main(int argc, unsigned char **argv)
{

  FILE *fp;
  long findhandle;
  struct _finddata_t wild_card;
  
  unsigned char filename[_MAX_PATH],
    path_buffer[_MAX_PATH],
    drive[_MAX_DRIVE],
    dir[_MAX_DIR],
    rootname[_MAX_FNAME],
    ext[_MAX_EXT];

  int found = 0;
  
  if(argc < 2) {
    puts("FFEED(C) CopyLeft Bill Buckels 2000. All Rights Reversed.");
    puts("A Filter Feed Program (Replaces the DOS TYPE Command)");
    puts("Usage is \"FFEED [anyfile*.*]\"");
    puts("-or-     \"FFEED @filelist\"");
    return 1;
  }

  /* allow (sorted) list as input as well as a filename spec */
  /* this overcomes the problem of not using a sorted find... */
  /* and files can be processed in any required order using @list */
  if (argv[1][0] == '@') {
    strcpy(filename, &argv[1][1]);
    fp = fopen(filename, "r");
  }
  else {
    strcpy(filename, argv[1]);
  }

  for (;;) {
    if (NULL != fp) {
      if (NULL == fgets(filename, _MAX_PATH, fp))break;
      nocr(filename);
    }
    strcpy(path_buffer, filename);       // allow pathing...

    _splitpath(path_buffer, drive, dir, rootname, ext);

    if((findhandle = _findfirst(filename, &wild_card)) < 1l)
      return 1;

    if(!(wild_card.attrib  &_A_SUBDIR))
    {
      sprintf(path_buffer, "%s%s%s", drive, dir, wild_card.name);
      found += feed(path_buffer, wild_card.name);
    }

    while(_findnext(findhandle, &wild_card) == 0)
    {
      if(!(wild_card.attrib  &_A_SUBDIR))
      {
        sprintf(path_buffer, "%s%s%s", drive, dir, wild_card.name);
        found += feed(path_buffer, wild_card.name);
      }
    }
    _findclose(findhandle);
    if (NULL == fp)break;
  }

  if (NULL != fp)
    fclose(fp);

  if(!found)
    return 1;
  
  return 0;
}
