// ------------------------------------------------------------------------
// System       : Win9X/NT
// Program      : hexval.c
// Description  : A C Programmers Tool.
//                Create Character Arrays from Binary Files
//                suitable for embedding in C programs.
//                Handles long filenames under Win9X/NT.
// Written by   : Bill Buckels
// Date Written : March 3, 1991
// Revision     : 2.0 Second Release - March 2000
//                General Cleanup
//                Added Support for Long FileNames
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <io.h>

char arrayname[_MAX_PATH],
     infile[_MAX_PATH],
     outfile[_MAX_PATH];

/* create a legal c array name from a file name */
void cname(char *ptr)
{
  int idx;
  char c;

  for (idx = 0; ptr[idx] != 0; idx++) {
    if (ptr[idx] == '.') {
      ptr[idx] = 0;
      break;
    }
    c = tolower(ptr[idx]);
    if ((c >= '0' && c <= '9') || (c>= 'a' && c <= 'z')) ptr[idx] = c;
    else ptr[idx] = '_';

  }
}

void main(int argc,char **argv)
{
  FILE *fp,*fp2;

  long count = 0,
       target;
  int counter=0,
      status=0;

  unsigned char c;

  puts("HexVal(C) v2.0 CopyLeft Bill Buckels 1991-2000.");
  puts("All Rights Reversed.");
  if (argc < 2) {
    puts("Usage is : \"hexval [infile] [outfile (optional)]\"");
    puts("Purpose  : Create Character Arrays from Binary Files.");
    status = 1;
  }
  else {
    if(argc>1)strcpy(infile,argv[1]);
    if(argc>2)strcpy(outfile,argv[2]);

    strcpy(arrayname, argv[1]);
    cname(arrayname);

    fp  = fopen(infile,"rb");
    if (fp == NULL) {
      perror(infile);
      status = 1;
    }
    else {
      target = filelength(fileno(fp));
      if (argc < 3)
        fp2 = stdout;
      else
        fp2= fopen(outfile,"w");
    }
    if (fp2 == NULL) {
      perror(outfile);
      status = 1;
    }
    else {
      /* print the header for the character array */
      fprintf(fp2,"unsigned char %s[%ld] ={", arrayname, target);
      /* print the character array */
      do
      {
        if(counter%8==0)fprintf(fp2,"\n");
        counter++;
        count++;
        c=fgetc(fp);
        if(count<target)
        {
          if(c<0x10)fprintf(fp2,"0x0%1X, ",c);
          else fprintf(fp2,"0x%2X, ",c);
        }
        else
        {
          if(c<0x10)fprintf(fp2,"0x0%1X};",c);
          else fprintf(fp2,"0x%2X};",c);
        }
      }while(count<target);

      if (fp != NULL)
        fclose(fp);
      if (argc > 2)
        fclose(fp2);
    }
  }
  if (argc > 2) {
    puts("Done!");
  }
  exit(status);
}
