// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : WhereIs.c
// Description  : Find all occurences of files on the drive
// Written by   : Bill Buckels
// Date Written : 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------


#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <string.h>
#include <direct.h>


char szSearchSpec[_MAX_PATH];


int isdirectory(char *filename, unsigned attribute)
{
  if(strcmpi(filename, ".") == 0)return  0;
  if(strcmpi(filename, "..") == 0)return 0;
  if((attribute & _A_SUBDIR) != 0)return (-1);
  return 0;
  
}


int isdot(char *filename)
{
  if(strcmpi(filename, ".") == 0)return  (-1);
  if(strcmpi(filename, "..") == 0)return (-1);
  return 0;
  
}

int ZERO = 0;
int sizerange(_fsize_t filesize)
{
  if (filesize > 0 && ZERO != 0) {
    return 0;
  }
  return 1;
}

void listfiles(char *pathname)
{
  long findhandle;
  struct _finddata_t wild_card;
  char filename[_MAX_PATH];
  int pathlength = strlen(pathname) - 3;
  
  strcpy(filename, szSearchSpec);
  
  if((findhandle = _findfirst(filename, &wild_card)) > 0l)
  {
    if(!isdot(wild_card.name))
    {
      if (sizerange(wild_card.size)) {
        if(pathlength)
          printf("%s\\%s\n", pathname, wild_card.name);
        else
          printf("%s%s\n", pathname, wild_card.name);
      }
    }
    
    while(_findnext(findhandle, &wild_card) == 0) 
    {
      if(!isdot(wild_card.name))
      {
        if (sizerange(wild_card.size)) {
          if(pathlength)
            printf("%s\\%s\n", pathname, wild_card.name);
          else
            printf("%s%s\n", pathname, wild_card.name);
        }
      }
      
    }
    _findclose(findhandle);
  }
}


void treewalker(void)
{
  long findhandle;
  struct _finddata_t wild_card;
  
  char filename[_MAX_PATH];
  char buffer[_MAX_PATH];
  
  strcpy(filename, "*.*");
  
  /* we must walk each directory tree          */
  /* beneath us and call ourselves recursively */
  /* until we are done                         */
  
  getcwd(buffer, _MAX_DIR);
  
  if((findhandle = _findfirst(filename, &wild_card)) > 0l)
  {
    /* descend into the subdirectory */
    if((isdirectory(wild_card.name, wild_card.attrib)))
    {
      chdir(wild_card.name);
      treewalker();
      chdir(buffer);
    }
    while(_findnext(findhandle, &wild_card) == 0) 
    {
      if((isdirectory(wild_card.name, wild_card.attrib)))
      {
        chdir(wild_card.name);
        treewalker();
        chdir(buffer);
      }
    }
    _findclose(findhandle);
    
  }
  listfiles(buffer);
}

void main(int argc, char **argv)
{
  char buffer[_MAX_PATH];
  int idx, jdx;
  unsigned char c;

  switch(argc)
  {
    case 3:
    case 2:

      for (idx = 1; idx < argc; idx++) {
        if (argv[idx][0] == '-') {
          for (jdx = 0; argv[idx][jdx] != 0; jdx++) {
            c = tolower(argv[idx][jdx]);
            switch (c) {
              case 'z':      /* allow a filter to find zero length */
                ZERO = 1;
                break;
            }
          }
        }
        else {
          strcpy(szSearchSpec, argv[idx]);  /* global search spec */
        }
      }

      getcwd(buffer, _MAX_DIR);       /* save origin */
      chdir("\\");                    /* start in the root */
      treewalker();                   /* walk the tree */
      chdir(buffer);                  /* restore origin */
      break;

    default:
    puts("WhereIs(C) CopyLeft Bill Buckels 2000. All Rights Reversed.");
    puts("Usage is : \"WhereIs [FileName] (switches optional -z)\"");
    
  }
  exit(0);
  
}
