// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : pipecon.c
// Description  : Pipe the colsole to a disk file.
//                Console IO to disk with echo back to console
//                on some systems.
// Written by   : Bill Buckels
// Date Written : 1993
// Revision     : 1.1 First Release
// Errata       : This program cannot be compiled using MSC 12
//                because dos is no longer supported.
//                So compiled under MSC 6 as an .EXE.
// ------------------------------------------------------------------------

#include <stdlib.h>
#include <stdio.h>
#include <process.h>
#include <dos.h>
#include <fcntl.h>

char far *dos_ptr;
// a place to keep the old dos idle loop
void (interrupt _far *old_dos)();

// our replacement for whatever was hooked to the DOS idle loop
// when DOS is not busy open the LOG file and write to screen
long OLDLENGTH = 0L, NEWLENGTH=0L;
long OLDERR = 0L, NEWERR = 0L;

void interrupt new_dos()
{
    FILE *realcon, *pipecon;
    unsigned char temp;
    int c,fh;

    old_dos();
    temp = dos_ptr[0];
    if(temp!=0)
    {
      if((realcon=fopen("con","wb"))!=NULL)
       {
       if((pipecon=fopen("C:\\PIPECON.LOG","rb"))!=NULL)
          {
           fh=fileno(pipecon);
           NEWLENGTH =filelength(fh);
           lseek(fh,(long)OLDLENGTH,SEEK_SET);
           while(OLDLENGTH<NEWLENGTH)
           {
             c=fgetc(pipecon);
             fputc(c,realcon);
             OLDLENGTH++;
            }
            fclose(pipecon);
          }
       if((pipecon=fopen("C:\\PIPERR.LOG","rb"))!=NULL)
          {
           fh=fileno(pipecon);
           NEWERR =filelength(fh);
           lseek(fh,(long)OLDERR,SEEK_SET);
           while(OLDERR<NEWERR)
           {
             c=fgetc(pipecon);
             fputc(c,realcon);
             OLDERR++;
            }
            fclose(pipecon);
          }
         fclose(realcon);
       }
    }
}

int main(int argc, char *argv[])
{
    unsigned dosseg,indos;
    unsigned long dos_busy = 0L;
    FILE *realcon, *pipecon;
    int c,fh;
    char commandbuffer[128];
    char *ptr, cmd[128] = "command";


    ptr = getenv("COMSPEC");
    if (NULL != ptr)
      strcpy(cmd, ptr);

    remove("C:\\PIPECON.LOG");
    remove("C:\\PIPERR.LOG");
    puts("Pipecon(C) CopyLeft Bill Buckels 1993-2000. All Rights Reversed.");
    puts("Console Output will be redirected to C:\\PIPECON.LOG");
    puts("DOS Error Output will be redirected to C:\\PIPERR.LOG");

    if(argc<2)
    {
      sprintf(commandbuffer,"%s /E:2048",cmd);
      puts("Now Executing Dos Shell! Type \"EXIT\" to unload....");
      puts("Some Systems Will Also Echo The PIPE to The Console.");

    }
    else
    {
      sprintf(commandbuffer,"%s /E:2048 /C%s",cmd,argv[1]);
      printf("Now Executing %s.\n",commandbuffer);
      puts("Some Systems Will Also Echo The PIPE to The Console.");
    }

    _asm{
         mov ah, 34h
         int 21h
         push bx
         mov ax,es
         mov dosseg,ax
         pop bx
         mov indos, bx
    }

    dos_busy += dosseg;
    dos_busy <<= 16;
    dos_busy |= indos;
    dos_ptr = (unsigned char far *)dos_busy;

    old_dos=  _dos_getvect(0x28);
    _dos_setvect(0x28, new_dos);

    // 2. redirect the console to a diskfile called...
    freopen("C:\\PIPECON.LOG", "a", stdout);
    freopen("C:\\PIPERR.LOG", "a", stderr);

    // 3. load a new shell
    system(commandbuffer);

    // 4. release the vector and clean up
    _dos_setvect(0x28, old_dos);

    if((realcon=fopen("con","wb"))!=NULL)
      {
        if((pipecon=fopen("C:\\PIPECON.LOG","rb"))!=NULL)
          {
           fh=fileno(pipecon);
           NEWLENGTH =filelength(fh);
           lseek(fh,(long)OLDLENGTH,SEEK_SET);
           while(OLDLENGTH<NEWLENGTH)
           {
             c=fgetc(pipecon);
             fputc(c,realcon);
             OLDLENGTH++;
            }
            fclose(pipecon);
        }
        if((pipecon=fopen("C:\\PIPERR.LOG","rb"))!=NULL)
          {
           fh=fileno(pipecon);
           NEWERR =filelength(fh);
           lseek(fh,(long)OLDERR,SEEK_SET);
           while(OLDERR<NEWERR)
           {
             c=fgetc(pipecon);
             fputc(c,realcon);
             OLDERR++;
            }
            fclose(pipecon);
          }
        fclose(realcon);
      }

    freopen("con", "w", stdout);
    freopen("con", "w", stderr);

    puts("\nPipecon is DONE! Have a Nice Dos");

    return 0;

}
