// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : uniq.c
// Description  : A filter that deletes duplicate adjacent lines
//                from a file or stream.
//                Useful after sorting to remove duplicate lines.
//
// Written by   : Bill Buckels
// Based On     : unique.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// ------------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>

#define BUF_MAX  4096
#define BUF_SIZE (BUF_MAX + 1)

char cbuf[BUF_SIZE] = "\0", dbuf[BUF_SIZE] = "\0";

void main(int argc, char **argv)
{
    int c, cnt = 0, idx;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;
      if (c=='\r')continue;

      if (c == '\n' || cnt >= BUF_MAX) {
        if (strcmp(cbuf, dbuf)) {
          for (idx = 0; cbuf[idx] != 0; idx++)
            putchar(cbuf[idx]);
          putchar('\n');        // splits the line if too long
          strcpy(dbuf, cbuf);
        }
        cbuf[0] = cnt = 0;
        continue;
      }

      cbuf[cnt] = c;
      cnt++;
      cbuf[cnt] = 0;
    }
    if (cbuf[0] != 0) {
      if (strcmp(cbuf, dbuf)) {
        for (idx = 0; cbuf[idx] != 0; idx++)
          putchar(cbuf[idx]);
        putchar('\n');
      }
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
