// ------------------------------------------------------------------------
// System       : WIN9X/NT
// Program      : xtodos.c
// Description  : Unix to Dos text filter. lf -> cr, lf
//                Should also work with Apple text. cr -> cr, lf
//
// Written by   : Bill Buckels
// Date Written : March 2000
// Revision     : 1.1
// ------------------------------------------------------------------------
#include <stdio.h>

void main(int argc, char **argv)
{
    int c = 0, d = 0;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "rb");

    for (;;) {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (d == '\r' && c != '\n') {
        putchar('\n');               // apple
      }

      if (c==EOF)break;

      if(c != '\r')
        putchar(c);

      d = c;
    }

    if (NULL != fp) {
      fclose(fp);
      exit(0);
    }
}
