// ------------------------------------------------------------------------
// System       : MS-DOS
// Program      : decho.c
// Description  : double echo
//                Filter to echo to stderr and to stdout at the same time.
//                Use with other filters when redirecting to show activity
//                or to debug output.
// Written by   : Bill Buckels
// Based On     : fecho.asm
//                used with permission
// Date Written : March 2000
// Revision     : 1.1 First Release
// Errata       : This filter cannot be compiled using MSC 12
//                because stderr is no longer properly supported.
//                So compiled under MSC 6 as a .COM but long filenames
//                are not supported.
// ------------------------------------------------------------------------

#include <stdio.h>

void main(int argc, char **argv)
{
    int c;
    FILE *fp = NULL;

    if (argc > 1)
      fp = fopen(argv[1], "r");

    for (;;)
    {
      if (NULL == fp)
        c = getchar();
      else
        c = fgetc(fp);

      if (c==EOF)break;

      fputc(c, stderr);    // not supported properly under MSC 12

      putchar(c);
    }
    if (fp != NULL) {
      fclose(fp);
      exit(0);
    }
}
