/* ---------------------------------------------------------------------- */
/*   GRABASC.c (C) Version 2.0 CopyLeft Bill Buckels 1992-2000            */
/*   All Rights Reversed.                                                 */
/*                                                                        */
/*   Date Written : Jan 25, 1992                                          */
/*   Revision     : 2.0 December 1992                                     */
/*                                                                        */
/*   GRABASC is distributed as FreeWare and Written by:                   */
/*                                                                        */
/*   Bill Buckels                                                         */
/*   589 Oxford Street                                                    */
/*   Winnipeg, Manitoba, Canada R3M 3J2                                   */
/*                                                                        */
/*   Email: bbuckels@escape.ca                                            */
/*   WebSite: http://www.escape.ca/~bbuckels                              */
/*                                                                        */
/*   You have a royalty-free right to use, modify, reproduce and          */
/*   distribute this source code (and/or any modified  version) in any    */
/*   way you find useful, provided that you do not compete                */
/*   with Bill Buckels or his agents, and that you agree that Bill        */
/*   Buckels has no warranty obligations or liability whatsoever          */
/*   resulting from any associated loss or damage.                        */
/*                                                                        */
/*   If you do not agree with these terms, remove this source and         */
/*   all associated files from your computer now.                         */
/*                                                                        */
/*   Description                                                          */
/*                                                                        */
/*   A tsr ascii screen capture utility for 80-column text mode 3 or 7.   */
/*                                                                        */
/*   Grab the print screen key and save ascii text to disk.               */
/*                                                                        */
/*   This TSR has been used safely by me and works well on a clean        */
/*   system. Reboot after use as with any screen capture utility. I will  */
/*   not be held responsible for self-inflicted wounds.                   */
/*                                                                        */
/*   Compiler                                                             */
/*                                                                        */
/*   This program cannot be compiled using MSC 12 because dos is no       */
/*   longer supported.                                                    */
/*                                                                        */
/*   Written in MIX POWER C 2.0 16 bit medium model. Compile and link     */
/*   with a 2K stack and a 2K heap using the following sequence...        */
/*                                                                        */
/*   pc grabasc.c                                                         */
/*   pcl [2K,2K] grabasc.mix                                              */
/*                                                                        */
/* ---------------------------------------------------------------------- */

#include <bios.h>
#include <stdio.h>
#include <dos.h>

unsigned rowmax=25; /* number of lines to save */

unsigned SCREENSEG = 0xb800; /* default to the CGA */
                             /* adjust for people with mono */

/* the current video mode */
/* we don't want to grab squinty modes or graphics */
char far *vmodeptr = (char far *)(unsigned long)0x0400049;

void interrupt grabasc(void)
{
  FILE *fp;
  static char far *crtptr;
  unsigned char temp;
  unsigned row,col,target;
  
  char *filename = "HANDFULL.TXT";
  
  disable();
  
  /* make sure we are in a legal text mode */
  temp = vmodeptr[0];
  if(temp == 2 || temp == 3 || temp == 7)
  {
    /* open HANDFULL.TXT for append and write screen bytes  */
    /* without attributes. put a carriage return- line feed */
    /* at the end of each row... */
    
    fp = fopen(filename, "ab");
    if (NULL != fp) {
      for(row = 0;row < rowmax;row++)
      {
        /* point to the start of each line of text */
        crtptr = MK_FP(SCREENSEG, row*160);

        /* skip the attributes and save the ascii to disk */
        /* trim the white space while we are at it...     */
        /* we need to check first then write...           */
        for(col = 0;col < 160;col += 2)if(crtptr[col] != '\x20')target = col;
        for(col = 0;col <= target;col += 2)fputc(crtptr[col], fp);
        /* append the line with a cr-lf combination */
        fputc('\x0d', fp);
        fputc('\x0a', fp);
      }
      fputc('\x0c', fp);  /* put a formfeed at the end of the grab */
      fputc('\x0d', fp);
      fputc('\x0a', fp);
      fclose(fp);
    }
  }
  enable();
}

void main(int argc, char **argv)
{
  unsigned programsize;
  
  if(argc > 1)rowmax = atoi(argv[1]);
  
  if(rowmax < 1 || rowmax > 25)rowmax = 25;
  
  puts("ͻ");
  puts(" Grabasc(C) Version 2 by Bill Buckels December 1992   ");
  puts(" Usage is \"Grabasc [number of lines (1-25) optional]\" ");
  puts(" Grabasc is now resident.                             ");
  puts("ͼ");
  
  puts("Use the Shift-Print-Screen Key Combination to Capture Text Screens.");
  puts("The Ascii Capture Buffer will be appended to \"HANDFULL.TXT\".");
  printf("Grabasc will save %d lines per grab\n", rowmax);
  puts("Have a Nice Dos!");
  
  if((biosequip() & 0x30) == 0x30)SCREENSEG = 0xb000;
  setvect(5, grabasc);
  programsize = farsetsize(0);
  
  keep(0, programsize);
  
}
