; TAB modified 10/90 - 3/99 by J.E. Arkay
; Disassembled with Re-Source, assembled with TASM 3.0

;The file is processed a line at a time, 2 passes for each line.
;First, LineToTemp expands tabs to spaces (anything in quotes is untouched
; except no check is made for nested quotes),
; eliminates trailing spaces, and ends each line at a CR or LF, or MaxLen
; characters.
;Then LinePass2 converts spaces to tabs and writes it out, adding the CR,LF.

;**** may have a problem handling pairs of long paths in the command line...
;**** NEEDS to break lines at single space or comma BEFORE 80 chars.
;**** NEEDS to not put Tab for 2 or 3 spaces in text, makes editing annoying.

cr	EQU	0Dh
lf	EQU	0Ah
tab	EQU	9

CSEG	segment	byte public
	assume	CS:CSEG, DS:CSEG, ES:CSEG, SS:CSEG

	ORG	0100h

Start:	JMP	Begin

HelpScrn	DB	'TAB V 3 - V.BUERG, mods by J.E. Arkay 10/90 - 3/99'
		DB	cr,lf,cr,lf,'Usage:  TAB infile outfile [/d]'
		DB	cr,lf,tab,'Infile and outfile may include d:\path.'
		DB	cr,lf,tab,'/d expands tabs to spaces.',0FFh

Begin:	MOV	ErrSP,SP
	CALL	SetUpRAM
	CALL	ParseCmdLine
NextInFile:
	CALL	OpenInFile
	CALL	CreateOutFile
	CALL	ShowFileNames
	CALL	DoTheJob
	CALL	ChkAndWriteLast
	CALL	CloseFiles
	CALL	FindNext		;why ?? For wildcards ?
	OR	AL,AL
	JZ	NextInFile
	SUB	AL,AL			;Errorlevel 0
	JMP	SHORT Exit

Err1Exit:
	MOV	SP,ErrSP
	CALL	DsplStrAtDX
	MOV	AL,1
Exit:	MOV	AH,4Ch			;exit with Errorlevel
	INT	21h

MaxLen		DW	80		;break longer lines into MaxLen chars
BlockSize	DW	0
SpaceCount	DB	0
CrLfFlag	DB	0
QuoteFlag	DB	0
DeTabFlag	DB	0
ErrSP		DW	0
InOpenErrMsg	DB	cr,lf,'Input failed to open, '
InPathName	DB	0
H00155		DB	4Ah DUP (0)
H0019F		DB	0,0,0FFh
InHandle	DW	0
BytesToGo	DW	0
ReadBufPtr	DW	0
ReadBufAddr	DW	0
OutOpenErrMsg	DB	cr,lf,'Output failed to open, '
OutPathName	DB	0
H001C4		DB	0		;treated as a WORD, too
H001C5		DB	4Bh DUP (0),cr,lf,0FFh
OutHandle	DW	0
BytesTillWrite	DW	0
WritePtr	DW	0
WriteBufAddr	DW	0
EightSpaces	DB	'        '
H00223		DW	OFFSET InPathName
H00225		DW	OFFSET OutPathName
DTA		DB	1Eh DUP (0)
DTAfilename	DB	12h DUP (0)

ReadErrMsg	DB	cr,lf,'Read error',0FFh
WriteErrMsg	DB	cr,lf,'Write error or disk full.',0FFh
NoRAMmsg	DB	cr,lf,'Not enough memory',0FFh
NotFoundMsg	DB	cr,lf,'File not found',0FFh
DeTabStr	DB	'DE-'
TabsStr		DB	'TABS:',tab,0FFh
Arrow		DB	tab,'-> ',0FFh
CrLfStr		DB	cr,lf,0FFh

;these are all 16 bytes, for error codes 2 thru 5
Err2msg	DB	'File not found ',0FFh
	DB	'Path not found ',0FFh
	DB	'Too many files ',0FFh
	DB	'Access denied  ',0FFh

DoTheJob:
	CALL	LineToTemp
	SUB	BX,BX
	MOV	SpaceCount,BL
	MOV	QuoteFlag,BL
	OR	CX,CX			;bytes for this line in temp buf
	JNZ	LinePass2
	OR	AH,AH			;check for EOF at 0-length last line
	JNZ	Ret3
	JMP	PutCrLf

Ret3:	RET

LinePass2:
	MOV	SI,OFFSET EndPgm
LinePass2Loop:
	LODSB
	INC	BX
	CMP	AL,''''
	JZ	FlagSglQuote
	CMP	AL,'"'
	JZ	FlagDblQuote
	CMP	DeTabFlag,0
	JNZ	ChkEOF
	CMP	AL,' '
	JNZ	ChkEOF
	TEST	QuoteFlag,3
	JNZ	ChkEOF
	INC	SpaceCount
	TEST	BL,7
	JNZ	LoopAgain
	CMP	BYTE PTR [SI-2],' '
	JZ	PutTab
	CMP	BYTE PTR [SI-2],tab
	JNZ	PutByte
PutTab:	MOV	AL,tab
	JMP	SHORT PutByte

FlagDblQuote:
	XOR	QuoteFlag,00000001b
H00419:	CMP	SpaceCount,0
	JZ	ChkEOF
	JMP	SHORT WriteSpaces

FlagSglQuote:
	XOR	QuoteFlag,00000010b
	JMP	SHORT H00419

ChkEOF:
;We are up to the last byte in the file if both CX=1 and AH is non-0
	CMP	CX,1
	JNZ	NotEOF
	OR	AH,AH
	JZ	NotEOF
	CALL	ALtoBuffer
	RET				;DoTheJob ends here ...
;
NotEOF:	CMP	DeTabFlag,0
	JNZ	PutByte
	TEST	QuoteFlag,3
	JNZ	PutByte
	CMP	SpaceCount,0
	JZ	PutByte
;there have been some spaces since last tab or character
	MOV	DX,BX
	DEC	DL
	TEST	DL,7
	JNZ	WriteSpaces
;there have been a multiple of 8 since last tab or character
	PUSH	AX
	MOV	AL,tab
	CALL	ALtoBuffer
WrSpDone:
	POP	AX
PutByte:OR	AL,AL
	JNZ	PutOK
	MOV	AL,' '			;convert nulls to spaces
PutOK:	CALL	ALtoBuffer
	MOV	SpaceCount,0
LoopAgain:
	DEC	CX
	JZ	PutCrLf
	JMP	LinePass2Loop		;can't LOOP, over 127 bytes back

PutCrLf:MOV	AL,cr
	CALL	ALtoBuffer
	MOV	AL,lf
	CALL	ALtoBuffer
	JMP	DoTheJob

WriteSpaces:
	PUSH	AX
	MOV	DL,SpaceCount
WrSpLoop:
	CMP	DL,1
	JB	WrSpDone
	MOV	AL,' '
	CALL	ALtoBuffer
	DEC	DL
	JMP	SHORT WrSpLoop
;
;Copy a line to temp buf at EndPgm, eliminating trailing spaces.
; If not in quotes, replace any tab with spaces.
; A lone LF or a LF, CR pair is converted to a CR, LF pair.
; A CR followed by a CR is ignored
LineToTemp:
	SUB	DI,DI
	MOV	QuoteFlag,0
NextByte:
	CALL	GetOneByte		;returns AH=1, AL=' ' if no bytes read
;replace 92h ('') with single quote, 93h & 94h with dbl quote for text from
;Bill Gates programs
	CMP	AL,92h
	JNZ	Chk93
	MOV	AL,27h
	Jmp	Short ChkLf

Chk93:	Cmp	AL,93h
	JNZ	Chk94
	MOV	AL,22h
	Jmp	Short ChkQ

Chk94:	Cmp	AL,94h
	JNZ	ChkLf
	MOV	AL,22h
	Jmp	Short ChkQ

ChkLf:	CMP	AL,lf
	JNZ	ChkCr
;the character is a LF
	TEST	CrLfFlag,1		;was last char on prev line a CR ?
	JNZ	ResetFlagAndGoNextByte	;ignore other char if 1st on line 
	OR	CrLfFlag,2		;flag last char was LF
	JMP	TrailSpaceLoop

ChkCr:	CMP	AL,cr
	JNZ	ChkQ
;the character is a CR
	TEST	CrLfFlag,1		;was last char on prev line a CR ?
	JZ	NextByte
	TEST	CrLfFlag,2		;was last char on prev line a LF ?
	JNZ	ResetFlagAndGoNextByte	;ignore other char if 1st on line
	OR	CrLfFlag,1		;flag last char was CR
	JMP	TrailSpaceLoop		;and end the line

ChkQ:	CMP	AL,'"'
	JNZ	ChkDbl
	XOR	QuoteFlag,00000001b
ChkDbl:	CMP	AL,''''
	JNZ	ChkSgl
	XOR	QuoteFlag,00000010b
ChkSgl:	CMP	AL,tab
	JNZ	KeepIt
	TEST	QuoteFlag,3
	JNZ	KeepIt
DeTabLoop:				;--- the character is a Tab ---
	MOV	BYTE PTR [DI+OFFSET EndPgm],' '
	INC	DI
	CMP	DI,MaxLen		;a tab that would expand a line past
	JNB	TrailSpaceLoop		; MaxLen chars is dropped
	TEST	DI,7			;DI anded with 0007
	JZ	ResetFlagAndGoNextByte	;if bits 0, 1, and 2 all are 0
	JMP	SHORT DeTabLoop

KeepIt:	MOV	[DI+OFFSET EndPgm],AL	;at EOF, writes the ' ' in AL
	INC	DI
	CMP	DI,MaxLen
	JNB	TrailSpaceLoop
	OR	AH,AH			;check for end of file
	JZ	ResetFlagAndGoNextByte
TrailSpaceLoop:
	CMP	BYTE PTR [DI+OFFSET EndPgm-1],' '
	JNZ	EndLine
	DEC	DI
	JNZ	TrailSpaceLoop
EndLine:MOV	CX,DI			;length of line after processing
	RET

ResetFlagAndGoNextByte:
	MOV	CrLfFlag,0
	JMP	NextByte
; - - - - - - - - - - - - - - - -
GetOneByte:
	CMP	BytesToGo,0
	JZ	GetSome
	MOV	SI,ReadBufPtr
	LODSB
	MOV	ReadBufPtr,SI
	DEC	BytesToGo
	XOR	AH,AH			;do not signal EOF
	RET

GetSome:PUSH	CX
	MOV	BX,InHandle
	MOV	CX,BlockSize
	MOV	DX,ReadBufAddr
	MOV	ReadBufPtr,DX
	MOV	AH,3Fh			;read from file
	INT	21h
	POP	CX
	MOV	BytesToGo,AX
	JC	ReadError
	OR	AX,AX
	JNZ	GetOneByte
	MOV	AX,120h			;Signal EOF without using 1Ah as marker.
Ret1:	RET				;The ' ' in AL is for TrailSpaceLoop in
					; case of trailing tabs on last line.
ReadError:				;This is the only signal for EOF
	MOV	DX,OFFSET ReadErrMsg
	JMP	Err1Exit

ALtoBuffer:
	MOV	DI,WritePtr
	STOSB
	MOV	WritePtr,DI
	DEC	BytesTillWrite
	JNZ	Ret1
	PUSH	CX
	MOV	CX,BlockSize
WriteLast:
	PUSH	AX
	PUSH	BP
	PUSH	BX
	PUSH	DX
	MOV	BX,OutHandle
	MOV	BP,CX
	MOV	DX,WriteBufAddr
	MOV	WritePtr,DX
	MOV	AX,BlockSize
	MOV	BytesTillWrite,AX
	MOV	AH,40h			;write to file
	INT	21h
	JC	WriteError
	SUB	BP,AX
	JZ	H0056F
WriteError:
	MOV	DX,OFFSET WriteErrMsg
	JMP	Err1Exit

ChkAndWriteLast:			;eliminated writing EOF to file
	PUSH	CX
	MOV	CX,BlockSize
	SUB	CX,BytesTillWrite
	JNZ	WriteLast
	POP	CX
	RET

H0056F:	POP	DX
	POP	BX
	POP	BP
	POP	AX
	POP	CX
	RET

OpenInFile:
	MOV	DX,OFFSET InPathName
	MOV	AX,3D00h		;open file as read-only
	INT	21h
	JNC	OpenOK
	MOV	DX,OFFSET InOpenErrMsg
	JMP	SHORT OpenErrs

OpenOK:	MOV	InHandle,AX
	RET

CreateOutFile:
	MOV	DX,OFFSET OutPathName
	SUB	CX,CX			;file attribute
	MOV	AH,3Ch			;create file
	INT	21h
	JNC	CreateOK
	MOV	DX,OFFSET OutOpenErrMsg
	JMP	SHORT OpenErrs

CreateOK:
	MOV	OutHandle,AX
	RET

OpenErrs:
	CMP	AL,2
	JC	ToErr1Exit
	CMP	AL,5
	JA	ToErr1Exit
;error nos. 2 thru 5:
	DEC	AL
	DEC	AL
	SUB	BX,BX
	MOV	BL,AL
	MOV	CL,4
	SHL	BX,CL
	CALL	DsplStrAtDX
	MOV	DX,OFFSET CrLfStr
	CALL	DsplStrAtDX
	LEA	DX,[BX+OFFSET Err2msg]
ToErr1Exit:
	JMP	Err1Exit

CloseFiles:
	MOV	BX,OutHandle
	MOV	AH,3Eh			;close file
	INT	21h
	MOV	BX,InHandle
	MOV	AH,3Eh
	INT	21h
	RET

ParseCmdLine:
	MOV	SI,80h
	SUB	CX,CX
	OR	CL,[SI]
	JNZ	ParseInName
ShowHelp:
	MOV	DX,OFFSET HelpScrn
	JMP	Err1Exit

ParseInName:
	MOV	DI,OFFSET InPathName
	INC	SI
H005E2:	LODSB
	CMP	AL,' '
	JNZ	H005EB
	LOOPZ	H005E2
	JCXZ	ShowHelp
H005EB:	CMP	AL,cr
	JZ	H00639
	CMP	AL,'/'
	JZ	H005FE
	CMP	AL,' '
	JZ	H00613
	STOSB
	LODSB
	LOOP	H005EB

	JMP	SHORT H00639

H005FE:	MOV	AX,0FF00h
	STOSW
	LODSB
	CMP	AL,'D'
	JZ	H0060B
	CMP	AL,'d'
	JNZ	H00610
H0060B:	MOV	DeTabFlag,0FFh
H00610:	JMP	SHORT H0063D

H00613:	MOV	AX,0FF00h
	STOSW
	LEA	DI,OutPathName
H0061C:	LODSB
	CMP	AL,' '
	JNZ	H00625
	LOOPZ	H0061C
	JCXZ	H0063D
H00625:	CMP	AL,cr
	JZ	H00639
	CMP	AL,'/'
	JZ	H005FE
	CMP	AL,' '
	JZ	H00636
	STOSB
	MOV	H00225,DI
H00636:	LODSB
	LOOP	H00625

H00639:	MOV	AX,0FF00h
	STOSW
H0063D:	CMP	BYTE PTR DS:InPathName,0
	JNZ	H00646
	JMP	SHORT ShowHelp

H00646:	CALL	H00692
	CMP	OutPathName,0
	JNZ	H0065A
	CMP	H00155,':'
	JZ	H00684
	JMP	ShowHelp

H0065A:	CMP	WORD PTR DS:H001C4,':'
	JNZ	H0066A
	MOV	DI,OFFSET H001C5
	MOV	H00225,DI
	JMP	SHORT H00684

H0066A:	CMP	WORD PTR DS:H001C4,5C3Ah	;':\'
	JZ	H00679
	CMP	OutPathName,'\'
	JNZ	H00691
H00679:	MOV	DI,H00225
	MOV	AL,'\'
	STOSB
	MOV	H00225,DI
H00684:	MOV	CX,4Ah
	MOV	DI,H00225
	MOV	SI,H00223
	REP	MOVSB
H00691:	RET

H00692:	MOV	DX,OFFSET DTA
	MOV	AH,1Ah			;set DTA
	INT	21h
	MOV	DX,OFFSET InPathName
	SUB	CX,CX			;attrib to find (in addition to normal)
	MOV	AH,4Eh			;find first file
	INT	21h
	JNC	FirstFound
H006A4:	MOV	DX,OFFSET NotFoundMsg
	JMP	Err1Exit

FirstFound:
	OR	AL,AL
	JNZ	H006A4
	MOV	DI,OFFSET InPathName
	CMP	BYTE PTR 1[DI],':'
	JNZ	H006BA
	ADD	DI,2
H006BA:	CMP	BYTE PTR [DI],'\'
	JNZ	H006D4
	MOV	SI,OFFSET H0019F
	STD
	MOV	CX,4Ch
H006C6:	LODSB
	CMP	AL,'\'
	JZ	H006CF
	LOOP	H006C6

	MOV	SI,DI
H006CF:	MOV	DI,SI
	ADD	DI,2
H006D4:	MOV	H00223,DI
H006D8:	MOV	CX,0Dh
	MOV	DI,H00223
	CLD
	MOV	SI,OFFSET DTAfilename
H006E3:	LODSB
	STOSB
	CMP	AL,0
	LOOPNZ	H006E3
	MOV	AL,0FFh
	STOSB
	SUB	AL,AL
	RET

FindNext:
	MOV	AH,4Fh			;find next file
	INT	21h
	OR	AL,AL
	JNZ	FindNextError
	MOV	QuoteFlag,0
	MOV	SpaceCount,0
	MOV	AX,BlockSize
	MOV	BytesTillWrite,AX
	MOV	BytesToGo,0
	MOV	AX,WriteBufAddr
	MOV	WritePtr,AX
	MOV	AX,ReadBufAddr
	MOV	ReadBufPtr,AX
	MOV	AX,OFFSET OutPathName
	CMP	AX,H00225
	JNZ	H00727
	MOV	OutPathName,0
H00727:	MOV	CX,8
	MOV	SI,OFFSET EightSpaces
	MOV	DI,OFFSET DeTabStr
	REP	MOVSB
	MOV	TabsStr,cr
	MOV	TabsStr+1,lf
	MOV	DI,H00225
	MOV	CX,0Dh
	MOV	SI,OFFSET DTAfilename
H00746:	LODSB
	STOSB
	CMP	AL,0
	LOOPNZ	H00746
	MOV	AL,0FFh
	STOSB
	JMP	SHORT H006D8

FindNextError:
	RET

ShowFileNames:
	MOV	DX,OFFSET TabsStr
	CMP	DeTabFlag,0
	JZ	H0075F
	MOV	DX,OFFSET DeTabStr
H0075F:	CALL	DsplStrAtDX
	MOV	DX,OFFSET InPathName
	CALL	DsplStrAtDX
	MOV	DX,OFFSET Arrow
	CALL	DsplStrAtDX
	MOV	DX,OFFSET OutPathName
	CALL	DsplStrAtDX
	RET

DsplStrAtDX:
	PUSH	BX
	PUSH	SI
	MOV	SI,DX
DisplLoop:
	LODSB
	CMP	AL,0FFh
	JZ	DisplDone
	CMP	AL,0
	JZ	DisplLoop
	MOV	DL,AL
	MOV	AH,2			;display char in DL
	INT	21h
	JMP	SHORT DisplLoop

DisplDone:
	POP	SI
	POP	BX
	RET

SetUpRAM:
	MOV	CX,9Eh			;length of pgm in para's
	MOV	BX,DS:2			;seg past end of RAM
	MOV	AX,CS
	SUB	BX,AX
	SUB	BX,CX			;RamTop - Our Seg - len pgm = avail RAM
	ADD	AX,CX			;Our Seg + len pgm => seg of EndPgm
	CMP	BX,0F62h		;have 63K ?
	JNA	H007A7
	MOV	BX,0F62h		;take 63K max
H007A7:	MOV	ReadBufAddr,AX		;seg of EndPgm
	CMP	BX,0200h		;have 8K ?
	JB	H007E9
	SUB	BX,20h
	SHR	BX,1
	ADD	AX,BX			;ReadBufAddr+(RAM-20)/2, in segs
	MOV	WriteBufAddr,AX
	MOV	AX,BX
	MOV	CL,4
	SHL	AX,CL			;(RAM-20)/2 converted to bytes
	MOV	BlockSize,AX
	MOV	BytesTillWrite,AX
	CMP	AX,20h
	JB	H007A7			;can this happen ??
	MOV	DX,CS
	MOV	AX,ReadBufAddr
	SUB	AX,DX
	SHL	AX,CL
	MOV	ReadBufAddr,AX		;addr in our seg of EndPgm
	MOV	ReadBufPtr,AX
	MOV	AX,WriteBufAddr
	SUB	AX,DX
	SHL	AX,CL			;convert to bytes
	MOV	WriteBufAddr,AX
	MOV	WritePtr,AX
	RET

H007E9:	MOV	DX,OFFSET NoRAMmsg
	JMP	Err1Exit

EndPgm	EQU	$
	
CSEG	ends
	END	Start
