REM     The Standart GNU Personal BASIC Language Interpretter.
REM     Copyright (C) Sandul Yura Valentinovich.
REM     (R) Monday, 10 March 2003 year.
REM     This program is free software; you can redistribute it and/or modify
REM it under the terms of the GNU General Public License as published by the
REM Free Software Foundation; either version 2 of the License, or (at your
REM option) any later version.
REM     This program is distributed in the hope that it will be useful, but
REM WITHOUT ANY WARRANTY; without even the implied warranty of
REM MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
REM Public License for more details.
REM     You should have received a copy of the GNU General Public License
REM along with this program; if not, write to the Free Software Foundation,
REM Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
REM
REM $DYNAMIC
DECLARE SUB RunLine (InLine$)
DECLARE SUB SortLines ()
DECLARE SUB ClearAll (ClearLines%)
DECLARE SUB ANSIOut (ANSISymbol$)
DECLARE SUB ClearANSI ()
DECLARE SUB DeleteLine (LineNumber%)
DECLARE SUB Hang ()
DECLARE SUB OutHelp ()
DECLARE SUB Restart ()
DECLARE SUB WriteLineOut (Line$)
DECLARE SUB SetVariable (VariableName$, VariableType%, VariableValue$)
DECLARE SUB SetTimerValue (NewValue&)
DECLARE SUB WriteLine (Line$)
DECLARE FUNCTION Calculate$ (InLine$)
DECLARE FUNCTION DayName$ (DayNumber%)
DECLARE FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
DECLARE FUNCTION FindLine% (LineNumber%)
DECLARE FUNCTION GetTimerValue& ()
DECLARE FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
DECLARE FUNCTION InMeaning$ (InLine$)
DECLARE FUNCTION InName$ (InLine$)
DECLARE FUNCTION InNumber# (InLine$)
DECLARE FUNCTION InVariable$ (VariableName$, VariableType%, InLine$)
DECLARE FUNCTION IsLeapYear% (YearValue%)
DECLARE FUNCTION MonthDays% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
DECLARE FUNCTION MonthName$ (MonthNumber%)
DECLARE FUNCTION ParseCalculate$ (InLine$)
DECLARE FUNCTION ParseInMeaning$ (InLine$)
DECLARE FUNCTION ParseInNumber$ (InLine$)
DECLARE FUNCTION ParseRunLine$ (InLine$)
DECLARE FUNCTION SquareRoot# (Meaning#)
DECLARE FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
OPTION BASE 1
CONST False% = 0
CONST True% = NOT False%
CONST BASICLinesCountValue% = 64
CONST DefFnSCountValue% = 4
CONST DefFnSArgumentsCountValue% = 4
CONST VariablesCountValue% = 8
CONST GoSubSCountValue% = 4
CONST FilesCountValue% = 4
CONST ANSIParametersCountValue% = 4
CONST WhilesCountValue% = 4
CONST FromsCountValue% = 4
CLEAR , , 7356
DIM SHARED CursorRow%
DIM SHARED CursorColumn%
DIM SHARED CursorSaved%
DIM SHARED Parameters%(ANSIParametersCountValue%)
DIM SHARED ParametersCount%
DIM SHARED ANSIMode%
DIM SHARED NumberLine$
DIM SHARED BASICLines$(BASICLinesCountValue%)
DIM SHARED DefFnS$(DefFnSCountValue%)
DIM SHARED DefFnSArgs$(DefFnSCountValue%, DefFnSArgumentsCountValue%)
DIM SHARED DefFnSArgsCount%(DefFnSCountValue%)
DIM SHARED Variables$(VariablesCountValue%)
DIM SHARED GoSubS%(GoSubSCountValue%)
DIM SHARED BASICFiles$(FilesCountValue%)
DIM SHARED Whiles$(WhilesCountValue%)
DIM SHARED Froms$(FromsCountValue%)
DIM SHARED BASICLinesCount%
DIM SHARED DefFnSCount%
DIM SHARED VariablesCount%
DIM SHARED GoSubSCount%
DIM SHARED RunMode%
DIM SHARED TraceMode%
DIM SHARED DebugMode%
DIM SHARED CurrentLine%
DIM SHARED CurrentDefFn%
DIM SHARED DefFnMode%
DIM SHARED NumStr%
DIM Errors$(87)
DIM BASICLine$
DIM Index%
DIM LineNumber%
ON ERROR GOTO BASICError
Errors$(1) = "NEXT without FOR"
Errors$(2) = "Syntax error"
Errors$(3) = "RETURN without GOSUB"
Errors$(4) = "Out of DATA"
Errors$(5) = "Illegal function call"
Errors$(6) = "Overflow"
Errors$(7) = "Out of memory"
Errors$(8) = "Label not defined"
Errors$(9) = "Subscript out of range"
Errors$(10) = "Duplicate definition"
Errors$(11) = "Division by zero"
Errors$(12) = "Illegal in direct mode"
Errors$(13) = "Type mismatch"
Errors$(14) = "Out of string space"
Errors$(15) = "Inavlid line number"
Errors$(16) = "String formula too complex"
Errors$(17) = "Cannot continue"
Errors$(18) = "Function not defined"
Errors$(19) = "No RESUME"
Errors$(20) = "RESUME without error"
Errors$(21) = "Too many program lines"
Errors$(22) = "Too many variables"
Errors$(23) = "User - defined functions are not declare"
Errors$(24) = "Device timeout"
Errors$(25) = "Device fault"
Errors$(26) = "FOR without NEXT"
Errors$(27) = "Out of paper"
Errors$(28) = "Inquired user - defined function is not declare"
Errors$(29) = "WHILE without WEND"
Errors$(30) = "WEND without WHILE"
Errors$(31) = "Too many calculating user - defined functions"
Errors$(32) = "Too many arguments for user - defined function"
Errors$(33) = "Duplicate label"
Errors$(34) = "Unknown statement"
Errors$(35) = "Subprogram not defined"
Errors$(36) = "File already closed"
Errors$(37) = "Argument - count mismatch"
Errors$(38) = "Array not defined"
Errors$(39) = "Too many user - defined functions"
Errors$(40) = "Variable required"
Errors$(41) = "Trace mode is already turned to On"
Errors$(42) = "Cannot run this statement without program is running mode"
Errors$(43) = "Line is not found"
Errors$(44) = "Too many GOSUB's"
Errors$(45) = "Program already running"
Errors$(46) = "Nothing to save"
Errors$(47) = "Trace mode is already turned to Off"
Errors$(48) = "Too many lines in file"
Errors$(49) = "Cannot turn on debug mode if program is running"
Errors$(50) = "FIELD overflow"
Errors$(51) = "Internal error"
Errors$(52) = "Bad file name or number"
Errors$(53) = "File not found"
Errors$(54) = "Bad file mode"
Errors$(55) = "File already open"
Errors$(56) = "FIELD statement active"
Errors$(57) = "Device I/O error"
Errors$(58) = "File already exists"
Errors$(59) = "Bad record length"
Errors$(60) = "Debug mode is already turned to On"
Errors$(61) = "Disk full"
Errors$(62) = "Input past end of file"
Errors$(63) = "Bad record number"
Errors$(64) = "Bad file name"
Errors$(65) = "Nothing to run"
Errors$(66) = "Nothing to debug"
Errors$(67) = "Too many files"
Errors$(68) = "Device unavailable"
Errors$(69) = "Communication-buffer overflow"
Errors$(70) = "Permission denied"
Errors$(71) = "Disk not ready"
Errors$(72) = "Disk - media error"
Errors$(73) = "Feature unavailable"
Errors$(74) = "Rename across disks"
Errors$(75) = "Path/File access error"
Errors$(76) = "Path not found"
Errors$(77) = "Cannot trace not turned to debug mode program"
Errors$(78) = "Debug mode is already turned to Off"
Errors$(79) = "Invalid line numbers range"
Errors$(80) = "Cannot end not runned program"
Errors$(81) = "Too many WHILE's"
Errors$(82) = "EXIT WHILE without WHILE"
Errors$(83) = "Too many FROM's"
Errors$(84) = "EXIT FROM without FROM"
Errors$(85) = "Year must be in range from 1980 up to 2099"
Errors$(86) = "Month must be in range from 1 up to 12"
Errors$(87) = "Day must be in range from 1 up to maximal count of days in given month and given year"
KEY OFF
KEY 1, "List" + CHR$(13)
KEY 2, "Save " + CHR$(34)
KEY 3, "Load " + CHR$(34)
KEY 4, "Cls" + CHR$(13)
KEY 5, "TrOn" + CHR$(13)
KEY 6, "TrOff" + CHR$(13)
KEY 7, "Run" + CHR$(13)
KEY 8, "List" + CHR$(13)
KEY 9, "Help!" + CHR$(13)
KEY 10, "System" + CHR$(13)
KEY ON
SCREEN 0, 1, 0, 0
COLOR 7, 0
CLS
LOCATE 1, 1, 1, 7, 8
PRINT "    The Standart GNU Personal BASIC Language Interpretter."
PRINT "    Copyright (C) Sandul Yura Valentinovich."
PRINT "    (R) Monday, 10 March 2003 year."
PRINT "    This program is free software; you can redistribute it and/or modify it"
PRINT "under the terms of the GNU General Public License as published by the Free"
PRINT "Software Foundation; either version 2 of the License, or (at your option) any"
PRINT "later version."
PRINT "    This program is distributed in the hope that it will be useful, but WITHOUT"
PRINT "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS"
PRINT "FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details."
PRINT "    You should have received a copy of the GNU General Public License along with"
PRINT "this program; if not, write to the Free Software Foundation, Inc., 675 Mass Ave,"
PRINT "Cambridge, MA 02139, USA."
PRINT
DO
 PRINT "Current date: " + DayOfWeekName$(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))) + ", " + LTRIM$(STR$(VAL(MID$(DATE$, 4, 2)))) + " " + MonthName$(VAL(MID$(DATE$, 1, 2))) + " " + LTRIM$(STR$(VAL(MID$(DATE$, 7, 4)))) + " year, time: " + TIME$ + ", week: " + LTRIM$(STR$(WeekNumber%(VAL(MID$(DATE$, 4, 2)), VAL(MID$(DATE$, 1, 2)), VAL(MID$(DATE$, 7, 4))))) + "."
 PRINT "Free stack space: " + LTRIM$(STR$(FRE(-2))) + " bytes."
 LINE INPUT "*(BASIC)="; BASICLine$
 BASICLine$ = LTRIM$(RTRIM$(BASICLine$))
 IF BASICLine$ <> "" THEN
  SELECT CASE LEFT$(UCASE$(BASICLine$), 1)
  CASE "A" TO "Z"
    BASICLine$ = ParseRunLine$(BASICLine$)
    CALL RunLine(BASICLine$)
  CASE "0" TO "9"
    LineNumber% = INT(InNumber#(BASICLine$))
    IF (LineNumber% < 1) OR (LineNumber% > BASICLinesCountValue%) THEN ERROR 15
    BASICLine$ = LTRIM$(BASICLine$)
    SELECT CASE LEFT$(UCASE$(BASICLine$), 1)
    CASE "A" TO "Z"
      BASICLine$ = ParseRunLine$(BASICLine$)
      IF BASICLinesCount% = 0 THEN
       BASICLinesCount% = BASICLinesCount% + 1
       BASICLines$(BASICLinesCount%) = LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
      ELSE
       FOR Index% = 1 TO BASICLinesCount% + 1
        IF Index% = BASICLinesCount% + 1 THEN
         IF BASICLinesCount% = BASICLinesCountValue% THEN ERROR 21
         BASICLinesCount% = BASICLinesCount% + 1
         BASICLines$(BASICLinesCount%) = LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
         CALL SortLines
         EXIT FOR
        END IF
        IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN
         BASICLines$(Index%) = LTRIM$(STR$(LineNumber%)) + "=" + BASICLine$
         EXIT FOR
        END IF
       NEXT Index%
      END IF
    CASE ELSE
      ERROR 2
    END SELECT
  CASE ELSE
    ERROR 2
  END SELECT
 END IF
BASICInterpretterWork:
LOOP
END
BASICError:
 PRINT "FATAL! Error: " + Errors$(ERR) + "."
 CALL ClearAll(False%)
 RESUME BASICInterpretterWork

SUB ANSIOut (ANSISymbol$)
 DIM CurrentRow%
 DIM CurrentColumn%
 DIM Index%
 SELECT CASE ANSIMode%
 CASE 0
   SELECT CASE ANSISymbol$
   CASE CHR$(10)
     PRINT
   CASE CHR$(27)
     ANSIMode% = 1
   CASE ELSE
     IF ANSISymbol$ <> "" THEN IF ASC(ANSISymbol$) > (ASC(SPACE$(1)) - 1) THEN PRINT ANSISymbol$;
   END SELECT
 CASE 1
   SELECT CASE ANSISymbol$
   CASE "["
     ANSIMode% = 2
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 2
   SELECT CASE ANSISymbol$
   CASE "H"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "f"
     SELECT CASE ParametersCount%
     CASE 0
       LOCATE 1, 1, 1, 7, 8
     CASE 1
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       LOCATE Parameters%(1), 1, 1, 7, 8
     CASE ELSE
       IF Parameters%(1) < 1 THEN Parameters%(1) = 1
       IF Parameters%(1) > 25 THEN Parameters%(1) = 25
       IF Parameters%(2) < 1 THEN Parameters%(2) = 1
       IF Parameters%(2) > 80 THEN Parameters%(2) = 80
       LOCATE Parameters%(1), Parameters%(2), 1, 7, 8
     END SELECT
     CALL ClearANSI
   CASE "A"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN - Parameters%(1)) > 0 THEN LOCATE CSRLIN - Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "B"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (CSRLIN + Parameters%(1)) < 26 THEN LOCATE CSRLIN + Parameters%(1), POS(0), 1, 7, 8
     CALL ClearANSI
   CASE "C"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) + Parameters%(1)) < 81 THEN LOCATE CSRLIN, POS(0) + Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "D"
     IF Parameters%(1) < 1 THEN Parameters%(1) = 1
     IF (POS(0) - Parameters%(1)) > 0 THEN LOCATE CSRLIN, POS(0) - Parameters%(1), 1, 7, 8
     CALL ClearANSI
   CASE "s"
     IF NOT CursorSaved% THEN
      CursorSaved% = True%
      CursorRow% = CSRLIN
      CursorColumn% = POS(0)
     END IF
     CALL ClearANSI
   CASE "u"
     IF CursorSaved% THEN
      LOCATE CursorRow%, CursorColumn%, 1, 7, 8
      CursorRow% = 0
      CursorColumn% = 0
      CursorSaved% = False%
     END IF
     CALL ClearANSI
   CASE "J"
     CLS
     CALL ClearANSI
     LOCATE 1, 1, 1, 7, 8
   CASE "K"
     CurrentRow% = CSRLIN
     CurrentColumn% = POS(0)
     PRINT SPACE$(80 - POS(0));
     LOCATE CurrentRow%, CurrentColumn%, 1, 7, 8
     CurrentRow% = 0
     CurrentColumn% = 0
     CALL ClearANSI
   CASE "m"
     IF ParametersCount% > 0 THEN
      FOR Index% = 1 TO ParametersCount%
       SELECT CASE Parameters%(Index%)
       CASE 0
         COLOR 7, 0
       CASE 1
         COLOR 15
       CASE 4
         COLOR 1
       CASE 5
         COLOR 7
       CASE 7
         COLOR 0, 7
       CASE 8
         COLOR 0, 0
       CASE 30
         COLOR 0
       CASE 31
         COLOR 4
       CASE 32
         COLOR 2
       CASE 33
         COLOR 6
       CASE 34
         COLOR 1
       CASE 35
         COLOR 5
       CASE 36
         COLOR 3
       CASE 37
         COLOR 15
       CASE 40
         COLOR , 0
       CASE 41
         COLOR , 4
       CASE 42
         COLOR , 2
       CASE 43
         COLOR , 6
       CASE 44
         COLOR , 1
       CASE 45
         COLOR , 5
       CASE 46
         COLOR , 3
       CASE 47
         COLOR , 7
       END SELECT
      NEXT Index%
     ELSE
      COLOR 7, 0
     END IF
     CALL ClearANSI
   CASE "0" TO "9"
     ANSIMode% = 3
     CALL ANSIOut(ANSISymbol$)
   CASE ";"
     ParametersCount% = 1
   CASE ELSE
     CALL ClearANSI
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 CASE 3
   SELECT CASE ANSISymbol$
   CASE "0" TO "9"
     IF LEN(NumberLine$) < 2 THEN NumberLine$ = NumberLine$ + ANSISymbol$
   CASE ";"
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     NumberLine$ = ""
   CASE ELSE
     IF ParametersCount% < ANSIParametersCountValue% THEN
      ParametersCount% = ParametersCount% + 1
      Parameters%(ParametersCount%) = VAL(NumberLine$)
     END IF
     ANSIMode% = 2
     CALL ANSIOut(ANSISymbol$)
   END SELECT
 END SELECT
END SUB

FUNCTION Calculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM WorkNumStr%
 DIM SavedLine$
 Result$ = InMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    WorkNumStr% = NumStr%
    Value$ = InMeaning$(InLine$)
    IF NumStr% <> WorkNumStr% THEN ERROR 13
    IF NumStr% THEN Result$ = Result$ + Value$ ELSE Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
  CASE "-"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) - VAL(Value$)))
  CASE "/"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "\"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) = 0# THEN ERROR 11
    Result$ = LTRIM$(STR$(VAL(Result$) / VAL(Value$)))
  CASE "*"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) * VAL(Value$)))
  CASE "^"
    IF NumStr% THEN ERROR 13
    InLine$ = MID$(InLine$, 2)
    Value$ = InMeaning$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(VAL(Result$) ^ VAL(Value$)))
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ = Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) = VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ < Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) < VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ <> Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) <> VAL(Value$)))
    CASE "="
      InLine$ = MID$(InLine$, 2)
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ >= Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) >= VAL(Value$)))
    CASE ELSE
      WorkNumStr% = NumStr%
      Value$ = InMeaning$(InLine$)
      IF NumStr% <> WorkNumStr% THEN ERROR 13
      IF NumStr% THEN Result$ = LTRIM$(STR$(Result$ > Value$)) ELSE Result$ = LTRIM$(STR$(VAL(Result$) > VAL(Value$)))
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) AND VAL(Value$)))
    CASE "OR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) OR VAL(Value$)))
    CASE "XOR"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) XOR VAL(Value$)))
    CASE "MOD"
      IF NumStr% THEN ERROR 13
      Value$ = InMeaning$(InLine$)
      IF NumStr% THEN ERROR 13
      Result$ = LTRIM$(STR$(VAL(Result$) MOD VAL(Value$)))
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 IF NOT NumStr% THEN IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
 Calculate$ = Result$
END FUNCTION

SUB ClearAll (ClearLines%)
 DIM Index%
 DIM SubIndex%
 IF ClearLines% THEN
  FOR Index% = 1 TO BASICLinesCountValue%
   BASICLines$(Index%) = ""
  NEXT Index%
  BASICLinesCount% = 0
 END IF
 FOR Index% = 1 TO DefFnSCountValue%
  DefFnS$(Index%) = ""
  DefFnSArgsCount%(Index%) = 0
  FOR SubIndex% = 1 TO DefFnSArgumentsCountValue%
   DefFnSArgs$(Index%, SubIndex%) = ""
  NEXT SubIndex%
 NEXT Index%
 FOR Index% = 1 TO VariablesCountValue%
  Variables$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO GoSubSCountValue%
  GoSubS%(Index%) = 0
 NEXT Index%
 FOR Index% = 1 TO FilesCountValue%
  BASICFiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO WhilesCountValue%
  Whiles$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO FromsCountValue%
  Froms$(Index%) = ""
 NEXT Index%
 FOR Index% = 1 TO ANSIParametersCountValue%
  Parameters%(Index%) = 0
 NEXT Index%
 DefFnSCount% = 0
 VariablesCount% = 0
 GoSubSCount% = 0
 CurrentLine% = 0
 CurrentDefFn% = 0
 NumStr% = False%
 DefFnMode% = False%
 RunMode% = False%
 TraceMode% = False%
 DebugMode% = False%
 CursorRow% = 0
 CursorColumn% = 0
 CursorSaved% = False%
 ParametersCount% = 0
 ANSIMode% = 0
 NumberLine$ = ""
 CLOSE
END SUB

SUB ClearANSI
 DIM Index%
 FOR Index% = 1 TO ANSIParametersCountValue%
  Parameters%(Index%) = 0
 NEXT Index%
 ParametersCount% = 0
 ANSIMode% = 0
 NumberLine$ = ""
END SUB

FUNCTION DayName$ (DayNumber%)
 SELECT CASE DayNumber%
 CASE 1
   DayName$ = "Monday"
 CASE 2
   DayName$ = "Tuesday"
 CASE 3
   DayName$ = "Wednesday"
 CASE 4
   DayName$ = "Thursday"
 CASE 5
   DayName$ = "Friday"
 CASE 6
   DayName$ = "Saturday"
 CASE 7
   DayName$ = "Sunday"
 END SELECT
END FUNCTION

FUNCTION DayOfWeek% (DayValue%, MonthValue%, YearValue%)
 SELECT CASE DaysCount&(DayValue%, MonthValue%, YearValue%) - (INT(DaysCount&(DayValue%, MonthValue%, YearValue%) / 7) * 7)
 CASE 0
   DayOfWeek% = 6
 CASE 1
   DayOfWeek% = 7
 CASE 2
   DayOfWeek% = 1
 CASE 3
   DayOfWeek% = 2
 CASE 4
   DayOfWeek% = 3
 CASE 5
   DayOfWeek% = 4
 CASE 6
   DayOfWeek% = 5
 CASE 7
   DayOfWeek% = 6
 END SELECT
END FUNCTION

FUNCTION DayOfWeekName$ (DayValue%, MonthValue%, YearValue%)
 DayOfWeekName$ = DayName$(DayOfWeek%(DayValue%, MonthValue%, YearValue%))
END FUNCTION

FUNCTION DaysCount& (DayValue%, MonthValue%, YearValue%)
 DaysCount& = (YearValue% * 365&) + INT(YearValue% / 100) + INT(YearValue% / 4) + MonthDaysCount%(MonthValue%, YearValue%) + DayValue%
END FUNCTION

SUB DeleteLine (LineNumber%)
 DIM Index%
 DIM Value%
 Value% = FindLine%(LineNumber%)
 BASICLines$(Value%) = ""
 FOR Index% = Value% TO BASICLinesCount% - 1
  BASICLines$(Index%) = BASICLines$(Index% + 1)
  BASICLines$(Index% + 1) = ""
 NEXT Index%
 BASICLinesCount% = BASICLinesCount% - 1
END SUB

FUNCTION FindLine% (LineNumber%)
 DIM Index%
 IF BASICLinesCount% = 0 THEN ERROR 43
 FOR Index% = 1 TO BASICLinesCount% + 1
  IF Index% = BASICLinesCount% + 1 THEN ERROR 43
  IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN EXIT FOR
 NEXT Index%
 FindLine% = Index%
END FUNCTION

FUNCTION GetTimerValue&
 DIM TimerMeaning&
 DIM Bytes%(4)
 DIM Index%
 DEF SEG = &H0
 FOR Index% = &H0 TO &H3
  Bytes%(Index% + 1) = PEEK(&H46C + Index%)
 NEXT Index%
 DEF SEG = VARSEG(TimerMeaning&)
 FOR Index% = &H0 TO &H3
  POKE VARPTR(TimerMeaning&) + Index%, Bytes%(Index% + 1)
 NEXT Index%
 DEF SEG
 GetTimerValue& = TimerMeaning&
END FUNCTION

SUB Hang
 DIM HangCode%(32)
 DIM Index%
 DIM HangCode$
 HangCode$ = "BA0000529DBF40008EC7BF000026C6050083C70181FF010475F3B80000509D"
 HangCode$ = HangCode$ + "BB0000B90000BA0000BD0000BC0000BE0000BF00008EDA8EC7"
 HangCode$ = HangCode$ + "8ED4F0F4CD20CB"
 Index% = 0
 DEF SEG = VARSEG(HangCode%(1))
 WHILE HangCode$ <> ""
  POKE VARPTR(HangCode%(1)) + Index%, VAL("&H" + LEFT$(HangCode$, 2))
  Index% = Index% + 1
  HangCode$ = MID$(HangCode$, 3)
 WEND
 CALL Absolute(VARPTR(HangCode%(1)))
END SUB

FUNCTION InDefFn$ (DefFnName$, DefFnType%, InLine$)
 DIM Result$
 DIM WorkDefFnName$
 DIM WorkDefFnType%
 DIM OldDefFnMode%
 DIM WorkLine$
 DIM Index%
 DIM ArgumentType%
 IF DefFnSCount% = 0 THEN ERROR 23
 FOR Index% = 1 TO DefFnSCount% + 1
  IF Index% = DefFnSCount% + 1 THEN ERROR 28
  WorkLine$ = DefFnS$(Index%)
  WorkDefFnName$ = InName$(WorkLine$)
  WorkLine$ = LTRIM$(WorkLine$)
  WorkDefFnType% = False%
  SELECT CASE LEFT$(WorkLine$, 1)
  CASE "$"
    WorkDefFnType% = True%
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "!"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "@"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "#"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "%"
    WorkLine$ = MID$(WorkLine$, 2)
  CASE "&"
    WorkLine$ = MID$(WorkLine$, 2)
  END SELECT
  IF (WorkDefFnName$ = DefFnName$) AND (WorkDefFnType% = DefFnType%) THEN EXIT FOR
 NEXT Index%
 IF CurrentDefFn% = DefFnSCountValue% THEN ERROR 31
 CurrentDefFn% = CurrentDefFn% + 1
 DefFnSArgsCount%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgumentsCountValue%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 WorkLine$ = LTRIM$(WorkLine$)
 IF LEFT$(WorkLine$, 1) = "(" THEN
  WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
  DefFnSArgsCount%(CurrentDefFn%) = 1
  DO WHILE WorkLine$ <> ""
   Result$ = InName$(WorkLine$)
   WorkLine$ = LTRIM$(WorkLine$)
   ArgumentType% = False%
   SELECT CASE LEFT$(WorkLine$, 1)
   CASE "$"
     ArgumentType% = True%
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "!"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "@"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "#"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "%"
     WorkLine$ = MID$(WorkLine$, 2)
   CASE "&"
     WorkLine$ = MID$(WorkLine$, 2)
   END SELECT
   DefFnSArgs$(CurrentDefFn%, DefFnSArgsCount%(CurrentDefFn%)) = Result$ + "[" + LTRIM$(STR$(ABS(ArgumentType%))) + "]="
   WorkLine$ = LTRIM$(WorkLine$)
   SELECT CASE LEFT$(WorkLine$, 1)
   CASE ","
     IF DefFnSArgsCount%(CurrentDefFn%) = DefFnSArgumentsCountValue% THEN ERROR 32
     WorkLine$ = MID$(WorkLine$, 2)
     DefFnSArgsCount%(CurrentDefFn%) = DefFnSArgsCount%(CurrentDefFn%) + 1
   CASE ")"
     WorkLine$ = LTRIM$(MID$(WorkLine$, 2))
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
  InLine$ = LTRIM$(InLine$)
  IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
  InLine$ = LTRIM$(MID$(InLine$, 2))
  IF InLine$ = "" THEN ERROR 5
  Index% = 1
  DO WHILE InLine$ <> ""
   Result$ = Calculate$(InLine$)
   IF ABS(NumStr%) <> VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) THEN ERROR 13
   DefFnSArgs$(CurrentDefFn%, Index%) = DefFnSArgs$(CurrentDefFn%, Index%) + Result$
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE ","
     IF Index% = DefFnSArgsCount%(CurrentDefFn%) THEN ERROR 37
     InLine$ = MID$(InLine$, 2)
     Index% = Index% + 1
   CASE ")"
     IF Index% <> DefFnSArgsCount%(CurrentDefFn%) THEN ERROR 37
     InLine$ = LTRIM$(MID$(InLine$, 2))
     EXIT DO
   CASE ELSE
     ERROR 2
   END SELECT
  LOOP
 END IF
 IF LEFT$(WorkLine$, 1) <> "=" THEN ERROR 2
 WorkLine$ = MID$(WorkLine$, 2)
 OldDefFnMode% = DefFnMode%
 DefFnMode% = True%
 Result$ = Calculate$(WorkLine$)
 IF NumStr% <> DefFnType% THEN ERROR 13
 DefFnMode% = OldDefFnMode%
 DefFnSArgsCount%(CurrentDefFn%) = 0
 FOR Index% = 1 TO DefFnSArgumentsCountValue%
  DefFnSArgs$(CurrentDefFn%, Index%) = ""
 NEXT Index%
 CurrentDefFn% = CurrentDefFn% - 1
 InDefFn$ = Result$
END FUNCTION

FUNCTION InMeaning$ (InLine$)
 DIM Crc32Table&(256)
 DIM CrcIndex%
 DIM Crc&
 DIM Index%
 DIM WorkValue%
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# + VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   Result$ = LTRIM$(STR$(0# - VAL(Result$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "0" TO "9"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "."
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE "&"
   NumStr% = False%
   Result$ = LTRIM$(STR$(InNumber#(InLine$)))
   IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
   InMeaning$ = Result$
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   NumStr% = True%
   InMeaning$ = MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   InMeaning$ = Calculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   NumStr% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     NumStr% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    Result$ = LTRIM$(STR$(NOT VAL(Result$)))
    IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
    InMeaning$ = Result$
   ELSE
    IF NumStr% THEN
     SELECT CASE WorkName$
     CASE "DATE"
       InMeaning$ = DATE$
     CASE "TIME"
       InMeaning$ = TIME$
     CASE "INKEY"
       InMeaning$ = INKEY$
     CASE "INPUT"
       IF LEFT$(InLine$, 1) = "(" THEN
        InLine$ = LTRIM$(MID$(InLine$, 2))
        IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        Result$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
        InLine$ = MID$(InLine$, 2)
        IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
        IF LEFT$(BASICFiles$(VAL(Result$)), 3) <> "IN=" THEN ERROR 54
        LINE INPUT #VAL(Result$), Result$
        NumStr% = True%
       ELSE
        LINE INPUT Result$
       END IF
       InMeaning$ = Result$
     CASE "CHR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = CHR$(INT(VAL(Result$)))
     CASE "HEX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = HEX$(VAL(Result$))
     CASE "OCT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = OCT$(VAL(Result$))
     CASE "DAYNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 7) THEN ERROR 5
       InMeaning$ = DayName$(VAL(Result$))
     CASE "MONTHNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Result$) < 1) OR (VAL(Result$) > 12) THEN ERROR 86
       InMeaning$ = MonthName$(VAL(Result$))
     CASE "SPACE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = SPACE$(VAL(Result$))
     CASE "STR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "LCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LCASE$(Result$)
     CASE "UCASE"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = UCASE$(Result$)
     CASE "LTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(Result$)
     CASE "RTRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = RTRIM$(Result$)
     CASE "TRIM"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(RTRIM$(Result$))
     CASE "LEFT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = LEFT$(Result$, VAL(Value$))
     CASE "RIGHT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = RIGHT$(Result$, VAL(Value$))
     CASE "STRING"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = STRING$(VAL(Result$), Value$) ELSE InMeaning$ = STRING$(VAL(Result$), VAL(Value$))
       NumStr% = True%
     CASE "MID"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       InMeaning$ = MID$(Result$, VAL(Value$), VAL(Meaning$))
     CASE "DAYOFWEEKNAME"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = True%
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = DayOfWeekName$(VAL(Result$), VAL(Value$), VAL(Meaning$))
     CASE "ENVIRON"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF NumStr% THEN InMeaning$ = ENVIRON$(Result$) ELSE InMeaning$ = ENVIRON$(VAL(Result$))
       NumStr% = True%
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ < Result$ THEN Result$ = Value$
       LOOP
       InMeaning$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NOT NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF Value$ > Result$ THEN Result$ = Value$
       LOOP
       InMeaning$ = Result$
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN InMeaning$ = InDefFn$(WorkName$, True%, InLine$) ELSE InMeaning$ = InVariable$(WorkName$, True%, InLine$)
       IF NOT NumStr% THEN ERROR 13
     END SELECT
    ELSE
     SELECT CASE WorkName$
     CASE "PI"
       InMeaning$ = "3.1415926535897932385"
     CASE "CSRLIN"
       InMeaning$ = LTRIM$(STR$(CSRLIN))
     CASE "RANDOM"
       Result$ = LTRIM$(STR$(RND))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "TIMER"
       InMeaning$ = LTRIM$(STR$(TIMER))
     CASE "TIMERVALUE"
       InMeaning$ = LTRIM$(STR$(GetTimerValue&))
     CASE "BLACK"
       InMeaning$ = "0"
     CASE "BLUE"
       InMeaning$ = "1"
     CASE "GREEN"
       InMeaning$ = "2"
     CASE "CYAN"
       InMeaning$ = "3"
     CASE "RED"
       InMeaning$ = "4"
     CASE "MAGENTA"
       InMeaning$ = "5"
     CASE "BROWN"
       InMeaning$ = "6"
     CASE "WHITE"
       InMeaning$ = "7"
     CASE "GRAY"
       InMeaning$ = "8"
     CASE "LIGHTBLUE"
       InMeaning$ = "9"
     CASE "LIGHTGREEN"
       InMeaning$ = "10"
     CASE "LIGHTCYAN"
       InMeaning$ = "11"
     CASE "LIGHTRED"
       InMeaning$ = "12"
     CASE "LIGHTMAGENTA"
       InMeaning$ = "13"
     CASE "YELLOW"
       InMeaning$ = "14"
     CASE "BRIGHTWHITE"
       InMeaning$ = "15"
     CASE "TRUE"
       InMeaning$ = LTRIM$(STR$(True%))
     CASE "FALSE"
       InMeaning$ = LTRIM$(STR$(False%))
     CASE "POS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(POS(0)))
     CASE "SQR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SquareRoot#(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "ABS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ABS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "ATN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(ATN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "COS"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(COS(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "EXP"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(EXP(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "FIX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(FIX(VAL(Result$))))
     CASE "INT"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(INT(VAL(Result$))))
     CASE "LOG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(LOG(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "SIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(SIN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "TAN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = LTRIM$(STR$(TAN(VAL(Result$))))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "SGN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       InMeaning$ = LTRIM$(STR$(SGN(VAL(Result$))))
     CASE "EOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
       IF LEFT$(BASICFiles$(VAL(Result$)), 3) <> "IN=" THEN ERROR 54
       InMeaning$ = LTRIM$(STR$(EOF(VAL(Result$))))
     CASE "LOF"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = LTRIM$(MID$(InLine$, 2))
       IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
       InMeaning$ = LTRIM$(STR$(LOF(VAL(Result$))))
     CASE "ASC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF Result$ = "" THEN ERROR 5
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(ASC(Result$)))
     CASE "LEN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(LEN(Result$)))
     CASE "CRC"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       FOR Index% = 1 TO 256
        Crc& = Index% - 1
        FOR CrcIndex% = 1 TO 8
         IF ((INT(Crc& / 2) * 2) <> Crc&) THEN Crc& = INT(Crc& / 2) XOR &HEDB88320 ELSE Crc& = INT(Crc& / 2)
        NEXT CrcIndex%
        Crc32Table&(Index%) = Crc&
       NEXT Index%
       Crc& = &HFFFFFFFF
       WHILE Result$ <> ""
        WorkValue% = ABS((Crc& MOD &H100) XOR ASC(Result$))
        Result$ = MID$(Result$, 2)
        IF WorkValue% < 0 THEN WorkValue% = 0
        IF WorkValue% > 255 THEN WorkValue% = 255
        Crc& = Crc32Table&(WorkValue% + 1) XOR INT(Crc& / &H100)
       WEND
       InMeaning$ = LTRIM$(STR$(Crc&))
     CASE "VAL"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       Result$ = LTRIM$(STR$(VAL(Result$)))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "INSTR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NOT NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       NumStr% = False%
       InMeaning$ = LTRIM$(STR$(INSTR(Result$, Value$)))
     CASE "DAYOFWEEK"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(DayOfWeek%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "WEEKNUMBER"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Value$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Meaning$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Meaning$) < 1980) OR (VAL(Meaning$) > 2099) THEN ERROR 85
       IF (VAL(Value$) < 1) OR (VAL(Value$) > 12) THEN ERROR 86
       IF (VAL(Result$) < 1) OR (VAL(Result$) > MonthDays%(VAL(Value$), VAL(Meaning$))) THEN ERROR 87
       InMeaning$ = LTRIM$(STR$(WeekNumber%(VAL(Result$), VAL(Value$), VAL(Meaning$))))
     CASE "ISLEAPYEAR"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       IF (VAL(Result$) < 1980) OR (VAL(Result$) > 2099) THEN ERROR 85
       InMeaning$ = LTRIM$(STR$((INT(INT(VAL(Result$)) / 4) * 4) = INT(VAL(Result$))))
     CASE "MIN"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) < VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "MAX"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        IF VAL(Value$) > VAL(Result$) THEN Result$ = LTRIM$(STR$(VAL(Value$)))
       LOOP
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE "AVG"
       IF LEFT$(InLine$, 1) <> "(" THEN ERROR 2
       InLine$ = MID$(InLine$, 2)
       Result$ = Calculate$(InLine$)
       Index% = 1
       IF NumStr% THEN ERROR 13
       InLine$ = LTRIM$(InLine$)
       DO WHILE InLine$ <> ""
        SELECT CASE LEFT$(InLine$, 1)
        CASE ","
          InLine$ = MID$(InLine$, 2)
        CASE ")"
          InLine$ = MID$(InLine$, 2)
          EXIT DO
        CASE ELSE
          ERROR 2
        END SELECT
        Value$ = Calculate$(InLine$)
        IF NumStr% THEN ERROR 13
        InLine$ = LTRIM$(InLine$)
        Result$ = LTRIM$(STR$(VAL(Result$) + VAL(Value$)))
        Index% = Index% + 1
       LOOP
       Result$ = LTRIM$(STR$(VAL(Result$) / Index%))
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     CASE ELSE
       IF LEFT$(WorkName$, 2) = "FN" THEN Result$ = InDefFn$(WorkName$, False%, InLine$) ELSE Result$ = InVariable$(WorkName$, False%, InLine$)
       IF NumStr% THEN ERROR 13
       IF LEFT$(Result$, 1) = "." THEN Result$ = "0" + Result$
       InMeaning$ = Result$
     END SELECT
    END IF
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InName$ (InLine$)
 DIM OutName$
 InLine$ = LTRIM$(InLine$)
 OutName$ = ""
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "A" TO "Z"
    OutName$ = OutName$ + LEFT$(UCASE$(InLine$), 1)
    InLine$ = MID$(InLine$, 2)
  CASE "0" TO "9"
    OutName$ = OutName$ + LEFT$(InLine$, 1)
    InLine$ = MID$(InLine$, 2)
  CASE "_"
    OutName$ = OutName$ + "_"
    InLine$ = MID$(InLine$, 2)
  CASE "."
    OutName$ = OutName$ + "."
    InLine$ = MID$(InLine$, 2)
  CASE ELSE
    EXIT DO
  END SELECT
 LOOP
 IF OutName$ = "" THEN ERROR 2
 InName$ = OutName$
END FUNCTION

FUNCTION InNumber# (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 InLine$ = LTRIM$(InLine$)
 OutNumber$ = ""
 PointPresent% = False%
 SELECT CASE LEFT$(InLine$, 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&H" + OutNumber$)
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     InNumber# = VAL("&O" + OutNumber$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = MID$(InLine$, 2)
      IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) OR PointPresent% THEN ERROR 2
      PointPresent% = True%
      OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL(OutNumber$)
 CASE "."
   PointPresent% = True%
   InLine$ = LTRIM$(MID$(InLine$, 2))
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   InNumber# = VAL("0." + OutNumber$)
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION InVariable$ (VariableName$, VariableType%, InLine$)
 DIM Index%
 DIM LineNumber%
 DIM WorkLine$
 DIM Result$
 DIM SubType%
 DIM ArgType%
 IF DefFnMode% THEN
  IF DefFnSArgsCount%(CurrentDefFn%) = 0 THEN
   DefFnMode% = False%
   InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
   DefFnMode% = True%
  ELSE
   FOR Index% = 1 TO DefFnSArgsCount%(CurrentDefFn%) + 1
    IF Index% = DefFnSArgsCount%(CurrentDefFn%) + 1 THEN
     DefFnMode% = False%
     InVariable$ = InVariable$(VariableName$, VariableType%, InLine$)
     DefFnMode% = True%
     EXIT FOR
    END IF
    IF (MID$(DefFnSArgs$(CurrentDefFn%, Index%), 1, INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") - 1) = VariableName$) AND (VAL(MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(DefFnSArgs$(CurrentDefFn%, Index%), INSTR(DefFnSArgs$(CurrentDefFn%, Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 ELSE
  IF VariablesCount% = 0 THEN
   IF VariableType% THEN
    CALL SetVariable(VariableName$, VariableType%, "")
    InVariable$ = ""
   ELSE
    CALL SetVariable(VariableName$, VariableType%, "0")
    InVariable$ = "0"
   END IF
  ELSE
   FOR Index% = 1 TO VariablesCount% + 1
    IF Index% = VariablesCount% + 1 THEN
     IF VariableType% THEN
      CALL SetVariable(VariableName$, VariableType%, "")
      InVariable$ = ""
     ELSE
      CALL SetVariable(VariableName$, VariableType%, "0")
      InVariable$ = "0"
     END IF
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     InVariable$ = MID$(Variables$(Index%), INSTR(Variables$(Index%), "=") + 1)
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END FUNCTION

FUNCTION IsLeapYear% (YearValue%)
 IsLeapYear% = ABS((INT(YearValue% / 4) * 4) = YearValue%)
END FUNCTION

FUNCTION MonthDays% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDays% = 31
 CASE 2
   MonthDays% = 28 + IsLeapYear%(YearValue%)
 CASE 3
   MonthDays% = 31
 CASE 4
   MonthDays% = 30
 CASE 5
   MonthDays% = 31
 CASE 6
   MonthDays% = 30
 CASE 7
   MonthDays% = 31
 CASE 8
   MonthDays% = 31
 CASE 9
   MonthDays% = 30
 CASE 10
   MonthDays% = 31
 CASE 11
   MonthDays% = 30
 CASE 12
   MonthDays% = 31
 END SELECT
END FUNCTION

FUNCTION MonthDaysCount% (MonthValue%, YearValue%)
 SELECT CASE MonthValue%
 CASE 1
   MonthDaysCount% = 0
 CASE 2
   MonthDaysCount% = 31
 CASE 3
   MonthDaysCount% = 59 + IsLeapYear%(YearValue%)
 CASE 4
   MonthDaysCount% = 90 + IsLeapYear%(YearValue%)
 CASE 5
   MonthDaysCount% = 120 + IsLeapYear%(YearValue%)
 CASE 6
   MonthDaysCount% = 151 + IsLeapYear%(YearValue%)
 CASE 7
   MonthDaysCount% = 181 + IsLeapYear%(YearValue%)
 CASE 8
   MonthDaysCount% = 212 + IsLeapYear%(YearValue%)
 CASE 9
   MonthDaysCount% = 243 + IsLeapYear%(YearValue%)
 CASE 10
   MonthDaysCount% = 273 + IsLeapYear%(YearValue%)
 CASE 11
   MonthDaysCount% = 304 + IsLeapYear%(YearValue%)
 CASE 12
   MonthDaysCount% = 334 + IsLeapYear%(YearValue%)
 END SELECT
END FUNCTION

FUNCTION MonthName$ (MonthNumber%)
 SELECT CASE MonthNumber%
 CASE 1
   MonthName$ = "January"
 CASE 2
   MonthName$ = "February"
 CASE 3
   MonthName$ = "March"
 CASE 4
   MonthName$ = "April"
 CASE 5
   MonthName$ = "May"
 CASE 6
   MonthName$ = "June"
 CASE 7
   MonthName$ = "July"
 CASE 8
   MonthName$ = "August"
 CASE 9
   MonthName$ = "September"
 CASE 10
   MonthName$ = "October"
 CASE 11
   MonthName$ = "November"
 CASE 12
   MonthName$ = "December"
 END SELECT
END FUNCTION

SUB OutHelp
 DIM HelpText$(249)
 DIM Index%
 DIM LinesIndex%
 DIM WorkKey$
 HelpText$(1) = "System variables:"
 HelpText$(2) = "        RANDOM"
 HelpText$(3) = "        If get value, then return the random number. If set value,"
 HelpText$(4) = "        then reinitializing the random number generator."
 HelpText$(5) = "        TIMERVALUE"
 HelpText$(6) = "        This variable location on address: 0000:046C. This variable"
 HelpText$(7) = "        contain meaning of system timer."
 HelpText$(8) = "        DATE$"
 HelpText$(9) = "        This variable contain system date in the format: MM-DD-YYYY."
 HelpText$(10) = "        TIME$"
 HelpText$(11) = "        This variable contain system time in the format: HH:MM:SS."
 HelpText$(12) = "Constans:"
 HelpText$(13) = "        PI=3.1415926535897932385,BLACK=0,BLUE=1,GREEN=2,CYAN=3,RED=4,"
 HelpText$(14) = "        MAGENTA=5,BROWN=6,WHITE=7,GRAY=8,LIGHTBLUE=9,LIGHTGREEN=10,"
 HelpText$(15) = "        LIGHTCYAN=11,LIGHTRED=12,LIGHTMAGENTA=13,YELLOW=14,"
 HelpText$(16) = "        BRIGHTWHITE=15,TRUE=-1,FALSE=0"
 HelpText$(17) = "String functions:"
 HelpText$(18) = "        INKEY$"
 HelpText$(19) = "        If any numeric or alphabetical key is pressed, the return the"
 HelpText$(20) = "        one symbol, contain the input symbol. If not keys is pressed,"
 HelpText$(21) = "        then return the empty string. If pressed the special keys"
 HelpText$(22) = "        (like F1 - F10), then return two - symbols string: first"
 HelpText$(23) = "        symbol contain CHR$(0), and next (two) symbol contain symbol"
 HelpText$(24) = "        with code of pressed key."
 HelpText$(25) = "        INPUT$[(#FileNumber%)]"
 HelpText$(26) = "        Read line from file or keyboard. If parenthis and file number"
 HelpText$(27) = "        is not pointed, then return line, readed from keyboard, else"
 HelpText$(28) = "        is readed from the file."
 HelpText$(29) = "        CHR$(Code%)"
 HelpText$(30) = "        Symbol for code: Code%."
 HelpText$(31) = "        HEX$(Value&)"
 HelpText$(32) = "        Hexadecimal string type of number."
 HelpText$(33) = "        OCT$(Value&)"
 HelpText$(34) = "        Octal string type of number."
 HelpText$(35) = "        DAYNAME$(NumberOfDay%)"
 HelpText$(36) = "        Return name of days (1 - Monday, ... 7 - Sunday)."
 HelpText$(37) = "        MONTHNAME$(NumberOfMonth%)"
 HelpText$(38) = "        Return name of month (1 - January, ... 12 - December)."
 HelpText$(39) = "        SPACE$(Count%)"
 HelpText$(40) = "        Return the line of spaces."
 HelpText$(41) = "        STR$(Value#)"
 HelpText$(42) = "        Convert number to string."
 HelpText$(43) = "        LCASE$(Line$)"
 HelpText$(44) = "        Return line, converted to lower case."
 HelpText$(45) = "        UCASE$(Line$)"
 HelpText$(46) = "        Return line, converted to upper case."
 HelpText$(47) = "        LTRIM$(Line$)"
 HelpText$(48) = "        Return line without leading spaces."
 HelpText$(49) = "        RTRIM$(Line$)"
 HelpText$(50) = "        Return line without trailing spaces."
 HelpText$(51) = "        TRIM$(Line$)"
 HelpText$(52) = "        Return line without leading and trailing spaces."
 HelpText$(53) = "        LEFT$(Line$,Count%)"
 HelpText$(54) = "        Return Count% symbols from the start of line."
 HelpText$(55) = "        RIGHT$(Line$,Count%)"
 HelpText$(56) = "        Return Count% symbols from the end of string."
 HelpText$(57) = "        STRING$(Count%,Line$|Code%)"
 HelpText$(58) = "        Return Count% of Line$ or symbols for Code%."
 HelpText$(59) = "        MID$(Line$,Start%,Count%)"
 HelpText$(60) = "        Return line from Line$, started with Start% symbol, length"
 HelpText$(61) = "        of Count%."
 HelpText$(62) = "        DAYOFWEEKNAME$(Day%,Month%,Year%)"
 HelpText$(63) = "        Return day of week name."
 HelpText$(64) = "        ENVIRON$(NumberOfVariable%|VariableName$)"
 HelpText$(65) = "        Return value of environement variable."
 HelpText$(66) = "        MIN$(Line$[,Line$...])"
 HelpText$(67) = "        Return minimal string."
 HelpText$(68) = "        MAX$(Line$[,Line$...])"
 HelpText$(69) = "        Return maximal string."
 HelpText$(70) = "Numeric functions:"
 HelpText$(71) = "        CSRLIN"
 HelpText$(72) = "        Return value of row of current screen cursor position."
 HelpText$(73) = "        TIMER"
 HelpText$(74) = "        Return value of seconds from the start of day."
 HelpText$(75) = "        POS(AnyExpression)"
 HelpText$(76) = "        Return value of column of current screen cursor position."
 HelpText$(77) = "        SQR(Value#)"
 HelpText$(78) = "        Return square root of Value#."
 HelpText$(79) = "        ABS(Value#)"
 HelpText$(80) = "        Return absolute value of Value#."
 HelpText$(81) = "        ATN(Value#)"
 HelpText$(82) = "        Return arctangent of Value#."
 HelpText$(83) = "        COS(Value#)"
 HelpText$(84) = "        Return cosine of Value#."
 HelpText$(85) = "        EXP(Value#)"
 HelpText$(86) = "        Return exponent of Value#."
 HelpText$(87) = "        FIX(Value#)"
 HelpText$(88) = "        Returns a whole number, round before the nearest whole"
 HelpText$(89) = "        number."
 HelpText$(90) = "        INT(Value#)"
 HelpText$(91) = "        Return integer (whole) part of Value#."
 HelpText$(92) = "        LOG(Value#)"
 HelpText$(93) = "        Return logarifm of Value#."
 HelpText$(94) = "        SIN(Value#)"
 HelpText$(95) = "        Return sine of Value#."
 HelpText$(96) = "        TAN(Value#)"
 HelpText$(97) = "        Return tangent of Value#."
 HelpText$(98) = "        SGN(Value#)"
 HelpText$(99) = "        If whole part of value is 0, then return 0. If Value# is less"
 HelpText$(100) = "        than 0, then return -1. If value is greater than 0, return 1."
 HelpText$(101) = "        EOF(#FileNumber%)"
 HelpText$(102) = "        If end of file marker is present, return the True (-1), else"
 HelpText$(103) = "        return the False (0)."
 HelpText$(104) = "        LOF(#FileNumber%)"
 HelpText$(105) = "        Return length in bytes of file."
 HelpText$(106) = "        ASC(Line$)"
 HelpText$(107) = "        Return code of first symbol of string."
 HelpText$(108) = "        LEN(Line$)"
 HelpText$(109) = "        Return length of line."
 HelpText$(110) = "        CRC(Line$)"
 HelpText$(111) = "        Return CRC-32 code of line."
 HelpText$(112) = "        VAL(NumberLine$)"
 HelpText$(113) = "        Return numeric string, convert it to number."
 HelpText$(114) = "        INSTR(Line$,SubLine$)"
 HelpText$(115) = "        Return first position of SubLine$ in the Line$."
 HelpText$(116) = "        DAYOFWEEK(Day%,Month%,Year%)"
 HelpText$(117) = "        Return the day of week number (1 - Monday, ... 7 - Sunday)."
 HelpText$(118) = "        WEEKNUMBER(Day%,Month%,Year%)"
 HelpText$(119) = "        Return week number of start of the given year."
 HelpText$(120) = "        ISLEAPYEAR(Year%)"
 HelpText$(121) = "        If is leap year, then return True (-1), else return False"
 HelpText$(122) = "        (0)."
 HelpText$(123) = "        MIN(Value#[,Value#...])"
 HelpText$(124) = "        Return minimal value."
 HelpText$(125) = "        MAX(Value#[,Value#...])"
 HelpText$(126) = "        Return maximal value."
 HelpText$(127) = "        AVG(Value#[,Value#...])"
 HelpText$(128) = "        Return average value."
 HelpText$(129) = "Statements:"
 HelpText$(130) = "        BEEP"
 HelpText$(131) = "        Beeping the beep."
 HelpText$(132) = "        REM [Comment.]"
 HelpText$(133) = "        This statement can include your comment lines to program."
 HelpText$(134) = "        SYSTEM"
 HelpText$(135) = "        Quit from the interpretter."
 HelpText$(136) = "        CLS"
 HelpText$(137) = "        Clear the screen."
 HelpText$(138) = "        NEW"
 HelpText$(139) = "        Clear current program and reset interpretter."
 HelpText$(140) = "        REBOOT"
 HelpText$(141) = "        Reboot the computer."
 HelpText$(142) = "        HANG"
 HelpText$(143) = "        Hang the computer."
 HelpText$(144) = "        OPEN FileName$ FOR INPUT|OUTPUT|APPEND AS #FileNumber%"
 HelpText$(145) = "        Open file."
 HelpText$(146) = "        CLOSE #FileNumber%"
 HelpText$(147) = "        Close file."
 HelpText$(148) = "        PRINT [#FileNumber%,]Expression"
 HelpText$(149) = "        Out meaning to file of screen."
 HelpText$(150) = "        LET VariableName=Expression"
 HelpText$(151) = "        Set value for variable."
 HelpText$(152) = "        DEF FNNAME[(Argument[,Argument...])]=Expression"
 HelpText$(153) = "        Declare the user - defined function."
 HelpText$(154) = "        LOCATE Column%,Row%"
 HelpText$(155) = "        Change location of display cursor."
 HelpText$(156) = "        COLOR ForeGround% ON BackGround%"
 HelpText$(157) = "        Change current color of the screen."
 HelpText$(158) = "        SOUND Frequency&,Duration&"
 HelpText$(159) = "        Play a sound."
 HelpText$(160) = "        SLEEP Seconds#"
 HelpText$(161) = "        Stop program execution to Seconds# second. This value can be"
 HelpText$(162) = "        less than 1 (sample: 0.001 - the sleep to 1 milisecond)."
 HelpText$(163) = "        MKDIR DirectoryName$"
 HelpText$(164) = "        Create new directory."
 HelpText$(165) = "        CHDIR DirectoryName$"
 HelpText$(166) = "        Change current directory."
 HelpText$(167) = "        RMDIR DirectoryName$"
 HelpText$(168) = "        Remove directory."
 HelpText$(169) = "        KILL FileMask$"
 HelpText$(170) = "        Delete files."
 HelpText$(171) = "        FILES FileMask$"
 HelpText$(172) = "        Out to screen list of files. File mask can contain the path"
 HelpText$(173) = "        to files."
 HelpText$(174) = "        SHELL Command$"
 HelpText$(175) = "        Call command interpretter (Command.com) with command."
 HelpText$(176) = "        NAME OldFileOrDirectoryName$ AS NewFileOrDirectoryName$"
 HelpText$(177) = "        Rename file or directory."
 HelpText$(178) = "        SWAP Variable,Variable"
 HelpText$(179) = "        Swap values of variables."
 HelpText$(180) = "        GO TO|SUB LineNumber%"
 HelpText$(181) = "        Perform call GO TO or GO SUB statement."
 HelpText$(182) = "        RETURN"
 HelpText$(183) = "        Return from the GO SUB linear subroutine."
 HelpText$(184) = "        SCREEN FOURTY|EIGHTY|MONO|COLOR"
 HelpText$(185) = "        Change current screen mode. FOURTY - color, 40x25 mode;"
 HelpText$(186) = "        EIGHTY - color, 80x25 mode; MONO - monocrome, 80x25 mode;"
 HelpText$(187) = "        COLOR - color, 80x25 mode."
 HelpText$(188) = "        RUN"
 HelpText$(189) = "        Run current program."
 HelpText$(190) = "        TRON"
 HelpText$(191) = "        Turn trace mode to on."
 HelpText$(192) = "        TROFF"
 HelpText$(193) = "        Turn trace mode to off."
 HelpText$(194) = "        DEBUG ON|OFF"
 HelpText$(195) = "        Turn debug mode to on or off."
 HelpText$(196) = "        TRACE"
 HelpText$(197) = "        Tracing current program in the turned to on debug mode."
 HelpText$(198) = "        SAVE FileName$"
 HelpText$(199) = "        Save current program to file."
 HelpText$(200) = "        LOAD FileName$"
 HelpText$(201) = "        Load program from the file."
 HelpText$(202) = "        LIST [LineNumber%[,EndLineNumber%]]"
 HelpText$(203) = "        List to screen program lines."
 HelpText$(204) = "        DELETE LineNumber%[,EndLineNumber%]"
 HelpText$(205) = "        Delete line(s) from the current program."
 HelpText$(206) = "        END"
 HelpText$(207) = "        End of current program execution."
 HelpText$(208) = "        EXIT WHILE|FROM"
 HelpText$(209) = "        Perform exit from current repeat WHILE or FROM."
 HelpText$(210) = "        FROM Variable=StartValue TO EndValue [STEP=Value]"
 HelpText$(211) = "        NEXT Variable"
 HelpText$(212) = "        FROM (like FOR in other programming languages) repeat."
 HelpText$(213) = "        STEP value can be less than 0."
 HelpText$(214) = "        WHILE Conditional"
 HelpText$(215) = "        WEND"
 HelpText$(216) = "        The WHILE repeat."
 HelpText$(217) = "        IF Conditional THEN Statement [ELSE Statement]"
 HelpText$(218) = "        The standart IF conditional operator."
 HelpText$(219) = "Operators:"
 HelpText$(220) = "        Value[!|@|#|$|%|&]      +          Value[!|@|#|$|%|&]"
 HelpText$(221) = "        Value[!|@|#|%|&]        -          Value[!|@|#|%|&]"
 HelpText$(222) = "        Value[!|@|#|%|&]        \          Value[!|@|#|%|&]"
 HelpText$(223) = "        Value[!|@|#|%|&]        /          Value[!|@|#|%|&]"
 HelpText$(224) = "        Value[!|@|#|%|&]        *          Value[!|@|#|%|&]"
 HelpText$(225) = "        Value[!|@|#|%|&]        ^          Value[!|@|#|%|&]"
 HelpText$(226) = "        Value[!|@|#|$|%|&]      =          Value[!|@|#|$|%|&]"
 HelpText$(227) = "        Value[!|@|#|$|%|&]      <          Value[!|@|#|$|%|&]"
 HelpText$(228) = "        Value[!|@|#|$|%|&]      >          Value[!|@|#|$|%|&]"
 HelpText$(229) = "        Value[!|@|#|$|%|&]      <=         Value[!|@|#|$|%|&]"
 HelpText$(230) = "        Value[!|@|#|$|%|&]      =>         Value[!|@|#|$|%|&]"
 HelpText$(231) = "        Value[!|@|#|$|%|&]      =<         Value[!|@|#|$|%|&]"
 HelpText$(232) = "        Value[!|@|#|$|%|&]      >=         Value[!|@|#|$|%|&]"
 HelpText$(233) = "        Value[!|@|#|$|%|&]      <>         Value[!|@|#|$|%|&]"
 HelpText$(234) = "        Value[!|@|#|$|%|&]      ><         Value[!|@|#|$|%|&]"
 HelpText$(235) = "        Value[!|@|#|%|&]        AND        Value[!|@|#|%|&]"
 HelpText$(236) = "        Value[!|@|#|%|&]        OR         Value[!|@|#|%|&]"
 HelpText$(237) = "        Value[!|@|#|%|&]        XOR        Value[!|@|#|%|&]"
 HelpText$(238) = "        Value[!|@|#|%|&]        MOD        Value[!|@|#|%|&]"
 HelpText$(239) = "                                NOT        Value[!|@|#|%|&]"
 HelpText$(240) = "Settings:"
 HelpText$(241) = "        Size of BASIC lines area - 64 lines."
 HelpText$(242) = "        Maximal count of user - defined funtions - 4."
 HelpText$(243) = "        Maximal count of arguments for user - defined functions - 4."
 HelpText$(244) = "        Maximal count of variables - 8."
 HelpText$(245) = "        Maximal count of GO SUB subroutines - 4."
 HelpText$(246) = "        Maximal count of files - 4."
 HelpText$(247) = "        Maximal count of parameters for ANSI escape sequences - 4."
 HelpText$(248) = "        Maximal count of WHILE's - 4."
 HelpText$(249) = "        Maximal count of FROM's - 4."
 LinesIndex% = 1
 FOR Index% = 1 TO 249
  PRINT HelpText$(Index%)
  LinesIndex% = LinesIndex% + 1
  IF LinesIndex% = 24 THEN
   LinesIndex% = 1
   PRINT "Please press the ENTER key to continue or ESC key to cancel.";
   WorkKey$ = CHR$(0)
   WHILE (WorkKey$ <> CHR$(13)) AND (WorkKey$ <> CHR$(27))
    WorkKey$ = INKEY$
   WEND
   IF WorkKey$ = CHR$(27) THEN EXIT FOR
  END IF
 NEXT Index%
END SUB

FUNCTION ParseCalculate$ (InLine$)
 DIM Result$
 DIM Value$
 DIM SavedLine$
 Result$ = ParseInMeaning$(InLine$)
 InLine$ = LTRIM$(InLine$)
 DO WHILE InLine$ <> ""
  SELECT CASE LEFT$(UCASE$(InLine$), 1)
  CASE "+"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "+" + ParseInMeaning$(InLine$)
  CASE "-"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "-" + ParseInMeaning$(InLine$)
  CASE "/"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "\"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "/" + ParseInMeaning$(InLine$)
  CASE "*"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "*" + ParseInMeaning$(InLine$)
  CASE "^"
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + "^" + ParseInMeaning$(InLine$)
  CASE "="
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "=" + ParseInMeaning$(InLine$)
    END SELECT
  CASE "<"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE ">"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<=" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + "<" + ParseInMeaning$(InLine$)
    END SELECT
  CASE ">"
    InLine$ = LTRIM$(MID$(InLine$, 2))
    SELECT CASE LEFT$(InLine$, 1)
    CASE "<"
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "<>" + ParseInMeaning$(InLine$)
    CASE "="
      InLine$ = MID$(InLine$, 2)
      Result$ = Result$ + "=>" + ParseInMeaning$(InLine$)
    CASE ELSE
      Result$ = Result$ + ">" + ParseInMeaning$(InLine$)
    END SELECT
    NumStr% = False%
  CASE "A" TO "Z"
    SavedLine$ = InLine$
    SELECT CASE InName$(InLine$)
    CASE "AND"
      Result$ = Result$ + " And " + ParseInMeaning$(InLine$)
    CASE "OR"
      Result$ = Result$ + " Or " + ParseInMeaning$(InLine$)
    CASE "XOR"
      Result$ = Result$ + " XOr " + ParseInMeaning$(InLine$)
    CASE "MOD"
      Result$ = Result$ + " Mod " + ParseInMeaning$(InLine$)
    CASE ELSE
      InLine$ = SavedLine$
      EXIT DO
    END SELECT
  CASE ELSE
    EXIT DO
  END SELECT
  InLine$ = LTRIM$(InLine$)
 LOOP
 ParseCalculate$ = Result$
END FUNCTION

FUNCTION ParseInMeaning$ (InLine$)
 DIM Result$
 DIM WorkName$
 InLine$ = LTRIM$(InLine$)
 SELECT CASE LEFT$(UCASE$(InLine$), 1)
 CASE "+"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = ParseCalculate$(InLine$)
 CASE "-"
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "-" + ParseCalculate$(InLine$)
 CASE "0" TO "9"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "."
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE "&"
   ParseInMeaning$ = ParseInNumber$(InLine$)
 CASE CHR$(34)
   InLine$ = MID$(InLine$, 2)
   IF INSTR(InLine$, CHR$(34)) = 0 THEN ERROR 2
   ParseInMeaning$ = CHR$(34) + MID$(InLine$, 1, INSTR(InLine$, CHR$(34)) - 1) + CHR$(34)
   InLine$ = MID$(InLine$, INSTR(InLine$, CHR$(34)) + 1)
 CASE "("
   InLine$ = MID$(InLine$, 2)
   ParseInMeaning$ = "(" + ParseCalculate$(InLine$) + ")"
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
 CASE "A" TO "Z"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF WorkName$ = "NOT" THEN
    ParseInMeaning$ = "Not " + ParseCalculate$(InLine$)
   ELSE
    Result$ = UCASE$(LEFT$(WorkName$, 1)) + LCASE$(MID$(WorkName$, 2)) + Result$
    IF LEFT$(InLine$, 1) = "(" THEN
     Result$ = Result$ + "("
     InLine$ = LTRIM$(MID$(InLine$, 2))
     IF LEFT$(InLine$, 1) = "#" THEN
      Result$ = Result$ + "#"
      InLine$ = LTRIM$(MID$(InLine$, 2))
     END IF
     DO WHILE InLine$ <> ""
      Result$ = Result$ + ParseCalculate$(InLine$)
      InLine$ = LTRIM$(InLine$)
      SELECT CASE LEFT$(InLine$, 1)
      CASE ","
        Result$ = Result$ + ","
        InLine$ = MID$(InLine$, 2)
      CASE ")"
        EXIT DO
      CASE ELSE
        ERROR 2
      END SELECT
     LOOP
     IF LEFT$(InLine$, 1) <> ")" THEN ERROR 2
     Result$ = Result$ + ")"
     InLine$ = MID$(InLine$, 2)
    END IF
    ParseInMeaning$ = Result$
   END IF
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseInNumber$ (InLine$)
 DIM OutNumber$
 DIM PointPresent%
 InLine$ = LTRIM$(InLine$)
 OutNumber$ = ""
 PointPresent% = False%
 SELECT CASE LEFT$(InLine$, 1)
 CASE "&"
   InLine$ = LTRIM$(MID$(InLine$, 2))
   SELECT CASE LEFT$(UCASE$(InLine$), 1)
   CASE "H"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "9"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "A" TO "F"
        OutNumber$ = OutNumber$ + LEFT$(UCASE$(InLine$), 1)
        InLine$ = MID$(InLine$, 2)
      CASE "G" TO "Z"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR ((NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) AND (NOT ((ASC(UCASE$(InLine$)) > (ASC("A") - 1)) AND (ASC(UCASE$(InLine$)) < (ASC("F") + 1))))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&H" + OutNumber$
   CASE "O"
     InLine$ = LTRIM$(MID$(InLine$, 2))
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE "0" TO "7"
     DO WHILE InLine$ <> ""
      SELECT CASE LEFT$(UCASE$(InLine$), 1)
      CASE "0" TO "7"
        OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
        InLine$ = MID$(InLine$, 2)
      CASE "8" TO "9"
        ERROR 2
      CASE "."
        InLine$ = MID$(InLine$, 2)
        IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("7") + 1)))) OR PointPresent% THEN ERROR 2
        PointPresent% = True%
        OutNumber$ = OutNumber$ + "."
      CASE ELSE
        EXIT DO
      END SELECT
     LOOP
     IF OutNumber$ = "" THEN ERROR 2
     ParseInNumber$ = "&O" + OutNumber$
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "0" TO "9"
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      InLine$ = MID$(InLine$, 2)
      IF (OutNumber$ = "") OR (NOT ((ASC(InLine$) > (ASC("0") - 1)) AND (ASC(InLine$) < (ASC("9") + 1)))) OR PointPresent% THEN ERROR 2
      PointPresent% = True%
      OutNumber$ = OutNumber$ + "."
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = OutNumber$
 CASE "."
   PointPresent% = True%
   InLine$ = LTRIM$(MID$(InLine$, 2))
   DO WHILE InLine$ <> ""
    SELECT CASE LEFT$(UCASE$(InLine$), 1)
    CASE "0" TO "9"
      OutNumber$ = OutNumber$ + LEFT$(InLine$, 1)
      InLine$ = MID$(InLine$, 2)
    CASE "."
      ERROR 2
    CASE ELSE
      EXIT DO
    END SELECT
   LOOP
   IF OutNumber$ = "" THEN ERROR 2
   ParseInNumber$ = "0." + OutNumber$
 CASE ELSE
   ERROR 2
 END SELECT
END FUNCTION

FUNCTION ParseRunLine$ (InLine$)
 DIM WorkName$
 DIM WorkLine$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Value%
 DIM Number%
 DIM Index%
 DIM LineNumber%
 WorkName$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE WorkName$
 CASE "HELP"
   ParseRunLine$ = "Help"
 CASE "REBOOT"
   ParseRunLine$ = "Reboot"
 CASE "HANG"
   ParseRunLine$ = "Hang"
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "REM"
   IF InLine$ <> "" THEN ParseRunLine$ = "Rem " + InLine$ ELSE ParseRunLine$ = "Rem"
 CASE "SYSTEM"
   ParseRunLine$ = "System"
 CASE "CLS"
   ParseRunLine$ = "Cls"
 CASE "BEEP"
   ParseRunLine$ = "Beep"
 CASE "NEW"
   ParseRunLine$ = "New"
 CASE "OPEN"
   Result$ = ParseCalculate$(InLine$) + " For "
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = Result$ + "InPut"
   CASE "OUTPUT"
     Result$ = Result$ + "OutPut"
   CASE "APPEND"
     Result$ = Result$ + "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Open " + Result$ + " As #" + ParseCalculate$(InLine$)
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Close #" + ParseCalculate$(InLine$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Print #" + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Print " + ParseCalculate$(InLine$)
   END IF
 CASE "LET"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Let " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "DEF"
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 2
   Result$ = UCASE$(LEFT$(Result$, 3)) + LCASE$(MID$(Result$, 4))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
     Result$ = Result$ + Value$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       Result$ = Result$ + "$"
       InLine$ = MID$(InLine$, 2)
     CASE "!"
       InLine$ = MID$(InLine$, 2)
     CASE "@"
       InLine$ = MID$(InLine$, 2)
     CASE "#"
       InLine$ = MID$(InLine$, 2)
     CASE "%"
       InLine$ = MID$(InLine$, 2)
     CASE "&"
       InLine$ = MID$(InLine$, 2)
     END SELECT
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Def " + Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Locate " + Result$ + "," + ParseCalculate$(InLine$)
 CASE "COLOR"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   ParseRunLine$ = "Color " + Result$ + " On " + ParseCalculate$(InLine$)
 CASE "SOUND"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   ParseRunLine$ = "Sound " + Result$ + "," + ParseCalculate$(InLine$)
 CASE "SLEEP"
   ParseRunLine$ = "Sleep " + ParseCalculate$(InLine$)
 CASE "MKDIR"
   ParseRunLine$ = "MkDir " + ParseCalculate$(InLine$)
 CASE "CHDIR"
   ParseRunLine$ = "ChDir " + ParseCalculate$(InLine$)
 CASE "RMDIR"
   ParseRunLine$ = "RmDir " + ParseCalculate$(InLine$)
 CASE "KILL"
   ParseRunLine$ = "Kill " + ParseCalculate$(InLine$)
 CASE "FILES"
   ParseRunLine$ = "Files " + ParseCalculate$(InLine$)
 CASE "SHELL"
   ParseRunLine$ = "Shell " + ParseCalculate$(InLine$)
 CASE "NAME"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   ParseRunLine$ = "Name " + Result$ + " As " + ParseCalculate$(InLine$)
 CASE "SWAP"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = InName$(InLine$)
   Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
   Result$ = Result$ + "," + Value$
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   ParseRunLine$ = "Swap " + Result$
 CASE "GO"
   SELECT CASE InName$(InLine$)
   CASE "TO"
     ParseRunLine$ = "Go To " + ParseCalculate$(InLine$)
   CASE "SUB"
     ParseRunLine$ = "Go Sub " + ParseCalculate$(InLine$)
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RETURN"
   ParseRunLine$ = "Return"
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     ParseRunLine$ = "Screen Fourty"
   CASE "EIGHTY"
     ParseRunLine$ = "Screen Eighty"
   CASE "MONO"
     ParseRunLine$ = "Screen Mono"
   CASE "COLOR"
     ParseRunLine$ = "Screen Color"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RUN"
   ParseRunLine$ = "Run"
 CASE "TRON"
   ParseRunLine$ = "TrOn"
 CASE "TROFF"
   ParseRunLine$ = "TrOff"
 CASE "DEBUG"
   SELECT CASE InName$(InLine$)
   CASE "ON"
     ParseRunLine$ = "Debug On"
   CASE "OFF"
     ParseRunLine$ = "Debug Off"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "TRACE"
   ParseRunLine$ = "Trace"
 CASE "SAVE"
   ParseRunLine$ = "Save " + ParseCalculate$(InLine$)
 CASE "LOAD"
   ParseRunLine$ = "Load " + ParseCalculate$(InLine$)
 CASE "LIST"
   IF InLine$ <> "" THEN
    Result$ = ParseCalculate$(InLine$)
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) = "," THEN
     InLine$ = MID$(InLine$, 2)
     ParseRunLine$ = "List " + Result$ + "," + ParseCalculate$(InLine$)
    ELSE
     ParseRunLine$ = "List " + Result$
    END IF
   ELSE
    ParseRunLine$ = "List"
   END IF
 CASE "DELETE"
   Result$ = ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "," THEN
    InLine$ = MID$(InLine$, 2)
    ParseRunLine$ = "Delete " + Result$ + "," + ParseCalculate$(InLine$)
   ELSE
    ParseRunLine$ = "Delete " + Result$
   END IF
 CASE "END"
   ParseRunLine$ = "End"
 CASE "EXIT"
   SELECT CASE InName$(InLine$)
   CASE "FROM"
     ParseRunLine$ = "Exit From"
   CASE "WHILE"
     ParseRunLine$ = "Exit While"
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "FROM"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Result$ + "=" + ParseCalculate$(InLine$) + " To "
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Result$ = Result$ + ParseCalculate$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Result$ = Result$ + " Step=" + ParseCalculate$(InLine$)
   END IF
   ParseRunLine$ = "From " + Result$
 CASE "NEXT"
   Result$ = InName$(InLine$)
   Result$ = UCASE$(LEFT$(Result$, 1)) + LCASE$(MID$(Result$, 2))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   ParseRunLine$ = "Next " + Result$
 CASE "WHILE"
   ParseRunLine$ = "While " + ParseCalculate$(InLine$)
 CASE "WEND"
   ParseRunLine$ = "WEnd"
 CASE "IF"
   Result$ = ParseCalculate$(InLine$)
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   Result$ = Result$ + " Then " + ParseRunLine$(InLine$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "ELSE" THEN ERROR 2
    Result$ = Result$ + " Else " + ParseRunLine$(InLine$)
   END IF
   ParseRunLine$ = "If " + Result$
 CASE ELSE
   ERROR 34
 END SELECT
END FUNCTION

SUB Restart
 DEF SEG = &HF000
 CALL Absolute(&HFFF0)
END SUB

SUB RunLine (InLine$)
 DIM WorkName$
 DIM WorkLine$
 DIM Result$
 DIM Value$
 DIM Meaning$
 DIM Value%
 DIM Number%
 DIM Index%
 DIM LineNumber%
 DIM SubIndex%
 DIM IfElse%
 DIM WhileCount%
 DIM FromCount%
 DIM StartLine%
 DIM EndLine%
 DIM Conditional$
 DIM FromVariableName$
 DIM StartValue#
 DIM EndValue#
 DIM FromStep#
 WorkName$ = InName$(InLine$)
 InLine$ = LTRIM$(InLine$)
 SELECT CASE WorkName$
 CASE "HELP"
   CALL OutHelp
 CASE "BEEP"
   BEEP
 CASE "REM"
   EXIT SUB
 CASE "SYSTEM"
   SYSTEM
 CASE "CLS"
   CLS
 CASE "NEW"
   CALL ClearAll(True%)
 CASE "REBOOT"
   CALL Restart
 CASE "HANG"
   CALL Hang
 CASE "OPEN"
   WorkName$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "FOR" THEN ERROR 2
   SELECT CASE InName$(InLine$)
   CASE "INPUT"
     Result$ = "InPut"
   CASE "OUTPUT"
     Result$ = "OutPut"
   CASE "APPEND"
     Result$ = "Append"
   CASE ELSE
     ERROR 2
   END SELECT
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (VAL(Value$) < 1) OR (VAL(Value$) > FilesCountValue%) THEN ERROR 52
   IF BASICFiles$(VAL(Value$)) <> "" THEN ERROR 55
   SELECT CASE Result$
   CASE "InPut"
     OPEN WorkName$ FOR INPUT AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "IN=" + WorkName$
   CASE "OutPut"
     OPEN WorkName$ FOR OUTPUT AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "OUT=" + WorkName$
   CASE "Append"
     OPEN WorkName$ FOR APPEND AS #VAL(Value$)
     BASICFiles$(VAL(Value$)) = "OUT=" + WorkName$
   END SELECT
 CASE "CLOSE"
   IF LEFT$(InLine$, 1) <> "#" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
   IF BASICFiles$(VAL(Result$)) = "" THEN ERROR 36
   BASICFiles$(VAL(Result$)) = ""
   CLOSE #VAL(Result$)
 CASE "PRINT"
   IF LEFT$(InLine$, 1) = "#" THEN
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    IF (VAL(Result$) < 1) OR (VAL(Result$) > FilesCountValue%) THEN ERROR 52
    IF LEFT$(BASICFiles$(VAL(Result$)), 4) <> "OUT=" THEN ERROR 54
    PRINT #VAL(Result$), Calculate$(InLine$)
   ELSE
    CALL WriteLineOut(Calculate$(InLine$))
   END IF
 CASE "LET"
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Value% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Value% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% <> Value% THEN ERROR 13
   CALL SetVariable(WorkName$, Value%, Result$)
 CASE "DEF"
   IF DefFnSCount% = DefFnSCountValue% THEN ERROR 39
   DefFnSCount% = DefFnSCount% + 1
   Result$ = InName$(InLine$)
   IF LEFT$(Result$, 2) <> "FN" THEN ERROR 2
   Result$ = UCASE$(LEFT$(Result$, 3)) + LCASE$(MID$(Result$, 4))
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Result$ = Result$ + "$"
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "(" THEN
    Result$ = Result$ + "("
    InLine$ = LTRIM$(MID$(InLine$, 2))
    DO WHILE InLine$ <> ""
     Value$ = InName$(InLine$)
     Value$ = UCASE$(LEFT$(Value$, 1)) + LCASE$(MID$(Value$, 2))
     Result$ = Result$ + Value$
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE "$"
       Result$ = Result$ + "$"
       InLine$ = MID$(InLine$, 2)
     CASE "!"
       InLine$ = MID$(InLine$, 2)
     CASE "@"
       InLine$ = MID$(InLine$, 2)
     CASE "#"
       InLine$ = MID$(InLine$, 2)
     CASE "%"
       InLine$ = MID$(InLine$, 2)
     CASE "&"
       InLine$ = MID$(InLine$, 2)
     END SELECT
     InLine$ = LTRIM$(InLine$)
     SELECT CASE LEFT$(InLine$, 1)
     CASE ","
       Result$ = Result$ + ","
       InLine$ = MID$(InLine$, 2)
     CASE ")"
       Result$ = Result$ + ")"
       InLine$ = LTRIM$(MID$(InLine$, 2))
       EXIT DO
     CASE ELSE
       ERROR 2
     END SELECT
    LOOP
   END IF
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   DefFnS$(DefFnSCount%) = Result$ + "=" + ParseCalculate$(InLine$)
 CASE "LOCATE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   LOCATE VAL(Value$), VAL(Result$)
 CASE "COLOR"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "ON" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   COLOR VAL(Result$), VAL(Value$)
 CASE "SOUND"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SOUND VAL(Result$), VAL(Value$)
 CASE "SLEEP"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   SLEEP VAL(Result$)
 CASE "MKDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   MKDIR Result$
 CASE "CHDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   CHDIR Result$
 CASE "RMDIR"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   RMDIR Result$
 CASE "KILL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   KILL Result$
 CASE "FILES"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   FILES Result$
 CASE "SHELL"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   SHELL Result$
 CASE "NAME"
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "AS" THEN ERROR 2
   Value$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   NAME Result$ AS Value$
 CASE "SWAP"
   Result$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Value% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Value% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "," THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Value$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   Number% = False%
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     Number% = True%
     InLine$ = MID$(InLine$, 2)
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   IF Value% <> Number% THEN ERROR 13
   Meaning$ = InVariable$(Result$, Value%, InLine$)
   CALL SetVariable(Result$, Value%, InVariable$(Value$, Value%, InLine$))
   CALL SetVariable(Value$, Value%, Meaning$)
 CASE "GO"
   IF NOT RunMode% THEN ERROR 42
   SELECT CASE InName$(InLine$)
   CASE "TO"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     CurrentLine% = FindLine%(VAL(Result$)) - 1
   CASE "SUB"
     Result$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     IF GoSubSCount% = GoSubSCountValue% THEN ERROR 44
     GoSubSCount% = GoSubSCount% + 1
     GoSubS%(GoSubSCount%) = CurrentLine%
     CurrentLine% = FindLine%(VAL(Result$)) - 1
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RETURN"
   IF NOT RunMode% THEN ERROR 42
   IF GoSubSCount% = 0 THEN ERROR 3
   CurrentLine% = GoSubS%(GoSubSCount%) - 1
   GoSubS%(GoSubSCount%) = 0
   GoSubSCount% = GoSubSCount% - 1
 CASE "SCREEN"
   SELECT CASE InName$(InLine$)
   CASE "FOURTY"
     SCREEN 0, , 0, 0
     WIDTH 40
   CASE "EIGHTY"
     SCREEN 0, , 0, 0
     WIDTH 80
   CASE "MONO"
     SCREEN 0, 0, 0, 0
   CASE "COLOR"
     SCREEN 0, 1, 0, 0
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "RUN"
   IF RunMode% THEN ERROR 45
   IF BASICLinesCount% = 0 THEN ERROR 65
   RunMode% = True%
   CurrentLine% = 1
   DO
    IF TraceMode% THEN PRINT "[" + LTRIM$(STR$(VAL(MID$(BASICLines$(CurrentLine%), 1, INSTR(BASICLines$(CurrentLine%), "=") - 1)))) + "]";
    WorkLine$ = MID$(BASICLines$(CurrentLine%), INSTR(BASICLines$(CurrentLine%), "=") + 1)
    WorkLine$ = ParseRunLine$(WorkLine$)
    CALL RunLine(WorkLine$)
    CurrentLine% = CurrentLine% + 1
   LOOP UNTIL (CurrentLine% > BASICLinesCount%) OR (NOT RunMode%)
   RunMode% = False%
   CurrentLine% = 0
 CASE "TRON"
   IF TraceMode% THEN ERROR 41
   TraceMode% = True%
   PRINT "Trace mode is On."
 CASE "TROFF"
   IF NOT TraceMode% THEN ERROR 47
   TraceMode% = False%
   PRINT "Trace mode is Off."
 CASE "DEBUG"
   IF RunMode% THEN ERROR 49
   SELECT CASE InName$(InLine$)
   CASE "ON"
     IF DebugMode% THEN ERROR 60
     IF BASICLinesCount% = 0 THEN ERROR 66
     DebugMode% = True%
     RunMode% = True%
     CurrentLine% = 1
     PRINT "Debug mode is turned to On."
   CASE "OFF"
     IF NOT DebugMode% THEN ERROR 78
     DebugMode% = False%
     RunMode% = False%
     CurrentLine% = 0
     PRINT "Debug mode is turned to Off."
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "TRACE"
   IF NOT DebugMode% THEN ERROR 77
   DO
    PRINT "Line number: " + LTRIM$(STR$(VAL(MID$(BASICLines$(CurrentLine%), 1, INSTR(BASICLines$(CurrentLine%), "=") - 1)))) + "."
    PRINT "Line={" + MID$(BASICLines$(CurrentLine%), INSTR(BASICLines$(CurrentLine%), "=") + 1) + "}."
    PRINT "Run this line (Yes/No)?"
    LINE INPUT WorkLine$
    WorkLine$ = LTRIM$(RTRIM$(UCASE$(WorkLine$)))
   LOOP UNTIL (WorkLine$ = "YES") OR (WorkLine$ = "NO")
   IF WorkLine$ = "YES" THEN
    WorkLine$ = MID$(BASICLines$(CurrentLine%), INSTR(BASICLines$(CurrentLine%), "=") + 1)
    WorkLine$ = ParseRunLine$(WorkLine$)
    CALL RunLine(WorkLine$)
   END IF
   CurrentLine% = CurrentLine% + 1
   IF (CurrentLine% > BASICLinesCount%) OR (NOT RunMode%) OR (NOT DebugMode%) THEN
    DebugMode% = False%
    RunMode% = False%
    CurrentLine% = 0
    PRINT "Debug session is succefully ended."
   END IF
 CASE "SAVE"
   IF BASICLinesCount% = 0 THEN ERROR 46
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   OPEN Result$ FOR OUTPUT AS #(FilesCountValue% + 1)
   FOR Index% = 1 TO BASICLinesCount%
    PRINT #(FilesCountValue% + 1), SPACE$(LEN(LTRIM$(STR$(BASICLinesCountValue%))) - LEN(LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))))) + LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))) + SPACE$(1) + MID$(BASICLines$(Index%), INSTR(BASICLines$(Index%), "=") + 1)
   NEXT Index%
   CLOSE #(FilesCountValue% + 1)
 CASE "LOAD"
   CALL ClearAll(True%)
   Result$ = Calculate$(InLine$)
   IF NOT NumStr% THEN ERROR 13
   OPEN Result$ FOR INPUT AS #(FilesCountValue% + 1)
   Index% = 1
   DO WHILE NOT EOF(FilesCountValue% + 1)
    LINE INPUT #(FilesCountValue% + 1), WorkLine$
    LineNumber% = InNumber#(WorkLine$)
    IF (LineNumber% < 1) OR (LineNumber% > BASICLinesCountValue%) THEN ERROR 15
    WorkLine$ = LTRIM$(WorkLine$)
    SELECT CASE LEFT$(UCASE$(WorkLine$), 1)
    CASE "A" TO "Z"
      WorkLine$ = ParseRunLine$(WorkLine$)
      IF BASICLinesCount% = 0 THEN
       BASICLinesCount% = BASICLinesCount% + 1
       BASICLines$(BASICLinesCount%) = LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
      ELSE
       FOR Index% = 1 TO BASICLinesCount% + 1
        IF Index% = BASICLinesCount% + 1 THEN
         IF BASICLinesCount% = BASICLinesCountValue% THEN ERROR 21
         BASICLinesCount% = BASICLinesCount% + 1
         BASICLines$(BASICLinesCount%) = LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
         CALL SortLines
         EXIT FOR
        END IF
        IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) = LineNumber% THEN
         BASICLines$(Index%) = LTRIM$(STR$(LineNumber%)) + "=" + WorkLine$
         EXIT FOR
        END IF
       NEXT Index%
      END IF
    CASE ELSE
      ERROR 2
    END SELECT
    IF Index% = BASICLinesCountValue% THEN ERROR 48
    Index% = Index% + 1
   LOOP
   CLOSE #(FilesCountValue% + 1)
 CASE "LIST"
   IF InLine$ <> "" THEN
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    Value% = FindLine%(VAL(Result$))
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) = "," THEN
     InLine$ = MID$(InLine$, 2)
     Value$ = Calculate$(InLine$)
     IF NumStr% THEN ERROR 13
     Number% = FindLine%(VAL(Value$))
     IF Number% < Value% THEN ERROR 79
     FOR Index% = Value% TO Number%
      PRINT SPACE$(LEN(LTRIM$(STR$(BASICLinesCountValue%))) - LEN(LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))))) + LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))) + SPACE$(1) + MID$(BASICLines$(Index%), INSTR(BASICLines$(Index%), "=") + 1)
     NEXT Index%
    ELSE
     PRINT SPACE$(LEN(LTRIM$(STR$(BASICLinesCountValue%))) - LEN(LTRIM$(STR$(VAL(MID$(BASICLines$(Value%), 1, INSTR(BASICLines$(Value%), "=") - 1)))))) + LTRIM$(STR$(VAL(MID$(BASICLines$(Value%), 1, INSTR(BASICLines$(Value%), "=") - 1)))) + SPACE$(1) + MID$(BASICLines$(Value%), INSTR(BASICLines$(Value%), "=") + 1)
    END IF
   ELSE
    FOR Index% = 1 TO BASICLinesCount%
     PRINT SPACE$(LEN(LTRIM$(STR$(BASICLinesCountValue%))) - LEN(LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))))) + LTRIM$(STR$(VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)))) + SPACE$(1) + MID$(BASICLines$(Index%), INSTR(BASICLines$(Index%), "=") + 1)
    NEXT Index%
   END IF
 CASE "DELETE"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) = "," THEN
    InLine$ = MID$(InLine$, 2)
    Value$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    IF VAL(Value$) < VAL(Result$) THEN ERROR 79
    FOR Index% = VAL(Result$) TO VAL(Value$)
     CALL DeleteLine(Index%)
    NEXT Index%
   ELSE
    CALL DeleteLine(VAL(Result$))
   END IF
 CASE "END"
   IF NOT RunMode% THEN ERROR 80
   RunMode% = False%
   CurrentLine% = 0
 CASE "EXIT"
   IF NOT RunMode% THEN ERROR 42
   SELECT CASE InName$(InLine$)
   CASE "WHILE"
     FOR Index% = 1 TO WhilesCountValue% + 1
      IF Index% = WhilesCountValue% + 1 THEN ERROR 82
      IF Whiles$(Index%) = "" THEN
       WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF EndLine% = CurrentLine% THEN EXIT FOR
      END IF
     NEXT Index%
     IF (CurrentLine% > (StartLine% - 1)) AND (CurrentLine% < (EndLine% + 1)) THEN
      Whiles$(Index%) = ""
      CurrentLine% = EndLine%
     END IF
   CASE "FROM"
     FOR Index% = 1 TO FromsCountValue% + 1
      IF Index% = FromsCountValue% + 1 THEN ERROR 84
      IF Froms$(Index%) <> "" THEN
       WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
       StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       FromStep# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
       WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
       FromVariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
       IF EndLine% = CurrentLine% THEN EXIT FOR
      END IF
     NEXT Index%
     IF (CurrentLine% > (StartLine% - 1)) AND (CurrentLine% < (EndLine% + 1)) THEN
      Froms$(Index%) = ""
      CurrentLine% = EndLine%
     END IF
   CASE ELSE
     ERROR 2
   END SELECT
 CASE "FROM"
   IF NOT RunMode% THEN ERROR 42
   FromVariableName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   InLine$ = LTRIM$(InLine$)
   IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
   InLine$ = MID$(InLine$, 2)
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   StartValue# = VAL(Result$)
   IF InName$(InLine$) <> "TO" THEN ERROR 2
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   EndValue# = VAL(Result$)
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "STEP" THEN ERROR 2
    InLine$ = LTRIM$(InLine$)
    IF LEFT$(InLine$, 1) <> "=" THEN ERROR 2
    InLine$ = MID$(InLine$, 2)
    Result$ = Calculate$(InLine$)
    IF NumStr% THEN ERROR 13
    FromStep# = VAL(Result$)
   ELSE
    FromStep# = 1#
   END IF
   FromCount% = 0
   IF CurrentLine% = BASICLinesCount% THEN ERROR 26
   FOR LineNumber% = CurrentLine% + 1 TO BASICLinesCount% + 1
    IF LineNumber% = BASICLinesCount% + 1 THEN ERROR 26
    WorkLine$ = MID$(BASICLines$(LineNumber%), INSTR(BASICLines$(LineNumber%), "=") + 1)
    SELECT CASE InName$(WorkLine$)
    CASE "FROM"
      FromCount% = FromCount% + 1
    CASE "NEXT"
      IF FromCount% = 0 THEN IF InName$(WorkLine$) = FromVariableName$ THEN EXIT FOR
      FromCount% = FromCount% - 1
    END SELECT
   NEXT LineNumber%
   FOR Index% = 1 TO FromsCountValue% + 1
    IF Index% = FromsCountValue% + 1 THEN ERROR 83
    IF Froms$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   IF StartValue# > EndValue# THEN
    IF NOT (FromStep# < 0#) THEN
     CurrentLine% = LineNumber%
    ELSE
     Froms$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(FromStep#)) + "). Variable name=" + FromVariableName$
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(StartValue#)))
    END IF
   ELSE
    IF NOT (FromStep# > 0) THEN
     CurrentLine% = LineNumber%
    ELSE
     Froms$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Start value=(" + LTRIM$(STR$(StartValue#)) + "). End value=(" + LTRIM$(STR$(EndValue#)) + "). Step=(" + LTRIM$(STR$(FromStep#)) + "). Variable name=" + FromVariableName$
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(StartValue#)))
    END IF
   END IF
 CASE "NEXT"
   IF NOT RunMode% THEN ERROR 42
   WorkName$ = InName$(InLine$)
   InLine$ = LTRIM$(InLine$)
   SELECT CASE LEFT$(InLine$, 1)
   CASE "$"
     ERROR 13
   CASE "!"
     InLine$ = MID$(InLine$, 2)
   CASE "@"
     InLine$ = MID$(InLine$, 2)
   CASE "#"
     InLine$ = MID$(InLine$, 2)
   CASE "%"
     InLine$ = MID$(InLine$, 2)
   CASE "&"
     InLine$ = MID$(InLine$, 2)
   END SELECT
   FOR Index% = 1 TO FromsCountValue% + 1
    IF Index% = FromsCountValue% + 1 THEN ERROR 1
    IF Froms$(Index%) <> "" THEN
     WorkLine$ = MID$(Froms$(Index%), INSTR(Froms$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     StartValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndValue# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     FromStep# = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     FromVariableName$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF (EndLine% = CurrentLine%) AND (FromVariableName$ = WorkName$) THEN EXIT FOR
    END IF
   NEXT Index%
   IF FromStep# < 0 THEN
    Result$ = InVariable$(FromVariableName$, False%, InLine$)
    IF VAL(Result$) <= EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(VAL(Result$) + FromStep#)))
     CurrentLine% = StartLine%
    END IF
   ELSE
    Result$ = InVariable$(FromVariableName$, False%, InLine$)
    IF VAL(Result$) >= EndValue# THEN
     Froms$(Index%) = ""
    ELSE
     CALL SetVariable(FromVariableName$, False%, LTRIM$(STR$(VAL(Result$) + FromStep#)))
     CurrentLine% = StartLine%
    END IF
   END IF
 CASE "WHILE"
   IF NOT RunMode% THEN ERROR 42
   Conditional$ = InLine$
   Value$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF CurrentLine% = BASICLinesCount% THEN ERROR 29
   WhileCount% = 0
   FOR LineNumber% = CurrentLine% + 1 TO BASICLinesCount% + 1
    IF LineNumber% = BASICLinesCount% + 1 THEN ERROR 29
    WorkLine$ = MID$(BASICLines$(LineNumber%), INSTR(BASICLines$(LineNumber%), "=") + 1)
    SELECT CASE InName$(WorkLine$)
    CASE "WHILE"
      WhileCount% = WhileCount% + 1
    CASE "WEND"
      IF WhileCount% = 0 THEN EXIT FOR
      WhileCount% = WhileCount% - 1
    END SELECT
   NEXT LineNumber%
   FOR Index% = 1 TO WhilesCountValue% + 1
    IF Index% = WhilesCountValue% + 1 THEN ERROR 81
    IF Whiles$(Index%) = "" THEN EXIT FOR
   NEXT Index%
   IF VAL(Value$) THEN
    Whiles$(Index%) = "Start line=(" + LTRIM$(STR$(CurrentLine%)) + "). End line=(" + LTRIM$(STR$(LineNumber%)) + "). Conditional=" + Conditional$
   ELSE
    CurrentLine% = LineNumber%
   END IF
 CASE "WEND"
   IF NOT RunMode% THEN ERROR 42
   FOR Index% = 1 TO WhilesCountValue% + 1
    IF Index% = WhilesCountValue% + 1 THEN ERROR 30
    IF Whiles$(Index%) <> "" THEN
     WorkLine$ = MID$(Whiles$(Index%), INSTR(Whiles$(Index%), "(") + 1)
     StartLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     WorkLine$ = MID$(WorkLine$, INSTR(WorkLine$, "(") + 1)
     EndLine% = VAL(MID$(WorkLine$, 1, INSTR(WorkLine$, ")") - 1))
     Conditional$ = MID$(WorkLine$, INSTR(WorkLine$, "=") + 1)
     IF EndLine% = CurrentLine% THEN EXIT FOR
    END IF
   NEXT Index%
   Result$ = Calculate$(Conditional$)
   IF NumStr% THEN ERROR 13
   IF VAL(Result$) THEN
    CurrentLine% = StartLine%
   ELSE
    Whiles$(Index%) = ""
   END IF
 CASE "IF"
   Result$ = Calculate$(InLine$)
   IF NumStr% THEN ERROR 13
   IF InName$(InLine$) <> "THEN" THEN ERROR 2
   InLine$ = LTRIM$(InLine$)
   Value$ = ParseRunLine$(InLine$)
   IfElse% = False%
   InLine$ = LTRIM$(InLine$)
   IF InLine$ <> "" THEN
    IF InName$(InLine$) <> "ELSE" THEN ERROR 2
    IfElse% = True%
    Meaning$ = ParseRunLine$(InLine$)
   END IF
   IF VAL(Result$) THEN
    CALL RunLine(Value$)
   ELSE
    IF IfElse% THEN CALL RunLine(Meaning$)
   END IF
 CASE ELSE
   ERROR 34
 END SELECT
END SUB

SUB SetTimerValue (NewValue&)
 DIM TimerMeaning&
 DIM Bytes%(4)
 DIM Index%
 TimerMeaning& = NewValue&
 DEF SEG = VARSEG(TimerMeaning&)
 FOR Index% = 0 TO 3
  Bytes%(Index% + 1) = PEEK(VARPTR(TimerMeaning&) + Index%)
 NEXT Index%
 DEF SEG = &H0
 FOR Index% = 0 TO 3
  POKE &H46C + Index%, Bytes%(Index% + 1)
 NEXT Index%
 DEF SEG
END SUB

SUB SetVariable (VariableName$, VariableType%, VariableValue$)
 DIM Index%
 IF (VariableName$ = "TIME") AND VariableType% THEN
  TIME$ = VariableValue$
 ELSEIF (VariableName$ = "DATE") AND VariableType% THEN
  DATE$ = VariableValue$
 ELSEIF (VariableName$ = "ENVIRON") AND VariableType% THEN
  ENVIRON VariableValue$
 ELSEIF (VariableName$ = "RANDOM") AND (NOT VariableType%) THEN
  RANDOMIZE VAL(VariableValue$)
 ELSEIF (VariableName$ = "TIMERVALUE") AND (NOT VariableType%) THEN
  CALL SetTimerValue(VAL(VariableValue$))
 ELSE
  IF VariablesCount% = 0 THEN
   VariablesCount% = VariablesCount% + 1
   Variables$(VariablesCount%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
  ELSE
   FOR Index% = 1 TO VariablesCount% + 1
    IF Index% = VariablesCount% + 1 THEN
     IF VariablesCount% = VariablesCountValue% THEN ERROR 22
     VariablesCount% = VariablesCount% + 1
     Variables$(VariablesCount%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
     EXIT FOR
    END IF
    IF (MID$(Variables$(Index%), 1, INSTR(Variables$(Index%), "[") - 1) = VariableName$) AND (VAL(MID$(Variables$(Index%), INSTR(Variables$(Index%), "[") + 1, 1)) = ABS(VariableType%)) THEN
     Variables$(Index%) = VariableName$ + "[" + LTRIM$(STR$(ABS(VariableType%))) + "]=" + VariableValue$
     EXIT FOR
    END IF
   NEXT Index%
  END IF
 END IF
END SUB

SUB SortLines
 DIM Index%
 DIM LinesIndex%
 DIM TempLine$
 FOR Index% = 1 TO BASICLinesCount%
  FOR LinesIndex% = Index% TO BASICLinesCount%
   IF VAL(MID$(BASICLines$(Index%), 1, INSTR(BASICLines$(Index%), "=") - 1)) > VAL(MID$(BASICLines$(LinesIndex%), 1, INSTR(BASICLines$(LinesIndex%), "=") - 1)) THEN
    TempLine$ = BASICLines$(LinesIndex%)
    BASICLines$(LinesIndex%) = BASICLines$(Index%)
    BASICLines$(Index%) = TempLine$
   END IF
  NEXT LinesIndex%
 NEXT Index%
END SUB

FUNCTION SquareRoot# (Meaning#)
 DIM Value#
 DIM ControlValue#
 Value# = 1
 ControlValue# = 0
 WHILE Value# <> ControlValue#
  ControlValue# = Value#
  Value# = ((Meaning# / Value#) + Value#) / 2
 WEND
 SquareRoot# = Value#
END FUNCTION

FUNCTION WeekNumber% (DayValue%, MonthValue%, YearValue%)
 WeekNumber% = INT((MonthDaysCount%(MonthValue%, YearValue%) + DayValue%) / 7) + 1
END FUNCTION

SUB WriteLine (Line$)
 DIM OutLine$
 OutLine$ = Line$
 WHILE OutLine$ <> ""
  CALL ANSIOut(LEFT$(OutLine$, 1))
  OutLine$ = MID$(OutLine$, 2)
 WEND
END SUB

SUB WriteLineOut (Line$)
 CALL WriteLine(Line$ + CHR$(13) + CHR$(10))
END SUB

