Attribute VB_Name = "Global"
Option Explicit

Public Const APP_ID = "{A3B87F3C-7C95-41E3-94C9-3B27FB79BDDF}"

Private Const MAX_PROP_LEN As Integer = 25000

Declare Function GetPrivateProfileString Lib "KERNEL32" Alias _
        "GetPrivateProfileStringA" (ByVal lpApplicationName _
        As String, ByVal lpKeyName As Any, ByVal lpDefault _
        As String, ByVal lpReturnedString As String, ByVal _
        nSize As Long, ByVal lpFileName As String) As Long
Declare Function WritePrivateProfileString Lib "KERNEL32" Alias _
        "WritePrivateProfileStringA" (ByVal lpApplicationName _
        As String, ByVal lpKeyName As Any, ByVal lpString As Any, _
        ByVal lpFileName As String) As Long

Public gsTipsFile As String

Public Declare Function PlaySound Lib "winmm.dll" Alias "PlaySoundA" _
   (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long
Public Const SND_ASYNC = &H1         '  play asynchronously
Public Const SND_SYNC = &H0         '  play synchronously (default)
Public Const SND_FILENAME = &H20000     '  name is a file name

Private Declare Function GetWindowLong Lib "user32" Alias "GetWindowLongA" _
   (ByVal hwnd As Long, ByVal nIndex As Long) As Long
Private Declare Function SetWindowLong Lib "user32" Alias "SetWindowLongA" _
   (ByVal hwnd As Long, ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
Private Const GWL_STYLE = (-16)
Private Const ES_NUMBER = &H2000

Public Function gfsGetINI(sINIFile As String, sSection As String, sKey _
        As String, Optional sDefault As String = "") As String

    Dim sTemp As String * MAX_PROP_LEN
    Dim nLength As Integer

    sTemp = Space$(MAX_PROP_LEN)
    nLength = GetPrivateProfileString(sSection, sKey, sDefault, sTemp, _
        MAX_PROP_LEN, sINIFile)
    gfsGetINI = Left$(sTemp, nLength)
End Function

Public Sub gpWriteINI(sINIFile As String, sSection As String, sKey _
        As String, ByVal sValue As String)
    Call WritePrivateProfileString(sSection, sKey, sValue, sINIFile)
End Sub

Public Sub gpCheckShowTips(pForm As Form)
   If GetSetting(APP_ID, "Main", "ShowTips", "1") = "1" Then
      frmTip.Exec pForm
   End If
End Sub

Public Sub gpTextBoxNumOnly(tb As TextBox)
   SetWindowLong tb.hwnd, GWL_STYLE, GetWindowLong(tb.hwnd, GWL_STYLE) Or ES_NUMBER
End Sub

