VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   3180
   ClientLeft      =   10275
   ClientTop       =   8010
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3180
   ScaleWidth      =   4680
   Begin VB.CommandButton Command2 
      Caption         =   "Command2"
      Height          =   435
      Left            =   1200
      TabIndex        =   1
      Top             =   1980
      Width           =   2295
   End
   Begin VB.CommandButton Command1 
      Caption         =   "Command1"
      Height          =   435
      Left            =   1200
      TabIndex        =   0
      Top             =   1500
      Width           =   2295
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim WithEvents MyDevice1 As PSGPIB32
Attribute MyDevice1.VB_VarHelpID = -1
Dim WithEvents MyDevice2 As PSGPIB32
Attribute MyDevice2.VB_VarHelpID = -1
Dim WithEvents MyVirtualDevice As PSVirtualDevice32
Attribute MyVirtualDevice.VB_VarHelpID = -1
Dim WithEvents MyLEDBar As PSLEDBar32
Attribute MyLEDBar.VB_VarHelpID = -1
Dim WithEvents MyMenu As PSMenu32
Attribute MyMenu.VB_VarHelpID = -1
Dim mIsAbort As Boolean
Dim MyUtility As PSUtility32

Private Sub Command1_Click()
Command2_Click
With MyDevice1
    .SimulateMode = True        'for no GPIB card or device connected
    .DeviceName = 7             'this device address is 7
    .PanelParameter = "My Test Parameter 1"
    .PanelOption = "VDC"
    .PanelStatus = "Remote"
    .BrandName = "Fluke"
    .ModelName = "45 #1"
    .PanelPosition = RightUp
    .StatusPosition = CenterDown
    .InitCommand1 = "*RST;CLS"
    .ReadCommand = "MEAS?"
    .ReadInterval = 250         'read every 250 ms
    .Offset = 1
    .Execute
End With
With MyDevice2
    .SimulateMode = True        'for no GPIB card or device connected
    .DeviceName = 5             'this device address is 7
    .PanelParameter = "My Test Parameter 2"
    .PanelOption = "VDC"
    .PanelStatus = "Remote"
    .BrandName = "Fluke"
    .ModelName = "45 #2"
    .PanelLeft = MyDevice1.PanelLeft
    .PanelTop = MyDevice1.PanelTop + MyDevice1.PanelHeight
    .StatusPosition = CenterDown
    .InitCommand1 = "*RST;CLS"
    .ReadCommand = "MEAS?"
    .ReadInterval = 250         'read every 250 ms
    .Execute
End With
With MyVirtualDevice
    .Caption = "Virtual Device Demonstration"
    .Suffix = "VDC"
    .Left = MyDevice2.PanelLeft
    .Top = MyDevice2.PanelTop + MyDevice2.PanelHeight
    .Show
End With
With MyLEDBar
    .DecimalPoint = 2
    .Min = -80
    .Max = 80
    .ScaleMin = -100
    .ScaleMax = 100
    .PreciseStep = 0.5
    .Suffix = "VDC"
    .Left = MyVirtualDevice.Left
    .Top = MyVirtualDevice.Top + MyVirtualDevice.Height
    .Show
End With
End Sub

Private Sub Command2_Click()
With MyUtility
    .AppPath = App.Path       'let class library know where is your application path
    .INIPath = .AppPath       'let class library know where is you keep INI files
    MyMenu.ShowMenu
End With
End Sub

Private Sub Form_Load()
Set MyDevice1 = New PSGPIB32
Set MyDevice2 = New PSGPIB32
Set MyVirtualDevice = New PSVirtualDevice32
Set MyLEDBar = New PSLEDBar32
Set MyMenu = New PSMenu32
Set MyUtility = New PSUtility32
End Sub

Private Sub Form_Unload(Cancel As Integer)
Set MyDevice1 = Nothing
Set MyDevice2 = Nothing
Set MyVirtualDevice = Nothing
Set MyLEDBar = Nothing
Set MyMenu = Nothing
Set MyUtility = Nothing
End Sub

Private Sub MyDevice1_ValueChanged(ByVal Value As Double, _
                                   ByVal RawValue As Variant)
Value = Format(Value, "#,##0.00")
MyMenu.SendData "Frequency Response Test", "Q1 @-3dB", Value
End Sub


Private Sub MyDevice2_ValueChanged(ByVal Value As Double, _
                                   ByVal RawValue As Variant)
'MyVirtualDevice.SendValue Value, 2
End Sub

Private Sub MyLEDBar_ValueChanged(ByVal Value As Double, _
                                  ByVal IsPassed As Boolean)
MyVirtualDevice.SendValue Value, 2
End Sub

Private Sub MyMenu_AbortClick()
Unload Me
End
End Sub

Private Sub MyMenu_ExitClick()
Unload Me
End
End Sub
