
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################

namespace eval dbg {
    variable flags
    variable channel
    variable all
    set all 0
    array set flags {}
    set channel stdout
}

proc dbg::puts { flag string } {
    variable flags
    variable channel
    variable all
    if { $all || [ info exists flags($flag) ] } {
	::puts $channel $string
    }
}

proc dbg::enable { flag } {
    variable flags
    set flags($flag) 1
}

proc dbg::enableAll { } {
    variable all
    set all 1
}

proc dbg::disable { flag } {
    variable flags
    catch { unset flags($flag) }
}

proc dbg::disableAll { } {
    variable flags
    variable all
    catch { unset flags }
    array set flags {}
    set all 0
}

proc dbg::setChannel { chan} {
    variable channel
    set channel $chan
}
    
proc dbg::bufWriteContents { flag buffer } {
    variable flags
    variable channel
    variable all
    if { $all || [info exists flags($flag)] } {
	::bufWriteContents $buffer $channel
    }
}
    
###########################################################################
# Copyright (c) 1998, Jeffrey Glen Rennie
# All rights reserved.
###########################################################################
