#include <gtk/gtk.h>
#include <strings.h>
#include "block.h"
#include "hcom.hh"
#include "adb.h"
#include "h.h"
#include "about.hh"
#include "chup.hh"
#include "addentry.hh"
#include "conf.h"
#include "compat.hh"
#include "confunix.hh"

void do_exit()
{
  gtk_main_quit();
}

GtkCheckMenuItem * disable_item, *autosave_item;

void do_disable(gpointer   callback_data,  guint      callback_action,
		GtkWidget *widget)
{

  blist.disabled = disable_item->active;
  PrintThreads(num_threads);
}

void do_autosave(gpointer   callback_data,  guint      callback_action,
		GtkWidget *widget)
{

  auto_save = autosave_item->active;
  SaveConf();
}

void do_check()
{
  CheckUpdate(false);
}

GtkWidget *filew;

void open_list_ok(GtkWidget *w, GtkFileSelection *fs)
{
  const char *s = gtk_file_selection_get_filename (GTK_FILE_SELECTION (fs));
  if (s) {
    strncpy(block_filename, s, sizeof(block_filename));
    block_filename_used = true;
    SaveConf();    
    blist.Free();
    blist.Load(s);
    ResetList();
  }
  gtk_grab_remove(filew);
  gtk_widget_hide(filew);
  gtk_widget_destroy(filew);  
}

void open_list(gpointer   callback_data,  guint      callback_action,
	       GtkWidget *widget)
{
  filew = gtk_file_selection_new ("File selection");
  gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filew)->ok_button),
		      "clicked", (GtkSignalFunc) open_list_ok, filew );
  gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filew)->cancel_button),
			     "clicked", (GtkSignalFunc) gtk_widget_destroy,
			     GTK_OBJECT (filew));
  gtk_widget_show(filew);
  gtk_grab_add(filew);
}

void save_list()
{
  if (block_filename_used) {
    blist.Save(block_filename);
    return;
  }
  MessageBox(0, "Save as not implemented yet.", "Sorry", 0);
  /* !!! FIXME !!! */
}

GtkItemFactoryEntry menu_items[] =
{
    {"/Ad Buster/Configure", 0, (GtkItemFactoryCallback) confdlg, 0, 0},
    {"/Ad Buster/", 0, 0, 0, "<Separator>"},
    {"/Ad Buster/Exit", 0, (GtkItemFactoryCallback) do_exit, 0, 0},
    {"/Blocklist/Flush", 0, 0, 0, 0},
    {"/Blocklist/", 0, 0, 0, "<Separator>"},
    {"/Blocklist/Open...", "<control>O", (GtkItemFactoryCallback) open_list, 0, 0},
    {"/Blocklist/Add...", "<control>A", 0, 0, 0},
    {"/Blocklist/", 0, 0, 0, "<Separator>"},
    {"/Blocklist/Save", "<control>S", (GtkItemFactoryCallback) save_list, 0, 0},
    {"/Blocklist/Save as...", 0, 0, 0, 0},
    {"/Blocklist/", 0, 0, 0, "<Separator>"},
    {"/Blocklist/Autoload&autosave", 0, (GtkItemFactoryCallback) do_autosave, 0, "<CheckItem>"},
    {"/Blocklist/", 0, 0, 0, "<Separator>"},
    {"/Blocklist/Disabled", 0, (GtkItemFactoryCallback) do_disable, 0, "<CheckItem>"},
    {"/Entry/Add entry (from selection)...", 0, (GtkItemFactoryCallback) addentry, 0, 0},
    {"/Entry/", 0, 0, 0, "<Separator>"},
    {"/Entry/Remove entry", 0, (GtkItemFactoryCallback) removeentry, 0, 0},
    {"/Loglist/Show log list", 0, 0, 0, 0},
    {"/Loglist/Show all messages", 0, 0, 0, 0},
    {"/Loglist/", 0, 0, 0, "<Separator>"},
    {"/Loglist/Flush", 0, 0, 0, 0},
    {"/Help/Go to Ad Buster homepage", 0, 0, 0, 0},
    {"/Help/Check for update", 0, (GtkItemFactoryCallback) do_check, 0, 0},
    {"/Help/", 0, 0, 0, "<Separator>"},
    {"/Help/About...", 0, (GtkItemFactoryCallback) about_box, 0, 0}
};

void get_main_menu(GtkWidget *window, GtkWidget ** menubar)
{
  int nmenu_items = sizeof(menu_items) / sizeof(menu_items[0]);
  GtkItemFactory *factory;
  
  factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<Menu>", 0);
  gtk_window_add_accel_group(GTK_WINDOW (window), factory->accel_group);
  gtk_item_factory_create_items(factory, nmenu_items, menu_items, window);
           
  if (menubar)
    *menubar = factory->widget;
  
  disable_item = GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(factory, "/Blocklist/Disabled"));
  gtk_check_menu_item_set_state(disable_item, blist.disabled);
  autosave_item = GTK_CHECK_MENU_ITEM(gtk_item_factory_get_widget(factory, "/Blocklist/Autoload&autosave"));
  gtk_check_menu_item_set_state(autosave_item, auto_save);
}
