#include "reg.h"
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>

bool get_bool_key(const char *subtree, const char *name)
{
   HKEY hkey;
   bool value = false;
   if (RegOpenKeyEx(HKEY_CURRENT_USER, subtree, 0, KEY_ALL_ACCESS, &hkey) == ERROR_SUCCESS) {
      DWORD lpType;
      DWORD val;
      DWORD size = sizeof(val);      
      RegQueryValueEx(hkey, name, 0, &lpType, (LPBYTE) &val, &size);
      RegCloseKey(hkey);
      value = (val);
   }
   return value;
}

void set_bool_key(const char *subtree, const char *name, bool val)
{
   HKEY hkey;
   DWORD value = val ? 1 : 0;
   DWORD ret;
   if (RegCreateKeyEx(HKEY_CURRENT_USER, subtree, 0, "huh", REG_OPTION_NON_VOLATILE,
		  KEY_ALL_ACCESS, 0, &hkey, &ret) == ERROR_SUCCESS) {
      RegSetValueEx(hkey, name, 0, REG_DWORD, (CONST BYTE *) &value, sizeof(value));
      RegCloseKey(hkey);
   }
}

void get_string_key(const char *subtree, const char *name, char *buf, int buflen)
{
   *buf = 0;
   HKEY hkey;
   if (RegOpenKeyEx(HKEY_CURRENT_USER, subtree, 0, KEY_ALL_ACCESS, &hkey) == ERROR_SUCCESS) {
      DWORD lpType;
      DWORD size = buflen;
      RegQueryValueEx(hkey, name, 0, &lpType, (LPBYTE) buf, &size);
      RegCloseKey(hkey);
      if (lpType != REG_EXPAND_SZ)
	*buf = 0;
   }
}

void set_string_key(const char *subtree, const char *name, const char *buf)
{
   HKEY hkey;
   DWORD ret;   
   if (RegCreateKeyEx(HKEY_CURRENT_USER, subtree, 0, "huh", REG_OPTION_NON_VOLATILE,
		  KEY_ALL_ACCESS, 0, &hkey, &ret) == ERROR_SUCCESS) {
      RegSetValueEx(hkey, name, 0, REG_EXPAND_SZ, (CONST BYTE *) buf, strlen(buf)+1);
      RegCloseKey(hkey);
   }
}


int get_int_key(const char *subtree, const char *name)
{
   char buf[256];
   get_string_key(subtree, name, buf, sizeof(buf));
   return atoi(buf);
}

void set_int_key(const char *subtree, const char *name, int val)
{
   char buf[256];
   sprintf(buf, "%i", val);
   set_string_key(subtree, name, buf);
}

