/*
 * Decompiled with CFR 0.152.
 */
package com.oreilly.servlet;

import com.oreilly.servlet.MultipartInputStreamHandler;
import com.oreilly.servlet.UploadedFile;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class MultipartRequest {
    private static final int DEFAULT_MAX_POST_SIZE = 0x100000;
    private static final String NO_FILE = "unknown";
    private HttpServletRequest req;
    private File dir;
    private int maxSize;
    private Hashtable parameters = new Hashtable();
    private Hashtable files = new Hashtable();

    public MultipartRequest(HttpServletRequest httpServletRequest, String string) throws IOException {
        this(httpServletRequest, string, 0x100000);
    }

    public MultipartRequest(HttpServletRequest httpServletRequest, String string, int n) throws IOException {
        if (httpServletRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("saveDirectory cannot be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("maxPostSize must be positive");
        }
        this.req = httpServletRequest;
        this.dir = new File(string);
        this.maxSize = n;
        if (!this.dir.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + string);
        }
        if (!this.dir.canWrite()) {
            throw new IllegalArgumentException("Not writable: " + string);
        }
        this.readRequest();
    }

    public MultipartRequest(ServletRequest servletRequest, String string) throws IOException {
        this((HttpServletRequest)servletRequest, string);
    }

    public MultipartRequest(ServletRequest servletRequest, String string, int n) throws IOException {
        this((HttpServletRequest)servletRequest, string, n);
    }

    public Enumeration getParameterNames() {
        return this.parameters.keys();
    }

    public Enumeration getFileNames() {
        return this.files.keys();
    }

    public String getParameter(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            String string2 = (String)vector.elementAt(vector.size() - 1);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getParameterValues(String string) {
        try {
            Vector vector = (Vector)this.parameters.get(string);
            if (vector == null || vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getFilesystemName(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFilesystemName();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getContentType(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getContentType();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public File getFile(String string) {
        try {
            UploadedFile uploadedFile = (UploadedFile)this.files.get(string);
            return uploadedFile.getFile();
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void readRequest() throws IOException {
        String string = this.req.getHeader("Content-Type");
        if (string == null || !string.toLowerCase().startsWith("multipart/form-data")) {
            throw new IOException("Posted content type isn't multipart/form-data");
        }
        int n = this.req.getContentLength();
        if (n > this.maxSize) {
            throw new IOException("Posted content length of " + n + " exceeds limit of " + this.maxSize);
        }
        String string2 = this.extractBoundary(string);
        if (string2 == null) {
            throw new IOException("Separation boundary was not specified");
        }
        MultipartInputStreamHandler multipartInputStreamHandler = new MultipartInputStreamHandler(this.req.getInputStream(), n);
        String string3 = multipartInputStreamHandler.readLine();
        if (string3 == null) {
            throw new IOException("Corrupt form data: premature ending");
        }
        if (!string3.startsWith(string2)) {
            throw new IOException("Corrupt form data: no leading boundary");
        }
        boolean bl = false;
        while (!bl) {
            bl = this.readNextPart(multipartInputStreamHandler, string2);
        }
    }

    protected boolean readNextPart(MultipartInputStreamHandler multipartInputStreamHandler, String string) throws IOException {
        String string2 = multipartInputStreamHandler.readLine();
        if (string2 == null) {
            return true;
        }
        if (string2.length() == 0) {
            return true;
        }
        String[] stringArray = this.extractDispositionInfo(string2);
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        string2 = multipartInputStreamHandler.readLine();
        if (string2 == null) {
            return true;
        }
        String string5 = this.extractContentType(string2);
        if (string5 != null) {
            string2 = multipartInputStreamHandler.readLine();
            if (string2 == null || string2.length() > 0) {
                throw new IOException("Malformed line after content type: " + string2);
            }
        } else {
            string5 = "application/octet-stream";
        }
        if (string4 == null) {
            Vector<String> vector;
            String string6 = this.readParameter(multipartInputStreamHandler, string);
            if (string6.equals("")) {
                string6 = null;
            }
            if ((vector = (Vector<String>)this.parameters.get(string3)) == null) {
                vector = new Vector<String>();
                this.parameters.put(string3, vector);
            }
            vector.addElement(string6);
        } else {
            this.readAndSaveFile(multipartInputStreamHandler, string, string4);
            if (string4.equals(NO_FILE)) {
                this.files.put(string3, new UploadedFile(null, null, null));
            } else {
                this.files.put(string3, new UploadedFile(this.dir.toString(), string4, string5));
            }
        }
        return false;
    }

    protected String readParameter(MultipartInputStreamHandler multipartInputStreamHandler, String string) throws IOException {
        String string2;
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = multipartInputStreamHandler.readLine()) != null) {
            if (string2.startsWith(string)) break;
            stringBuffer.append(String.valueOf(string2) + "\r\n");
        }
        if (stringBuffer.length() == 0) {
            return null;
        }
        stringBuffer.setLength(stringBuffer.length() - 2);
        return stringBuffer.toString();
    }

    protected void readAndSaveFile(MultipartInputStreamHandler multipartInputStreamHandler, String string, String string2) throws IOException {
        int n;
        Object object;
        OutputStream outputStream = null;
        if (string2.equals(NO_FILE)) {
            outputStream = new ByteArrayOutputStream();
        } else {
            object = new File(String.valueOf(this.dir) + File.separator + string2);
            outputStream = new FileOutputStream((File)object);
        }
        object = new BufferedOutputStream(outputStream, 8192);
        byte[] byArray = new byte[102400];
        boolean bl = false;
        while ((n = multipartInputStreamHandler.readLine(byArray, 0, byArray.length)) != -1) {
            String string3;
            if (n > 2 && byArray[0] == 45 && byArray[1] == 45 && (string3 = new String(byArray, 0, n, "ISO-8859-1")).startsWith(string)) break;
            if (bl) {
                ((BufferedOutputStream)object).write(13);
                ((BufferedOutputStream)object).write(10);
                bl = false;
            }
            if (n >= 2 && byArray[n - 2] == 13 && byArray[n - 1] == 10) {
                ((BufferedOutputStream)object).write(byArray, 0, n - 2);
                bl = true;
                continue;
            }
            ((BufferedOutputStream)object).write(byArray, 0, n);
        }
        ((BufferedOutputStream)object).flush();
        ((FilterOutputStream)object).close();
        outputStream.close();
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        string2 = "--" + string2;
        return string2;
    }

    private String[] extractDispositionInfo(String string) throws IOException {
        String[] stringArray = new String[3];
        String string2 = string;
        string = string2.toLowerCase();
        int n = string.indexOf("content-disposition: ");
        int n2 = string.indexOf(";");
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string3 = string.substring(n + 21, n2);
        if (!string3.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + string3);
        }
        n = string.indexOf("name=\"", n2);
        n2 = string.indexOf("\"", n + 7);
        if (n == -1 || n2 == -1) {
            throw new IOException("Content disposition corrupt: " + string2);
        }
        String string4 = string2.substring(n + 6, n2);
        String string5 = null;
        n = string.indexOf("filename=\"", n2 + 2);
        n2 = string.indexOf("\"", n + 10);
        if (n != -1 && n2 != -1) {
            string5 = string2.substring(n + 10, n2);
            int n3 = Math.max(string5.lastIndexOf(47), string5.lastIndexOf(92));
            if (n3 > -1) {
                string5 = string5.substring(n3 + 1);
            }
            if (string5.equals("")) {
                string5 = NO_FILE;
            }
        }
        stringArray[0] = string3;
        stringArray[1] = string4;
        stringArray[2] = string5;
        return stringArray;
    }

    private String extractContentType(String string) throws IOException {
        String string2 = null;
        String string3 = string;
        if ((string = string3.toLowerCase()).startsWith("content-type")) {
            int n = string.indexOf(" ");
            if (n == -1) {
                throw new IOException("Content type corrupt: " + string3);
            }
            string2 = string.substring(n + 1);
        } else if (string.length() != 0) {
            throw new IOException("Malformed line after disposition: " + string3);
        }
        return string2;
    }
}

