<%
    /**************************************/
    /********  Search Result Page  ********/
    /**************************************/
%>

<jsp:useBean id="SearchBean" scope="session" class="com.kplab.webeasy.SearchBean" />

<%! int MAX_PER_PAGE = 20; %>
<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    int language=1, max_result=10;
    try {
      if (session.getValue("Language") != null)
         language = Integer.parseInt((String) session.getValue("Language"));
      if (request.getParameter("MaxResult") != null)
         max_result = Integer.parseInt(request.getParameter("MaxResult"));
    }
    catch (Exception e) {
        %>Sorry, the page you selected does not exist.<%
        return;
    }

    int num_of_match=0, display_index=0, remain_match=0;

    String call_parm = request.getParameter("call_parm");
    if (call_parm != null && call_parm.equals("FIRST"))
    /* If it is the first call to this page, search the database. */
    {
      String search_string = request.getParameter("SearchString");
      SearchBean.refreshList(search_string, language, max_result);
      num_of_match  = SearchBean.getListSize();
      remain_match  = num_of_match;
      display_index = 0;
    }
    else
    /* If it is not the first call, continue to show results not yet displayed. */
    {
      try {
        num_of_match  = Integer.parseInt(request.getParameter("num_of_match"));
        remain_match  = Integer.parseInt(request.getParameter("remain_match"));
        display_index = Integer.parseInt(request.getParameter("display_index"));
      }
      catch (Exception e) {
        %>Sorry, the page you selected does not exist.<%
        return;
      }
    }

    int num_of_display = 0;
    if (remain_match > MAX_PER_PAGE)
         num_of_display = MAX_PER_PAGE;
    else num_of_display = remain_match;

%>



<form action="Search.jsp" method="POST">
<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr>
    <td valign="top" align="left" colspan="2"><font size="4" face="Arial">
    <strong>Search Results:</strong></font></td>
  </tr>

<%
    /*******************************************/
    /***** Number of matched records found *****/
    /*******************************************/

    if (num_of_display == 0)
    {
%>
      <tr>
        <td valign="top" align="left" colspan="2">Sorry, no records are found.</td>
      </tr>
<%
    }
    else
    {
%>
      <tr>
        <td valign="top" align="left" colspan="2">
          Total <%= num_of_match %> records are found.<br>
        </td>
      </tr>
<%
    }


    /***********************************/
    /***** List of matched records *****/
    /***********************************/

    for (int i=0; i<num_of_display; i++)
    {
      SearchResult sr = SearchBean.getResultAt(display_index);
      String result_num = Integer.toString(display_index + 1);

      String title=null, link=null;
      int item_id = sr.getItemID();
      if (item_id == 0) /* Category */
      {
        title = sr.getCatName();
        link  = new String("Product.jsp?Type=CAT&ID=" + Integer.toString(sr.getCatID()));
      }
      else              /* Item     */
      {
        title = sr.getCatName() + ": " + sr.getItemName();
        link  = new String("Product.jsp?Type=ITEM&ID=" + Integer.toString(item_id));
      }

%>
      <tr>
        <td align="left" valign="top"><%= result_num %>.&nbsp;</td>
        <td align="left" valign="top" width="2000"><a href="<%= link %>"><%= title %></a></td>
      </tr>
<%
      display_index++;
    }
%>

<%
    /*******************************/
    /********** Next Page **********/
    /*******************************/

    remain_match   -= num_of_display;
    String s_match  = Integer.toString(num_of_match);
    String s_remain = Integer.toString(remain_match);
    String s_index  = Integer.toString(display_index);

    if (remain_match > 0)
    {
%>
      <tr>
          <td valign="top" align="left">&nbsp;</td>
          <td valign="top" align="left"><br><input type="submit" value="Next Page"></p></td>
      </tr>

      <tr><td><input type="hidden" name="call_parm" value="SECOND"></td></tr>
      <tr><td><input type="hidden" name="num_of_match" value="<%= s_match %>"></td></tr>
      <tr><td><input type="hidden" name="remain_match" value="<%= s_remain %>"></td></tr>
      <tr><td><input type="hidden" name="display_index" value="<%= s_index %>"></td></tr>
<%
    }
%>

</table>
</form>
