/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.CpoolString;
import gnu.bytecode.CpoolValue1;
import gnu.bytecode.CpoolValue2;
import java.io.DataOutputStream;
import java.io.IOException;

public class ConstantValueAttr
extends Attribute {
    Object value;
    int value_index;

    public Object getValue(ConstantPool constantPool) {
        if (this.value != null) {
            return this.value;
        }
        CpoolEntry cpoolEntry = constantPool.getPoolEntry(this.value_index);
        switch (cpoolEntry.getTag()) {
            case 8: {
                this.value = ((CpoolString)cpoolEntry).getString().getString();
                break;
            }
            case 3: {
                this.value = new Integer(((CpoolValue1)cpoolEntry).value);
                break;
            }
            case 5: {
                this.value = new Long(((CpoolValue2)cpoolEntry).value);
                break;
            }
            case 4: {
                float f = Float.intBitsToFloat(((CpoolValue1)cpoolEntry).value);
                this.value = new Float(f);
                break;
            }
            case 6: {
                double d = Double.longBitsToDouble(((CpoolValue2)cpoolEntry).value);
                this.value = new Double(d);
            }
        }
        return this.value;
    }

    public ConstantValueAttr(Object object) {
        super("ConstantValue");
        this.value = object;
    }

    public ConstantValueAttr(int n) {
        super("ConstantValue");
        this.value_index = n;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        if (this.value_index == 0) {
            ConstantPool constantPool = classType.getConstants();
            CpoolEntry cpoolEntry = null;
            if (this.value instanceof String) {
                cpoolEntry = constantPool.addString((String)this.value);
            } else if (this.value instanceof Integer) {
                cpoolEntry = constantPool.addInt((Integer)this.value);
            } else if (this.value instanceof Long) {
                cpoolEntry = constantPool.addLong((Long)this.value);
            } else if (this.value instanceof Float) {
                cpoolEntry = constantPool.addFloat(((Float)this.value).floatValue());
            } else if (this.value instanceof Long) {
                cpoolEntry = constantPool.addDouble((Double)this.value);
            }
            this.value_index = cpoolEntry.getIndex();
        }
    }

    public final int getLength() {
        return 2;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.value_index);
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", value: ");
        if (this.value_index == 0) {
            Object object = this.getValue(classTypeWriter.ctype.constants);
            if (object instanceof String) {
                classTypeWriter.printQuotedString((String)object);
            } else {
                classTypeWriter.print(object);
            }
        } else {
            if (classTypeWriter.printConstants) {
                classTypeWriter.print(this.value_index);
                classTypeWriter.print('=');
            }
            CpoolEntry cpoolEntry = classTypeWriter.ctype.constants.getPoolEntry(this.value_index);
            cpoolEntry.print(classTypeWriter, 1);
        }
        classTypeWriter.println();
    }
}

