/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.ByteCode;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.EmptyStackException;
import java.util.Stack;
import uk.co.visualisationsystems.QuickFire.ByteCode.ClassBuilder;
import uk.co.visualisationsystems.QuickFire.ByteCode.ConstantPool;
import uk.co.visualisationsystems.QuickFire.ByteCode.ConstantPoolEntry;
import uk.co.visualisationsystems.QuickFire.ByteCode.ConstantPoolEntryUtf8;

public class Method {
    private ConstantPool constantPool;
    private ConstantPoolEntry lineNumberTable;
    private ConstantPoolEntry code;
    private ByteArrayOutputStream byteArrayOutputStream;
    private DataOutputStream codeOutputStream;
    private Stack stack;
    private int maxStack;
    private int accessFlags;

    Method(ClassBuilder classBuilder) {
        this.constantPool = classBuilder.getConstantPool();
        this.code = new ConstantPoolEntryUtf8("Code");
        this.constantPool.addEntry(this.code);
        this.lineNumberTable = new ConstantPoolEntryUtf8("LineNumberTable");
        this.constantPool.addEntry(this.lineNumberTable);
        this.byteArrayOutputStream = new ByteArrayOutputStream();
        this.codeOutputStream = new DataOutputStream(this.byteArrayOutputStream);
        this.stack = new Stack();
        this.maxStack = 0;
    }

    void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    private void appendByte(byte by) throws IOException {
        this.codeOutputStream.writeByte(by);
    }

    private void appendShort(short s) throws IOException {
        this.codeOutputStream.writeShort(s);
    }

    private void pushObject() {
        this.stack.push("Object");
        if (this.stack.size() > this.maxStack) {
            this.maxStack = this.stack.size();
        }
    }

    private void popObject() throws EmptyStackException {
        Object e = this.stack.pop();
    }

    public void _nop() throws Exception {
        this.codeOutputStream.writeByte(0);
    }

    public void _aconst_null() throws Exception {
        this.codeOutputStream.writeByte(1);
        this.pushObject();
    }

    public void _iconst_m1() throws Exception {
        this.codeOutputStream.writeByte(2);
        this.pushObject();
    }

    public void _iconst_0() throws Exception {
        this.codeOutputStream.writeByte(3);
        this.pushObject();
    }

    public void _iconst_1() throws Exception {
        this.codeOutputStream.writeByte(4);
        this.pushObject();
    }

    public void _iconst_2() throws Exception {
        this.codeOutputStream.writeByte(5);
        this.pushObject();
    }

    public void _iconst_3() throws Exception {
        this.codeOutputStream.writeByte(6);
        this.pushObject();
    }

    public void _iconst_4() throws Exception {
        this.codeOutputStream.writeByte(7);
        this.pushObject();
    }

    public void _iconst_5() throws Exception {
        this.codeOutputStream.writeByte(8);
        this.pushObject();
    }

    public void _lconst_0() throws Exception {
        this.codeOutputStream.writeByte(9);
        this.pushObject();
    }

    public void _lconst_1() throws Exception {
        this.codeOutputStream.writeByte(10);
        this.pushObject();
    }

    public void _fconst_0() throws Exception {
        this.codeOutputStream.writeByte(11);
        this.pushObject();
    }

    public void _fconst_1() throws Exception {
        this.codeOutputStream.writeByte(12);
        this.pushObject();
    }

    public void _fconst_2() throws Exception {
        this.codeOutputStream.writeByte(13);
        this.pushObject();
    }

    public void _dconst_0() throws Exception {
        this.codeOutputStream.writeByte(14);
        this.pushObject();
    }

    public void _dconst_1() throws Exception {
        this.codeOutputStream.writeByte(15);
        this.pushObject();
    }

    public void _aload_0() throws Exception {
        this.codeOutputStream.writeByte(42);
        this.pushObject();
    }

    public void _return() throws Exception {
        this.codeOutputStream.writeByte(177);
    }

    public void _putfield(short s) throws Exception {
        this.codeOutputStream.writeByte(181);
        this.codeOutputStream.writeShort(s);
        this.popObject();
        this.popObject();
    }

    public void _invokespecial(short s) throws Exception {
        this.codeOutputStream.writeByte(183);
        this.codeOutputStream.writeShort(s);
        this.popObject();
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        int n = 5;
        int n2 = 6;
        int n3 = 1;
        dataOutputStream.writeShort(this.accessFlags);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n3);
        byte[] byArray = this.byteArrayOutputStream.toByteArray();
        int n4 = byArray.length;
        dataOutputStream.writeShort(this.constantPool.getIndex(this.code));
        dataOutputStream.writeInt(8 + n4 + 2 + 22);
        System.out.println("maxStack = " + this.maxStack);
        dataOutputStream.writeShort(2);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(this.constantPool.getIndex(this.lineNumberTable));
        dataOutputStream.writeInt(14);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(4);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(9);
        dataOutputStream.writeShort(1);
    }
}

