/*
 * Decompiled with CFR 0.152.
 */
package uk.co.visualisationsystems.QuickFire.Compiler;

import java.util.Stack;
import java.util.Vector;
import uk.co.visualisationsystems.QuickFire.Compiler.ArgList;
import uk.co.visualisationsystems.QuickFire.Compiler.ArgListOperand;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzInstruction;
import uk.co.visualisationsystems.QuickFire.Compiler.BlitzProgram;
import uk.co.visualisationsystems.QuickFire.Compiler.ENode;
import uk.co.visualisationsystems.QuickFire.Compiler.FunctionFrame;
import uk.co.visualisationsystems.QuickFire.Compiler.FunctionFrameOperand;
import uk.co.visualisationsystems.QuickFire.Compiler.Operand;
import uk.co.visualisationsystems.QuickFire.Compiler.ParserTab;
import uk.co.visualisationsystems.QuickFire.Compiler.Scope;
import uk.co.visualisationsystems.QuickFire.Compiler.Symbol;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolOperand;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolTable;
import uk.co.visualisationsystems.QuickFire.Compiler.SymbolType;

class ParserSupport {
    public BlitzProgram program;
    private Stack stack;
    private Scope scope;
    private FunctionFrame globalFunctionFrame;
    private FunctionFrame functionFrame;
    private Symbol functionSymbol;
    private Symbol breakSymbol;
    private Symbol continueSymbol;
    private ParserTab parser;
    private int labelCounter;
    private int tempCounter;
    private int sourceOffset;
    static final int[] castOpcodes = new int[]{3, 4, 27, 3, 5, 28, 3, 6, 29, 3, 7, 30, 4, 3, 31, 4, 5, 32, 4, 6, 33, 4, 7, 34, 5, 3, 35, 5, 4, 36, 5, 6, 37, 5, 7, 38, 6, 3, 39, 6, 4, 40, 6, 5, 41, 6, 7, 42};
    static final int[] unaryMinus = new int[]{3, 3, 69, 4, 4, 70, 5, 5, 71, 6, 6, 72};
    static final int[] logicalNOT = new int[]{3, 3, 63, 4, 4, 64};
    static final int[] bitComp = new int[]{3, 3, 43, 4, 4, 44};
    static final int[] bitAND = new int[]{3, 3, 45, 4, 4, 46};
    static final int[] bitOR = new int[]{3, 3, 47, 4, 4, 48};
    static final int[] bitXOR = new int[]{3, 3, 49, 4, 4, 50};
    static final int[] leftShift = new int[]{3, 3, 51, 4, 4, 52};
    static final int[] rightShift = new int[]{3, 3, 53, 4, 4, 54};
    static final int[] signRightShift = new int[]{3, 3, 55, 4, 4, 56};
    static final int[] moveInstr = new int[]{3, 3, 2, 4, 4, 3, 5, 5, 4, 6, 6, 5, 7, 7, 6, 8, 8, 7, 9, 9, 7, 10, 10, 7, 11, 11, 7, 12, 12, 7};
    static final int[] addInstr = new int[]{3, 3, 8, 4, 4, 9, 5, 5, 10, 6, 6, 11, 7, 7, 12};
    static final int[] subInstr = new int[]{3, 3, 13, 4, 4, 14, 5, 5, 15, 6, 6, 16};
    static final int[] mulInstr = new int[]{3, 3, 17, 4, 4, 18, 5, 5, 19, 6, 6, 20};
    static final int[] divInstr = new int[]{3, 3, 21, 4, 4, 22, 5, 5, 23, 6, 6, 24};
    static final int[] modInstr = new int[]{3, 3, 25, 4, 4, 26};
    static final int[] logicalAND = new int[]{3, 3, 65, 4, 4, 66};
    static final int[] logicalOR = new int[]{3, 3, 67, 4, 4, 68};

    ParserSupport(ParserTab parserTab) {
        this.parser = parserTab;
        this.stack = new Stack();
        this.scope = new Scope();
        this.functionFrame = this.globalFunctionFrame = new FunctionFrame();
        this.functionSymbol = null;
        this.breakSymbol = null;
        this.continueSymbol = null;
        this.labelCounter = 0;
        this.tempCounter = 0;
        this.sourceOffset = 0;
    }

    void SetSourceOffset(int n) {
        this.sourceOffset = n;
    }

    public Symbol DefineSystemCall(String string, int n) {
        Symbol symbol = new Symbol(string, 7, n);
        this.scope.AddSymbol(string, symbol);
        symbol.argList = new Vector();
        return symbol;
    }

    Symbol MakeTemp(int n) {
        String string = "T" + Integer.toString(this.tempCounter++);
        Symbol symbol = new Symbol(string, 2, n);
        this.scope.AddSymbol(string, symbol);
        return symbol;
    }

    ENode JumpOver(ENode eNode) {
        ENode eNode2 = new ENode();
        Symbol symbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
        BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(symbol, this.sourceOffset));
        symbol.valObject = blitzInstruction;
        BlitzInstruction blitzInstruction2 = new BlitzInstruction(73, new SymbolOperand(symbol, this.sourceOffset));
        eNode2.Append(blitzInstruction2);
        eNode2.Append(eNode);
        eNode2.Append(blitzInstruction);
        return eNode2;
    }

    void doEndCompile(ENode eNode) {
        BlitzInstruction blitzInstruction = null;
        Symbol symbol = this.scope.Lookup("main", false);
        if (symbol == null) {
            this.parser.yyerror("main() function has not been declared");
        } else if (!symbol.isFunction()) {
            this.parser.yyerror("main is not declared as a function");
        } else {
            blitzInstruction = (BlitzInstruction)symbol.valObject;
        }
        SymbolTable symbolTable = this.scope.CloseScope();
        this.program = eNode.blitzProgram;
        this.program.SetGlobalFunctionFrame(this.globalFunctionFrame);
        this.program.SetEntryPoint(blitzInstruction);
    }

    FunctionFrame GetGlobalFunctionFrame() {
        return this.globalFunctionFrame;
    }

    void ScopeBegin() {
        this.functionFrame.AddSymbolTable(this.scope.OpenScope());
    }

    void ScopeEnd() {
        this.scope.CloseScope();
    }

    void DoFunction1(int n, String string) {
        this.stack.push(this.continueSymbol);
        this.stack.push(this.breakSymbol);
        this.stack.push(this.functionSymbol);
        this.stack.push(this.functionFrame);
        this.continueSymbol = null;
        this.breakSymbol = null;
        Symbol symbol = this.scope.Lookup(string, false);
        if (symbol == null) {
            symbol = new Symbol(string, 5, n);
            this.scope.AddSymbol(string, symbol);
        } else {
            this.parser.yyerror("Function: " + string + " already declared");
        }
        this.stack.push(symbol);
        this.functionSymbol = symbol;
        this.functionFrame = new FunctionFrame();
        this.functionFrame.AddSymbolTable(this.scope.OpenScope());
    }

    void DoFunction2(ArgList argList) {
        Symbol symbol = (Symbol)this.stack.pop();
        symbol.argList = argList.argList;
        this.stack.push(symbol);
    }

    ENode DoFunction3(ENode eNode) {
        ENode eNode2 = new ENode();
        Symbol symbol = (Symbol)this.stack.pop();
        ArgList argList = new ArgList();
        argList.argList = symbol.argList;
        ArgListOperand argListOperand = new ArgListOperand(argList, this.sourceOffset);
        FunctionFrameOperand functionFrameOperand = new FunctionFrameOperand(this.functionFrame, this.sourceOffset);
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        BlitzInstruction blitzInstruction = new BlitzInstruction(76, symbolOperand, argListOperand, functionFrameOperand);
        symbol.valObject = blitzInstruction;
        eNode2.Append(blitzInstruction);
        eNode2.Append(eNode);
        if (symbol.GetSymbolType() == 2) {
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(78, functionFrameOperand);
            eNode2.Append(blitzInstruction2);
        }
        if (symbol != null && symbol.isFunction()) {
            symbol.SetData(eNode2.blitzProgram.first);
        } else {
            this.parser.yyerror("Internal Error: DoFunction2");
        }
        this.scope.CloseScope();
        this.functionFrame = (FunctionFrame)this.stack.pop();
        this.functionSymbol = (Symbol)this.stack.pop();
        this.breakSymbol = (Symbol)this.stack.pop();
        this.continueSymbol = (Symbol)this.stack.pop();
        return eNode2;
    }

    ENode DoDeclareVariable(int n, String string, int n2) {
        ENode eNode = new ENode();
        Symbol symbol = this.scope.Lookup(string, false);
        if (symbol == null) {
            symbol = new Symbol(string, 1, n);
            symbol.setArraySize(n2);
            this.scope.AddSymbol(string, symbol);
        } else {
            this.parser.yyerror("Variable: " + string + " already declared");
        }
        return eNode;
    }

    ENode DoDeclareParameter(int n, String string, int n2) {
        ENode eNode = new ENode();
        Symbol symbol = this.scope.Lookup(string, false);
        if (symbol == null) {
            symbol = new Symbol(string, 6, n);
            symbol.setArraySize(n2);
            this.scope.AddSymbol(string, symbol);
        } else {
            this.parser.yyerror("Parameter: " + string + " already declared");
        }
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        eNode.result = symbolOperand;
        return eNode;
    }

    ENode doIdentifier(String string) {
        Symbol symbol = this.scope.Lookup(string, true);
        if (symbol == null) {
            this.parser.yyerror(string + " has not been declared");
            symbol = new Symbol(string, 1, 3);
            this.scope.AddSymbol(string, symbol);
        }
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        ENode eNode = new ENode();
        eNode.result = symbolOperand;
        return eNode;
    }

    ENode doConstant(String string, int n) {
        String string2 = "$" + n + "_" + string;
        Symbol symbol = this.scope.Lookup(string2, true);
        if (symbol == null) {
            symbol = new Symbol(string2, 3, n);
            this.scope.AddSymbol(string2, symbol);
            switch (n) {
                case 3: {
                    symbol.ival = Integer.parseInt(string);
                    symbol.valObject = new Integer(symbol.ival);
                    break;
                }
                case 4: {
                    symbol.lval = Long.parseLong(string);
                    symbol.valObject = new Long(symbol.lval);
                    break;
                }
                case 5: {
                    symbol.fval = Double.valueOf(string).floatValue();
                    symbol.valObject = new Float(symbol.fval);
                    break;
                }
                case 6: {
                    symbol.dval = Double.valueOf(string);
                    symbol.valObject = new Double(symbol.dval);
                    break;
                }
                case 7: {
                    symbol.sval = string;
                    symbol.valObject = symbol.sval;
                    break;
                }
                default: {
                    this.parser.yyerror("Internal Error in doConstant");
                }
            }
        }
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        ENode eNode = new ENode();
        eNode.result = symbolOperand;
        return eNode;
    }

    ENode DoCast(int n, ENode eNode) {
        ENode eNode2 = new ENode();
        eNode2.Append(eNode);
        eNode2.result = eNode.result;
        int n2 = eNode.result.GetType();
        if (n != n2) {
            int n3 = this.SelectInstr(castOpcodes, n2, n);
            if (n3 != -1) {
                Symbol symbol = this.MakeTemp(n);
                SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
                BlitzInstruction blitzInstruction = new BlitzInstruction(n3, eNode.result, symbolOperand);
                eNode2.Append(blitzInstruction);
                eNode2.result = symbolOperand;
            } else {
                this.parser.yyerror("Invalid Cast: destType=" + n + " srcType=" + n2);
            }
        }
        return eNode2;
    }

    int DoCoercion(ENode eNode, ENode eNode2) {
        int n;
        int n2;
        int n3 = eNode.result.GetType();
        if (n3 > (n2 = eNode2.result.GetType())) {
            ENode eNode3 = this.DoCast(n3, eNode2);
            eNode2.blitzProgram = eNode3.blitzProgram;
            eNode2.result = eNode3.result;
            n = n3;
        } else if (n2 > n3) {
            ENode eNode4 = this.DoCast(n2, eNode);
            eNode.blitzProgram = eNode4.blitzProgram;
            eNode.result = eNode4.result;
            n = n2;
        } else {
            n = n3;
        }
        return n;
    }

    boolean CheckArgLists(Vector vector, Vector vector2) {
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        if (vector != null) {
            n = vector.size();
        }
        if (vector2 != null) {
            n2 = vector2.size();
        }
        if (n == n2) {
            int n3 = 0;
            while (n3 < n) {
                int n4;
                Operand operand = (Operand)vector.elementAt(n3);
                Operand operand2 = (Operand)vector2.elementAt(n3);
                int n5 = operand.GetType();
                if (n5 != (n4 = operand2.GetType())) {
                    String string = SymbolType.Name(n5);
                    String string2 = SymbolType.Name(n4);
                    this.parser.yyerror("Incorrect parameter type for argument " + (n3 + 1) + ": passed=" + string + " " + operand.GetSymbolName() + " expected=" + string2 + " " + operand2.GetSymbolName());
                    bl = false;
                }
                ++n3;
            }
        } else {
            this.parser.yyerror("Incorrect number of arguments: supplied=" + n + " expected=" + n2);
            bl = false;
        }
        return bl;
    }

    void PrintArgList(Vector vector) {
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        int n2 = 0;
        while (n2 < n) {
            Operand operand = (Operand)vector.elementAt(n2);
            int n3 = operand.GetType();
            String string = operand.GetSymbolName();
            String string2 = SymbolType.Name(n3);
            System.out.println("Arg " + (n2 + 1) + ": symbolName=" + string + " symbolType=" + string2);
            ++n2;
        }
    }

    ENode DoFunctionCall(String string, ArgList argList) {
        ENode eNode = new ENode();
        eNode.Append(argList.blitzProgram);
        ArgListOperand argListOperand = new ArgListOperand(argList, this.sourceOffset);
        Symbol symbol = this.scope.Lookup(string, true);
        if (symbol != null) {
            SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
            Symbol symbol2 = null;
            SymbolOperand symbolOperand2 = null;
            int n = symbol.GetSymbolType();
            if (n != 2) {
                symbol2 = this.MakeTemp(n);
                if (symbolOperand.symbol.getArraySize() != -1) {
                    System.out.println("Function call: Creating Temporary Array");
                    symbol2.setArraySize(0);
                }
                symbolOperand2 = new SymbolOperand(symbol2, this.sourceOffset);
            }
            if (symbol.isFunction()) {
                BlitzInstruction blitzInstruction = new BlitzInstruction(77, symbolOperand, argListOperand, symbolOperand2);
                eNode.Append(blitzInstruction);
            } else if (symbol.isSyscall()) {
                BlitzInstruction blitzInstruction = new BlitzInstruction(79, symbolOperand, argListOperand, symbolOperand2);
                eNode.Append(blitzInstruction);
            } else {
                this.parser.yyerror(string + " is not a function");
            }
            if (symbol.isFunction() || symbol.isSyscall()) {
                boolean bl = this.CheckArgLists(argList.argList, symbol.argList);
            }
            eNode.result = symbolOperand2;
        } else {
            this.parser.yyerror(string + " has not been declared (No forward references allowed)");
        }
        return eNode;
    }

    ENode BinaryOperator(int n, ENode eNode, ENode eNode2, int n2) {
        ENode eNode3 = new ENode();
        if (n2 == 1) {
            int n3;
            int n4 = eNode.result.GetType();
            switch (n4 > (n3 = eNode2.result.GetType()) ? n4 : n3) {
                case 3: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
                case 5: {
                    n2 = 5;
                    break;
                }
                case 6: {
                    n2 = 6;
                    break;
                }
                case 7: {
                    n2 = 7;
                    break;
                }
                default: {
                    this.parser.yyerror("Internal Error in BinaryOperator");
                }
            }
        }
        Symbol symbol = this.MakeTemp(n2);
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        BlitzInstruction blitzInstruction = new BlitzInstruction(n, eNode.result, eNode2.result, symbolOperand);
        eNode3.Append(eNode);
        eNode3.Append(eNode2);
        eNode3.Append(blitzInstruction);
        eNode3.result = symbolOperand;
        return eNode3;
    }

    ENode DoIfElseStatement(ENode eNode, ENode eNode2, ENode eNode3) {
        ENode eNode4 = new ENode();
        if (eNode.result.isNumericOperand()) {
            Symbol symbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
            Symbol symbol2 = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
            BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(symbol, this.sourceOffset));
            symbol.valObject = blitzInstruction;
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(1, new SymbolOperand(symbol2, this.sourceOffset));
            symbol2.valObject = blitzInstruction2;
            BlitzInstruction blitzInstruction3 = new BlitzInstruction(75, eNode.result, new SymbolOperand(symbol, this.sourceOffset));
            BlitzInstruction blitzInstruction4 = new BlitzInstruction(73, new SymbolOperand(symbol2, this.sourceOffset));
            eNode4.Append(eNode);
            eNode4.Append(blitzInstruction3);
            eNode4.Append(eNode2);
            eNode4.Append(blitzInstruction4);
            eNode4.Append(blitzInstruction);
            eNode4.Append(eNode3);
            eNode4.Append(blitzInstruction2);
        } else {
            this.parser.yyerror("if ... else statement requires an numeric expression");
        }
        return eNode4;
    }

    ENode DoIfStatement(ENode eNode, ENode eNode2) {
        ENode eNode3 = new ENode();
        if (eNode.result.isNumericOperand()) {
            Symbol symbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
            BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(symbol, this.sourceOffset));
            symbol.valObject = blitzInstruction;
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(75, eNode.result, new SymbolOperand(symbol, this.sourceOffset));
            eNode3.Append(eNode);
            eNode3.Append(blitzInstruction2);
            eNode3.Append(eNode2);
            eNode3.Append(blitzInstruction);
        } else {
            this.parser.yyerror("if statement requires an numeric expression");
        }
        return eNode3;
    }

    void doLoopBegin() {
        this.stack.push(this.continueSymbol);
        this.stack.push(this.breakSymbol);
        this.continueSymbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
        this.breakSymbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
    }

    void doLoopEnd() {
        this.breakSymbol = (Symbol)this.stack.pop();
        this.continueSymbol = (Symbol)this.stack.pop();
    }

    ENode doBreak() {
        ENode eNode = new ENode();
        if (this.breakSymbol != null) {
            BlitzInstruction blitzInstruction = new BlitzInstruction(73, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            eNode.Append(blitzInstruction);
        } else {
            this.parser.yyerror("break not valid here!");
        }
        return eNode;
    }

    ENode doContinue() {
        ENode eNode = new ENode();
        if (this.continueSymbol != null) {
            BlitzInstruction blitzInstruction = new BlitzInstruction(73, new SymbolOperand(this.continueSymbol, this.sourceOffset));
            eNode.Append(blitzInstruction);
        } else {
            this.parser.yyerror("continue not valid here!");
        }
        return eNode;
    }

    ENode doReturn(ENode eNode) {
        FunctionFrameOperand functionFrameOperand = new FunctionFrameOperand(this.functionFrame, this.sourceOffset);
        BlitzInstruction blitzInstruction = new BlitzInstruction(78, functionFrameOperand, eNode.result);
        eNode.Append(blitzInstruction);
        return eNode;
    }

    ENode doWhileLoop(ENode eNode, ENode eNode2) {
        ENode eNode3 = new ENode();
        if (eNode.result.isNumericOperand()) {
            BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(this.continueSymbol, this.sourceOffset));
            this.continueSymbol.valObject = blitzInstruction;
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(1, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            this.breakSymbol.valObject = blitzInstruction2;
            BlitzInstruction blitzInstruction3 = new BlitzInstruction(75, eNode.result, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            BlitzInstruction blitzInstruction4 = new BlitzInstruction(73, new SymbolOperand(this.continueSymbol, this.sourceOffset));
            eNode3.Append(blitzInstruction);
            eNode3.Append(eNode);
            eNode3.Append(blitzInstruction3);
            eNode3.Append(eNode2);
            eNode3.Append(blitzInstruction4);
            eNode3.Append(blitzInstruction2);
        } else {
            this.parser.yyerror("while statement requires an numeric expression");
        }
        this.doLoopEnd();
        return eNode3;
    }

    ENode doRepeatUntil(ENode eNode, ENode eNode2) {
        ENode eNode3 = new ENode();
        if (eNode2.result.isNumericOperand()) {
            BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(this.continueSymbol, this.sourceOffset));
            this.continueSymbol.valObject = blitzInstruction;
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(1, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            this.breakSymbol.valObject = blitzInstruction2;
            Symbol symbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
            BlitzInstruction blitzInstruction3 = new BlitzInstruction(1, new SymbolOperand(symbol, this.sourceOffset));
            symbol.valObject = blitzInstruction3;
            BlitzInstruction blitzInstruction4 = new BlitzInstruction(74, eNode2.result, new SymbolOperand(symbol, this.sourceOffset));
            eNode3.Append(blitzInstruction3);
            eNode3.Append(eNode);
            eNode3.Append(blitzInstruction);
            eNode3.Append(eNode2);
            eNode3.Append(blitzInstruction4);
            eNode3.Append(blitzInstruction2);
        } else {
            this.parser.yyerror("do .. while statement requires an numeric expression");
        }
        this.doLoopEnd();
        return eNode3;
    }

    ENode doForLoop(ENode eNode, ENode eNode2, ENode eNode3, ENode eNode4) {
        ENode eNode5 = new ENode();
        if (eNode2.result.isNumericOperand()) {
            Symbol symbol = new Symbol(Integer.toString(this.labelCounter++), 4, 2);
            BlitzInstruction blitzInstruction = new BlitzInstruction(1, new SymbolOperand(symbol, this.sourceOffset));
            symbol.valObject = blitzInstruction;
            BlitzInstruction blitzInstruction2 = new BlitzInstruction(1, new SymbolOperand(this.continueSymbol, this.sourceOffset));
            this.continueSymbol.valObject = blitzInstruction2;
            BlitzInstruction blitzInstruction3 = new BlitzInstruction(1, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            this.breakSymbol.valObject = blitzInstruction3;
            BlitzInstruction blitzInstruction4 = new BlitzInstruction(75, eNode2.result, new SymbolOperand(this.breakSymbol, this.sourceOffset));
            BlitzInstruction blitzInstruction5 = new BlitzInstruction(73, new SymbolOperand(symbol, this.sourceOffset));
            eNode5.Append(eNode);
            eNode5.Append(blitzInstruction);
            eNode5.Append(eNode2);
            eNode5.Append(blitzInstruction4);
            eNode5.Append(eNode4);
            eNode5.Append(blitzInstruction2);
            eNode5.Append(eNode3);
            eNode5.Append(blitzInstruction5);
            eNode5.Append(blitzInstruction3);
        } else {
            this.parser.yyerror("for statement requires an numeric test expression");
        }
        this.doLoopEnd();
        return eNode5;
    }

    private ENode UnaryOperator(int n, ENode eNode) {
        Symbol symbol;
        ENode eNode2 = new ENode();
        int n2 = eNode.result.GetType();
        switch (n2) {
            case 3: {
                symbol = this.MakeTemp(3);
                break;
            }
            case 4: {
                symbol = this.MakeTemp(4);
                break;
            }
            case 5: {
                symbol = this.MakeTemp(5);
                break;
            }
            case 6: {
                symbol = this.MakeTemp(6);
                break;
            }
            case 7: {
                symbol = this.MakeTemp(7);
                break;
            }
            default: {
                this.parser.yyerror("Internal Error in UnaryOperator");
                symbol = null;
            }
        }
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        BlitzInstruction blitzInstruction = new BlitzInstruction(n, eNode.result, symbolOperand);
        eNode2.Append(eNode);
        eNode2.Append(blitzInstruction);
        eNode2.result = symbolOperand;
        return eNode2;
    }

    ENode PreIncrement(ENode eNode) {
        int n = eNode.result.GetType();
        ENode eNode2 = this.doConstant("1", n);
        int n2 = this.SelectInstr(addInstr, n, n);
        ENode eNode3 = this.BinaryOperator(n2, eNode, eNode2, 1);
        eNode.blitzProgram = new BlitzProgram();
        return this.Move(eNode3, eNode);
    }

    ENode PreDecrement(ENode eNode) {
        int n = eNode.result.GetType();
        ENode eNode2 = this.doConstant("1", n);
        int n2 = this.SelectInstr(subInstr, n, n);
        ENode eNode3 = this.BinaryOperator(n2, eNode, eNode2, 1);
        eNode.blitzProgram = new BlitzProgram();
        return this.Move(eNode3, eNode);
    }

    ENode PostIncrement(ENode eNode) {
        int n = eNode.result.GetType();
        Operand operand = eNode.result;
        ENode eNode2 = new ENode();
        Symbol symbol = this.MakeTemp(n);
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        eNode2.result = symbolOperand;
        eNode2 = this.Move(eNode, eNode2);
        eNode.blitzProgram = new BlitzProgram();
        ENode eNode3 = this.doConstant("1", n);
        eNode2.result = operand;
        int n2 = this.SelectInstr(addInstr, n, n);
        eNode2 = this.BinaryOperator(n2, eNode2, eNode3, 1);
        eNode2 = this.Move(eNode2, eNode);
        eNode2.result = symbolOperand;
        return eNode2;
    }

    ENode PostDecrement(ENode eNode) {
        int n = eNode.result.GetType();
        Operand operand = eNode.result;
        ENode eNode2 = new ENode();
        Symbol symbol = this.MakeTemp(n);
        SymbolOperand symbolOperand = new SymbolOperand(symbol, this.sourceOffset);
        eNode2.result = symbolOperand;
        eNode2 = this.Move(eNode, eNode2);
        eNode.blitzProgram = new BlitzProgram();
        ENode eNode3 = this.doConstant("1", n);
        eNode2.result = operand;
        int n2 = this.SelectInstr(subInstr, n, n);
        eNode2 = this.BinaryOperator(n2, eNode2, eNode3, 1);
        eNode2 = this.Move(eNode2, eNode);
        eNode2.result = symbolOperand;
        return eNode2;
    }

    int SelectInstr(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3] == n && nArray[n3 + 1] == n2) {
                return nArray[n3 + 2];
            }
            n3 += 3;
        }
        this.parser.yyerror("No suitable instructions: Invalid combination of types: srcType=" + n + " destType=" + n2);
        return -1;
    }

    ENode UnaryMinus(ENode eNode) {
        int n = eNode.result.GetType();
        int n2 = this.SelectInstr(unaryMinus, n, n);
        return this.UnaryOperator(n2, eNode);
    }

    ENode LogicalNot(ENode eNode) {
        int n = eNode.result.GetType();
        int n2 = this.SelectInstr(logicalNOT, n, n);
        return this.UnaryOperator(n2, eNode);
    }

    ENode BitComp(ENode eNode) {
        int n = eNode.result.GetType();
        int n2 = this.SelectInstr(bitComp, n, n);
        return this.UnaryOperator(n2, eNode);
    }

    ENode Add(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(addInstr, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode Sub(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(subInstr, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode Mult(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(mulInstr, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode Div(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(divInstr, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode Mod(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(modInstr, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode BitAnd(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(bitAND, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode BitOr(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(bitOR, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode BitExclusiveOr(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(bitXOR, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode LeftShift(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(leftShift, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode RightShift(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(rightShift, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode RightShiftWithSignExtension(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(signRightShift, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode LogicalAnd(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(logicalAND, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode LogicalOr(ENode eNode, ENode eNode2) {
        int n = this.DoCoercion(eNode, eNode2);
        int n2 = this.SelectInstr(logicalOR, n, n);
        return this.BinaryOperator(n2, eNode, eNode2, 1);
    }

    ENode TestEQ(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(57, eNode, eNode2, 3);
        return eNode3;
    }

    ENode TestNE(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(58, eNode, eNode2, 3);
        return eNode3;
    }

    ENode TestLT(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(59, eNode, eNode2, 3);
        return eNode3;
    }

    ENode TestLE(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(60, eNode, eNode2, 3);
        return eNode3;
    }

    ENode TestGT(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(61, eNode, eNode2, 3);
        return eNode3;
    }

    ENode TestGE(ENode eNode, ENode eNode2) {
        this.DoCoercion(eNode, eNode2);
        ENode eNode3 = this.BinaryOperator(62, eNode, eNode2, 3);
        return eNode3;
    }

    ENode Move(ENode eNode, ENode eNode2) {
        int n = eNode2.result.GetType();
        ENode eNode3 = this.DoCast(n, eNode);
        int n2 = this.SelectInstr(moveInstr, n, n);
        BlitzInstruction blitzInstruction = new BlitzInstruction(n2, eNode3.result, eNode2.result);
        eNode3.Append(eNode2);
        eNode3.Append(blitzInstruction);
        eNode3.result = eNode2.result;
        return eNode3;
    }
}

