/*
Copyright 2002 Catalin Stefan Samfirescu mdsa@lycos.co.uk

This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.applet.*;
import java.io.*;
import java.util.*;

public class MyDomainSearch extends Applet implements ActionListener, Runnable{

    URL codeBase, userURL, documentBase;
    BufferedReader index;
    String buf, key, ind, title, param, start, stop, labelText,curFile;
    Vector URLVector;
    Hashtable filetitle;
    char ch;
    java.awt.List list;
    TextField tf;
    Button b;
    Label lb;
    boolean needLine ,search, titlefound, keyfound, reg, comment, flag;
    GridBagLayout gridbag;
    GridBagConstraints cons;
    Thread runner;

    public void init()
    {
        codeBase=getCodeBase();

        flag=false;

        try{
            setBackground(new Color(Integer.parseInt(param()),Integer.parseInt(param()),Integer.parseInt(param())));
        }catch (NullPointerException e){setBackground(new Color(255,255,255));}
        catch(NumberFormatException e){setBackground(new Color(255,255,255));}
        catch(IllegalArgumentException e){setBackground(new Color(255,255,255));}

        gridbag=new GridBagLayout();
        cons=new GridBagConstraints();
        setLayout(gridbag);

        build (cons,0,0,1,1,90,10);
        cons.fill=GridBagConstraints.HORIZONTAL;

        tf=new TextField();
        gridbag.setConstraints(tf,cons);
        add(tf);

        build (cons,1,0,1,1,10,0);
        cons.fill=GridBagConstraints.NONE;
        cons.anchor=GridBagConstraints.CENTER;
        try{
            start=param();
        }catch (StringIndexOutOfBoundsException e) {start="Search";}
        catch (NullPointerException e) {start="Search";}
        b=new Button(start);
        gridbag.setConstraints(b,cons);
        add(b);
        try{
            stop=param();
        }catch (StringIndexOutOfBoundsException e) {stop="Stop";}
        catch (NullPointerException e) {stop="Stop";}

        build (cons,0,1,2,1,0,80);
        cons.fill=GridBagConstraints.BOTH;
        list=new java.awt.List();
        list.addActionListener(this);
        list.setCursor(new Cursor(Cursor.HAND_CURSOR));
        gridbag.setConstraints(list,cons);
        add(list);

        build (cons,0,2,2,1,0,10);
        cons.fill=GridBagConstraints.HORIZONTAL;
        try{
            labelText=param();
        }catch (StringIndexOutOfBoundsException e) {labelText="Enter keyword";}
        catch (NullPointerException e) {labelText="Enter keyword";}
        lb=new Label(labelText, Label.CENTER);
        gridbag.setConstraints(lb,cons);
        add(lb);

        needLine=false;
        search=false;
        comment=false;

        filetitle=new Hashtable(30,(float)0.5);

        try{
            ind=getParameter ("index");
        }catch(NullPointerException e) { ind="index.html"; }

        curFile=ind;
        
        URLVector=new Vector (30,15);
    }

    public void parseHLink (String str) throws StringIndexOutOfBoundsException
    {
        int m;
        /*it is true when quotes are present*/
        boolean flag=false;
        int i=0, j=0, k=0;
        /*We have a frameset page*/
        while ((k=str.toUpperCase().indexOf("<FRAME"))!=-1)
        {
			/*Pass the FRAME tag*/
            j=k+6;
            /*Determine the SRC attribute*/
            if ((i=str.toUpperCase().indexOf("SRC",j))!=-1)
            {
                i+=3;
                j=i;
                /*Pass the equals, quotes or spaces*/
                do{
                    j++;
                    ch=str.charAt(j);
                    if (ch=='"')
                        flag=true;
                    else flag=false;
                }while (ch==' ' || ch=='"' || ch=='=');
                i=j;
                /*i is the index of the content of the SRC attribute*/
                /*Search the end of the content of the SRC attribute*/
                do{
                    j++;
                    ch=str.charAt(j);
                }while (ch!='>' && (ch!=' ' || flag==true) && ch!='"' && ch!='#');
                /*Now we have a page*/
                buf=str.substring(i,j);
				
				/*We want only relative URLs*/
                if (buf.indexOf(codeBase.toString())!=-1)
                    buf=buf.substring(codeBase.toString().length(),j);
				
				/*Check to see if it is a link to the exterior or a link to a non-html file*/
                if ((buf.toUpperCase().indexOf("NEWS")==-1) && (buf.toUpperCase().indexOf("WWW.")==-1) && (buf.indexOf("@")==-1) && (buf.toUpperCase().indexOf("HTTP:")==-1) && (buf.toUpperCase().indexOf("FILE:")==-1) && (buf.toUpperCase().indexOf("HTTPS:")==-1) && (buf.indexOf("#")==-1) && (buf.toUpperCase().indexOf("MAILTO")==-1) && (buf.toUpperCase().indexOf("FTP:")==-1) && (buf.toUpperCase().indexOf(".GIF")==-1) && (buf.toUpperCase().indexOf(".JPG")==-1) && (buf.toUpperCase().indexOf(".JPEG")==-1) && (buf.toUpperCase().indexOf(".PNG")==-1) && (buf.toUpperCase().indexOf(".SWF")==-1) && (buf.toUpperCase().indexOf("JAVASCRIPT:")==-1))
                {
                    if (buf.startsWith("/"))
                    {
                        if (buf.length()==1)
                        {
                            if (URLVector.contains(ind)==false)
                                buf=ind;
                        }
                        else buf=buf.substring(1);
                    }
                    else
                    {
                        if (curFile.endsWith("/")==true)
                        {
                            curFile=curFile.substring(0,curFile.length()-1);
                            if (curFile.lastIndexOf('/')!=-1)
                            {
                                if (buf.startsWith("../"))
                                {
                                    if ((m=curFile.substring(0,curFile.lastIndexOf('/')).lastIndexOf('/'))!=-1)
                                        buf=curFile.substring(0,m).concat(buf.substring(3));
                                    else buf=buf.substring(3);
                                }
                                else
                                    buf=curFile.substring(0,curFile.lastIndexOf('/')+1).concat(buf);
                            }
                        }

                        else if (curFile.lastIndexOf('/')!=-1)
                        {
                            if (buf.startsWith("../"))
                            {
                                if ((m=curFile.substring(0,curFile.lastIndexOf('/')).lastIndexOf('/'))!=-1)
                                    buf=curFile.substring(0,m).concat(buf.substring(3));
                                else buf=buf.substring(3);
                            }
                            else
                                buf=curFile.substring(0,curFile.lastIndexOf('/')+1).concat(buf);
                        }
                    }

                    if (URLVector.contains (buf)==false && buf!=ind)
                    {
                        URLVector.addElement (buf);
                    }
                }
            }
            str=str.substring(k+6);
        }
        while ((k=str.toUpperCase().indexOf("<A"))!=-1)
        {
            j=k+2;
            if ((i=str.toUpperCase().indexOf("HREF",j))!=-1)
            {
                i+=4;
                j=i;
                do{
                    j++;
                    ch=str.charAt(j);
                    if (ch=='"')
                        flag=true;
                    else flag=false;
                }while (ch==' ' || ch=='"' || ch=='=');

                i=j;

                do{
                    j++;
                    ch=str.charAt(j);
                }while (ch!='>' && (ch!=' ' || flag==true) && ch!='"' && ch!='#');

                buf=str.substring(i,j);

                if (buf.indexOf(codeBase.toString())!=-1)
                    buf=buf.substring(codeBase.toString().length(),j);

                if ((buf.toUpperCase().indexOf("NEWS")==-1) && (buf.toUpperCase().indexOf("WWW")==-1) && (buf.indexOf("@")==-1) && (buf.toUpperCase().indexOf("HTTP:")==-1) && (buf.toUpperCase().indexOf("FILE:")==-1) && (buf.toUpperCase().indexOf("HTTPS:")==-1) && (buf.indexOf("#")==-1) && (buf.toUpperCase().indexOf("MAILTO")==-1) && (buf.toUpperCase().indexOf("FTP:")==-1) && (buf.toUpperCase().indexOf(".GIF")==-1) && (buf.toUpperCase().indexOf(".JPG")==-1) && (buf.toUpperCase().indexOf(".JPEG")==-1) && (buf.toUpperCase().indexOf(".PNG")==-1) && (buf.toUpperCase().indexOf(".SWF")==-1) && (buf.toUpperCase().indexOf("JAVASCRIPT:")==-1))
                {
                    if (buf.startsWith("/"))
                    {
                        if (buf.length()==1)
                        {
                            if (URLVector.contains(ind)==false)
                                buf=ind;
                        }
                        else buf=buf.substring(1);
                    }
                    else
                    {
                        if (curFile.endsWith("/")==true)
                        {
                            curFile=curFile.substring(0,curFile.length()-1);
                            if (curFile.lastIndexOf('/')!=-1)
                            {
                                if (buf.startsWith("../"))
                                {
                                    if ((m=curFile.substring(0,curFile.lastIndexOf('/')).lastIndexOf('/'))!=-1)
                                        buf=curFile.substring(0,m).concat(buf.substring(3));
                                    else buf=buf.substring(3);
                                }
                                else
                                    buf=curFile.substring(0,curFile.lastIndexOf('/')+1).concat(buf);
                            }
                        }

                        else if (curFile.lastIndexOf('/')!=-1)
                        {
                            if (buf.startsWith("../"))
                            {
                                if ((m=curFile.substring(0,curFile.lastIndexOf('/')).lastIndexOf('/'))!=-1)
                                    buf=curFile.substring(0,m).concat(buf.substring(3));
                                else buf=buf.substring(3);
                            }
                            else
                                buf=curFile.substring(0,curFile.lastIndexOf('/')+1).concat(buf);
                        }
                    }

                    if (URLVector.contains (buf)==false && buf!=ind)
                        URLVector.addElement (buf);
                }
            }
            str=str.substring(k+2);
        }
    }

    public void parseKeyword (String str, String keyword)
    {
        int i=0;
        boolean tag=false;
        StringBuffer buffer=new StringBuffer();
        if (comment==false)
        {
            if (str.indexOf("<")!=-1)
            {
                if (str.indexOf(">")!=-1 && (str.indexOf(">")<str.indexOf("<")))
                    i=str.indexOf(">");
            }
            else if (str.indexOf(">")!=-1)
                i=str.indexOf(">");
        }
        for (;i<str.length();i++)
        {
            ch=str.charAt(i);
            if (ch=='<')
            {
                if (str.charAt(i+1)=='!')
                    comment=true;
                tag=true;
            }
            else if (ch=='>')
            {
                tag=false;
                comment=false;
            }
            else if (tag==false && comment==false)
            {
                if (i>1 && str.charAt(i-1)=='>')
                {
                    buffer.append (' ');
                    buffer.append (ch);
                }
                else buffer.append (ch);
            }
        }

        if (buffer!=null)
            buf=buffer.toString().trim();

        if (buffer!=null && (i=buf.toUpperCase().indexOf(keyword.toUpperCase()))!=-1 && comment==false)
        {
            if (buf.length()==keyword.length())
            {
                keyfound=true;
                list.addItem(title);
            }
            else
            {
                if (i==0)
                {
                    if (Character.isLetter(buf.charAt(i+keyword.length()))==false)
                    {
                        keyfound=true;
                        list.addItem(title);
                    }
                }
                else
                {
                    if ((i+keyword.length())==buf.length())
                    {
                        if (Character.isLetter(buf.charAt(i-1))==false)
                        {
                            keyfound=true;
                            list.addItem(title);
                        }
                    }
                    else if (Character.isLetter(buf.charAt(i-1))==false && Character.isLetter(buf.charAt(i+keyword.length()))==false)
                    {
                        keyfound=true;
                        list.addItem(title);
                    }
                }
            }
        }
    }

    public void parseTitle (String str, String file)
    {
        int i=0, j=0;
        if (needLine==true)
        {
            if ((j=str.toUpperCase().indexOf("</TITLE>"))!=-1)
            {
                title=title.concat(" "+str.substring(0,j));
                filetitle.put (title, file);
                titlefound=true;
                needLine=false;
            }
            else
                title=title.concat(" "+str);
        }

        else if ((i=str.toUpperCase().indexOf("<TITLE>"))!=-1)
            {
                i+=7;
                if ((j=str.toUpperCase().indexOf("</TITLE>"))!=-1)
                {
                    title=str.substring(i,j);
                    filetitle.put (title, file);
                    titlefound=true;
                }
                else
                {
                    needLine=true;
                    title=str.substring(i,str.length());
                }
            }

        if ((str.toUpperCase().indexOf("</HEAD")!=-1 || str.toUpperCase().indexOf("<BODY")!=-1 || str.toUpperCase().indexOf("</HTML>")!=-1 || str.toUpperCase().indexOf("<FRAMESET")!=-1) && titlefound==false)
        {
            titlefound=true;
            title=file;
            filetitle.put(title,file);
        }
    }

    public void parseFile(String str)
    {
        String inputLine;

        try{
            userURL=new URL(codeBase,str);
        }catch (MalformedURLException e) { }

        lb.setText ("Searching... "+userURL.toString());
        
        try{
            index=new BufferedReader(new InputStreamReader (userURL.openStream()));
        }catch(IOException e) {}

        titlefound=false;
        keyfound=false;

        try{
            while ((inputLine=index.readLine())!=null && (keyfound==false || search==false || titlefound==false))
            {
                if (search==false)
                {
                    try{
                        parseHLink (inputLine);
                    }catch (StringIndexOutOfBoundsException e) { }
                }
                if (titlefound==false)
                    parseTitle (inputLine,str);
                if (keyfound==false)
                {
                    try{
                        parseKeyword (inputLine,key);
                    }catch (StringIndexOutOfBoundsException e) {}
                }
            }
        }catch (IOException e) {}
        try{
            index.close();
        }catch (IOException e) {}
    }

    public void search()
    {
        list.clear();

        b.setLabel(stop);
        
        parseFile(ind);

        for (int k=0;k<URLVector.size();k++)
        {
			if (k!=URLVector.indexOf(ind)){
			    curFile=URLVector.elementAt(k).toString();
				parseFile(URLVector.elementAt(k).toString());
			}
        }
		
        search=true;

        if (list.getItemCount()==0)
        {
            try{
                lb.setText(getParameter("np"));
            }catch (NullPointerException e){lb.setText("No pages found");}
        }
        else
        {
            if (list.getItemCount()==1)
            {
                try{
                    lb.setText(getParameter("op"));
                }catch(NullPointerException e){lb.setText("One page found. Double click on a link.");}
            }
            else
            {
                try{
                    lb.setText(String.valueOf(list.getItemCount())+" "+getParameter("mp"));
                }catch(NullPointerException e) {lb.setText(String.valueOf(list.getItemCount())+" "+"pages found. Double click on a link.");}
            }
        }

        b.setLabel(start);
    }

    public boolean action (Event evt, Object arg)
    {
        if ((evt.target instanceof TextField) && tf.getText().length()>0)
            return (react());
        else if ((evt.target instanceof Button) && tf.getText().length()>0)
            return (react());
        else return false;
    }

    public void build (GridBagConstraints gbc, int gx, int gy, int gw, int gh, int wx, int wy)
    {
        gbc.gridx=gx;
        gbc.gridy=gy;
        gbc.gridwidth=gw;
        gbc.gridheight=gh;
        gbc.weightx=wx;
        gbc.weighty=wy;
    }

    public void actionPerformed (ActionEvent e)
    {
        try{
            this.getAppletContext().showDocument (new URL(codeBase, filetitle.get(list.getSelectedItem()).toString()), "_blank");
        }catch (MalformedURLException exc) { }
    }

    public void run ()
    {
        while (runner==Thread.currentThread())
        {
            search();
            runner.stop();
        }
    }

    public void stop()
    {
		try{
	        if (runner.isAlive())
				runner.stop();
		}catch (NullPointerException e){}
    }

    public void destroy ()
    {
        runner=null;
    }

    public boolean react()
    {
        key=tf.getText();
        if (b.getLabel()==stop)
        {
            runner.stop();
            b.setLabel(start);
            return true;
        }
        else
        {
            runner=new Thread (this,"runner");
            runner.start();
            b.setLabel(stop);
            return true;
        }
    }

    public String param () throws NullPointerException, StringIndexOutOfBoundsException
    {
        if (flag==false)
        {
            param=getParameter("param");
            flag=true;
        }
        buf=param.substring(0,param.indexOf(","));
        param=param.substring(param.indexOf(",")+1);
        return buf;
    }
}
