// file dbg_util.cpp
//(C) 1996 Alessandro Mordacci   mordacci@xtreme.it
//(C) 1996 SMC Sistemi di Misura e Controllo
//    Via Caduti del Lavoro, 26 - Pisa (Italy)
//    Tel. +39 50 525484
#ifndef   __DBG_UTIL_H
#define   __DBG_UTIL_H

#ifdef DBG_MSG_USECONIO
#   include <constrea.h>
extern constream dbg_conout;
#endif //DBG_MSG_USECONIO

#ifdef DEBUG_OPTIONS
#   define DebugPause(s) mySleep(s)
#   ifdef DBG_MSG_SMALL
#      define DbgCerr()
#      define DbgCout()
#      define DbgMsg(msg)
#      ifdef DBG_MSG_USECONIO
			 void _DebugSmallConioLn(void);
#         define DbgLn()      _DebugSmallConioLn()
#      else
			 void _DebugSmallLn(void);
#         define DbgLn() _DebugSmallLn()
#      endif
#   else
#      ifdef DBG_MSG_USECONIO
#         define DbgCerr()    dbg_conout
#         define DbgCout()    dbg_conout
#      else
#         define DbgCerr()    cerr
#         define DbgCout()    cout
#      endif //DBG_MSG_USECONIO
#      define DbgMsg(msg)  <<msg
#      define DbgLn()      <<endl
#   endif //DBG_MSG_SMALL
	 void _DebugAssert(char *szExpr, char * szFile,int iLineNum);
	 void _DebugAssertNoExit(char *szExpr, char * szFile,int iLineNu);
	 void _DebugAssertNoExitMsg(char *szExpr,char * szMsg);
#   define DebugAssert(expr)   ((expr) ? 0 : \
										 _DebugAssert(#expr, __FILE__, __LINE__))
#   define DebugAssertNoExit(expr)   ((expr) ? 0 : \
										 _DebugAssertNoExit(#expr, __FILE__, __LINE__))
#   define DebugAssertNoExitMsg(expr, msg)   ((expr) ? 0 : \
										 _DebugAssertNoExitMsg(#expr, msg))
#else
#   define DebugPause(s)
#   define DbgCerr()
#   define DbgCout()
#   define DbgMsg(msg)
#   define DbgLn()
#   define DebugAssert(expr)
#   define DebugAssertNoExit(expr)
#   define DebugAssertNoExitMsg(expr, msg)
#endif

#define DbgCoutMsg(msg)   DbgCout() DbgMsg(msg)
#define DbgMsgLn(msg)     DbgMsg(msg) DbgLn()
#define DbgCoutLn()       DbgCout() DbgLn()
#define DbgCoutMsgLn(msg) DbgCout() DbgMsg(msg) DbgLn()
#define DebugMessage(msg) DbgCoutMsgLn(msg)

#endif // __DBG_UTIL_H
