/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSListSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    protected XMLErrorReporter fErrorReporter = null;
    ValidationState fValidationState = new ValidationState();
    private static final XSSimpleType fQNameDV = (XSSimpleType)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("QName");
    private StringBuffer fPattern = new StringBuffer();
    private final XSFacets xsFacets = new XSFacets();

    XSDAbstractTraverser(XSDHandler handler, XSAttributeChecker attrChecker) {
        this.fSchemaHandler = handler;
        this.fAttrChecker = attrChecker;
    }

    void reset(XMLErrorReporter errorReporter, SymbolTable symbolTable) {
        this.fErrorReporter = errorReporter;
        this.fSymbolTable = symbolTable;
        this.fValidationState.setExtraChecking(false);
        this.fValidationState.setSymbolTable(symbolTable);
    }

    void traverseAnnotationDecl(Element annotationDecl, Object[] parentAttrs, boolean isGlobal, XSDocumentInfo schemaDoc) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(annotationDecl, isGlobal, schemaDoc);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element child = DOMUtil.getFirstChildElement(annotationDecl);
        while (child != null) {
            String name = DOMUtil.getLocalName(child);
            if (!name.equals(SchemaSymbols.ELT_APPINFO) && !name.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportSchemaError("src-annotation", null);
            }
            attrValues = this.fAttrChecker.checkAttributes(child, true, schemaDoc);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
    }

    FacetInfo traverseFacets(Element content, Object[] contentAttrs, String simpleTypeName, XSSimpleType baseValidator, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        int facetsPresent = 0;
        short facetsFixed = 0;
        boolean hasQName = this.containsQName(baseValidator);
        Vector<String> enumData = new Vector<String>();
        Vector<NamespaceSupport> enumNSDecls = hasQName ? new Vector<NamespaceSupport>() : null;
        int currentFacet = 0;
        while (content != null) {
            Element child;
            Object[] attrs = null;
            String facet = DOMUtil.getLocalName(content);
            if (facet.equals(SchemaSymbols.ELT_ENUMERATION)) {
                Element child2;
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc, hasQName);
                String enumVal = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                NamespaceSupport nsDecls = (NamespaceSupport)attrs[XSAttributeChecker.ATTIDX_ENUMNSDECLS];
                if (baseValidator.getVariety() == 1 && ((XSAtomicSimpleType)baseValidator).getPrimitiveKind() == 19) {
                    schemaDoc.fValidationContext.setNamespaceSupport(nsDecls);
                    try {
                        QName temp = (QName)fQNameDV.validate(enumVal, schemaDoc.fValidationContext, null);
                        if (this.fSchemaHandler.getGlobalDecl(schemaDoc, 6, temp) == null) {
                            this.reportSchemaError("declaration-not-found", new Object[]{"notation", temp.localpart});
                        }
                    }
                    catch (InvalidDatatypeValueException ex) {
                        this.reportSchemaError(ex.getKey(), ex.getArgs());
                    }
                    schemaDoc.fValidationContext.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                }
                enumData.addElement(enumVal);
                if (hasQName) {
                    enumNSDecls.addElement(nsDecls);
                }
                if ((child2 = DOMUtil.getFirstChildElement(content)) != null) {
                    if (DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child2, attrs, false, schemaDoc);
                        child2 = DOMUtil.getNextSiblingElement(child2);
                    }
                    if (child2 != null && DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{"enumeration", "(annotation?)"});
                    }
                }
            } else if (facet.equals(SchemaSymbols.ELT_PATTERN)) {
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if (this.fPattern.length() == 0) {
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append((String)attrs[XSAttributeChecker.ATTIDX_VALUE]);
                    child = DOMUtil.getFirstChildElement(content);
                    if (child != null) {
                        if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                            child = DOMUtil.getNextSiblingElement(child);
                        }
                        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            Object[] args = new Object[]{"Pattern facet has more than one annotation."};
                            this.reportSchemaError("s4s-elt-must-match", new Object[]{"pattern", "(annotation?)"});
                        }
                    }
                }
            } else {
                if (facet.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    currentFacet = 2;
                } else if (facet.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    currentFacet = 4;
                } else if (facet.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    currentFacet = 128;
                } else if (facet.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    currentFacet = 64;
                } else if (facet.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    currentFacet = 256;
                } else if (facet.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    currentFacet = 512;
                } else if (facet.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    currentFacet = 1024;
                } else if (facet.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    currentFacet = 2048;
                } else if (facet.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    currentFacet = 32;
                } else {
                    if (!facet.equals(SchemaSymbols.ELT_LENGTH)) break;
                    currentFacet = 1;
                }
                attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                if ((facetsPresent & currentFacet) != 0) {
                    this.reportSchemaError("src-single-facet-value", new Object[]{"The facet '" + facet + "' is defined more than once."});
                } else if (attrs[XSAttributeChecker.ATTIDX_VALUE] != null) {
                    facetsPresent = (short)(facetsPresent | currentFacet);
                    if (((Boolean)attrs[XSAttributeChecker.ATTIDX_FIXED]).booleanValue()) {
                        facetsFixed = (short)(facetsFixed | currentFacet);
                    }
                    switch (currentFacet) {
                        case 2: {
                            this.xsFacets.minLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 4: {
                            this.xsFacets.maxLength = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 128: {
                            this.xsFacets.maxExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 64: {
                            this.xsFacets.maxInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 256: {
                            this.xsFacets.minExclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 512: {
                            this.xsFacets.minInclusive = (String)attrs[XSAttributeChecker.ATTIDX_VALUE];
                            break;
                        }
                        case 1024: {
                            this.xsFacets.totalDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 2048: {
                            this.xsFacets.fractionDigits = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                            break;
                        }
                        case 32: {
                            this.xsFacets.whiteSpace = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).shortValue();
                            break;
                        }
                        case 1: {
                            this.xsFacets.length = ((XInt)attrs[XSAttributeChecker.ATTIDX_VALUE]).intValue();
                        }
                    }
                }
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{facet, "(annotation?)"});
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(attrs, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (enumData.size() > 0) {
            facetsPresent = (short)(facetsPresent | 0x10);
            this.xsFacets.enumeration = enumData;
            this.xsFacets.enumNSDecls = enumNSDecls;
        }
        if (this.fPattern.length() != 0) {
            facetsPresent = (short)(facetsPresent | 8);
            this.xsFacets.pattern = this.fPattern.toString();
        }
        this.fPattern.setLength(0);
        FacetInfo fi = new FacetInfo();
        fi.facetdata = this.xsFacets;
        fi.nodeAfterFacets = content;
        fi.fPresentFacets = (short)facetsPresent;
        fi.fFixedFacets = facetsFixed;
        return fi;
    }

    private boolean containsQName(XSSimpleType type) {
        if (type.getVariety() == 1) {
            short primitive = ((XSAtomicSimpleType)type).getPrimitiveKind();
            return primitive == 18 || primitive == 19;
        }
        if (type.getVariety() == 2) {
            return this.containsQName(((XSListSimpleType)type).getItemType());
        }
        if (type.getVariety() == 3) {
            XSSimpleType[] members = ((XSUnionSimpleType)type).getMemberTypes();
            int i = 0;
            while (i < members.length) {
                if (this.containsQName(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    Element traverseAttrsAndAttrGrps(Element firstAttr, XSAttributeGroupDecl attrGrp, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        String childName;
        Element child = null;
        XSAttributeGroupDecl tempAttrGrp = null;
        XSAttributeUse tempAttrUse = null;
        child = firstAttr;
        while (child != null) {
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                tempAttrUse = this.fSchemaHandler.fAttributeTraverser.traverseLocal(child, schemaDoc, grammar);
                if (tempAttrUse == null) break;
                if (attrGrp.getAttributeUse(tempAttrUse.fAttrDecl.fTargetNamespace, tempAttrUse.fAttrDecl.fName) == null) {
                    String idName = attrGrp.addAttributeUse(tempAttrUse);
                    if (idName != null) {
                        this.reportSchemaError("cvc-complex-type.5.3", new Object[]{tempAttrUse.fAttrDecl.fName, idName});
                    }
                } else {
                    this.reportSchemaError("ct-props-correct.4", new Object[]{"Duplicate attribute " + tempAttrUse.fAttrDecl.fName + " found "});
                }
            } else {
                if (!childName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (tempAttrGrp = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(child, schemaDoc, grammar)) == null) break;
                XSAttributeUse[] attrUseS = tempAttrGrp.getAttributeUses();
                XSAttributeUse existingAttrUse = null;
                int i = 0;
                while (i < attrUseS.length) {
                    existingAttrUse = attrGrp.getAttributeUse(attrUseS[i].fAttrDecl.fTargetNamespace, attrUseS[i].fAttrDecl.fName);
                    if (existingAttrUse == null) {
                        String idName = attrGrp.addAttributeUse(attrUseS[i]);
                        if (idName != null) {
                            this.reportSchemaError("cvc-complex-type.5.3", new Object[]{attrUseS[i].fAttrDecl.fName, idName});
                        }
                    } else {
                        this.reportSchemaError("ct-props-correct.4", new Object[]{"Duplicate attribute " + existingAttrUse.fAttrDecl.fName + " found "});
                    }
                    ++i;
                }
                if (tempAttrGrp.fAttributeWC != null) {
                    if (attrGrp.fAttributeWC == null) {
                        attrGrp.fAttributeWC = tempAttrGrp.fAttributeWC;
                    } else {
                        attrGrp.fAttributeWC = attrGrp.fAttributeWC.performIntersectionWith(tempAttrGrp.fAttributeWC, attrGrp.fAttributeWC.fProcessContents);
                        if (attrGrp.fAttributeWC == null) {
                            this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"});
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            XSWildcardDecl tempAttrWC = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(child, schemaDoc, grammar);
            if (attrGrp.fAttributeWC == null) {
                attrGrp.fAttributeWC = tempAttrWC;
            } else {
                attrGrp.fAttributeWC = tempAttrWC.performIntersectionWith(attrGrp.fAttributeWC, tempAttrWC.fProcessContents);
                if (attrGrp.fAttributeWC == null) {
                    this.reportSchemaError("src-wildcard", new Object[]{"intersection of wildcards is not expressible"});
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return child;
    }

    void reportSchemaError(String key, Object[] args) {
        this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
    }

    void checkNotationType(String refName, XSTypeDecl typeDecl) {
        if (typeDecl.getXSType() == 2 && ((XSSimpleType)typeDecl).getVariety() == 1 && ((XSAtomicSimpleType)typeDecl).getPrimitiveKind() == 19 && (((XSSimpleType)typeDecl).getDefinedFacets() & 0x10) == 0) {
            this.reportSchemaError("dt-enumeration-notation", new Object[]{refName});
        }
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl particle, String particleName, Element parent, int allContextFlags, long defaultVals) {
        boolean isGroupChild;
        int min = particle.fMinOccurs;
        int max = particle.fMaxOccurs;
        boolean defaultMin = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean defaultMax = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean processingAllEl = (allContextFlags & 1) != 0;
        boolean processingAllGP = (allContextFlags & 8) != 0;
        boolean groupRefWithAll = (allContextFlags & 2) != 0;
        boolean bl = isGroupChild = (allContextFlags & 4) != 0;
        if (!(!isGroupChild || defaultMin && defaultMax)) {
            Object[] args = new Object[]{parent.getAttribute(SchemaSymbols.ATT_NAME), particleName};
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "MinMaxOnGroupChild", args, (short)1);
            max = 1;
            min = 1;
        }
        if (min == 0 && max == 0) {
            particle.fType = 0;
            return null;
        }
        if (processingAllEl || groupRefWithAll || processingAllGP) {
            Object[] args;
            String errorMsg;
            if ((processingAllGP || groupRefWithAll || min != 0) && min != 1) {
                errorMsg = processingAllEl ? "BadMinMaxForAllElem" : (processingAllGP ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                args = new Object[]{"minOccurs", Integer.toString(min)};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", errorMsg, args, (short)1);
                min = 1;
            }
            if (max != 1) {
                errorMsg = processingAllEl ? "BadMinMaxForAllElem" : (processingAllGP ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                args = new Object[]{"maxOccurs", Integer.toString(max)};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", errorMsg, args, (short)1);
                max = 1;
            }
        }
        particle.fMaxOccurs = min;
        particle.fMaxOccurs = max;
        return particle;
    }

    class FacetInfo {
        XSFacets facetdata;
        Element nodeAfterFacets;
        short fPresentFacets;
        short fFixedFacets;

        FacetInfo() {
        }
    }
}

