/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.SchemaDVFactory;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSConstraints;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final boolean DEBUG = false;
    private static XSParticleDecl fErrorContent = null;
    private SchemaDVFactory schemaFactory = SchemaDVFactory.getInstance();

    XSDComplexTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSComplexTypeDecl traverseLocal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, false, schemaDoc);
        String complexTypeName = this.genAnonTypeName(complexTypeNode);
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        grammar.addComplexTypeDecl(type);
        type.setIsAnonymous();
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    XSComplexTypeDecl traverseGlobal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, true, schemaDoc);
        String complexTypeName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar);
        if (complexTypeName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME});
        } else {
            grammar.addGlobalTypeDecl(type);
        }
        grammar.addComplexTypeDecl(type);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element complexTypeDecl, String complexTypeName, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Boolean abstractAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt blockAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        XInt finalAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        XSComplexTypeDecl complexType = new XSComplexTypeDecl();
        complexType.fName = complexTypeName;
        complexType.fTargetNamespace = schemaDoc.fTargetNamespace;
        complexType.fBlock = blockAtt == null ? schemaDoc.fBlockDefault : blockAtt.shortValue();
        short s = complexType.fFinal = finalAtt == null ? schemaDoc.fFinalDefault : finalAtt.shortValue();
        if (abstractAtt != null && abstractAtt.booleanValue()) {
            complexType.setIsAbstractType();
        }
        Element child = null;
        try {
            child = DOMUtil.getFirstChildElement(complexTypeDecl);
            if (child != null) {
                if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                    child = DOMUtil.getNextSiblingElement(child);
                }
                if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{complexType.fName, SchemaSymbols.ELT_ANNOTATION});
                }
            }
            if (child == null) {
                complexType.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, complexType, mixedAtt, false, schemaDoc, grammar);
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(child, complexType, schemaDoc, grammar);
                if (DOMUtil.getNextSiblingElement(child) != null) {
                    String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(child));
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{complexType.fName, siblingName});
                }
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                this.traverseComplexContent(child, complexType, mixedAtt, schemaDoc, grammar);
                if (DOMUtil.getNextSiblingElement(child) != null) {
                    String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(child));
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{complexType.fName, siblingName});
                }
            } else {
                complexType.fBaseType = SchemaGrammar.fAnyType;
                this.processComplexContent(child, complexType, mixedAtt, false, schemaDoc, grammar);
            }
        }
        catch (ComplexTypeRecoverableError e) {
            this.handleComplexTypeError(e.getMessage(), e.errorSubstText, complexType);
        }
        return complexType;
    }

    private void traverseSimpleContent(Element simpleContentElement, XSComplexTypeDecl typeInfo, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String typeName = typeInfo.fName;
        Object[] attrValues = this.fAttrChecker.checkAttributes(simpleContentElement, false, schemaDoc);
        typeInfo.fContentType = 1;
        typeInfo.fParticle = null;
        Element simpleContent = DOMUtil.getFirstChildElement(simpleContentElement);
        if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(simpleContent, attrValues, false, schemaDoc);
            simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (simpleContent == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{typeInfo.fName, SchemaSymbols.ELT_SIMPLECONTENT});
        }
        String simpleContentName = DOMUtil.getLocalName(simpleContent);
        if (simpleContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            typeInfo.fDerivedBy = (short)2;
        } else if (simpleContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            typeInfo.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, simpleContentName});
        }
        if (DOMUtil.getNextSiblingElement(simpleContent) != null) {
            String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(simpleContent));
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, siblingName});
        }
        attrValues = this.fAttrChecker.checkAttributes(simpleContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{typeInfo.fName});
        }
        XSTypeDecl type = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        typeInfo.fBaseType = type;
        XSSimpleType baseValidator = null;
        XSComplexTypeDecl baseComplexType = null;
        short baseFinalSet = 0;
        if (type.getXSType() == 1) {
            baseComplexType = (XSComplexTypeDecl)type;
            if (baseComplexType.fContentType != 1) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{typeInfo.fName});
            }
            baseFinalSet = baseComplexType.fFinal;
            baseValidator = baseComplexType.fXSSimpleType;
        } else {
            baseValidator = (XSSimpleType)type;
            if (typeInfo.fDerivedBy == 2) {
                throw new ComplexTypeRecoverableError("src-ct.2", new Object[]{typeInfo.fName});
            }
            baseFinalSet = baseValidator.getFinalSet();
        }
        if ((baseFinalSet & typeInfo.fDerivedBy) != 0) {
            String errorKey = typeInfo.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{typeInfo.fName});
        }
        if ((simpleContent = DOMUtil.getFirstChildElement(simpleContent)) != null) {
            if (DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(simpleContent, null, false, schemaDoc);
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeName, SchemaSymbols.ELT_ANNOTATION});
            }
        }
        if (typeInfo.fDerivedBy == 2) {
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                XSSimpleType dv = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(simpleContent, schemaDoc, grammar);
                if (dv == null) {
                    throw new ComplexTypeRecoverableError();
                }
                if (!XSConstraints.checkSimpleDerivationOk(dv, baseValidator, baseValidator.getFinalSet())) {
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.1.1", new Object[]{typeName});
                }
                baseValidator = dv;
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            }
            Element attrNode = null;
            XSFacets facetData = null;
            short presentFacets = 0;
            short fixedFacets = 0;
            if (simpleContent != null) {
                XSDAbstractTraverser.FacetInfo fi = this.traverseFacets(simpleContent, null, typeName, baseValidator, schemaDoc, grammar);
                attrNode = fi.nodeAfterFacets;
                facetData = fi.facetdata;
                presentFacets = fi.fPresentFacets;
                fixedFacets = fi.fFixedFacets;
            }
            typeInfo.fXSSimpleType = this.schemaFactory.createTypeRestriction(null, schemaDoc.fTargetNamespace, (short)0, baseValidator);
            try {
                this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                typeInfo.fXSSimpleType.applyFacets(facetData, presentFacets, fixedFacets, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException ex) {
                this.reportSchemaError(ex.getKey(), ex.getArgs());
            }
            if (attrNode != null) {
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
                }
            }
            this.mergeAttributes(baseComplexType.fAttrGrp, typeInfo.fAttrGrp, typeName, false);
            typeInfo.fAttrGrp.removeProhibitedAttrs();
            String errorCode = typeInfo.fAttrGrp.validRestrictionOf(baseComplexType.fAttrGrp);
            if (errorCode != null) {
                throw new ComplexTypeRecoverableError(errorCode, new Object[]{typeInfo.fName});
            }
        } else {
            typeInfo.fXSSimpleType = baseValidator;
            if (simpleContent != null) {
                Element attrNode = simpleContent;
                if (!this.isAttrOrAttrGroup(attrNode)) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
                }
                Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
                if (node != null) {
                    throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
                }
                typeInfo.fAttrGrp.removeProhibitedAttrs();
            }
            if (baseComplexType != null) {
                this.mergeAttributes(baseComplexType.fAttrGrp, typeInfo.fAttrGrp, typeName, true);
            }
        }
    }

    private void traverseComplexContent(Element complexContentElement, XSComplexTypeDecl typeInfo, boolean mixedOnType, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String typeName = typeInfo.fName;
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexContentElement, false, schemaDoc);
        boolean mixedContent = mixedOnType;
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        if (mixedAtt != null) {
            mixedContent = mixedAtt;
        }
        typeInfo.fXSSimpleType = null;
        Element complexContent = DOMUtil.getFirstChildElement(complexContentElement);
        if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(complexContent, attrValues, false, schemaDoc);
            complexContent = DOMUtil.getNextSiblingElement(complexContent);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (complexContent == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.2", new Object[]{typeName, SchemaSymbols.ELT_COMPLEXCONTENT});
        }
        String complexContentName = DOMUtil.getLocalName(complexContent);
        if (complexContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            typeInfo.fDerivedBy = (short)2;
        } else if (complexContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
            typeInfo.fDerivedBy = 1;
        } else {
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeName, complexContentName});
        }
        if (DOMUtil.getNextSiblingElement(complexContent) != null) {
            String siblingName = DOMUtil.getLocalName(DOMUtil.getNextSiblingElement(complexContent));
            throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeName, siblingName});
        }
        attrValues = this.fAttrChecker.checkAttributes(complexContent, false, schemaDoc);
        QName baseTypeName = (QName)attrValues[XSAttributeChecker.ATTIDX_BASE];
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (baseTypeName == null) {
            throw new ComplexTypeRecoverableError("src-ct.0.3", new Object[]{typeName});
        }
        XSTypeDecl type = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName);
        if (type == null) {
            throw new ComplexTypeRecoverableError();
        }
        if (!(type instanceof XSComplexTypeDecl)) {
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{typeName});
        }
        XSComplexTypeDecl baseType = (XSComplexTypeDecl)type;
        typeInfo.fBaseType = baseType;
        if ((baseType.fFinal & typeInfo.fDerivedBy) != 0) {
            String errorKey = typeInfo.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{typeInfo.fName});
        }
        if ((complexContent = DOMUtil.getFirstChildElement(complexContent)) != null) {
            if (DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(complexContent, null, false, schemaDoc);
                complexContent = DOMUtil.getNextSiblingElement(complexContent);
            }
            if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeName, SchemaSymbols.ELT_ANNOTATION});
            }
        }
        this.processComplexContent(complexContent, typeInfo, mixedContent, true, schemaDoc, grammar);
        XSParticleDecl baseContent = baseType.fParticle;
        if (typeInfo.fDerivedBy == 2) {
            if (typeInfo.fParticle == null && baseContent != null && !baseContent.emptiable()) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.2", new Object[]{typeName});
            }
            if (typeInfo.fParticle != null && baseContent == null) {
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.3", new Object[]{typeName});
            }
            this.mergeAttributes(baseType.fAttrGrp, typeInfo.fAttrGrp, typeName, false);
            String error = typeInfo.fAttrGrp.validRestrictionOf(baseType.fAttrGrp);
            if (error != null) {
                throw new ComplexTypeRecoverableError(error, new Object[]{typeName});
            }
            typeInfo.fAttrGrp.removeProhibitedAttrs();
        } else {
            if (baseType.fContentType != 0 && (baseType.fContentType == 3 && mixedContent || baseType.fContentType == 2 && !mixedContent)) {
                throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.2.2.2.2.1", new Object[]{typeName});
            }
            if (typeInfo.fParticle == null) {
                typeInfo.fParticle = baseContent;
            } else if (baseContent != null) {
                if (typeInfo.fParticle.fType == 5 || baseType.fParticle.fType == 5) {
                    throw new ComplexTypeRecoverableError("cos-all-limited.1.2", new Object[]{typeName});
                }
                XSParticleDecl temp = new XSParticleDecl();
                temp.fType = (short)4;
                temp.fValue = baseContent;
                temp.fOtherValue = typeInfo.fParticle;
                typeInfo.fParticle = temp;
            }
            typeInfo.fContentType = mixedContent ? (short)2 : (typeInfo.fParticle == null ? (short)0 : (short)3);
            typeInfo.fAttrGrp.removeProhibitedAttrs();
            this.mergeAttributes(baseType.fAttrGrp, typeInfo.fAttrGrp, typeName, true);
        }
    }

    private void mergeAttributes(XSAttributeGroupDecl fromAttrGrp, XSAttributeGroupDecl toAttrGrp, String typeName, boolean extension) throws ComplexTypeRecoverableError {
        XSAttributeUse[] attrUseS = fromAttrGrp.getAttributeUses();
        Object duplicateAttrUse = null;
        int i = 0;
        while (i < attrUseS.length) {
            XSAttributeUse existingAttrUse = toAttrGrp.getAttributeUse(attrUseS[i].fAttrDecl.fTargetNamespace, attrUseS[i].fAttrDecl.fName);
            if (existingAttrUse == null) {
                String idName = toAttrGrp.addAttributeUse(attrUseS[i]);
                if (idName != null) {
                    throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{typeName, idName, attrUseS[i].fAttrDecl.fName});
                }
            } else if (extension) {
                throw new ComplexTypeRecoverableError("ct-props-correct.4", new Object[]{typeName, existingAttrUse.fAttrDecl.fName});
            }
            ++i;
        }
        if (extension) {
            if (toAttrGrp.fAttributeWC == null) {
                toAttrGrp.fAttributeWC = fromAttrGrp.fAttributeWC;
            } else if (fromAttrGrp.fAttributeWC != null) {
                toAttrGrp.fAttributeWC = toAttrGrp.fAttributeWC.performUnionWith(fromAttrGrp.fAttributeWC, toAttrGrp.fAttributeWC.fProcessContents);
            }
        }
    }

    private void processComplexContent(Element complexContentChild, XSComplexTypeDecl typeInfo, boolean isMixed, boolean isDerivation, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        Element attrNode = null;
        XSParticleDecl particle = null;
        String typeName = typeInfo.fName;
        if (complexContentChild != null) {
            String childName = DOMUtil.getLocalName(complexContentChild);
            if (childName.equals(SchemaSymbols.ELT_GROUP)) {
                particle = this.fSchemaHandler.fGroupTraverser.traverseLocal(complexContentChild, schemaDoc, grammar);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(complexContentChild, schemaDoc, grammar, 0);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(complexContentChild, schemaDoc, grammar, 0);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(complexContentChild, schemaDoc, grammar, 8);
                attrNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else {
                attrNode = complexContentChild;
            }
        }
        typeInfo.fParticle = particle;
        typeInfo.fContentType = isMixed ? (short)2 : (typeInfo.fParticle == null ? (short)0 : (short)3);
        if (attrNode != null) {
            if (!this.isAttrOrAttrGroup(attrNode)) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(attrNode)});
            }
            Element node = this.traverseAttrsAndAttrGrps(attrNode, typeInfo.fAttrGrp, schemaDoc, grammar);
            if (node != null) {
                throw new ComplexTypeRecoverableError("src-ct.0.1", new Object[]{typeInfo.fName, DOMUtil.getLocalName(node)});
            }
            if (!isDerivation) {
                typeInfo.fAttrGrp.removeProhibitedAttrs();
            }
        }
    }

    private boolean isAttrOrAttrGroup(Element e) {
        String elementName = DOMUtil.getLocalName(e);
        return elementName.equals(SchemaSymbols.ELT_ATTRIBUTE) || elementName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || elementName.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private void traverseSimpleContentDecl(Element simpleContentDecl, XSComplexTypeDecl typeInfo) {
    }

    private void traverseComplexContentDecl(Element complexContentDecl, XSComplexTypeDecl typeInfo, boolean mixedOnComplexTypeDecl) {
    }

    private String genAnonTypeName(Element complexTypeDecl) {
        Element node = DOMUtil.getParent(complexTypeDecl);
        String typeName = "#AnonType_";
        while (node != null && node != DOMUtil.getRoot(DOMUtil.getDocument(node))) {
            typeName = typeName + node.getAttribute(SchemaSymbols.ATT_NAME);
            node = DOMUtil.getParent(node);
        }
        return typeName;
    }

    private void handleComplexTypeError(String messageId, Object[] args, XSComplexTypeDecl typeInfo) {
        if (messageId != null) {
            this.reportSchemaError(messageId, args);
        }
        typeInfo.fContentType = (short)2;
        typeInfo.fParticle = XSDComplexTypeTraverser.getErrorContent();
    }

    private static XSParticleDecl getErrorContent() {
        if (fErrorContent == null) {
            fErrorContent = new XSParticleDecl();
            XSDComplexTypeTraverser.fErrorContent.fType = (short)4;
            XSParticleDecl particle = new XSParticleDecl();
            XSWildcardDecl wildcard = new XSWildcardDecl();
            wildcard.fProcessContents = (short)2;
            particle.fType = (short)2;
            particle.fValue = wildcard;
            particle.fMinOccurs = 0;
            particle.fMaxOccurs = -1;
            XSDComplexTypeTraverser.fErrorContent.fValue = particle;
            XSDComplexTypeTraverser.fErrorContent.fOtherValue = null;
        }
        return fErrorContent;
    }

    private class ComplexTypeRecoverableError
    extends Exception {
        Object[] errorSubstText = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String msgKey) {
            super(msgKey);
        }

        ComplexTypeRecoverableError(String msgKey, Object[] args) {
            super(msgKey);
            this.errorSubstText = args;
        }
    }
}

