/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.jaxp.DocumentBuilderImpl;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.SAXException;

public class DocumentBuilderFactoryImpl
extends DocumentBuilderFactory {
    private Hashtable attributes;

    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        try {
            return new DocumentBuilderImpl(this, this.attributes);
        }
        catch (SAXException se) {
            throw new ParserConfigurationException(se.getMessage());
        }
    }

    public void setAttribute(String name, Object value) throws IllegalArgumentException {
        if (value == null) {
            if (this.attributes != null) {
                this.attributes.remove(name);
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(name, value);
        try {
            new DocumentBuilderImpl(this, this.attributes);
        }
        catch (Exception e) {
            this.attributes.remove(name);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Object getAttribute(String name) throws IllegalArgumentException {
        Object val;
        if (this.attributes != null && (val = this.attributes.get(name)) != null) {
            return val;
        }
        DOMParser domParser = null;
        try {
            domParser = new DocumentBuilderImpl(this, this.attributes).getDOMParser();
            return domParser.getProperty(name);
        }
        catch (SAXException se1) {
            try {
                boolean result = domParser.getFeature(name);
                return result ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (SAXException se2) {
                throw new IllegalArgumentException(se1.getMessage());
            }
        }
    }
}

