/*
 * Decompiled with CFR 0.152.
 */
package com.synex.xml.db;

import com.synex.xml.db.DBManager;
import com.synex.xml.db.DBManagerException;
import com.synex.xml.db.OpenConnectDialog;
import java.awt.Frame;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class DBManagerImpl
implements DBManager {
    private static String SQL_PATTERN1 = "SELECT MAX({1}) FROM {0}";
    private static String QUERY_TYPE_INSERT = "INSERT";
    private static String QUERY_TYPE_UPDATE = "UPDATE";
    private static String QUERY_TYPE_DELETE = "DELETE";
    private Hashtable currIdPool = new Hashtable();
    private Hashtable pkPool = new Hashtable();
    private Hashtable stmtPool = new Hashtable();
    private Connection conn;

    public void open(String driver, String url, String user, String password) throws DBManagerException {
        if (driver == null || url == null || user == null || password == null) {
            OpenConnectDialog openDialog = new OpenConnectDialog(new Frame(), true);
            openDialog.driver.setText(driver);
            openDialog.url.setText(url);
            openDialog.user.setText(user);
            openDialog.password.setText(password);
            openDialog.show();
            driver = openDialog.driver.getText();
            url = openDialog.url.getText();
            user = openDialog.user.getText();
            password = openDialog.password.getText();
        }
        try {
            Class.forName(driver);
            this.conn = DriverManager.getConnection(url, user, password);
            this.conn.setAutoCommit(false);
            StringBuffer sbPwd = new StringBuffer();
            int i = 0;
            while (i < password.length()) {
                sbPwd.append('*');
                ++i;
            }
            System.out.println("Open connect: driver=" + driver + ", url=" + url + ", user=" + user + ", password=" + sbPwd);
        }
        catch (ClassNotFoundException cnfe) {
            throw new DBManagerException("class not found: " + cnfe.getMessage());
        }
        catch (SQLException sqle) {
            throw new DBManagerException(sqle.getMessage());
        }
    }

    public void flush() throws DBManagerException {
        try {
            this.conn.commit();
            System.out.println("Flush this connect");
        }
        catch (Exception e) {
            throw new DBManagerException(e.getMessage());
        }
    }

    public void close() throws DBManagerException {
        this.pkPool.clear();
        try {
            Enumeration e = this.stmtPool.keys();
            while (e.hasMoreElements()) {
                ((Statement)((Object[])this.stmtPool.get(e.nextElement()))[0]).close();
            }
            this.stmtPool.clear();
            if (this.conn != null && !this.conn.isClosed()) {
                this.conn.close();
            }
            System.out.println("Close this connect");
        }
        catch (Exception e) {
            throw new DBManagerException(e.getMessage());
        }
    }

    public Map addRow(String tableName, Map ids, Map fields) throws DBManagerException {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        try {
            String key;
            if (this.pkPool.containsKey(tableName)) {
                ArrayList pks = (ArrayList)this.pkPool.get(tableName);
                int i = 0;
                while (i < pks.size()) {
                    keys.put(key, ids.containsKey(key = (String)pks.get(i)) ? (String)ids.get(key) : this.createID(tableName, key));
                    ++i;
                }
            } else if (this.conn != null && !this.conn.isClosed()) {
                ResultSet rs = this.conn.getMetaData().getPrimaryKeys(null, null, tableName);
                ArrayList<String> pks = new ArrayList<String>();
                while (rs.next()) {
                    keys.put(key, ids.containsKey(key = rs.getString("COLUMN_NAME")) ? (String)ids.get(key) : this.createID(tableName, key));
                    pks.add(key);
                }
                this.pkPool.put(tableName, pks);
            } else {
                Iterator i = ids.keySet().iterator();
                while (i.hasNext()) {
                    String key2 = (String)i.next();
                    keys.put(key2, (String)ids.get(key2));
                }
            }
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            PreparedStatement pstmt = null;
            if (this.stmtPool.containsKey(tableName + "_" + QUERY_TYPE_INSERT)) {
                pstmt = (PreparedStatement)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_INSERT))[0];
                columns.addAll((ArrayList)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_INSERT))[1]);
            } else if (this.conn != null && !this.conn.isClosed()) {
                Statement stmt = this.conn.createStatement();
                ResultSet rs = stmt.executeQuery("SELECT * FROM " + tableName + " WHERE 1 = 2");
                ResultSetMetaData rsmd = rs.getMetaData();
                String sqlStr = "INSERT INTO " + tableName + " VALUES(";
                int i = 1;
                while (i < rsmd.getColumnCount() + 1) {
                    columns.add(new Object[]{rsmd.getColumnName(i), new Integer(rsmd.getColumnType(i))});
                    if (i > 1) {
                        sqlStr = sqlStr + ",";
                    }
                    sqlStr = sqlStr + "?";
                    ++i;
                }
                sqlStr = sqlStr + ")";
                pstmt = this.conn.prepareStatement(sqlStr);
                this.stmtPool.put(tableName + "_" + QUERY_TYPE_INSERT, new Object[]{pstmt, columns});
            }
            int i = 0;
            while (i < columns.size()) {
                String key3 = (String)((Object[])columns.get(i))[0];
                int type = (Integer)((Object[])columns.get(i))[1];
                String value = (String)fields.get(key3);
                if (value == null) {
                    value = (String)keys.get(key3);
                }
                this.setParameter(pstmt, 1 + i, type, value);
                ++i;
            }
            pstmt.executeUpdate();
            System.out.println("Add into table " + tableName);
            System.out.println("    row: " + keys.toString() + fields.toString());
        }
        catch (SQLException sqle) {
            throw new DBManagerException(sqle.getMessage());
        }
        return keys;
    }

    public void updateRow(String tableName, Map ids, Map fields) throws DBManagerException {
        try {
            String sqlTest = "SELECT * FROM " + tableName + " WHERE ";
            Iterator i = ids.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                sqlTest = sqlTest + key + " = '" + (String)ids.get(key) + "'";
                if (!i.hasNext()) continue;
                sqlTest = sqlTest + " AND ";
            }
            Hashtable<String, String> defaultValues = new Hashtable<String, String>();
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            PreparedStatement pstmt = null;
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(sqlTest);
            ResultSetMetaData rsmd = rs.getMetaData();
            if (rs.next()) {
                int i2 = 1;
                while (i2 < rsmd.getColumnCount() + 1) {
                    if (rs.getString(i2) != null) {
                        defaultValues.put(rsmd.getColumnName(i2), rs.getString(i2));
                    }
                    ++i2;
                }
            } else {
                throw new DBManagerException("table " + tableName + " hasn't row with PK " + ids.toString());
            }
            if (this.stmtPool.containsKey(tableName + "_" + QUERY_TYPE_UPDATE)) {
                pstmt = (PreparedStatement)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_UPDATE))[0];
                columns.addAll((ArrayList)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_UPDATE))[1]);
            } else if (this.conn != null && !this.conn.isClosed()) {
                Hashtable<String, Integer> idTypes = new Hashtable<String, Integer>();
                String paramsStr = "";
                String sqlStr = "UPDATE " + tableName + " SET ";
                int i3 = 1;
                while (i3 < rsmd.getColumnCount() + 1) {
                    if (ids.containsKey(rsmd.getColumnName(i3))) {
                        idTypes.put(rsmd.getColumnName(i3), new Integer(rsmd.getColumnType(i3)));
                    } else {
                        columns.add(new Object[]{rsmd.getColumnName(i3), new Integer(rsmd.getColumnType(i3))});
                        if (!paramsStr.equals("")) {
                            paramsStr = paramsStr + ",";
                        }
                        paramsStr = paramsStr + rsmd.getColumnName(i3) + " = ?";
                    }
                    ++i3;
                }
                sqlStr = sqlStr + paramsStr + " WHERE ";
                Enumeration e = idTypes.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    columns.add(new Object[]{key, (Integer)idTypes.get(key)});
                    sqlStr = sqlStr + key + " = ?";
                    if (!e.hasMoreElements()) continue;
                    sqlStr = sqlStr + " AND ";
                }
                pstmt = this.conn.prepareStatement(sqlStr);
                this.stmtPool.put(tableName + "_" + QUERY_TYPE_UPDATE, new Object[]{pstmt, columns});
            }
            int i4 = 0;
            while (i4 < columns.size()) {
                String key = (String)((Object[])columns.get(i4))[0];
                int type = (Integer)((Object[])columns.get(i4))[1];
                String value = (String)fields.get(key);
                if (value == null) {
                    value = (String)ids.get(key);
                }
                if (value == null) {
                    value = (String)defaultValues.get(key);
                }
                this.setParameter(pstmt, 1 + i4, type, value);
                ++i4;
            }
            pstmt.executeUpdate();
            System.out.println("Update table " + tableName);
            System.out.println("    row: " + ids.toString() + fields.toString());
        }
        catch (SQLException sqle) {
            throw new DBManagerException(sqle.getMessage());
        }
    }

    public void deleteRow(String tableName, Map ids, Map fields) throws DBManagerException {
        try {
            ArrayList<String> columns = new ArrayList<String>();
            PreparedStatement pstmt = null;
            if (this.stmtPool.containsKey(tableName + "_" + QUERY_TYPE_DELETE)) {
                pstmt = (PreparedStatement)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_DELETE))[0];
                columns.addAll((ArrayList)((Object[])this.stmtPool.get(tableName + "_" + QUERY_TYPE_DELETE))[1]);
            } else if (this.conn != null && !this.conn.isClosed()) {
                String sqlStr = "DELETE FROM " + tableName + " WHERE ";
                Iterator i = ids.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    columns.add(key);
                    sqlStr = sqlStr + key + " = ?";
                    if (!i.hasNext()) continue;
                    sqlStr = sqlStr + " AND ";
                }
                if (!ids.isEmpty() && !fields.isEmpty()) {
                    sqlStr = sqlStr + " AND ";
                }
                Iterator i2 = fields.keySet().iterator();
                while (i2.hasNext()) {
                    String key = (String)i2.next();
                    columns.add(key);
                    sqlStr = sqlStr + key + " = ?";
                    if (!i2.hasNext()) continue;
                    sqlStr = sqlStr + " AND ";
                }
                pstmt = this.conn.prepareStatement(sqlStr);
                this.stmtPool.put(tableName + "_" + QUERY_TYPE_DELETE, new Object[]{pstmt, columns});
            }
            int i = 0;
            while (i < columns.size()) {
                String value = (String)ids.get((String)columns.get(i));
                if (value == null) {
                    value = (String)fields.get((String)columns.get(i));
                }
                pstmt.setString(1 + i, value);
                ++i;
            }
            pstmt.executeUpdate();
            System.out.println("Delete from table " + tableName);
            System.out.println("    row: " + ids.toString() + fields.toString());
        }
        catch (SQLException sqle) {
            throw new DBManagerException(sqle.getMessage());
        }
    }

    protected String createID(String tableName, String keyName) throws SQLException {
        int id = 0;
        Hashtable tmpHash = new Hashtable();
        if (this.currIdPool.containsKey(tableName) && ((Hashtable)this.currIdPool.get(tableName)).containsKey(keyName)) {
            tmpHash = (Hashtable)this.currIdPool.get(tableName);
            id = (Integer)tmpHash.get(keyName);
        } else if (this.conn != null && !this.conn.isClosed()) {
            Statement stmt = this.conn.createStatement();
            ResultSet rs = stmt.executeQuery(MessageFormat.format(SQL_PATTERN1, tableName, keyName));
            int columnType = rs.getMetaData().getColumnType(1);
            if (rs.next() && (columnType == 2 || columnType == 4 || columnType == -5 || columnType == 5)) {
                id = rs.getInt(1);
            }
            stmt.close();
        }
        tmpHash.put(keyName, new Integer(++id));
        this.currIdPool.put(tableName, tmpHash);
        String newKey = String.valueOf(id);
        return newKey;
    }

    protected void setParameter(PreparedStatement pstmt, int index, int type, String value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, type);
            return;
        }
        switch (type) {
            case 93: {
                pstmt.setTimestamp(index, Timestamp.valueOf(value));
                break;
            }
            case -7: {
                pstmt.setBoolean(index, Boolean.valueOf(value));
                break;
            }
            case -6: {
                pstmt.setByte(index, Byte.valueOf(value));
                break;
            }
            case 5: {
                pstmt.setShort(index, Short.valueOf(value));
                break;
            }
            case 4: {
                pstmt.setInt(index, Integer.valueOf(value));
                break;
            }
            case -5: {
                pstmt.setLong(index, Long.valueOf(value));
                break;
            }
            case 6: 
            case 8: {
                pstmt.setDouble(index, Double.valueOf(value));
                break;
            }
            case 7: {
                pstmt.setFloat(index, Float.valueOf(value).floatValue());
                break;
            }
            case 2: 
            case 3: {
                pstmt.setBigDecimal(index, new BigDecimal(value));
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                pstmt.setString(index, value);
                break;
            }
            case 91: {
                pstmt.setDate(index, Date.valueOf(value));
                break;
            }
            case 92: {
                pstmt.setTime(index, Time.valueOf(value));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                pstmt.setBytes(index, value.getBytes());
                break;
            }
            default: {
                pstmt.setString(index, value);
            }
        }
    }
}

