/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.dtd;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.dtd.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.IDREFDatatypeValidator;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.dtd.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.dtd.StatefullDatatypeValidator;

public class ListDatatypeValidator
extends AbstractDatatypeValidator
implements StatefullDatatypeValidator {
    private Locale fLocale = null;
    DatatypeValidator fBaseValidator = null;
    private int fLength = 0;
    private int fMaxLength = Integer.MAX_VALUE;
    private int fMinLength = 0;
    private String fPattern = null;
    private Vector fEnumeration = null;
    private int fFacetsDefined = 0;
    private boolean fDerivedByList = false;

    public ListDatatypeValidator() throws InvalidDatatypeFacetException {
        this(null, null, false);
    }

    public ListDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList) throws InvalidDatatypeFacetException {
        this.setBasetype(base);
        this.fDerivedByList = derivedByList;
        if (facets != null) {
            Enumeration e = facets.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals("length")) {
                    ++this.fFacetsDefined;
                    String lengthValue = (String)facets.get(key);
                    try {
                        this.fLength = Integer.parseInt(lengthValue);
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "' is invalid.");
                    }
                    if (this.fLength >= 0) continue;
                    throw new InvalidDatatypeFacetException("Length value '" + lengthValue + "'  must be a nonNegativeInteger.");
                }
                if (key.equals("minlength")) {
                    this.fFacetsDefined += 2;
                    String minLengthValue = (String)facets.get(key);
                    try {
                        this.fMinLength = Integer.parseInt(minLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + minLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("maxlength")) {
                    this.fFacetsDefined += 4;
                    String maxLengthValue = (String)facets.get(key);
                    try {
                        this.fMaxLength = Integer.parseInt(maxLengthValue);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InvalidDatatypeFacetException("maxLength value '" + maxLengthValue + "' is invalid.");
                    }
                }
                if (key.equals("enumeration")) {
                    this.fFacetsDefined += 16;
                    this.fEnumeration = (Vector)facets.get(key);
                    continue;
                }
                throw new InvalidDatatypeFacetException("invalid facet tag : " + key);
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fFacetsDefined & 4) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and maxLength to be members of facets.");
                }
                if ((this.fFacetsDefined & 2) != 0) {
                    throw new InvalidDatatypeFacetException("It is an error for both length and minLength to be members of facets.");
                }
            }
            if ((this.fFacetsDefined & 6) != 0 && this.fMinLength > this.fMaxLength) {
                throw new InvalidDatatypeFacetException("Value of minLength = " + this.fMinLength + "must be greater that the value of maxLength" + this.fMaxLength);
            }
        }
    }

    public void validate(String content, Object state) throws InvalidDatatypeValueException {
        this.checkContent(content, state);
    }

    public void setLocale(Locale locale) {
        this.fLocale = locale;
    }

    public Hashtable getFacets() {
        return null;
    }

    public int compare(String content, String facetValue) {
        return 0;
    }

    public Object clone() throws CloneNotSupportedException {
        ListDatatypeValidator newObj = null;
        try {
            newObj = new ListDatatypeValidator();
            newObj.fLocale = this.fLocale;
            newObj.fBaseValidator = this.fBaseValidator;
            newObj.fLength = this.fLength;
            newObj.fMaxLength = this.fMaxLength;
            newObj.fMinLength = this.fMinLength;
            newObj.fPattern = this.fPattern;
            newObj.fEnumeration = this.fEnumeration;
            newObj.fFacetsDefined = this.fFacetsDefined;
            newObj.fDerivedByList = this.fDerivedByList;
        }
        catch (InvalidDatatypeFacetException ex) {
            ex.printStackTrace();
        }
        return newObj;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkContent(String content, Object state) throws InvalidDatatypeValueException {
        StringTokenizer parsedList = new StringTokenizer(content);
        try {
            int numberOfTokens = parsedList.countTokens();
            if ((this.fFacetsDefined & 4) != 0 && numberOfTokens > this.fMaxLength) {
                throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' exceeds maximum length facet of '" + this.fMaxLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 2) != 0 && numberOfTokens < this.fMinLength) {
                throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' is less than minimum length facet of '" + this.fMinLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 1) != 0 && numberOfTokens != this.fLength) {
                throw new InvalidDatatypeValueException("Value '" + content + "' with length ='" + numberOfTokens + "' tokens" + "' is not equal to length facet of '" + this.fLength + "' tokens.");
            }
            if ((this.fFacetsDefined & 0x10) != 0 && !this.fEnumeration.contains(content)) {
                throw new InvalidDatatypeValueException("Value '" + content + "' must be one of " + this.fEnumeration);
            }
            try {
                if (!this.fDerivedByList) {
                    if (this.fBaseValidator == null) return;
                    this.fBaseValidator.validate(content, state);
                    return;
                }
                if (numberOfTokens == 0) {
                    InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
                    throw error;
                }
                while (true) {
                    if (!parsedList.hasMoreTokens()) {
                        return;
                    }
                    if (this.fBaseValidator == null) continue;
                    this.fBaseValidator.validate(parsedList.nextToken(), state);
                }
            }
            catch (InvalidDatatypeValueException ex) {
                InvalidDatatypeValueException error = new InvalidDatatypeValueException(content);
                error.setKeyIntoReporter(ex.getKeyIntoReporter());
                throw error;
            }
        }
        catch (NoSuchElementException e) {
            e.printStackTrace();
        }
    }

    private void setBasetype(DatatypeValidator base) {
        this.fBaseValidator = base;
    }

    public void initialize(Object documentInstanceState) {
        if (this.fBaseValidator instanceof StatefullDatatypeValidator) {
            ((StatefullDatatypeValidator)((Object)this.fBaseValidator)).initialize(documentInstanceState);
        }
    }

    public void validate() throws InvalidDatatypeValueException {
        if (this.fBaseValidator instanceof IDREFDatatypeValidator) {
            ((StatefullDatatypeValidator)((Object)this.fBaseValidator)).validate();
        }
    }

    public Object getInternalStateInformation() {
        Object value = null;
        if (this.fBaseValidator instanceof IDDatatypeValidator) {
            value = ((StatefullDatatypeValidator)((Object)this.fBaseValidator)).getInternalStateInformation();
        }
        return value;
    }
}

