/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.validation.ValidationContext;

public class FloatDV
extends TypeValidator {
    public short getAllowedFacets() {
        return 1016;
    }

    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        try {
            return FloatDV.fValueOf(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "float"});
        }
    }

    public int compare(Object value1, Object value2) {
        return this.compareFloats((Float)value1, (Float)value2);
    }

    private static Float fValueOf(String s) throws NumberFormatException {
        Float f = null;
        try {
            f = Float.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            if (s.equals("INF")) {
                f = new Float(Float.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                f = new Float(Float.NEGATIVE_INFINITY);
            }
            if (s.equals("NaN")) {
                f = new Float(Float.NaN);
            }
            throw nfe;
        }
        return f;
    }

    private int compareFloats(Float value, Float anotherValue) {
        int anotherBits;
        float anotherVal;
        float thisVal = value.floatValue();
        if (thisVal < (anotherVal = anotherValue.floatValue())) {
            return -1;
        }
        if (thisVal > anotherVal) {
            return 1;
        }
        int thisBits = Float.floatToIntBits(thisVal);
        return thisBits == (anotherBits = Float.floatToIntBits(anotherVal)) ? 0 : (thisBits < anotherBits ? -1 : 1);
    }
}

