REM --------------------------------------------------------------- 
REM XML based web deployment wizard V2.0
REM 
REM by David Morrill Jan-10-2001 
REM --------------------------------------------------------------- 
Option explicit
Const g_DefaultIISRoot = "IIS://localhost/W3SVC/1/Root"
Const g_DefaultDeployXML = "deploy.xml"

Dim g_objFS  
Dim g_objNet
Dim g_objDeployXMLDOM 
Dim g_objWSHShell

Dim strDefaultWebPath   ' ie  c:\inetpub\wwwroot
Dim strAppPath          ' ie [c:\inetpub\wwwroot\]MyAPP
Dim strAppVDir          ' ie [http://myWeb/]MyApp
Dim strTcpPort          ' Http port of the web
Dim strAppFriendlyName  ' Friendly name of the application to be installed
Dim strDefaultDoc       ' Start page for the web app
Dim strServerName       ' Server Name

REM ------------------ Initialize -----------------------------------
Set g_objFS  = CreateObject("Scripting.FileSystemObject")
Set g_objNet = CreateObject("WScript.Network")
Set g_objWSHShell = CreateObject("WScript.Shell")

On error resume next
Set g_objDeployXMLDOM = CreateObject("MSXML2.FreeThreadedDOMDocument")

If Err <> 0 then
   Dim sMsg
   sMsg = "Sorry, your platform is not ready!" + vbCRLF	
   sMsg = sMsg + "Unable to create object of ""MSXML2.FreeThreadedDOMDocument""." + vbCRLF
   sMsg = sMsg + "Please install MSXML Parser 3.0 or above, and then try again." + vbCRLF
   sMsg = sMsg + "MSXML Parsers (V3.0, V3.0 SP2, V4.0, etc) can be downloaded from ""http://www.microsoft.com/xml""." + vbCRLF
   MsgBox sMsg
   Print sMsg 
   Print "Thank you!"
   WScript.Quit   
End if
On error goto 0

g_objDeployXMLDOM.async = false 
g_objDeployXMLDOM.load(g_DefaultDeployXML)

strDefaultDoc = GetXMLNodeText("/app/defaultdoc")
strAppVDir = GetXMLNodeText("/app/vdir")
strAppFriendlyName = GetXMLNodeText("/app/@friendlyname")
strDefaultWebPath = GetDefaultWebPath()
strAppPath = strDefaultWebPath & "\" & strAppVDir
strTcpPort = GetTCPPort()
strServerName = g_objNet.ComputerName


REM ------------------ IISRESET -------------------------------------
Print "Start to install """ & strAppFriendlyName & """"
Exec "iisreset", true

REM ------------------ Copy files -----------------------------------
Dim oFolderNodes, item
Set oFolderNodes = g_objDeployXMLDOM.selectNodes("/app/copyFolder")
For each item  in oFolderNodes
    Dim oSrc, oDes, strDes
    Set oDes = item.selectSingleNode("des")
    Set oSrc = item.selectSingleNode("src")
    strDes = oDes.text
    strDes = Replace(strDes, "#WEBROOTPATH#", strDefaultWebPath)
    CreateFolder(strDes)
    CopyFiles oSrc.text, strDes    
next 

REM ------------------ Creating VDir ------------------------------
Dim oMyVDir
CreateVDir strAppVDir, strAppPath
Set oMyVDir = GetObject( g_DefaultIISRoot & "/" & strAppVDir)
oMyVDir.AspEnableParentPaths = false
oMyVDir.SetInfo

REM ------------------ Reg COM ------------------------------------ 
Dim oComNodes
Set oComNodes = g_objDeployXMLDOM.selectNodes("/app/regCom")
For each item  in oComNodes
    strDes = Replace(item.text, "#WEBROOTPATH#", strDefaultWebPath)
    Print "regsvr32 -s " & strDes 
    g_objWSHShell.run("regsvr32 -s " & strDes)
next 

REM ------------------ Create Folders ----------------------------- 
Set oFolderNodes = g_objDeployXMLDOM.selectNodes("/app/createFolder")
For each item  in oFolderNodes
    strDes = Replace(item.text, "#WEBROOTPATH#", strDefaultWebPath)
    Print "Creating Folder: " & strDes
    CreateFolder strDes
next 

REM ------------------ Update Settings ---------------------------- 
REM replacing tags #WEBSERVER# and #WEBPORT in some files
Dim oUpdateNodes
Set oUpdateNodes = g_objDeployXMLDOM.selectNodes("/app/updateSetting")
For each item  in oUpdateNodes
    strDes = Replace(item.text, "#WEBROOTPATH#", strDefaultWebPath)
    UpdateFile strDes
next 

REM ------------------ Update ACL -------------------------------- 
Dim oFolderAccessNode
Set oFolderAccessNode = g_objDeployXMLDOM.selectNodes("/app/setFolderAccess")
For each item  in oFolderAccessNode
    Dim oNodeFolder, oUser, oAccess, strUser, strAccess
    Set oNodeFolder = item.selectSingleNode("folder")
    strDes = Replace(oNodeFolder.text, "#WEBROOTPATH#", strDefaultWebPath)
    Set oUser = item.selectSingleNode("user")
    strUser = oUser.text
    Set oAccess = item.selectSingleNode("grantAccess")
    strAccess = oAccess.text
    Call g_objWshShell.Run("%SystemRoot%\system32\CACLS.EXE " & strDes &  " /E /G " & strUser & ":" & strAccess, 1, TRUE)
next 

REM ------------------ Update Web Attributes --------------------- 
Dim oWebAttNode
Set oWebAttNode = g_objDeployXMLDOM.selectNodes("/app/setWebAtt")
For each item  in oWebAttNode
    Dim oNodePath, oWeb, oAtt, oValue
    Set oNodePath = item.selectSingleNode("objpath")
    Set oWeb = GetObject("IIS://localhost/W3SVC/1/Root/" & oNodePath.text )    
    Set oAtt = item.selectSingleNode("name")
    Set oValue = item.selectSingleNode("value")

    if oAtt.text = "AccessExecute" Then
        oWeb.AccessExecute = CBool(oValue.text)
    End if    
    if oAtt.text = "AuthNTLM" Then
        oWeb.AuthNTLM = CBool(oValue.text)
    End if    
    if oAtt.text = "AuthAnonymous" Then
        oWeb.AuthAnonymous = CBool(oValue.text)
    End if    
    oWeb.SetInfo
next 

REM ------------------ Create a shortcut --------------------------- 
Call CreateUrlLink("http://localhost:" & strTcpPort & "/" & strAppVDir & "/"  & strDefaultDoc,  strAppFriendlyName)
Print "The installation has ended successfully."


REM --------------------------------------------------------------- 
REM                     Lib Functions 
REM --------------------------------------------------------------- 

REM --------------------------------------------------------------- 
REM UpdateFile()
REM
REM  Read the file and replace the parameter  
REM --------------------------------------------------------------- 
Function UpdateFile(strFile) 
    Dim strContent, oFile

    If Len(strFile) = 0 Then
        Exit function
    End if

    If g_objFS.FileExists(strFile) then
        Set oFile = g_objFS.OpenTextFile(strFile, 1) 'read-only
        strContent = oFile.ReadAll
        oFile.Close
        strContent = Replace(strContent, "#WEBSERVER#", strServerName)
        strContent = Replace(strContent, "#WEBPORT#", strTcpPort)
        strContent = Replace(strContent, "#WEBROOTPATH#", strDefaultWebPath)
        Set oFile = g_objFS.OpenTextFile(strFile, 2) 'write-only
        oFile.Write strContent
        oFile.Close        
    Else
        Print "Error: File " & strFile & " not found."
    End if    
End function

REM --------------------------------------------------------------- 
REM GetXMLNodeText()
REM
REM  Get text value of an xml node  
REM --------------------------------------------------------------- 
Function GetXMLNodeText(strXpath)
    Dim oVDirNode
    Set oVDirNode = g_objDeployXMLDOM.selectSingleNode(strXpath)
    If oVDirNode is nothing Then
        Print strXpath & " node is missing."
        GetXMLNodeText = ""
    End if
    GetXMLNodeText = oVDirNode.text
End Function


REM --------------------------------------------------------------- 
REM CreateUrlLink()
REM
REM  Create a short cut on the desktop and launch it  
REM --------------------------------------------------------------- 
Function CreateUrlLink(strUrl, strName)
    Dim WshShell, strTemp, oUrlLink, strDesktop
    Set WshShell = WScript.CreateObject("WScript.Shell")
    strDesktop = WshShell.SpecialFolders("Desktop")
    strTemp = strDesktop & "\" & strName & ".url"
    Set oUrlLink = WshShell.CreateShortcut(strTemp)
    oUrlLink.TargetPath = strUrl
    oUrlLink.Save
    Exec strTemp, false
End Function


REM --------------------------------------------------------------- 
REM Exec()
REM
REM  execute a console command  
REM --------------------------------------------------------------- 
Function Exec(strCmd, bWait)
    Dim WshShell
    Set WshShell = WScript.CreateObject("WScript.Shell")
    Print "Executing command: " & strCmd 
    WshShell.Run """" & strCmd & """", 7 , bWait
End function


REM --------------------------------------------------------------- 
REM GetDefaultWebPath()
REM
REM  Get the full path of the root of the default web  
REM --------------------------------------------------------------- 
Function GetDefaultWebPath()
    Dim oRoot
    Set oRoot = GetObject("IIS://localhost/W3SVC/1/Root")
    GetDefaultWebPath = oRoot.path
End Function


REM --------------------------------------------------------------- 
REM GetTCPPort()
REM
REM  Get the tcp port of the web  
REM --------------------------------------------------------------- 
Function GetTCPPort()
    Dim listSettings
    Dim strSetting
    Dim arrTemp
    listSettings = GetServerBindings()
    strSetting = CStr(listSettings(0)) 
    arrTemp = split(strSetting, ":")
    GetTCPPort = arrTemp(1)
End Function


REM --------------------------------------------------------------- 
REM GetServerBindings()
REM
REM  Get ServerBindings  
REM --------------------------------------------------------------- 
Function GetServerBindings()
    Dim oRoot 
    Set oRoot = GetObject("IIS://localhost/W3SVC/1")
    GetServerBindings = oRoot.ServerBindings
End Function


REM --------------------------------------------------------------- 
REM CopyFiles()
REM
REM   Copy files from source folder to destination folder supplied 
REM --------------------------------------------------------------- 
Function CopyFiles(srcPath, destPath)
    Dim desNormalPath
    Print "Copying files from """ & srcPath & """ to """ & destPath & """."

    If Mid(destPath, Len(destPath)) = "\" Then
        desNormalPath = Left(destPath, Len(destPath) - 1)
    Else
        desNormalPath = destPath
    End If
    g_objFS.GetFolder(srcPath).Copy(desNormalPath)
End Function


REM --------------------------------------------------------------- 
REM Print()
REM
REM   Display information on the console 
REM --------------------------------------------------------------- 
Function Print(strMessage)
    WScript.Echo (strMessage)
End Function


REM --------------------------------------------------------------- 
REM PrintError()
REM   
REM   Reporting errors
REM --------------------------------------------------------------- 
Function PrintError(strError)
    WScript.Echo ("ERROR: " & strError & " Error #:" & Err.Number &  ", " & Err.Description)
End Function


REM --------------------------------------------------------------- 
REM  CreateFolder()
REM
REM   Used to recursively create a specified folder and its parents
REM --------------------------------------------------------------- 
Function CreateFolder(strFolder)
    On Error Resume Next

    CreateFolder = True
    If Len(strFolder) = 0 Then
        Exit Function       	
    End if 

    If g_objFS.FolderExists(strFolder) Then
        Exit Function
    End If
    
    CreateFolder = False
    If Len(strFolder) = 0 Then
        Exit Function
    End If

    'Recurisvely create all the preceding folders
    If Not CreateFolder(Left(strFolder, InStrRev(strFolder, "\", Len(strFolder) - 1))) <> 0 Then
        Exit Function
    End If
    
    'Now create the folder itself.
    g_objFS.CreateFolder (strFolder)
    If Err.Number <> 0 Then
        Print "Failed to create " & strFolder
        Err.Clear
        Exit Function
    End If
    Err.Clear
    
    CreateFolder = True
End Function


REM --------------------------------------------------------------- 
REM CreateVDir
REM --------------------------------------------------------------- 
Function CreateVDir(strVDir, strVDirPath)
    Dim oRoot
    Dim oVDir
    CreateVDir = False

    If (Len(strVDir) <> 0) Then
        If Mid(strVDir, Len(strVDir)) = "/" Then
            strVDir = Left(strVDir, Len(strVDir) - 1)
        End If
    End If

    If Not SetExistingVDirPath(strVDir, strVDirPath) Then
        Set oRoot = GetObject(g_DefaultIISRoot)

        On Error Resume Next
        Set oVDir = oRoot.Create("IisWebVirtualDir", strVDir)
        If Err.Number <> 0 And Err.Number <> &H80070003 Then
            PrintError ("Error creating IIS VRoot " & strVDir)
            Exit Function
        End If
        Err.Clear

        oVDir.Path = strVDirPath
        oVDir.SetInfo
        If Err.Number <> 0 Then
            PrintError ("Error creating the IIS VDir" & strVDir)
            Exit Function
        End If
        Err.Clear
    End If
    
    CreateVDir = True
End Function


REM --------------------------------------------------------------- 
REM  SetVDirPath
REM
REM    Open an existing VDir, set the path 
REM --------------------------------------------------------------- 
Function SetExistingVDirPath(strVDir, strVDirPath)
    Dim oVDir
    Dim strObj
    SetExistingVDirPath = False

    strObj = g_DefaultIISRoot	

    If Len(strVDir) > 0 Then
	strObj = strObj & "/" & strVDir
    End if
    
    On Error Resume Next
    Set oVDir = GetObject(strObj)
    If Err.Number <> 0 Then
        If Err.Number <> &H80070003 Then
            PrintError ("Error getting IIS VDir object of " & strObj)
        End If
        Exit Function
    End If
    Err.Clear

    SetExistingVDirPath = SetVDirPath(oVDir, strVDirPath)    
End Function


REM --------------------------------------------------------------- 
REM  SetVDirPath
REM
REM    Set the path(c:\inetpub\wwwroot\vdir) property for a VDir
REM --------------------------------------------------------------- 
Function SetVDirPath(oVDirObj, strVDirPath)
    SetVDirPath = False

    On Error Resume Next
    If oVDirObj.Path <> strVDirPath Then
        oVDirObj.Path = strVDirPath
        oVDirObj.SetInfo
    End If
        
    If Err.Number <> 0 Then
        PrintError ("Error Setting the path [" & strVDirPath & "].")
        Exit Function
    End If
    Err.Clear

    SetVDirPath = True
End Function


