REM **------------------------------------------------**
REM ** Creates Oracle table to store binary files     **
REM **                                                **
REM ** Download4J/Oracle8i+ sample script.            **
REM ** http://www.javazoom.net/jzservlets/download4j/ **
REM ** Copyright JavaZOOM 1999-2002.                  **
REM **------------------------------------------------**
drop table DOWNLOAD;
create table DOWNLOAD (
	FILENAME varchar2(255), 
	BINARYFILE blob,
	primary key (FILENAME)
);

REM ** High privileges are required to execute the following instruction. **
create or replace directory MY_FILES as 'c:\temp';

REM ** PL/SQL procedure that reads and inserts file from MY_FILES folder on the RDBMS server. **
create or replace procedure load_file(filename varchar2) as
l_blob blob;
l_bfile bfile;
begin
    insert into DOWNLOAD values ( filename, empty_blob() )
    return BINARYFILE into l_blob;

    l_bfile := bfilename( 'MY_FILES', filename );
    dbms_lob.fileopen( l_bfile );
    dbms_lob.loadfromfile( l_blob, l_bfile, dbms_lob.getlength(l_bfile) );
    dbms_lob.fileclose( l_bfile );    
    commit;
end;
/

REM ** Read and inserts 4 sample files  **
execute load_file('protectedtest.pdf');
execute load_file('globaltest.txt');
execute load_file('ziptest.html');
execute load_file('jchatbox.gif');
REM ** Tests have been successfully made with big (more than 50MB) files  **
