/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.win32;

import com.develop.io.LittleEndianInputStream;
import com.develop.io.LittleEndianOutputStream;
import com.develop.io.NakedByteStream;
import com.develop.jawin.COMError;
import com.develop.jawin.COMException;
import com.develop.jawin.COMPtr;
import com.develop.jawin.FuncPtr;
import com.develop.jawin.GUID;
import com.develop.jawin.IdentityManager;
import com.develop.jawin.ObjectFinalization;
import com.develop.jawin.ReturnFlags;
import com.develop.jawin.marshal.GenericStub;
import com.develop.jawin.marshal.MarshalConstants;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class Ole32
implements MarshalConstants {
    static final FuncPtr mfuncCLSIDFromProgID;
    static final int mstackCoGetObject = 16;
    static final FuncPtr mfuncCoGetObject;
    static final int mstackCoCreateInstance = 20;
    static final FuncPtr mfuncCoCreateInstance;
    public static final int CLSCTX_INPROC_SERVER = 1;
    public static final int CLSCTX_INPROC_HANDLER = 2;
    public static final int CLSCTX_LOCAL_SERVER = 4;
    public static final int CLSCTX_REMOTE_SERVER = 16;
    public static final int CLSCTX_ALL = 23;

    public static void CoInitialize() throws COMException {
        FuncPtr funcPtr = new FuncPtr("OLE32.DLL", "CoInitialize");
        funcPtr.invoke(0, ReturnFlags.CHECK_HRESULT);
    }

    public static void CoUninitialize() throws COMException {
        ObjectFinalization.finalizeObjects();
        FuncPtr funcPtr = new FuncPtr("OLE32.DLL", "CoUninitialize");
        funcPtr.invoke(ReturnFlags.CHECK_HRESULT);
    }

    public static COMPtr GetFromProgID(String string, GUID gUID) throws COMException {
        GUID gUID2 = Ole32.CLSIDFromProgID(string);
        return Ole32.CoCreateInstance(gUID2, 5, gUID);
    }

    public static GUID CLSIDFromProgID(String string) throws COMException {
        try {
            NakedByteStream nakedByteStream = new NakedByteStream();
            LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
            littleEndianOutputStream.writeStringUnicode(string);
            byte[] byArray = GenericStub.win32Invoke(mfuncCLSIDFromProgID.getPeer(), "GM64:H:ln64", 8, littleEndianOutputStream.size(), nakedByteStream.getInternalBuffer(), null);
            LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
            return GUID.marshalOut(littleEndianInputStream);
        }
        catch (IOException iOException) {
            throw new COMException(iOException);
        }
    }

    public static COMPtr CoGetObject(String string, GUID gUID) throws COMException {
        try {
            NakedByteStream nakedByteStream = new NakedByteStream();
            LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
            littleEndianOutputStream.writeStringUnicode(string);
            gUID.marshal(littleEndianOutputStream, null);
            byte[] byArray = GenericStub.win32Invoke(mfuncCoGetObject.getPeer(), "GkP16A:H:L12N|4UU|", 16, littleEndianOutputStream.size(), nakedByteStream.getInternalBuffer(), null);
            return IdentityManager.getCOMPtr(byArray, 0, gUID);
        }
        catch (IOException iOException) {
            throw new COMException(iOException);
        }
    }

    public static COMPtr CoCreateInstance(GUID gUID, int n, GUID gUID2) throws COMException {
        try {
            NakedByteStream nakedByteStream = new NakedByteStream();
            LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
            gUID.marshal(littleEndianOutputStream, null);
            littleEndianOutputStream.writeInt(n);
            gUID2.marshal(littleEndianOutputStream, null);
            byte[] byArray = GenericStub.win32Invoke(mfuncCoCreateInstance.getPeer(), "P16kIP16A:H:L16N|4UU|", 20, littleEndianOutputStream.size(), nakedByteStream.getInternalBuffer(), null);
            COMPtr cOMPtr = IdentityManager.getCOMPtr(byArray, 0, gUID2);
            if (IdentityManager.traceRefs) {
                System.out.println(cOMPtr + " CoCreateInstance assigned reference");
            }
            return cOMPtr;
        }
        catch (IOException iOException) {
            throw new COMException(iOException);
        }
    }

    static {
        try {
            mfuncCLSIDFromProgID = new FuncPtr("OLE32.DLL", "CLSIDFromProgID");
            mfuncCoGetObject = new FuncPtr("OLE32.DLL", "CoGetObject");
            mfuncCoCreateInstance = new FuncPtr("OLE32.DLL", "CoCreateInstance");
        }
        catch (COMException cOMException) {
            throw new COMError("Unable to load Ole32 entry points");
        }
    }
}

