/*
 * JavaAsync.java
 *
 * Created on November 11, 2002, 6:13 PM
 */

package demo;
import com.develop.jawin.*;
import com.develop.jawin.constants.*;
import javax.swing.*;
import MSMQ.*;

/**
 *
 * @author  Cyril
 */
public class MSMQAsync extends javax.swing.JDialog implements _DMSMQEventEvents, DispatchConstants {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;
    
    //    MSMQEventHolder holder = null;
    private IMSMQEvent event;
    private IMSMQQueue queueIn;
    private java.awt.Frame parComp = null;
    int count = 1;
    
    /** Creates new form JavaAsync */
    public MSMQAsync(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        parComp = (java.awt.Frame)this.getParent();
        initComponents();
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            SwingUtilities.updateComponentTreeUI(this);
        } catch (Exception e) {}
    }
    
    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonPanel = new javax.swing.JPanel();
        notifyButton = new javax.swing.JButton();
        createButton = new javax.swing.JButton();
        exitButton = new javax.swing.JButton();
        controls = new javax.swing.JPanel();
        label1 = new javax.swing.JLabel();
        qToNotify = new javax.swing.JTextField();
        removeMsgCBox = new javax.swing.JCheckBox();
        label2 = new javax.swing.JLabel();
        qToSend = new javax.swing.JTextField();
        sendMsgButton = new javax.swing.JButton();
        label3 = new javax.swing.JLabel();
        receivedList = new java.awt.List();
        noteTextPane1 = new javax.swing.JTextPane();

        setTitle("MSMQAsync");
        setName("Dialog");
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        notifyButton.setText("Listen");
        notifyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                notifyButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(notifyButton);

        createButton.setText("Create");
        createButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                createQueue(evt);
            }
        });

        buttonPanel.add(createButton);

        exitButton.setText("Exit");
        exitButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitButtonActionPerformed(evt);
            }
        });

        buttonPanel.add(exitButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        controls.setLayout(null);

        controls.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        label1.setText("Queue to listen to:");
        controls.add(label1);
        label1.setBounds(30, 10, 150, 17);

        qToNotify.setText(".\\private$\\testqueue");
        controls.add(qToNotify);
        qToNotify.setBounds(30, 30, 350, 21);

        removeMsgCBox.setText("Perform destructive read on notify");
        controls.add(removeMsgCBox);
        removeMsgCBox.setBounds(30, 120, 220, 25);

        label2.setText("Queue to create or to send test messages to:");
        controls.add(label2);
        label2.setBounds(30, 150, 320, 17);

        qToSend.setText(".\\private$\\testqueue");
        controls.add(qToSend);
        qToSend.setBounds(30, 170, 350, 21);

        sendMsgButton.setText("Send Test Message");
        sendMsgButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                sendMessage(evt);
            }
        });

        controls.add(sendMsgButton);
        sendMsgButton.setBounds(130, 200, 160, 27);

        label3.setText("Data Received:");
        controls.add(label3);
        label3.setBounds(30, 240, 100, 17);

        controls.add(receivedList);
        receivedList.setBounds(30, 260, 350, 100);

        noteTextPane1.setBorder(new javax.swing.border.EtchedBorder(java.awt.SystemColor.controlLtHighlight, java.awt.SystemColor.controlShadow));
        noteTextPane1.setEditable(false);
        noteTextPane1.setText("NOTE:  Keep in mind that notifications cannot be enabled on remote queues if they are transactional.");
        noteTextPane1.setBackground(java.awt.SystemColor.control);
        noteTextPane1.setSelectionColor(new java.awt.Color(204, 204, 204));
        noteTextPane1.setAutoscrolls(false);
        controls.add(noteTextPane1);
        noteTextPane1.setBounds(30, 60, 350, 60);

        getContentPane().add(controls, java.awt.BorderLayout.CENTER);

        pack();
        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setSize(new java.awt.Dimension(410, 429));
        setLocation((screenSize.width-410)/2,(screenSize.height-429)/2);
    }//GEN-END:initComponents
    
    private void createQueue(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_createQueue
        MsgBox msg = new MsgBox(parComp, true);
        try {
            IMSMQQueueInfo queueInfo = new IMSMQQueueInfo("MSMQ.MSMQQueueInfo");
            queueInfo.setPathName(qToSend.getText());
            queueInfo.Create();
            msg.setTitle("Information");
            msg.setText("Queue created.\nPathName=" + qToSend.getText());
        }catch(COMException e) {
            msg.setText(e.getMessage() + "\nPathName=" + qToSend.getText());
        }
        msg.show();
    }//GEN-LAST:event_createQueue
    
    private void sendMessage(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_sendMessage
        try {
            IMSMQCoordinatedTransactionDispenser xActDispenser =
            new IMSMQCoordinatedTransactionDispenser("MSMQ.MSMQCoordinatedTransactionDispenser");
            IMSMQTransaction xAct = xActDispenser.BeginTransaction();
            IMSMQQueue queueOut;
            IMSMQQueueInfo queueInfo = new IMSMQQueueInfo("MSMQ.MSMQQueueInfo");
            queueInfo.setPathName(qToSend.getText());
            queueOut = queueInfo.Open(2, 0);
            IMSMQMessage message = new IMSMQMessage("MSMQ.MSMQMessage");
            message.setLabel("Test message");
            message.setBody("Test body");
            message.Send(queueOut);
        }catch(COMException e) {
            MsgBox msg = new MsgBox(parComp, true);
            msg.setText(e.getMessage());
            msg.show();
        }
    }//GEN-LAST:event_sendMessage
    
    private void notifyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_notifyButtonActionPerformed
        try {
            if(queueIn == null) {
                IMSMQQueueInfo queueInfo = new IMSMQQueueInfo("MSMQ.MSMQQueueInfo");
                queueInfo.setPathName(qToNotify.getText());
                queueIn = queueInfo.Open(1, 0);
            }
            event = new IMSMQEvent("MSMQ.MSMQEvent");
            event.toGITRef();
            event.addEventListener(_DMSMQEventEvents.class, this);
            queueIn.EnableNotification(event);
        }catch(COMException e) {
            MsgBox msg = new MsgBox(parComp, true);
            msg.setText(e.getMessage());
            msg.show();
        }
    }//GEN-LAST:event_notifyButtonActionPerformed
    
    private void exitButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitButtonActionPerformed
        doClose(RET_CANCEL);
    }//GEN-LAST:event_exitButtonActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog
    
    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
        System.exit(0);
    }
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new MSMQAsync(new javax.swing.JFrame(), true).show();
    }
    
    public void Arrived(Object srcObj, DispatchPtr Queue, int Cursor) {
        try {
            IMSMQQueue rawQueue = new IMSMQQueue(Queue);
            IMSMQMessage message;
            
            IMSMQCoordinatedTransactionDispenser xActDispenser =
            new IMSMQCoordinatedTransactionDispenser("MSMQ.MSMQCoordinatedTransactionDispenser");
            IMSMQTransaction transaction = xActDispenser.BeginTransaction();
            
            if(removeMsgCBox.getSelectedObjects() == null)
                message = rawQueue.PeekCurrent();
            else
                message = rawQueue.ReceiveCurrent();
            String msgData = "No." + count + ", Label=" + message.getLabel() + ", Body=" + message.getBody();
            if(count % 5 == 0)
                receivedList.clear();
            receivedList.add(msgData);
            count++;
            rawQueue.EnableNotification(event, (removeMsgCBox.getSelectedObjects() == null)?new Long(2):new Long(1));
        } catch(COMException e) {
            MsgBox msg = new MsgBox(parComp, true);
            msg.setText(e.getMessage());
            msg.show();
        }
    }
    
    public void ArrivedError(Object srcObj, DispatchPtr Queue, int ErrorCode, int Cursor) {
        MsgBox msg = new MsgBox(parComp, true);
        msg.setText("ArrivedError: "+ Integer.toHexString(ErrorCode) + "  Cursor: " + Cursor);
        msg.show();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton createButton;
    private javax.swing.JCheckBox removeMsgCBox;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JTextField qToSend;
    private javax.swing.JLabel label3;
    private javax.swing.JLabel label2;
    private javax.swing.JLabel label1;
    private javax.swing.JButton sendMsgButton;
    private javax.swing.JButton notifyButton;
    private javax.swing.JPanel controls;
    private java.awt.List receivedList;
    private javax.swing.JTextPane noteTextPane1;
    private javax.swing.JButton exitButton;
    private javax.swing.JTextField qToNotify;
    // End of variables declaration//GEN-END:variables
    
    private int returnStatus = RET_CANCEL;
}
